/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.Table;
import java.io.Serializable;
import java.util.List;

@SASScope(value="ALL")
@SubjectToChange
public class StructureOfData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INPUT_STRUCTURE_RELATIONAL = "Relational";
    private static final String INPUT_STRUCTURE_OLAP = "OLAP";
    private static final String INPUT_STRUCTURE_TABULAR = "Tabular";
    private static final String INPUT_STRUCTURE_NONE = "None";
    @SASScope
    public static final StructureOfData NONE = new StructureOfData(false, false, false);
    @SASScope
    public static final StructureOfData RELATIONAL = new StructureOfData(true, false, true);
    @SASScope
    public static final StructureOfData OLAP = new StructureOfData(false, true, false);
    @SASScope
    public static final StructureOfData TABULAR = new StructureOfData(false, false, true);
    private boolean _isRelational = false;
    private boolean _isOLAP = false;
    private boolean _isTabular = false;
    private boolean _immutable = false;

    public StructureOfData() {
    }

    private StructureOfData(boolean relational, boolean olap, boolean tabular) {
        this._immutable = true;
        this._isRelational = relational;
        this._isOLAP = olap;
        this._isTabular = tabular;
    }

    public String toValueString() {
        String string = this._isOLAP ? INPUT_STRUCTURE_OLAP : (this._isRelational ? INPUT_STRUCTURE_RELATIONAL : (this._isTabular ? INPUT_STRUCTURE_TABULAR : INPUT_STRUCTURE_NONE));
        return string;
    }

    public static StructureOfData valueOf(String string) {
        StructureOfData sod;
        if (string == null || INPUT_STRUCTURE_NONE.equals(string)) {
            sod = NONE;
        } else if (INPUT_STRUCTURE_OLAP.equals(string)) {
            sod = OLAP;
        } else if (INPUT_STRUCTURE_RELATIONAL.equals(string)) {
            sod = RELATIONAL;
        } else if (INPUT_STRUCTURE_TABULAR.equals(string)) {
            sod = TABULAR;
        } else {
            throw new NumberFormatException(string);
        }
        return sod;
    }

    public static StructureOfData getStructure(Object obj) {
        StructureOfData struct = new StructureOfData();
        if (StructureOfData.isOLAP(obj)) {
            struct.setIsOLAP(true);
        }
        if (StructureOfData.isRelational(obj)) {
            struct.setIsRelational(true);
        }
        if (StructureOfData.isTabular(obj)) {
            struct.setIsTabular(true);
        }
        return struct;
    }

    public static StructureOfData getStructure(List list) {
        StructureOfData struct = new StructureOfData();
        for (Object obj : list) {
            if (StructureOfData.isOLAP(obj)) {
                struct.setIsOLAP(true);
            }
            if (StructureOfData.isRelational(obj)) {
                struct.setIsRelational(true);
            }
            if (!StructureOfData.isTabular(obj)) continue;
            struct.setIsTabular(true);
        }
        return struct;
    }

    private static final boolean isRelational(Object obj) {
        boolean value = obj instanceof StructureOfData ? ((StructureOfData)obj).isRelational() : obj instanceof Column || obj instanceof Table;
        return value;
    }

    private static final boolean isOLAP(Object obj) {
        boolean value = obj instanceof StructureOfData ? ((StructureOfData)obj).isOLAP() : obj instanceof OlapItem || obj instanceof Cube;
        return value;
    }

    private static final boolean isTabular(Object obj) {
        boolean value = obj instanceof StructureOfData ? ((StructureOfData)obj).isTabular() : obj instanceof Column || obj instanceof Table;
        return value;
    }

    public boolean isRelational() {
        return this._isRelational;
    }

    public void setIsRelational(boolean isRelational) {
        if (this._immutable) {
            throw new IllegalStateException();
        }
        this._isRelational = isRelational;
        if (this._isRelational) {
            this._isTabular = true;
        }
    }

    public boolean isOLAP() {
        return this._isOLAP;
    }

    public void setIsOLAP(boolean isOLAP) {
        if (this._immutable) {
            throw new IllegalStateException();
        }
        this._isOLAP = isOLAP;
        if (this._isOLAP) {
            this._isTabular = false;
        }
    }

    public boolean isTabular() {
        return this._isTabular;
    }

    public void setIsTabular(boolean isTable) {
        if (this._immutable) {
            throw new IllegalStateException();
        }
        this._isTabular = isTable;
    }

    @SASScope
    public boolean equals(Object obj) {
        boolean same;
        boolean bl = same = obj == this;
        if (!same && obj instanceof StructureOfData) {
            StructureOfData that = (StructureOfData)obj;
            same = this._isRelational == that._isRelational && this._isOLAP == that._isOLAP && this._isTabular == that._isTabular;
        }
        return same;
    }

    @SASScope
    public int hashCode() {
        int rc = 17;
        rc = 37 * rc + (this._isRelational ? 0 : 1);
        rc = 37 * rc + (this._isOLAP ? 0 : 1);
        rc = 37 * rc + (this._isTabular ? 0 : 1);
        return rc;
    }
}

