/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IQSystemProperties {
    public static final String SASQueryServices_Dot_ = "SASQueryServices.";
    private static final Logger _logger = LogManager.getLogger((String)"IQSystemProperties.class");
    public static final String PROPERTY_WRITE_OLAP_STATEMENTS = "SASQueryServices.writeOLAPStatements";
    public static final String PROPERTY_WRITE_OLAP_STATEMENTS_93 = "IQ.writeOLAPStatements";
    public static final String PROPERTY_WRITE_SAS_STATEMENTS = "SASQueryServices.writeSasStatements";
    public static final String PROPERTY_WRITE_SAS_STATEMENTS_93 = "IQ.writeSasStatements";
    public static final String PROPERTY_DELAY_QUERY_IN_SECONDS = "SASQueryServices.QueryDelaySeconds";
    public static final String PROPERTY_DELAY_QUERY_IN_SECONDS_93 = "SAS.IQ.QueryDelaySeconds";
    public static final String PROPERTY_LOG_DATA_SELECTION_XML = "SASQueryServices.logIQDataSelection";
    public static final String PROPERTY_LOG_DATA_SELECTION_XML_93 = "logIQDataSelection";
    public static final String PROPERTY_FORCE_READ_USING_DOM = "SASQueryServices.ReadMapsUsingDom";
    public static final String PROPERTY_FORCE_READ_USING_DOM_93 = "SAS.IQ.READ.MAPS.USING.DOM";
    public static final String PROPERTY_INFOMAP_CACHE_IS_ACTIVE = "SASQueryServices.OMRInformationMapCache.isActive";
    public static final String PROPERTY_INFOMAP_CACHE_IS_ACTIVE_93 = "sas.QueryServices.OMRInformationMapCache.isActive";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_SIZE = "SASQueryServices.OMRInformationMapCache.maxEntries";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_SIZE_93 = "sas.QueryServices.OMRInformationMapCache.maxEntries";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_AGE_SEC = "SASQueryServices.OMRInformationMapCache.maxAgeSec";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_AGE_SEC_93 = "sas.QueryServices.OMRInformationMapCache.maxAgeSec";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_WEIGHTED_SIZE = "SASQueryServices.OMRInformationMapCache.maxSize";
    public static final String PROPERTY_INFOMAP_CACHE_MAX_WEIGHTED_SIZE_93 = "sas.QueryServices.OMRInformationMapCache.maxSize";
    public static final String PROPERTY_MAXNUMBEROFCELLS = "SASQueryServices.EmbeddedData.MaxNumberOfCells";
    public static final String PROPERTY_MAXNUMBEROFCELLS_93 = "SAS.IQ.EmbeddedData.MaxNumberOfCells";
    public static final String PROPERTY_SHOW_GPFV_QUERY = "SASQueryServices.ShowGPFVQuery";
    public static final String PROPERTY_SHOW_GPFV_QUERY_93 = "SAS.IQ.ShowGPFVQuery";
    public static final String PROPERTY_VERBOSE_LOGGING = "SASQueryServices.VerboseLogging";
    public static final String PROPERTY_VERBOSE_PROC_COMMENTS = "SASQueryServices.VerboseProcComments";
    public static final String PROPERTY_LOG_STARTING_LINE = "SASQueryServices.sasLogStartingLine";
    public static final String PROPERTY_LOG_ENDING_LINE = "SASQueryServices.sasLogEndingLine";
    public static final String PROPERTY_LOG_NUMBER_TO_READ = "SASQueryServices.sasLogNumberToRead";
    public static final String PROPERTY_LOG_LINENUMBER_IS_PREPENDED = "SASQueryServices.sasLogAddLineNum";
    public static final String PROPERTY_LOG_LINETYPE_IS_PREPENDED = "SASQueryServices.sasLogAddLineType";
    public static final String PROPERTY_LOG_LINECC_IS_PREPENDED = "SASQueryServices.sasLogAddLineCarriageControl";
    public static final String PROPERTY_SAS_SUBMIT_ASYNC = "SASQueryServices.sasSubmitAsync";
    private static String ASYNC_DEFAULT = "true";
    public static String VISUALTOTALS_VIA_UPDATE = "SASQueryServices.sasVisualTotalsViaUpdate";
    public static final String PROPERTY_SAS_SUBMIT_TIMEOUT = "SASQueryServices.sasSubmitTimeout";
    public static final String PROPERTY_SAS_SUBMIT_INTERVAL = "SASQueryServices.sasSubmitInterval";
    public static final String PROPERTY_SAS_SUBMIT_POLLS = "SASQueryServices.sasSubmitPolls";
    public static final String PROPERTY_FORMATTING_DATA_WITH_INVALID_WIDTH_IS_ERROR = "SASQueryServices.sasDisablePutQ";
    public static final String PROPERTY_ENABLE_MACRO_EXEC_EXPRESSIONS = "SASQueryServices.EnableMacroExecOfExpressions";
    public static final String PROPERTY_USE_ALTERNATE_RELATIVE_DATE_SYNTAX = "SASQueryServices.AltRelDateSyntax";
    public static final String PROPERTY_USE_NWAY = "SASQueryServices.useNWAY";
    public static final String PROPERTY_HIDDEN_VALUES_SHOW_FILTER_EXPR = "SASQueryServices.HiddenValuesShowFilterExpressions";
    public static final String PROPERTY_USE_TSSQL = "SASQueryServices.useTSSQL";
    public static final String PROPERTY_REMOVE_WRS_METADATA_CACHE = "SAS.QueryServices.RemoveWRSMetadataCache";
    public static final String PROPERTY_USE_NOCODEGEN = "SASQueryServices.NOCODEGEN";
    public static final String PROPERTY_SQL_RANK_ORDER = "SASQueryServices.SqlRankOrder";
    public static final String PROPERTY_NON_NESTED_CROSSJOIN = "SASQueryServices.useNonNestedCrossJoin";
    public static final String PROPERTY_SUPPRESS_VERSION_93 = "SASQueryServices.suppressVersion93";
    public static final String PROPERTY_LOG_STARTUP_VARS_FROM_PROC = "SASQueryServices.logStartVarsFromProc";
    public static final String PROPERTY_LOG_STARTUP_VARS_FROM_JDBC = "SASQueryServices.logStartVarsFromJDBC";
    public static final String PROPERTY_IGNORE_SYSCC_ON_STARTUP = "SASQueryServices.ignoreSysccOnStartup";
    public static final String PROPERTY_SASLOG_PAGESIZE = "SASQueryServices.sasLogPageSize";
    public static final String PROPERTY_SASLOG_LINESIZE = "SASQueryServices.sasLogLineSize";
    public static final String PROPERTY_ALLOW_INNER_MODELS_TO_REFER_TO_EXTERNAL_MODELS = "SASQueryServices.AllowInnerIQModelsToReferToIQModelsInBITrees";
    public static final String PROPERTY_ALLOW_IMSTAT = "SASQueryServices.AllowIMSTAT";
    public static final String PROPERTY_SAS_CONNECTION_ASYNC = "SASQueryServices.sasConnectAsync";
    public static final String PROPERTY_SAS_CONNECTION_TIMEOUT = "SASQueryServices.sasConnectTimeout";
    public static final String PROPERTY_SAS_CONNECTION_INTERVAL = "SASQueryServices.sasConnectInterval";
    public static final String PROPERTY_BIQ_NO_NEG_PARENS_FLAG = "SASQueryServices.BiqNoNegParens";
    public static final String PROPERTY_MEASURE_IN_DRILLTHRU = "SASQueryServices.measureInDrillThru";
    public static final int VALUE_SQL_RANK_ORDER_MIXED = 0;
    public static final int VALUE_SQL_RANK_ORDER_DEFAULT = 0;
    public static final int VALUE_SQL_RANK_ORDER_LOW_HIGH = 1;
    public static final int VALUE_SQL_RANK_ORDER_HIGH_LOW = 2;
    public static final int VALUE_SQL_RANK_ORDER_MIXED_REVERSED = 3;
    public static final int VALUE_SQL_RANK_ORDER_ASPER_OLAP = 4;

    public static int getSqlRankOrder() {
        int sqlRankOrder = IQSystemProperties.getIntProperty(PROPERTY_SQL_RANK_ORDER, 0);
        switch (sqlRankOrder) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return sqlRankOrder;
            }
        }
        return 0;
    }

    public static boolean isBooleanPropertyEnabled(String property) {
        boolean out = false;
        String value = System.getProperty(property);
        if (value != null && value.toUpperCase().startsWith("Y")) {
            out = true;
        }
        return out;
    }

    public static boolean isVerboseLoggingEnabled() {
        return IQSystemProperties.isBooleanPropertyEnabled(PROPERTY_VERBOSE_LOGGING);
    }

    public static boolean isVerboseProcCommentsEnabled(Object contextHint) {
        boolean out = false;
        String value = System.getProperty(PROPERTY_VERBOSE_PROC_COMMENTS);
        out = value != null ? value.toUpperCase().startsWith("Y") : _logger.isInfoEnabled();
        return out;
    }

    public static int getIntProperty(String propertyName, int defaultValue) {
        int out;
        block3: {
            out = defaultValue;
            try {
                String propValue = System.getProperty(propertyName);
                if (propValue != null) {
                    out = Integer.parseInt(propValue);
                }
            }
            catch (NumberFormatException e) {
                if (!_logger.isEnabled(Level.DEBUG)) break block3;
                _logger.log(Level.DEBUG, e.getMessage(), (Throwable)e);
            }
        }
        return out;
    }

    public static boolean isSasSubmitAsync() {
        return Boolean.valueOf(System.getProperty(PROPERTY_SAS_SUBMIT_ASYNC, ASYNC_DEFAULT));
    }
}

