/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.generation2;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.generation2.EmbeddedData;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class EmbeddedDataImpl
implements EmbeddedData {
    public static final String NODE_NAME_VARIABLES = "Variables";
    public static final String NODE_NAME_VARIABLE = "Variable";
    public static final String ATTRIBUTE_NAME_NAME = "name";
    public static final String ATTRIBUTE_NAME_LABEL = "label";
    public static final String ATTRIBUTE_NAME_TYPE = "type";
    public static final String ATTRIBUTE_NAME_ENCODING = "encoding";
    public static final String ATTRIBUTE_NAME_SASFORMAT = "SASFormat";
    private static final String linesep = " ";
    protected String m_strID = null;
    protected List<Column> m_columns;
    protected Element m_embeddedElement = null;

    public EmbeddedDataImpl(Element embeddedElement) {
        this.m_embeddedElement = embeddedElement;
        this._initialize(embeddedElement);
    }

    protected void _initialize(Element embeddedElement) {
        this.m_columns = new ArrayList<Column>();
        this._parseXML(embeddedElement);
    }

    @Override
    public void setID(String strID) {
        this.m_strID = strID;
    }

    @Override
    public String getID() {
        return this.m_strID;
    }

    @Override
    public void write(Element parentElement) {
    }

    @Override
    public String getString(int row, int column) {
        return null;
    }

    @Override
    public String getColumnType(int column) {
        return this.m_columns.get((int)column).m_strType;
    }

    @Override
    public String getColumnName(int column) {
        return this.m_columns.get((int)column).m_strName;
    }

    @Override
    public String getColumnSASFormat(int column) {
        return this.m_columns.get((int)column).m_SASFormat;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.m_columns.get((int)column).m_strLabel;
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public String toString() {
        String xml = IQModelImplUtilities.toString(this.m_embeddedElement);
        return xml;
    }

    protected String xmlElementToString2(Element element) {
        String str = " <" + element.getTagName() + linesep;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node item = attrs.item(i);
            str = str + item.getNodeName() + "=\"" + this.normalize(item.getNodeValue(), item) + "\" ";
        }
        str = str + ">  ";
        NodeList kids = element.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node kid = kids.item(i);
            str = kid instanceof Element ? str + this.xmlElementToString2((Element)kid) : str + this.normalize(kid.getNodeValue(), kid);
        }
        str = str + " </" + element.getTagName() + ">";
        return str;
    }

    protected String normalize(String s, Node node) {
        boolean canonical = false;
        StringBuffer str = new StringBuffer();
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: {
                int len = s != null ? s.length() : 0;
                block11: for (int i = 0; i < len; ++i) {
                    char ch = s.charAt(i);
                    switch (ch) {
                        case '<': {
                            str.append("&lt;");
                            continue block11;
                        }
                        case '>': {
                            str.append("&gt;");
                            continue block11;
                        }
                        case '&': {
                            str.append("&amp;");
                            continue block11;
                        }
                        case '\"': {
                            str.append("&quot;");
                            continue block11;
                        }
                        case '\'': {
                            str.append("&apos;");
                            continue block11;
                        }
                        case '\n': 
                        case '\r': {
                            if (canonical) {
                                str.append("&#");
                                str.append(Integer.toString(ch));
                                str.append(';');
                                continue block11;
                            }
                        }
                        default: {
                            str.append(ch);
                        }
                    }
                }
                return str.toString();
            }
        }
        return s;
    }

    protected void _parseXML(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName(NODE_NAME_VARIABLES);
        Element element = (Element)nodeList.item(0);
        nodeList = element.getElementsByTagName(NODE_NAME_VARIABLE);
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element columnElement = (Element)nodeList.item(index);
            NamedNodeMap attributes = columnElement.getAttributes();
            Column column = new Column();
            column.m_strName = this._getAttribute(ATTRIBUTE_NAME_NAME, attributes);
            column.m_strLabel = this._getAttribute(ATTRIBUTE_NAME_LABEL, attributes);
            column.m_strType = this._getAttribute(ATTRIBUTE_NAME_TYPE, attributes);
            column.m_strEncoding = this._getAttribute(ATTRIBUTE_NAME_ENCODING, attributes);
            column.m_SASFormat = this._getAttribute(ATTRIBUTE_NAME_SASFORMAT, attributes);
            this.m_columns.add(column);
        }
    }

    protected String _getAttribute(String strAttribute, NamedNodeMap childNodeMap) {
        String returnValue = null;
        try {
            returnValue = childNodeMap.getNamedItem(strAttribute).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    private static class Column {
        public String m_strName;
        public String m_strLabel;
        public String m_strType;
        public String m_strEncoding;
        public String m_SASFormat;

        private Column() {
        }
    }
}

