/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.iquery.execution2.MLSValueInterface;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.metadata.physical.MLSLookupDetailsTable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class MLSValue
implements MLSValueInterface {
    private MLSLookup mlsLookup = null;
    private Locale localeFound = null;
    private double localeLevel = Double.MAX_VALUE;
    private Object value = null;
    private boolean isTransient = true;
    private List<Object> extraDataColumnValues = Collections.emptyList();

    public MLSValue(MLSLookup mlsLookup, Locale initialLocaleFound, Object initialValue) {
        this.mlsLookup = mlsLookup;
        this.localeFound = initialLocaleFound;
        this.value = initialValue;
        this.isTransient = true;
    }

    boolean isTransient() {
        return this.isTransient;
    }

    void setIsTransient(boolean isDefault) {
        this.isTransient = isDefault;
    }

    public void setLookupQueryDef(MLSLookup mlsLookup) {
        this.mlsLookup = mlsLookup;
    }

    public void setLocaleFound(Locale localeFound) {
        this.localeFound = localeFound;
    }

    public void setLocaleLevel(double localeLevel) {
        this.localeLevel = localeLevel;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExtraDataColumnValues(List<Object> extraDataColumnValues) {
        this.extraDataColumnValues = extraDataColumnValues;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public MLSLookup getLookupQueryDef() {
        return this.mlsLookup;
    }

    @Override
    public Locale getLocaleFound() {
        return this.localeFound;
    }

    @Override
    public double getLocaleLevel() {
        return this.localeLevel;
    }

    @Override
    public List<Object> getExtraDataColumnValues() {
        return this.extraDataColumnValues;
    }

    @Override
    public String[] getExtraDataColumnNames() {
        String[] extraColumnNames = null;
        if (this.mlsLookup instanceof MLSLookupDetailsTable) {
            MLSLookupDetailsTable mlsDetailsTable = (MLSLookupDetailsTable)this.mlsLookup;
            try {
                extraColumnNames = mlsDetailsTable.getExtraColumnNames();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return extraColumnNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append('[').append(this.localeFound);
        if (this.localeLevel > 1.0) {
            sb.append(':').append(this.localeLevel);
        }
        sb.append(']');
        String[] extraColumnNames = this.getExtraDataColumnNames();
        String sep = "";
        if (this.extraDataColumnValues != null && this.extraDataColumnValues.size() > 0) {
            sb.append("(");
            for (int i = 0; i < this.extraDataColumnValues.size(); ++i) {
                Object object = this.extraDataColumnValues.get(i);
                sb.append(sep);
                if (extraColumnNames != null && i < extraColumnNames.length) {
                    sb.append(extraColumnNames[i]);
                    sb.append("=");
                }
                sb.append(object);
                sep = ",";
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

