/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import com.sas.iquery.execution2.MLSLocaleCache;
import com.sas.iquery.execution2.MLSResultSetInterface;
import com.sas.iquery.execution2.MLSResultSetMetaDataInterface;
import com.sas.iquery.execution2.MLSValue;
import com.sas.iquery.execution2.MLSValueInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.rio.MVASQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class MLSResultSetExtension
implements MLSResultSetInterface,
MLSResultSetMetaDataInterface {
    private static final String _KEY_ = "_key_";
    private static final String _LOCALE_ = "_locale_";
    private static final String _LOCALE_LEVEL_ = "_localeLevel_";
    private static final String _VALUE_ = "_value_";
    private final CredentialResolver _resolver;
    private final ResultSet _resultSet;
    private final ResultSetMetaData _resultSetMetadata;
    private final Map<String, MLSLookup> _lookupsByColumnName;
    private Set<Locale> _allLocales = null;
    private Map<String, Set<Locale>> _columnLocales = null;
    private Map<String, MLSValue> _valuesCache;

    MLSResultSetExtension(CredentialResolver resolver, ResultSet resultSet, Map<String, MLSLookup> lookupsByColumnName) throws SQLException {
        this._resolver = resolver;
        this._resultSet = resultSet;
        this._resultSetMetadata = resultSet.getMetaData();
        this._lookupsByColumnName = lookupsByColumnName;
    }

    @Override
    public MLSResultSetMetaDataInterface getMLSResultSetMetaData() throws SQLException {
        return this;
    }

    @Override
    public ResultSet getResultSet() {
        return this._resultSet;
    }

    @Override
    public boolean isLocalized(int columnIndex) throws SQLException {
        return this.isColumnLocalized(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex, Locale locale) throws SQLException {
        String columnName;
        MLSLookup mlsLookup;
        Object keyObjectIn;
        Object out = keyObjectIn = this._resultSet.getObject(columnIndex);
        if (this._lookupsByColumnName != null && this._lookupsByColumnName.size() > 0 && (mlsLookup = this._lookupsByColumnName.get(columnName = this._resultSetMetadata.getColumnName(columnIndex))) != null) {
            out = this.queryForValues(this._resolver, this._resultSet, this._valuesCache, columnName, locale, keyObjectIn, mlsLookup);
        }
        return out;
    }

    public Object getObject(String columnName, Locale locale) throws SQLException {
        MLSLookup mlsLookup;
        Object keyObjectIn;
        Object out = keyObjectIn = this._resultSet.getObject(columnName);
        if (this._lookupsByColumnName != null && this._lookupsByColumnName.size() > 0 && (mlsLookup = this._lookupsByColumnName.get(columnName)) != null) {
            out = this.queryForValues(this._resolver, this._resultSet, this._valuesCache, columnName, locale, keyObjectIn, mlsLookup);
        }
        return out;
    }

    @Override
    public String getString(int columnIndex, Locale locale) throws SQLException {
        Object object = this.getObject(columnIndex, locale);
        String string = object instanceof MLSValue ? ((MLSValueInterface)object).getString() : String.valueOf(object);
        return string;
    }

    public String getString(String columnName, Locale locale) throws SQLException {
        Object object = this.getObject(columnName, locale);
        String string = object instanceof MLSValue ? ((MLSValueInterface)object).getString() : String.valueOf(object);
        return string;
    }

    @Override
    public boolean isLocalized() throws SQLException {
        boolean isLocalized = this._lookupsByColumnName != null && this._lookupsByColumnName.size() > 0;
        return isLocalized;
    }

    @Override
    public boolean isColumnLocalized(int columnIndex) throws SQLException {
        String columnName = this._resultSetMetadata.getColumnName(columnIndex);
        return this.isColumnLocalized(this._lookupsByColumnName, columnName);
    }

    private boolean isColumnLocalized(Map<String, MLSLookup> lookupsByColumnName, String columnName) {
        MLSLookup mlsLookup;
        boolean isColumnLocalized = lookupsByColumnName != null && lookupsByColumnName.size() > 0 ? (mlsLookup = lookupsByColumnName.get(columnName)) != null : false;
        return isColumnLocalized;
    }

    @Override
    public Set<Locale> getColumnLocales(int columnIndex) throws SQLException {
        String columnName = this._resultSetMetadata.getColumnName(columnIndex);
        return this.getColumnLocales(this._resolver, this._resultSet, this._columnLocales, this._lookupsByColumnName, columnName);
    }

    private Set<Locale> getColumnLocales(CredentialResolver resolver, ResultSet resultSet, Map<String, Set<Locale>> columnLocales, Map<String, MLSLookup> lookupsByColumnName, String columnName) throws SQLException {
        MLSLookup mlsLookup;
        Set<Locale> locales = Collections.emptySet();
        if (lookupsByColumnName != null && lookupsByColumnName.size() > 0 && (mlsLookup = lookupsByColumnName.get(columnName)) != null) {
            locales = this.queryForLocales(resolver, resultSet, columnLocales, columnName, mlsLookup);
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Locale> getLocales() throws SQLException {
        boolean init = false;
        Object object = this;
        synchronized (object) {
            if (this._allLocales == null) {
                init = true;
                this._allLocales = Collections.synchronizedSet(new LinkedHashSet());
            }
        }
        if (this._lookupsByColumnName != null && this._lookupsByColumnName.size() > 0) {
            object = this._allLocales;
            synchronized (object) {
                if (init) {
                    for (Map.Entry<String, MLSLookup> entry : this._lookupsByColumnName.entrySet()) {
                        String columnName = entry.getKey();
                        MLSLookup mlsLookup = entry.getValue();
                        if (mlsLookup == null) continue;
                        Set<Locale> locales = this.queryForLocales(this._resolver, this._resultSet, this._columnLocales, columnName, mlsLookup);
                        this._allLocales.addAll(locales);
                    }
                }
            }
        }
        return this._allLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Locale> queryForLocales(CredentialResolver resolver, ResultSet resultSet, Map<String, Set<Locale>> columnLocales, String columnName, MLSLookup mlsLookup) throws SQLException {
        Set<Locale> locales;
        boolean init = false;
        Object object = this;
        synchronized (object) {
            if (columnLocales == null) {
                columnLocales = Collections.synchronizedMap(new LinkedHashMap());
                init = true;
                locales = Collections.synchronizedSet(new LinkedHashSet());
                columnLocales.put(columnName, locales);
            } else {
                locales = columnLocales.get(columnName);
                if (locales == null) {
                    init = true;
                    locales = Collections.synchronizedSet(new LinkedHashSet());
                    columnLocales.put(columnName, locales);
                }
            }
        }
        object = columnLocales;
        synchronized (object) {
            if (init) {
                String sql;
                LinkedHashSet<String> needLibrefAssignments = new LinkedHashSet<String>();
                try {
                    sql = mlsLookup.getLookupLocalesSql(resolver, needLibrefAssignments);
                }
                catch (MetadataException e) {
                    throw new SQLException(e);
                }
                this.loadLocales(resultSet, locales, sql, needLibrefAssignments);
            }
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocales(ResultSet resultSet, Set<Locale> locales, String sql, Set<String> needLibrefAssignments) throws SQLException {
        Connection connection = resultSet.getStatement().getConnection();
        try (Statement statement = connection.createStatement();){
            for (String libnameStatement : needLibrefAssignments) {
                statement.executeUpdate(libnameStatement);
            }
            try (ResultSet executeQuery = statement.executeQuery(sql);){
                LinkedHashSet<String> localeStrings = new LinkedHashSet<String>();
                while (executeQuery.next()) {
                    String localeString = executeQuery.getString(1);
                    localeStrings.add(localeString);
                }
                for (String localeString : localeStrings) {
                    Locale locale = IOMServerUtils.ConvertSASLocaleToJavaLocale(localeString);
                    locales.add(locale);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MLSValueInterface queryForValues(CredentialResolver resolver, ResultSet resultSet, Map<String, MLSValue> valuesCache, String columnName, Locale locale, Object keyObjectIn, MLSLookup mlsLookup) throws SQLException {
        boolean returnExtraColumns = true;
        String keyObjectText = String.valueOf(keyObjectIn);
        Locale localeCacheKeyIn = MLSLocaleCache.putInstance(locale);
        String masterLookupKey = columnName + "\n" + keyObjectText + "\n" + localeCacheKeyIn;
        MLSResultSetExtension mLSResultSetExtension = this;
        synchronized (mLSResultSetExtension) {
            if (valuesCache == null) {
                valuesCache = new LinkedHashMap<String, MLSValue>();
            }
        }
        MLSValue mlsValueDef = null;
        Map<String, MLSValue> map = valuesCache;
        synchronized (map) {
            boolean init = false;
            mlsValueDef = valuesCache.get(masterLookupKey);
            if (mlsValueDef == null) {
                init = true;
                mlsValueDef = new MLSValue(mlsLookup, localeCacheKeyIn, keyObjectIn);
                valuesCache.put(masterLookupKey, mlsValueDef);
            }
            if (init || mlsValueDef.isTransient()) {
                String sql;
                LinkedHashSet<String> needLibrefAssignments = new LinkedHashSet<String>();
                try {
                    sql = mlsLookup.getLookupValuesSql(resolver, needLibrefAssignments, columnName, returnExtraColumns, localeCacheKeyIn, keyObjectText);
                }
                catch (MetadataException e) {
                    throw new SQLException(e);
                }
                this.loadValueDef(resultSet, valuesCache, mlsValueDef, mlsLookup, columnName, keyObjectText, localeCacheKeyIn, sql, needLibrefAssignments);
            }
        }
        return mlsValueDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValueDef(ResultSet resultSet, Map<String, MLSValue> valuesCache, MLSValue mlsValueDef, MLSLookup mlsLookup, String columnName, String keyObjectText, Locale localeCacheKeyIn, String sql, Set<String> needLibrefAssignments) throws SQLException {
        Connection connection = resultSet.getStatement().getConnection();
        try (Statement statement = connection.createStatement();){
            for (String libnameStatement : needLibrefAssignments) {
                statement.executeUpdate(libnameStatement);
            }
            ResultSet executeQuery = null;
            try {
                executeQuery = statement.executeQuery(sql);
            }
            catch (MVASQLException e) {
                e.printStackTrace();
                throw e;
            }
            try {
                ResultSetMetaData metaData2 = executeQuery.getMetaData();
                int columnCount = metaData2.getColumnCount();
                while (executeQuery.next()) {
                    String masterLookupKey2;
                    MLSValue mlsValueDef2;
                    String key = executeQuery.getString(_KEY_);
                    double localeLevel = executeQuery.getDouble(_LOCALE_LEVEL_);
                    String localeText = executeQuery.getString(_LOCALE_);
                    Locale localeFound = MLSLocaleCache.getInstanceFromSASLocale(localeText);
                    String value = executeQuery.getString(_VALUE_);
                    if (key.equals(keyObjectText) && localeLevel > 0.0 && localeLevel < mlsValueDef.getLocaleLevel()) {
                        mlsValueDef.setLookupQueryDef(mlsLookup);
                        mlsValueDef.setLocaleFound(localeFound);
                        mlsValueDef.setLocaleLevel(localeLevel);
                        mlsValueDef.setValue(value);
                        mlsValueDef.setIsTransient(false);
                        if (columnCount > 4) {
                            ArrayList<Object> extraDataColumnValues = new ArrayList<Object>(columnCount - 4);
                            for (int i = 5; i <= columnCount; ++i) {
                                Object object = executeQuery.getObject(i);
                                extraDataColumnValues.add(object);
                            }
                            mlsValueDef.setExtraDataColumnValues(extraDataColumnValues);
                        }
                    }
                    if (localeFound == null || localeFound.equals(localeCacheKeyIn) || (mlsValueDef2 = valuesCache.get(masterLookupKey2 = columnName + "\n" + keyObjectText + "\n" + localeFound)) != null) continue;
                    mlsValueDef2 = new MLSValue(mlsLookup, localeFound, value);
                    if (columnCount > 4) {
                        ArrayList<Object> extraDataColumnValues = new ArrayList<Object>(columnCount - 4);
                        for (int i = 5; i <= columnCount; ++i) {
                            Object object = executeQuery.getObject(i);
                            extraDataColumnValues.add(object);
                        }
                        mlsValueDef2.setExtraDataColumnValues(extraDataColumnValues);
                    }
                    valuesCache.put(masterLookupKey2, mlsValueDef2);
                }
            }
            finally {
                if (executeQuery != null) {
                    executeQuery.close();
                }
            }
        }
    }
}

