/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution2;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class MLSLocaleCache {
    private static final ConcurrentHashMap<String, Locale> cache = new ConcurrentHashMap(32);

    private MLSLocaleCache() {
    }

    private static String getLocaleKey(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(language).append('_').append(country).append('_').append(variant);
        String key = sb.toString();
        return key;
    }

    public static Locale getInstance(String language, String country, String variant) {
        Locale l;
        String key = MLSLocaleCache.getLocaleKey(language, country, variant);
        Locale locale = cache.get(key);
        if (locale == null && (l = cache.putIfAbsent(key, locale = new Locale(language, country, variant))) != null) {
            locale = l;
        }
        return locale;
    }

    public static Locale putInstance(Locale inLocale) {
        String variant;
        String country;
        String language = inLocale.getLanguage();
        String key = MLSLocaleCache.getLocaleKey(language, country = inLocale.getCountry(), variant = inLocale.getVariant());
        Locale outLocale = cache.get(key);
        if (outLocale == null && (outLocale = cache.putIfAbsent(key, inLocale)) == null) {
            outLocale = inLocale;
        }
        return outLocale;
    }

    public static Locale getInstanceFromSASLocale(String localeString) {
        if (localeString == null || localeString.trim().length() == 0) {
            return null;
        }
        localeString = localeString.trim();
        String language = "";
        String country = "";
        String variant = "";
        String[] parts = localeString.split("[\\s\\-\\_]", 3);
        if (parts.length > 0) {
            language = parts[0];
            if (language.length() == 2) {
                language = language.toLowerCase();
            }
            if (parts.length > 1) {
                country = parts[1];
                if (parts.length > 2) {
                    variant = parts[2];
                }
            }
        }
        Locale javaLocale = MLSLocaleCache.getInstance(language, country, variant);
        return javaLocale;
    }
}

