/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.iquery.execution.util.NamedNode;
import com.sas.storage.olap.TupleElementType;

public class TreeUtils {
    public static NamedNode addNameNodes(NamedNode root, String[] nodeNames, String[] nodeLabels, TupleElementType[] elementTypes, int startIdx) {
        return TreeUtils.addNameNodes(root, nodeNames, nodeLabels, elementTypes, startIdx, false);
    }

    public static NamedNode addNameNodes(NamedNode root, String[] nodeNames, String[] nodeLabels, TupleElementType[] elementTypes, int startIdx, boolean lastAffinity) {
        String name = nodeNames[startIdx];
        String label = nodeLabels == null || nodeLabels.length < startIdx ? name : nodeLabels[startIdx];
        NamedNode child = root.getChild(name);
        if (child == null) {
            child = new NamedNode(name, label);
            child.setLastAffinity(lastAffinity);
            child.setType(elementTypes[startIdx]);
            root.addChild(child);
        }
        if (++startIdx == nodeNames.length) {
            return child;
        }
        return TreeUtils.addNameNodes(child, nodeNames, nodeLabels, elementTypes, startIdx, lastAffinity);
    }

    public static void mergeTrees(NamedNode dest, NamedNode source) {
        for (NamedNode sourceChild : source.getChildren()) {
            NamedNode destChild = dest.getChild(sourceChild.getName());
            if (destChild == null) {
                destChild = dest.addChild((NamedNode)sourceChild.clone());
            }
            TreeUtils.mergeTrees(destChild, sourceChild);
        }
    }

    public static int getFirstChildDepth(NamedNode node) {
        if (!node.hasChildren()) {
            return 0;
        }
        return 1 + TreeUtils.getFirstChildDepth(node.getChildren().get(0));
    }
}

