/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.iquery.execution.util.RetrieveStoredProcessPromptValues;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import java.rmi.RemoteException;
import java.util.List;
import javax.annotation.Nonnull;

public class StoredProcessUtils {
    public static final String STORED_PROCESS_PROMPT_VALUES_REF = "spValueRef";
    public static final String STORED_PROCESS_PROMPT_TIMESTAMP_REF = "spTimestampRef";
    private static final String READ_STORED_PROCESS_DATE_TEMPLATE = "<TEMPLATES><ClassifierMap Name=\"\" MetadataUpdated=\"\"/></TEMPLATES>";

    public static StoredProcess2Interface createStoredProcessFromMetadata(StoredProcessInterface storedProcess, DataSelection dataSelection) throws ServiceException, RemoteException {
        StoredProcess2Interface sp = null;
        StoredProcessOptions spOptions = new StoredProcessOptions();
        Object serviceObject = storedProcess.newServiceObject(spOptions);
        if (serviceObject instanceof StoredProcess2Interface) {
            sp = (StoredProcess2Interface)serviceObject;
        }
        return sp;
    }

    public static PromptValuesInterface retrieveStoredProcessPromptValues(RunStoredProcess runStoredProcess, PromptValuesInterface promptValues) {
        PromptValuesInterface result;
        try {
            String rspID = runStoredProcess.getID();
            RetrieveStoredProcessPromptValues visitor = new RetrieveStoredProcessPromptValues(rspID);
            promptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
            result = visitor.getPromptValues();
        }
        catch (InvalidIDException e) {
            result = null;
        }
        return result;
    }

    @Nonnull
    public static List<PromptValuesInterface> retrieveStoredProcessPromptValues(PromptValuesInterface promptValues) {
        RetrieveStoredProcessPromptValues visitor = new RetrieveStoredProcessPromptValues();
        promptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
        return visitor.getAllPromptValues();
    }

    public static boolean hasStoredProcessBeenUpdated(StoredProcessInterface storedProcess, long date) throws RemoteException, ServiceException {
        FilterInterface filter;
        String mdEntityKey;
        boolean rval = true;
        RepositoryInterface repos = storedProcess.getRepository();
        BrowseMetadataInterface browseFetch = repos.browseFetch(mdEntityKey = storedProcess.getEntityKey(), filter = StoredProcessUtils.getMetadataQueryFilter());
        if (browseFetch != null) {
            long currentModDate = browseFetch.getModifyDate();
            rval = currentModDate != date;
        }
        return rval;
    }

    private static FilterInterface getMetadataQueryFilter() {
        Filter rval = new Filter();
        rval.setOMRTemplate(READ_STORED_PROCESS_DATE_TEMPLATE);
        int queryFlags = -2080372348;
        rval.setOMRFlags(queryFlags);
        return rval;
    }
}

