/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.storage.olap.TupleElementType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamedNode {
    private String _name;
    private String _label;
    private int _leafCount = -1;
    private int _leafOffset = -1;
    private boolean _hasLastAffinity = false;
    private NamedNode _parent = null;
    private List<NamedNode> _children = null;
    private Map<String, NamedNode> _childrenByName = null;
    private TupleElementType _type;

    public NamedNode(String name, String label) {
        this._name = name;
        this._label = label != null ? label : name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this._label = name;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label != null ? this._label : this._name;
    }

    private void setParent(NamedNode parent) {
        this._parent = parent;
    }

    public NamedNode getParent() {
        return this._parent;
    }

    public void setLastAffinity(boolean lastAffinity) {
        this._hasLastAffinity = lastAffinity;
    }

    public boolean hasLastAffinity() {
        return this._hasLastAffinity;
    }

    public NamedNode addChild(NamedNode node) {
        if (this._children == null) {
            this._children = new ArrayList<NamedNode>();
            this._childrenByName = new HashMap<String, NamedNode>();
        }
        if (!this._children.isEmpty() && this._children.get(this._children.size() - 1).hasLastAffinity()) {
            this._children.add(this._children.size() - 1, node);
        } else {
            this._children.add(node);
        }
        this._childrenByName.put(node.getName(), node);
        node.setParent(this);
        return node;
    }

    public NamedNode getChild(String name) {
        if (this._childrenByName == null) {
            return null;
        }
        return this._childrenByName.get(name);
    }

    public List<NamedNode> getChildren() {
        if (this._children == null) {
            return new ArrayList<NamedNode>(0);
        }
        return this._children;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public NamedNode cloneDeep() {
        NamedNode clone = (NamedNode)this.clone();
        for (NamedNode child : this.getChildren()) {
            clone.addChild(child.cloneDeep());
        }
        return clone;
    }

    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Per James, read only clone does not require call to super")
    public Object clone() {
        NamedNode clone = new NamedNode(this._name, this._label);
        clone.setLastAffinity(this._hasLastAffinity);
        return clone;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ": name='" + this.getName() + "', label='" + this.getLabel() + "', lo=" + this._leafOffset + ", lc=" + this._leafCount + " type=" + this._type + ", chidren=" + (this._children == null ? null : Integer.valueOf(this._children.size())) + ")";
    }

    public String toTreeString() {
        StringBuffer sb = new StringBuffer();
        this.printTree(this, 0, sb);
        return sb.toString();
    }

    private void printTree(NamedNode node, int level, StringBuffer sb) {
        for (int l = 0; l < level; ++l) {
            sb.append("    ");
        }
        sb.append(node.toString());
        if (node.hasLastAffinity()) {
            sb.append("<last>");
        }
        sb.append("\n");
        ++level;
        for (NamedNode child : node.getChildren()) {
            this.printTree(child, level, sb);
        }
    }

    public int getLeafCount() {
        return this._leafCount;
    }

    public int getLeafOffset() {
        return this._leafOffset;
    }

    public int updateLeafCount(int leafOffset) {
        this._leafOffset = leafOffset++;
        if (this.hasChildren()) {
            for (NamedNode child : this.getChildren()) {
                leafOffset = child.updateLeafCount(leafOffset);
            }
        }
        this._leafCount = leafOffset - this._leafOffset;
        return leafOffset;
    }

    public NamedNode getLeaf(String[] ancestorNames) {
        return this.getLeaf(ancestorNames, 0);
    }

    private NamedNode getLeaf(String[] ancestorNames, int nameIndex) {
        NamedNode child;
        Object returnValue = ancestorNames.length == nameIndex ? this : ((child = this.getChild(ancestorNames[nameIndex])) == null ? null : child.getLeaf(ancestorNames, ++nameIndex));
        return returnValue;
    }

    public NamedNode getLastLeaf() {
        if (!this.hasChildren()) {
            return this;
        }
        List<NamedNode> children = this.getChildren();
        NamedNode lastChild = children.get(children.size() - 1);
        return lastChild.getLastLeaf();
    }

    public TupleElementType getType() {
        return this._type;
    }

    public void setType(TupleElementType type) {
        this._type = type;
    }

    public String getPath() {
        StringBuffer path = new StringBuffer(this._name);
        for (NamedNode parent = this._parent; parent != null; parent = parent.getParent()) {
            path.insert(0, '/').insert(0, parent.getName());
        }
        return path.toString();
    }
}

