/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import java.io.Serializable;
import java.util.Arrays;

public class Chunk<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int _chunkNumber;
    protected final E[] _objects;
    protected int _firstListIndexContained;
    private boolean _isModified = false;

    public Chunk(int chunkNumber, int size, int firstListIndexContained) {
        this._chunkNumber = chunkNumber;
        this._objects = new Object[size];
        this._firstListIndexContained = firstListIndexContained;
    }

    public int getChunkNumber() {
        return this._chunkNumber;
    }

    public int getSize() {
        return this._objects.length;
    }

    public void set(int chunkIdx, E element) {
        this.setIsModified(true);
        this._objects[chunkIdx] = element;
    }

    public int getFirstListIndexContained() {
        return this._firstListIndexContained;
    }

    public int getLastListIndexContained() {
        return this._firstListIndexContained + this._objects.length - 1;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public E get(int chunkIdx) {
        return this._objects[chunkIdx];
    }

    public String toString() {
        return "(Chunk number=" + this._chunkNumber + "\n" + Arrays.toString(this._objects) + "\n)";
    }

    public void setIsModified(boolean isModified) {
        this._isModified = isModified;
    }

    public int countNulls() {
        int nullCount = 0;
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] != null) continue;
            ++nullCount;
        }
        return nullCount;
    }
}

