/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.util;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.util.Chunk;
import com.sas.iquery.execution.util.ChunkFile;
import com.sas.iquery.execution.util.FileBackedListInterface;
import com.sas.iquery.util.impl.MessageFormatter;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicFileBackedList<E>
extends AbstractList<E>
implements FileBackedListInterface<E> {
    private static final int DEFAULT_CHUNK_SIZE = 250;
    private int _chunkSize;
    private int _size = 0;
    private Chunk<E> _readChunk;
    private Chunk<E> _writeChunk;
    private ChunkFile<E> _chunkFile;
    private static final Logger _logger = LogManager.getLogger(BasicFileBackedList.class);

    public BasicFileBackedList() throws IOException {
        this(250);
    }

    public BasicFileBackedList(Collection<E> source) throws IOException {
        this(250, source);
    }

    public BasicFileBackedList(int chunkSize) throws IOException {
        this._chunkSize = chunkSize;
    }

    public BasicFileBackedList(int chunkSize, Collection<E> source) throws IOException {
        this(chunkSize);
        for (E o : source) {
            this.add(o);
        }
    }

    @Override
    public E get(int listIndex) {
        int chunkIdx;
        if (listIndex >= this._size || listIndex < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(listIndex));
        }
        try {
            chunkIdx = this.ensureReadChunkContains(listIndex);
        }
        catch (IOException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("BasicFileBackedList.ErrorAtFileIndex.fmt.txt", this._chunkFile.getFile().getPath(), listIndex);
            throw new IQueryServicesRuntimeException(msg, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("BasicFileBackedList.ErrorAtFileIndex.fmt.txt", this._chunkFile.getFile().getPath(), listIndex);
            throw new IQueryServicesRuntimeException(msg, (Throwable)e);
        }
        return this.getReadChunk().get(chunkIdx);
    }

    @Override
    public int size() {
        return this._size;
    }

    private void updateSize(int listIndex) {
        if (this._size <= listIndex) {
            this._size = listIndex + 1;
        }
        ++this.modCount;
    }

    private int ensureReadChunkContains(int listIndex) throws IOException, ClassNotFoundException {
        if (listIndex < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(listIndex));
        }
        if (listIndex > this.getReadChunk().getLastListIndexContained() || listIndex < this.getReadChunk().getFirstListIndexContained()) {
            int newChunkNumber;
            if (this.getReadChunk().isModified()) {
                _logger.debug("Current read chunk modified; ignoring.");
            }
            if (this.getWriteChunk()._chunkNumber == (newChunkNumber = listIndex / this._chunkSize)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Setting read chunk to reference write chunk " + newChunkNumber);
                }
                this.setReadChunk(this.getWriteChunk());
            } else if (this.getChunkFile().containsChunk(newChunkNumber)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Loading chunk " + newChunkNumber + " as read chunk");
                }
                this.setReadChunk(this.performLoad(newChunkNumber));
            } else {
                int chunkFirstIndex = newChunkNumber * this._chunkSize;
                this.setReadChunk(new Chunk(newChunkNumber, this._chunkSize, chunkFirstIndex));
            }
        }
        return listIndex % this._chunkSize;
    }

    private int ensureWriteChunkContains(int listIndex) throws IOException, ClassNotFoundException {
        if (listIndex < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(listIndex));
        }
        if (listIndex > this.getWriteChunk().getLastListIndexContained() || listIndex < this.getWriteChunk().getFirstListIndexContained()) {
            int newChunkNumber;
            if (this.getWriteChunk().isModified()) {
                this.performStore(this.getWriteChunk());
            }
            if (this.getReadChunk()._chunkNumber == (newChunkNumber = listIndex / this._chunkSize)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Setting write chunk to reference read chunk " + newChunkNumber);
                }
                this.setWriteChunk(this.getReadChunk());
            } else if (this.getChunkFile().containsChunk(newChunkNumber)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Loading chunk " + newChunkNumber + " as write chunk");
                }
                this.setWriteChunk(this.performLoad(newChunkNumber));
            } else {
                int chunkFirstIndex = newChunkNumber * this._chunkSize;
                this.setWriteChunk(new Chunk(newChunkNumber, this._chunkSize, chunkFirstIndex));
            }
        }
        return listIndex % this._chunkSize;
    }

    protected void performStore(Chunk<E> chunk) throws IOException {
        this.getChunkFile().store(chunk);
    }

    protected Chunk<E> performLoad(int newChunkNumber) throws IOException, ClassNotFoundException {
        ChunkFile<E> file = this.getChunkFile();
        return file.load(newChunkNumber);
    }

    @Override
    public boolean add(E o) {
        int chunkIdx;
        if (!(o instanceof Serializable)) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("BasicFileBackedList.notSerializable.fmt.txt", o.getClass());
            throw new IQueryServicesRuntimeException(message, (Throwable)new NotSerializableException(o.getClass().getName()));
        }
        try {
            chunkIdx = this.ensureWriteChunkContains(this.size());
        }
        catch (IOException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("BasicFileBackedList.ErrorWritingToFile.fmt.txt", this._chunkFile.getFile().getPath());
            throw new IQueryServicesRuntimeException(msg, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("BasicFileBackedList.ErrorWritingToFile.fmt.txt", this._chunkFile.getFile().getPath());
            throw new IQueryServicesRuntimeException(msg, (Throwable)e);
        }
        this.getWriteChunk().set(chunkIdx, o);
        this.updateSize(this.size());
        return true;
    }

    private Chunk<E> getWriteChunk() {
        if (this._writeChunk == null) {
            this._writeChunk = this.getReadChunk();
        }
        return this._writeChunk;
    }

    private void setWriteChunk(Chunk<E> chunk) {
        this._writeChunk = chunk;
    }

    private Chunk<E> getReadChunk() {
        if (this._readChunk == null) {
            this._readChunk = new Chunk(0, this._chunkSize, 0);
        }
        return this._readChunk;
    }

    private void setReadChunk(Chunk<E> chunk) {
        this._readChunk = chunk;
    }

    @Override
    public ChunkFile<E> getChunkFile() {
        if (this._chunkFile == null) {
            this._chunkFile = new ChunkFile();
        }
        return this._chunkFile;
    }

    @Override
    public String toString() {
        return "(FileBackedList size=" + this._size + ", chunkSize=" + this._chunkSize + ", readChunk=" + this.getReadChunk().getChunkNumber() + ", writeChunk=" + this.getWriteChunk().getChunkNumber() + ")";
    }

    @Override
    public void flush() throws IOException {
        if (this.getWriteChunk().isModified()) {
            this.performStore(this.getWriteChunk());
        }
        this.getChunkFile().flush();
    }

    @Override
    public void close() throws IOException {
        if (this._chunkFile != null) {
            this._chunkFile.close();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return super.listIterator(index);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.close();
        }
        catch (IOException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
    }
}

