/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.relational.offline;

import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ExecutionProcessor;
import com.sas.iquery.execution.instructions.ConnectionInstruction;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.relational.offline.IndexCalculator;
import com.sas.iquery.execution.relational.offline.MemoryBuffer;
import com.sas.iquery.execution.relational.offline.PhysicalFileSupport;
import com.sas.iquery.execution.relational.offline.ResultSetMetaDataCache;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageFile {
    private List _instructions;
    private boolean _isClosed = false;
    private RetrievalPolicy _retrievalPolicy;
    public static final int LOADOK = 1;
    public static final int MEMORYUPDATENEEDED = 2;
    private PhysicalFileSupport _physicalFileSupport = null;
    private ResultSetMetaDataCache _metaData = null;
    private File _physicalFile = null;
    private int _currentRow = 0;
    private boolean _hasMoreData = false;
    private MemoryBuffer _currentMemoryBuffer = null;
    private int _currentFileBlockIndex = -1;
    private int _currentMemoryBlockIndex = -1;
    private long _lastRow = -1L;
    private int _position = -1;
    private int _resultSetType = 0;
    private int _lastAccessedColumnIndex = 0;
    private boolean _isDual;
    private int _columnCount;
    private int _columnOffset = 0;
    private static final Logger _logger = LogManager.getLogger(PageFile.class);

    public PageFile(File file, RetrievalPolicy retrievalPolicy) {
        this.setPhysicalFile(file);
        this.setRetrievalPolicy(retrievalPolicy);
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": Created new page file " + file.getAbsolutePath());
        }
    }

    public void setInstructions(List instructions) {
        this._instructions = new ArrayList();
        this._instructions.addAll(instructions);
    }

    public void initialize(ResultSet resultSet, boolean isDual) throws IOException, SQLException {
        this.storeMetaData(resultSet);
        this._hasMoreData = true;
        this._isDual = isDual;
        this._columnCount = this._metaData.getColumnCount();
        int bufferSize = this._isDual ? 2 * this._columnCount : this._columnCount;
        this._columnOffset = this._isDual ? this._columnCount : 0;
        this._physicalFileSupport = new PhysicalFileSupport(this._physicalFile);
        this._currentMemoryBuffer = new MemoryBuffer(this.getOfflineConfig().getMemoryBlockSize(), bufferSize);
        this._resultSetType = resultSet.getType();
    }

    public boolean hasMoreDataBlocks() {
        return this._hasMoreData;
    }

    public File getPhysicalFile() {
        return this._physicalFile;
    }

    public void setPhysicalFile(File file) {
        this._physicalFile = file;
    }

    public int getMemoryBlockCount() {
        return this._physicalFileSupport.getMemoryBufferCount();
    }

    private void storeMetaData(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        this._metaData = new ResultSetMetaDataCache();
        this._metaData.populate(metaData);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void close() throws IOException {
        this._isClosed = true;
        this._physicalFileSupport.close();
    }

    public ResultSetMetaDataCache getMetaData() {
        return this._metaData;
    }

    public boolean position(int rowIndex) throws ExecutionException, IntelligentQueryException, SQLException, IOException, ClassNotFoundException {
        if (this._isClosed) {
            throw new SQLException(IQDataServicesResourceBundle.getStringResource("PageFile.isClosed.txt"));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": position(" + rowIndex + ")");
        }
        boolean returnValue = true;
        if (rowIndex == 0 || this._lastRow == 0L) {
            rowIndex = 0;
            returnValue = false;
        }
        if (rowIndex < 0 && this._lastRow < 0L) {
            this.calcLastRow(rowIndex);
        }
        if (this._lastRow > 0L && rowIndex < 0 && (rowIndex = (int)this._lastRow - rowIndex * -1 + 1) < 0) {
            rowIndex = 0;
            returnValue = false;
            this._position = rowIndex;
        }
        if (!returnValue || this._lastRow > 0L && (long)rowIndex > this._lastRow && !this.hasMoreDataBlocks()) {
            returnValue = false;
            if (rowIndex != 0) {
                this._position = rowIndex = (int)this._lastRow + 1;
            }
        } else {
            int fileBlockCount = IndexCalculator.getFileBlockIndex(rowIndex, this.getOfflineConfig().getFileBlockSize());
            int memoryBlockIndex = IndexCalculator.getMemoryBlockIndex(rowIndex, this.getOfflineConfig().getMemoryBlockSize(), this.getOfflineConfig().getFileBlockSize());
            returnValue = this.getDataBlock(fileBlockCount);
            if (returnValue && memoryBlockIndex != this._currentMemoryBlockIndex) {
                this.getMemoryBlock(memoryBlockIndex);
            }
            if (this._lastRow != -1L && (long)rowIndex > this._lastRow) {
                returnValue = false;
                rowIndex = (int)this._lastRow + 1;
            }
        }
        if (returnValue || !this._hasMoreData) {
            this._position = rowIndex;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLastRow(int rowIndex) throws IntelligentQueryException, ExecutionException, SQLException, IOException, ClassNotFoundException {
        ResultSetInterface rsi = null;
        rsi = this.executeQuery();
        if (rsi != null) {
            try {
                ResultSet resultSet = (ResultSet)rsi.getResultSet();
                resultSet.last();
                resultSet.getString(1);
                this._lastRow = resultSet.getRow();
                this._currentRow = (int)(this._lastRow / (long)this.getOfflineConfig().getFileBlockSize()) * this.getOfflineConfig().getFileBlockSize();
            }
            finally {
                rsi.close();
            }
        }
    }

    public Object getValue(int rowIndex, int columnIndex) {
        int memoryBlockRowNumber = IndexCalculator.getMemoryBufferIndex(rowIndex, this.getOfflineConfig().getMemoryBlockSize(), this.getOfflineConfig().getFileBlockSize());
        this._lastAccessedColumnIndex = columnIndex;
        return this._currentMemoryBuffer.getData()[memoryBlockRowNumber - 1][columnIndex - 1];
    }

    public Object getObject(int rowIndex, int columnIndex) {
        int memoryBlockRowNumber = IndexCalculator.getMemoryBufferIndex(rowIndex, this.getOfflineConfig().getMemoryBlockSize(), this.getOfflineConfig().getFileBlockSize());
        this._lastAccessedColumnIndex = columnIndex;
        return this._currentMemoryBuffer.getData()[memoryBlockRowNumber - 1][columnIndex - 1 + this._columnOffset];
    }

    public void getFirstDataBlock(ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        this._currentRow = 0;
        boolean wasDataRead = this.getDataBlock(resultSet);
        if (wasDataRead) {
            this._currentFileBlockIndex = 0;
        }
    }

    public void getNextDataBlock(ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        this.getDataBlock(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDataBlock(int blockIndex) throws IntelligentQueryException, SQLException, IOException, ClassNotFoundException, ExecutionException {
        boolean returnValue = true;
        if (blockIndex != this._currentFileBlockIndex) {
            ResultSetInterface rsi = null;
            rsi = this.executeQuery();
            int oldCurrentRow = this._currentRow;
            if (rsi != null) {
                try {
                    ResultSet resultSet = (ResultSet)rsi.getResultSet();
                    this._currentRow = blockIndex * this.getOfflineConfig().getFileBlockSize();
                    returnValue = this.getDataBlock(resultSet);
                }
                finally {
                    rsi.close();
                }
            }
            if (returnValue) {
                this._currentFileBlockIndex = blockIndex;
            } else if (this._hasMoreData) {
                this._currentRow = oldCurrentRow;
            }
        }
        return returnValue;
    }

    protected ResultSetInterface executeQuery() throws DataRetrievalException, ExecutionException {
        List instructions;
        if (_logger.isInfoEnabled()) {
            _logger.info(Integer.toHexString(this.hashCode()) + ": Executing query");
        }
        if ((instructions = this.getInstructions()) == null || instructions.size() == 0) {
            throw new IllegalStateException("PageFile instructions not set. Cannot re-execute.");
        }
        ExecutionContext executionContext = ((ExecutionInstructionInterface)instructions.get(0)).getExecutionContext();
        ExecutionBlock executionBlock = new ExecutionBlock();
        boolean hasConnectionInstruction = false;
        for (ExecutionInstructionInterface instruction : instructions) {
            executionBlock.addInstruction(instruction);
            if (hasConnectionInstruction) continue;
            if (instruction instanceof ConnectionInstruction) {
                hasConnectionInstruction = true;
                continue;
            }
            if (!(instruction instanceof ExecutionBlock)) continue;
            hasConnectionInstruction = this.check4ConnectionInstruction((ExecutionBlock)instruction);
        }
        String resultId = "OfflineRepopulatedRS";
        executionBlock.setID(resultId);
        ExecutionProcessor processor = new ExecutionProcessor(this.getRetrievalPolicy());
        if (!hasConnectionInstruction && executionContext != null) {
            processor.setWorkspace(executionContext.getWorkspace());
            processor.setConnection(executionContext.getConnection());
            processor.setComputationalLocale(executionContext.getComputationalLocale());
            processor.setTemporaryTableName(executionContext.getTemporaryTableName());
        }
        processor.execute(Collections.singletonList(executionBlock));
        ResultSetInterface rsi = processor.getResult(resultId);
        return rsi;
    }

    private List getInstructions() {
        return this._instructions;
    }

    private boolean getDataBlock(ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        if (_logger.isDebugEnabled()) {
            _logger.debug(Integer.toHexString(this.hashCode()) + ": Reading data block from result set");
        }
        boolean returnValue = true;
        if (this._currentRow == 0) {
            resultSet.beforeFirst();
        } else {
            returnValue = resultSet.absolute(this._currentRow);
        }
        if (returnValue) {
            this._physicalFileSupport.clear();
            this._currentMemoryBuffer.clear();
            int fileRowCount = 1;
            int memoryRowCount = 0;
            returnValue = false;
            while (resultSet.next()) {
                int i;
                returnValue = true;
                ++memoryRowCount;
                if (!this._isDual) {
                    for (i = 1; i <= this._columnCount; ++i) {
                        Object formattedValue = null;
                        int columnType = this._metaData.getColumnType(i);
                        switch (columnType) {
                            case 8: {
                                formattedValue = resultSet.getDouble(i);
                                break;
                            }
                            case 12: {
                                formattedValue = resultSet.getString(i);
                                break;
                            }
                            default: {
                                formattedValue = resultSet.getObject(i);
                            }
                        }
                        this._currentMemoryBuffer.setValue(memoryRowCount, i, formattedValue, resultSet.wasNull());
                    }
                } else {
                    for (i = 1; i <= this._columnCount; ++i) {
                        this._currentMemoryBuffer.setValue(memoryRowCount, i, resultSet.getString(i), resultSet.wasNull());
                        this._currentMemoryBuffer.setValue(memoryRowCount, i + this._columnCount, resultSet.getObject(i), resultSet.wasNull());
                    }
                }
                if (memoryRowCount == this.getOfflineConfig().getMemoryBlockSize()) {
                    this._physicalFileSupport.writeMemoryBuffer(this._currentMemoryBuffer);
                    memoryRowCount = 0;
                    this._currentMemoryBuffer.clear();
                }
                if (++fileRowCount <= this.getOfflineConfig().getFileBlockSize()) continue;
            }
            this._currentRow += fileRowCount - 1;
            if (memoryRowCount > 0) {
                this._physicalFileSupport.writeMemoryBuffer(this._currentMemoryBuffer);
            }
            this._hasMoreData = resultSet.next();
            if (!this._hasMoreData) {
                this._lastRow = this._currentRow;
            }
            this._currentMemoryBlockIndex = 0;
            this._currentMemoryBuffer = this.getMemoryBlock(this._currentMemoryBlockIndex);
        }
        resultSet.close();
        return returnValue;
    }

    public MemoryBuffer getMemoryBlock(int blockIndex) throws IOException, ClassNotFoundException {
        int memoryBufferCount = this._physicalFileSupport.getMemoryBufferCount();
        if (blockIndex < memoryBufferCount) {
            this._currentMemoryBuffer = this._physicalFileSupport.readMemoryBuffer(blockIndex);
            this._currentMemoryBlockIndex = blockIndex;
        } else {
            this._currentMemoryBuffer.clear();
            this._currentMemoryBlockIndex = -1;
        }
        return this._currentMemoryBuffer;
    }

    public long getLastRow() {
        return this._lastRow;
    }

    public void setLastRow(long l) {
        this._lastRow = l;
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int i) {
        this._position = i;
    }

    public int getResultSetType() {
        return this._resultSetType;
    }

    public void setResultSetType(int i) {
        this._resultSetType = i;
    }

    public boolean wasNull(int rowIndex) {
        int memoryBlockRowNumber = IndexCalculator.getMemoryBufferIndex(rowIndex, this.getOfflineConfig().getMemoryBlockSize(), this.getOfflineConfig().getFileBlockSize());
        return this._currentMemoryBuffer.getNulls()[memoryBlockRowNumber - 1][this._lastAccessedColumnIndex - 1];
    }

    private void setRetrievalPolicy(RetrievalPolicy retrievalPolicy) {
        this._retrievalPolicy = new RetrievalPolicy(retrievalPolicy);
        this.getOfflineConfig().setOfflineResultSetsEnabled(false);
        this._retrievalPolicy.setPolicyValue(0);
    }

    private RetrievalPolicy getRetrievalPolicy() {
        return this._retrievalPolicy;
    }

    private OfflineResultSetConfiguration getOfflineConfig() {
        return this.getRetrievalPolicy().getOfflineResultSetConfiguration();
    }

    private boolean check4ConnectionInstruction(ExecutionBlock executionBlock) {
        boolean hasConnectionInstruction = false;
        ExecutionInstructionInterface[] instructions = executionBlock.getInstructions();
        if (instructions == null || instructions.length == 0) {
            return false;
        }
        for (ExecutionInstructionInterface instruction : instructions) {
            if (hasConnectionInstruction) {
                return true;
            }
            if (instruction instanceof ConnectionInstruction) {
                return true;
            }
            if (!(instruction instanceof ExecutionBlock)) continue;
            hasConnectionInstruction = this.check4ConnectionInstruction((ExecutionBlock)instruction);
        }
        return false;
    }
}

