/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.execution.instructions.ExecutionContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class StpNames {
    private int _dataFileNoSeq = 0;
    private Map<String, String> _stpDataFileNames = new LinkedHashMap<String, String>();
    private int _fileRefNoSeq = 0;
    private Map<String, String> _stpFileRefNames = new LinkedHashMap<String, String>();

    public StpNames() {
    }

    public int nextDataFileAutoNumber() {
        return this._dataFileNoSeq;
    }

    public int nextFileRefAutoNumber() {
        return this._fileRefNoSeq;
    }

    public StpNames(StpNames copyMe) {
        this._dataFileNoSeq = copyMe._dataFileNoSeq;
        this._fileRefNoSeq = copyMe._fileRefNoSeq;
        this._stpDataFileNames = new LinkedHashMap<String, String>();
        this._stpDataFileNames.putAll(copyMe._stpDataFileNames);
        this._stpFileRefNames = new LinkedHashMap<String, String>();
        this._stpFileRefNames.putAll(copyMe._stpFileRefNames);
    }

    public synchronized Map<String, String> getStpDataFileNames() {
        return Collections.unmodifiableMap(this._stpDataFileNames);
    }

    public synchronized Map<String, String> getStpFileRefNames() {
        return Collections.unmodifiableMap(this._stpFileRefNames);
    }

    public synchronized String getStpDataFileName(ExecutionContext context, String stpDataFileParmName, boolean autoGenerate) {
        String stpDataFileName = this._stpDataFileNames.get(stpDataFileParmName);
        if (autoGenerate && stpDataFileName == null) {
            stpDataFileName = this.getStpDataFileAutoPrefix(context) + this._dataFileNoSeq++;
            this._stpDataFileNames.put(stpDataFileParmName, stpDataFileName);
        }
        return stpDataFileName;
    }

    private String getStpDataFileAutoPrefix(ExecutionContext context) {
        String temporaryTableName;
        String prefix = "";
        if (context != null && (temporaryTableName = context.getTemporaryTableName()) != null) {
            prefix = temporaryTableName;
        }
        return prefix + "_STP";
    }

    private String getStpFileRefAutoPrefix() {
        return "_REF_STP";
    }

    public synchronized String getStpFileRefName(String stpFileRefParmName, boolean autoGenerate) {
        String stpFileRefName = this._stpFileRefNames.get(stpFileRefParmName);
        if (autoGenerate && stpFileRefName == null) {
            stpFileRefName = this.getStpFileRefAutoPrefix() + this._fileRefNoSeq++;
            this._stpFileRefNames.put(stpFileRefParmName, stpFileRefName);
        }
        return stpFileRefName;
    }

    public synchronized void setStpDataFileName(String stpDataFileParmName, String stpDataFileName) {
        this._stpDataFileNames.put(stpDataFileParmName, stpDataFileName);
    }

    public synchronized void setStpFileRefName(String stpFileRefParmName, String stpFileRefName) {
        this._stpFileRefNames.put(stpFileRefParmName, stpFileRefName);
    }
}

