/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.AbstractSASSubmitInstruction;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASOperations;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.EmptyResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.execution2.TabularResultSet;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CredentialResolver;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASSubmitInstruction
extends AbstractSASSubmitInstruction {
    protected String _resultTableReplacementPattern = null;
    protected String _sasStatement = null;
    protected String _resolvedSasStatement = null;
    protected DataSelection _dataSelection = null;
    private String _outputTableName;
    private String _jdbcStatementString = null;
    private ExecutionOptions _executionOptions = null;
    protected String _libref;
    protected String _tableNm;
    static final Logger _logger = LogManager.getLogger(SASSubmitInstruction.class);

    public SASSubmitInstruction(String sasStatement, String resultTableReplacementPattern, ExecutionOptions executionOptions, DataSelection dataSelection) {
        this._sasStatement = sasStatement;
        this.setExecutionOptions(executionOptions);
        this._resultTableReplacementPattern = resultTableReplacementPattern;
        this._dataSelection = dataSelection;
    }

    @Override
    public void execute() throws ExecutionException {
        super.execute();
        ResultSetInterface resultSet = this.buildResultSet();
        ExecutionContext executionContext = this.getExecutionContext();
        executionContext.setResult(resultSet);
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, executionContext);
        if (resultSet instanceof ResultSetUpdateInterface) {
            ((ResultSetUpdateInterface)((Object)resultSet)).setComputationalLocale(effectiveComputationLocale);
            StpNames stpNames = executionContext.getStpNames();
            ((ResultSetUpdateInterface)((Object)resultSet)).setStpNames(stpNames);
        }
    }

    protected ResultSet buildJdbcResultSet(ExecutionContext executionContext, ExecutionOptions executionOptions, String jdbcStatement) throws ExecutionException {
        ResultSet ret;
        List<ExportRule> returnList;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Executing an SASSubmitInstruction query, formatting=" + executionOptions.isFormatted());
        }
        if ((returnList = this._dataSelection.getEffectiveRules(ExportRule.class)).isEmpty()) {
            Connection sqlConnection = SASOperations.createConnection(executionContext, executionOptions);
            Statement statement = SASOperations.createStatement(executionContext, sqlConnection, executionOptions);
            ResultSet jdbcResultSet = SASOperations.createTable(executionContext, statement, jdbcStatement);
            CredentialResolver resolver = IQModelImplUtilities.getResolver(this._dataSelection);
            ret = SASOperations.addMLSResultSetExtension(resolver, executionContext, jdbcResultSet);
        } else {
            ret = new EmptyResultSet();
        }
        return ret;
    }

    protected ResultSetInterface buildResultSet() throws ExecutionException {
        ExecutionContext executionContext = this.getExecutionContext();
        ExecutionOptions executionOptions = this.getExecutionOptions();
        String jdbcStatement = this.getJDBCStatementString();
        ResultSet jdbcResultSet = this.buildJdbcResultSet(executionContext, executionOptions, jdbcStatement);
        TabularResultSet tabularResult = SASOperations.createTabularResultSet(jdbcResultSet, executionContext, false);
        return tabularResult;
    }

    @Override
    protected String getLanguageInstruction() {
        String sasStatementString = this.getSasStatement();
        if (this._resultTableReplacementPattern != null) {
            String directTableNm;
            String directLibref;
            int indexOfDot;
            ExecutionContext executionContext = this.getExecutionContext();
            String resultTableName = executionContext.getTemporaryTableName();
            sasStatementString = GenerationUtil.replaceTableName(sasStatementString, this._resultTableReplacementPattern, resultTableName);
            if (this._outputTableName != null) {
                resultTableName = GenerationUtil.replaceTableName(this._outputTableName, this._resultTableReplacementPattern, resultTableName);
            }
            if ((indexOfDot = resultTableName.indexOf(46)) != -1) {
                directLibref = resultTableName.substring(0, indexOfDot);
                directTableNm = resultTableName.substring(indexOfDot + 1, resultTableName.length());
            } else {
                directLibref = "WORK";
                directTableNm = resultTableName;
            }
            this.setJDBCStatementString("select * from " + resultTableName, directLibref, directTableNm);
        }
        this.setResolvedSasStatement(sasStatementString);
        _logger.debug(sasStatementString);
        return sasStatementString;
    }

    public String getResultTableName() {
        String resultTableName = null;
        if (this._resultTableReplacementPattern != null) {
            resultTableName = this.getExecutionContext().getTemporaryTableName();
            if (this._outputTableName != null) {
                resultTableName = GenerationUtil.replaceTableName(this._outputTableName, this._resultTableReplacementPattern, resultTableName);
            }
        }
        return resultTableName;
    }

    @Override
    protected void delay() {
        int clientRequestedQueryDelayInSeconds = this.getClientRequestedQueryDelayInSeconds();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Start of client requested query delay of " + Integer.toString(clientRequestedQueryDelayInSeconds) + " seconds.");
        }
        try {
            Thread.sleep((long)clientRequestedQueryDelayInSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        _logger.debug("End of client requested query delay.");
    }

    @Override
    protected boolean readSASOutput() {
        return true;
    }

    public String getSasStatement() {
        return this._sasStatement;
    }

    public void setSasStatement(String sasStatement) {
        this._sasStatement = sasStatement;
    }

    public String getResolvedSasStatement() {
        return this._resolvedSasStatement;
    }

    public void setResolvedSasStatement(String sasStatement) {
        this._resolvedSasStatement = sasStatement;
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        String sasStatement = this.getResolvedSasStatement();
        if (sasStatement == null) {
            sasStatement = this.getSasStatement();
            ExecutionContext executionContext = this.getExecutionContext();
            if (executionContext != null) {
                String resultTableName = executionContext.getTemporaryTableName();
                sasStatement = GenerationUtil.replaceTableName(sasStatement, this._resultTableReplacementPattern, resultTableName);
            }
        }
        return sasStatement;
    }

    public void setOutputTableName(String tableName) {
        this._outputTableName = tableName;
    }

    public String getOutputTableName() {
        return this._outputTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeOutStatment(String sasStatementString) {
        String writeSasStatements = System.getProperty("SASQueryServices.writeSasStatements");
        if (writeSasStatements == null) {
            writeSasStatements = System.getProperty("IQ.writeSasStatements");
        }
        if (writeSasStatements != null) {
            if (writeSasStatements.equalsIgnoreCase("System.err")) {
                System.err.println(sasStatementString);
            } else if (writeSasStatements.equalsIgnoreCase("System.out")) {
                System.out.println(sasStatementString);
            } else {
                try (PrintStream ps = null;){
                    FileOutputStream out = new FileOutputStream(writeSasStatements, true);
                    ps = new PrintStream(out);
                    ps.println(sasStatementString);
                }
            }
        }
    }

    private synchronized int getClientRequestedQueryDelayInSeconds() {
        int ret = IQSystemProperties.getIntProperty("SASQueryServices.QueryDelaySeconds", -1);
        if (ret == -1) {
            ret = IQSystemProperties.getIntProperty("SAS.IQ.QueryDelaySeconds", 0);
        }
        return ret;
    }

    @Override
    protected MessageFormatter getGeneralFailureMsg() {
        return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.submitLanguageInstructions.GenericError.txt", new Object[0]);
    }

    public ExecutionOptions getExecutionOptions() {
        return this._executionOptions;
    }

    public void setExecutionOptions(ExecutionOptions executionOptions) {
        this._executionOptions = executionOptions;
    }

    public String getJDBCStatementString() {
        return this._jdbcStatementString;
    }

    public void setJDBCStatementString(@Nonnull String statementString, @Nullable String libref, @Nullable String tableNm) {
        this._jdbcStatementString = statementString;
        this._libref = libref;
        this._tableNm = tableNm;
    }
}

