/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iom.SAS.IDBMSConnection;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataSet;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASEvents.ILanguageEvents_1_1Helper;
import com.sas.iom.SASEvents._ILanguageEvents_1_1ImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.orb.CP_IDConverter;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.SASLogReader;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionInterface;
import com.sas.util.ChainedException;
import java.nio.channels.ClosedChannelException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;

public class SASSubmitHandler {
    public static final String SHOW_VARIABLES = "/* all variables */\n%put _all_;\n";
    public static final String CLEAR_SYSCC_FOR_NEW_QUERY = "\n/* clear syscc before new query */\n%let syscc=0;\n%let sysrc=0;\n";
    public static final int SUBMIT_COMPLETE_SASRC_OK = 0;
    public static final int SUBMIT_COMPLETE_SASRC_WARNING = 4;
    private final MessageFormatter labelSubmitOk = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.PROPERTY_IS_SUBMIT_OK.txt", new java.lang.Object[0]);
    private final MessageFormatter labelSubmitFinished = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.PROPERTY_IS_SUBMIT_FINISHED.txt", new java.lang.Object[0]);
    private final MessageFormatter labelSubmitGlobalStmtError = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.PROPERTY_IS_GLOBAL_STMT_ERROR.txt", new java.lang.Object[0]);
    private long _maxSubmitMillisecs;
    private long _intervalMillisecs;
    private long _pollMillisecs;
    private static final Logger _logger = LogManager.getLogger(SASSubmitHandler.class);
    private static final Logger _statusLogger = LogManager.getLogger(Status.class);
    private static final Logger _listenerLogger = LogManager.getLogger(LanguageEventsListener.class);
    private static final Logger _perfDSLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    private ConcurrentLinkedQueue<Event> _events = new ConcurrentLinkedQueue();
    private static final String HANDLER_CONNECTIONPOINT = "SASSubmitInstruction.HANDLER_CONNECTIONPOINT.fmt.txt";
    private static final String HANDLER_STARTINGLISTENER = "SASSubmitInstruction.HANDLER_STARTINGLISTENER.fmt.txt";
    private static final String HANDLER_LISTENERSTARTED = "SASSubmitInstruction.HANDLER_LISTENERSTARTED.fmt.txt";
    private static final String HANDLER_SUBMITTEDSTATEMENT = "SASSubmitInstruction.HANDLER_SUBMITTEDSTATEMENT.fmt.txt";
    private static final String STATUS_CHANGED = "SASSubmitInstruction.STATUS_CHANGED.fmt.txt";
    private static final String SASRC_CHANGED = "SASSubmitInstruction.SASRC_CHANGED.fmt.txt";
    private static final String HANDLER_FINISHED_EVENT = "SASSubmitInstruction.HANDLER_FINISHED_EVENT.fmt.txt";
    private static final String HANDLER_PROCESSING_EVENT = "SASSubmitInstruction.HANDLER_PROCESSING_EVENT.fmt.txt";
    private static final String HANDLER_UNKNOWN_EVENT = "SASSubmitInstruction.HANDLER_UNKNOWN_EVENT.fmt.txt";
    private static final String HANDLER_ENCOUNTERED_EXCEPTION = "SASSubmitInstruction.HANDLER_ENCOUNTERED_EXCEPTION.fmt.txt";
    private static final String HANDLER_EXCEPTION_TEXT = "SASSubmitInstruction.HANDLER_EXCEPTION_TEXT.fmt.txt";
    private static final String HANDLER_CAUSED_BY_TEXT = "SASSubmitInstruction.HANDLER_CAUSED_BY_TEXT.fmt.txt";
    private static final String HANDLER_STOPPINGLISTENER = "SASSubmitInstruction.HANDLER_STOPPINGLISTENER.fmt.txt";
    private static final String HANDLER_LISTENERSTOPPED = "SASSubmitInstruction.HANDLER_LISTENERSTOPPED.fmt.txt";
    private static final String HANDLER_FINALVALUE = "SASSubmitInstruction.HANDLER_FINALVALUE.fmt.txt";
    private static final String HANDLER_IGNORED_EVENT_AND_AFTER_OK = "SASSubmitInstruction.HANDLER_IGNORED_EVENT_AND_AFTER_OK.fmt.txt";
    private static final String HANDLER_IGNORED_EVENT_AND_AFTER_ERROR = "SASSubmitInstruction.HANDLER_IGNORED_EVENT_AND_AFTER_ERROR.fmt.txt";
    private static final String LISTENER_RECV_EVENT = "SASSubmitInstruction.LISTENER_RECV_EVENT.fmt.txt";
    private static final String LISTENER_QUEUED_EVENT = "SASSubmitInstruction.LISTENER_QUEUED_EVENT.fmt.txt";
    private static final String HANDLER_REQUESTING_HANDLER_LOCK = "Handler #{0}{1,choice,0#(inactive)|1#}: {2} - Requesting lock on {3} to start processing events...";
    private static final String HANDLER_OBTAINED_HANDLER_LOCK = "Handler #{0}{1,choice,0#(inactive)|1#}: {2} - Obtained lock on {3} to start processing events.";
    private static final String HANDLER_NOTIFYING_THREADS_LOCK = "Handler #{0}{1,choice,0#(inactive)|1#}: {2} - After processing event, notify all threads waiting on lock {3}.";
    private static final String HANDLER_INTERRUPTED_NOTIFYING_LOCK = "Handler #{0}{1,choice,0#(inactive)|1#}: {2} - After handler interrupted, notify all threads waiting on lock {3}.";
    private static final String HANDLER_RELEASING_HANDLER_LOCK = "Handler #{0}{1,choice,0#(inactive)|1#}: {2} - After finished processing events, releasing lock on {3}.";
    private static final String LISTENER_REQUESTING_HANDLER_LOCK = "Listener #{0}{1,choice,0#(inactive)|1#}: {2} - Requesting lock on {3} to process request...";
    private static final String LISTENER_OBTAINED_HANDLER_LOCK = "Listener #{0}{1,choice,0#(inactive)|1#}: {2} - Obtained lock on {3} to process request.";
    private static final String LISTENER_NOTIFYING_HANDLER_LOCK = "Listener #{0}{1,choice,0#(inactive)|1#}: {2} - After processing of request, notify all threads waiting on lock {3}.";
    private static final String LISTENER_RELEASING_HANDLER_LOCK = "Listener #{0}{1,choice,0#(inactive)|1#}: {2} - After processing of request, release lock on {3}.";

    public SASSubmitHandler() {
        this._maxSubmitMillisecs = this.defaultMaxSubmitMilliseconds();
        this._intervalMillisecs = this.defaultWaitIntervalMilliseconds();
        this._pollMillisecs = this.defaultPollMilliseconds();
    }

    public SASSubmitHandler(long maxSubmitMillisecs, long intervalMilliseconds) {
        this._maxSubmitMillisecs = maxSubmitMillisecs;
        this._intervalMillisecs = intervalMilliseconds;
        this._pollMillisecs = 100L * this._intervalMillisecs;
    }

    public long getIntervalMillisecs() {
        return this._intervalMillisecs;
    }

    public void setIntervalMillisecs(long intervalMillisecs) {
        this._intervalMillisecs = intervalMillisecs;
    }

    public long getMaxSubmitMillisecs() {
        return this._maxSubmitMillisecs;
    }

    public void setMaxSubmitMillisecs(long maxSubmitMillisecs) {
        this._maxSubmitMillisecs = maxSubmitMillisecs;
    }

    private long defaultMaxSubmitMilliseconds() {
        long maxSubmitMillisecs = -1L;
        Long timeout = Long.getLong("SASQueryServices.sasSubmitTimeout");
        if (timeout != null && (maxSubmitMillisecs = timeout.longValue()) < 0L) {
            maxSubmitMillisecs = -1L;
        }
        return maxSubmitMillisecs;
    }

    private long defaultWaitIntervalMilliseconds() {
        long intervalMilliseconds = 50L;
        Long interval = Long.getLong("SASQueryServices.sasSubmitInterval");
        if (interval != null && (intervalMilliseconds = interval.longValue()) < 0L) {
            intervalMilliseconds = -1L;
        }
        return intervalMilliseconds;
    }

    public void execute(boolean aSyncState, ExecutionContext context, String sasStatementString, boolean readSASLog) throws ExecutionException {
        Throwable e2;
        StringBuffer statementErrors = new StringBuffer();
        IWorkspace workspace = context.getWorkspace();
        ILanguageService languageService = IOMServerUtils.GetILanguageService(workspace);
        Status status = new Status();
        status.setConnection(context.getConnection());
        status.setSubmitOk(false);
        Exception caught = null;
        try {
            long startTime = this.logExecutionStarting("execute()", sasStatementString, aSyncState, readSASLog, status, this);
            this.execute(aSyncState, languageService, sasStatementString, status);
            this.logExecutionComplete("execute()", status, this, startTime);
            if (!status.isSubmitOK()) {
                readSASLog = true;
            } else if (!aSyncState) {
                readSASLog = true;
            }
            if (readSASLog) {
                context.appendRunningLog("/* =================================== */\n");
                SASLogReader.flushLogForError(context, languageService, statementErrors);
                if (statementErrors.length() == 0) {
                    if (!status.isSubmitOK()) {
                        this.silentError(context, statementErrors, languageService, workspace, status);
                    }
                } else {
                    status.setSubmitOk(false);
                }
            }
            if (!status.isSubmitOK()) {
                this.logExecutionFailure("execute()", context, sasStatementString, status, this);
            }
        }
        catch (Exception e) {
            e2 = ChainedException.getRootException((Throwable)e);
            String msg = IQDataServicesResourceBundle.getStringResource("SASSubmitInstruction.getSubmitLog.GenericError.txt");
            this.logExecutionException("execute()", e, e2, msg, status, this);
            context.appendRunningLog(msg + "> " + e2);
            status.setSubmitOk(false);
            try {
                SASLogReader.flushLogForError(context, languageService, statementErrors);
            }
            catch (Exception e3) {
                context.appendRunningLog("Error reading log> " + e3);
                _logger.error(msg, (Throwable)e3);
            }
            if (statementErrors.length() == 0) {
                this.silentError(context, statementErrors, languageService, workspace, status);
            }
            caught = e;
        }
        this.logExecutionCompleteStatus("execute()", status, this);
        if (!status.isSubmitOK()) {
            if (status.isSubmitTimedOut() && caught instanceof ExecutionException) {
                throw (ExecutionException)caught;
            }
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.submitLanguageInstructions.GenericError.txt", new java.lang.Object[0]);
            e2 = caught == null ? new ExecutionException(errorMsg) : new ExecutionException(errorMsg, (Throwable)caught);
            SASLogReader.prepException((IQueryServicesException)e2, errorMsg, context, statementErrors.toString());
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean asyncState, ILanguageService languageService, String sasStatementString, Status status) throws GenericError, RuntimeException, ExecutionException, InterruptedException {
        block15: {
            this.doReset(languageService, status);
            status.setSubmitOk(false);
            boolean savedAsyncState = languageService.Async();
            if (asyncState != savedAsyncState) {
                this.logChangingLanguageServiceSyncState("execute()", asyncState, savedAsyncState, status, this);
                languageService.Async(asyncState);
            }
            try {
                String what = languageService.Parent().Name() + "=" + languageService.Parent().UniqueIdentifier();
                if (!asyncState) {
                    this.logUsingSynchronous("execute(sync)", status, this);
                    _logger.info("--- starting sync submit to server ---");
                    this.outputToLog(what, sasStatementString);
                    languageService.Submit(sasStatementString);
                    _logger.info("--- finished submit to server ---");
                    status.setSubmitOk(true);
                    break block15;
                }
                this.logUsingAsynchronous("execute(async)", status, this);
                LanguageEventsListener listener = this.newLanguageEventsListener(this, status);
                this.logLockingObject("execute(async)", status, this, listener);
                boolean savedSuspendOnErrorState = languageService.SuspendOnError();
                try {
                    languageService.SuspendOnError(true);
                    try {
                        listener.startListening(languageService);
                        this.logHandlerRequestingLock("execute(async)", status, this, listener);
                        SASSubmitHandler sASSubmitHandler = this;
                        synchronized (sASSubmitHandler) {
                            this.logHandlerObtainedLock("execute(async)", status, this, listener);
                            this.logSasStatmentToSubmit("execute(async)", sasStatementString, status, this, listener);
                            _logger.info("--- starting async submit to server ---");
                            this.outputToLog(what, sasStatementString);
                            languageService.Submit(sasStatementString);
                            _logger.info("--- finished submit to server, waiting for completion ---");
                            status.setSubmitOk(true);
                            this.logStatementSubmitted("execute(async)", status, this, listener);
                            this.waitForCompletion(languageService, status, this, listener);
                            _logger.info("--- finished submit and completion received ---");
                            this.logHandlerReleasingLock("execute(async)", status, this, listener);
                        }
                    }
                    finally {
                        this.logFinallyStoppingListener("execute(async)", status, this, listener);
                        listener.stopListening();
                        this.logFinalValues("execute(async)", status, this, listener);
                        this.logFinallyStoppedListener("execute(async)", status, this, listener);
                    }
                }
                finally {
                    this.restoreSuspendOnError(languageService, status, savedSuspendOnErrorState);
                }
            }
            finally {
                if (savedAsyncState != asyncState) {
                    this.logRestoringLanguageServiceAsync("execute()", asyncState, savedAsyncState, status, this);
                    this.restoreAsync(languageService, status, savedAsyncState);
                }
            }
        }
    }

    private void restoreSuspendOnError(ILanguageService languageService, Status status, boolean savedSuspendOnErrorState) {
        try {
            languageService.SuspendOnError(savedSuspendOnErrorState);
        }
        catch (SystemException e) {
            status.addToEventLog("set languageService.SuspendOnError(" + savedSuspendOnErrorState + ") failed: " + e.toString());
            this.handleLanguageServiceError(status, e);
        }
    }

    private void restoreAsync(ILanguageService languageService, Status status, boolean savedAsyncState) {
        try {
            languageService.Async(savedAsyncState);
        }
        catch (SystemException e) {
            status.addToEventLog("set languageService.Async(" + savedAsyncState + ") failed: " + e.toString());
            this.handleLanguageServiceError(status, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForCompletion(ILanguageService languageService, Status status, SASSubmitHandler handler, LanguageEventsListener listener) throws InterruptedException, ExecutionException, GenericError {
        long startMillis;
        long maxSubmitMilliSeconds = this.getMaxSubmitMillisecs();
        long waitIntervalMilliSeconds = this.getIntervalMillisecs();
        long pollMilliSeconds = this.getPollMillisecs();
        boolean useTimeout = maxSubmitMilliSeconds >= 0L;
        long lastPollMillis = startMillis = System.currentTimeMillis();
        this.logStartOfProcessing("waitForCompletion()", maxSubmitMilliSeconds, waitIntervalMilliSeconds, startMillis, status, handler, listener);
        int i = 0;
        boolean hasBeenReset = false;
        boolean finished = false;
        try {
            while (!finished) {
                boolean bl;
                this.processEvents(status, handler, listener);
                this.logIterationOfProcessing("waitForCompletion()", ++i, status, handler, listener);
                try {
                    this.checkForExecutionTimeExceeded(useTimeout, startMillis, maxSubmitMilliSeconds, status, handler, listener);
                    this.pollConnection(startMillis, lastPollMillis, pollMilliSeconds, status, handler, listener);
                    lastPollMillis = System.currentTimeMillis();
                    if (i > 1) {
                        this.logWaitingForEvent("waitForCompletion()", status, handler, listener);
                        long startWait = System.currentTimeMillis();
                        handler.wait(waitIntervalMilliSeconds);
                        this.logMessageAboutWaiting("waitForCompletion()", startWait, waitIntervalMilliSeconds, status, handler, listener);
                    }
                    bl = status.isSubmitFinished() && this._events.isEmpty();
                }
                catch (Throwable throwable) {
                    boolean bl2 = finished = status.isSubmitFinished() && this._events.isEmpty();
                    if (!status.isSubmitOK() && !hasBeenReset) {
                        hasBeenReset = true;
                        finished = false;
                        this.doReset(languageService, status);
                    }
                    throw throwable;
                }
                finished = bl;
                if (status.isSubmitOK() || hasBeenReset) continue;
                hasBeenReset = true;
                finished = false;
                this.doReset(languageService, status);
            }
        }
        catch (InterruptedException e) {
            status.setActive(false);
            status.setSubmitOk(false);
            this.logHandlerInterruptedNotifyingLock("waitForCompletion()", status, handler, listener);
            handler.notifyAll();
            throw e;
        }
        finally {
            status.setActive(false);
        }
        this.logProcessingFinishedStatus("waitForCompletion()", status, handler, listener);
    }

    private void checkForExecutionTimeExceeded(boolean useTimeout, long startMillis, long maxSubmitMilliSeconds, Status status, SASSubmitHandler handler, LanguageEventsListener listener) throws ExecutionException {
        long tickMillis = System.currentTimeMillis();
        long elaspedMillis = tickMillis - startMillis;
        if (useTimeout && elaspedMillis > maxSubmitMilliSeconds) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitHandler.ExecutionTimeExceeded.fmt.txt", maxSubmitMilliSeconds, status.isSubmitOK(), status.isSubmitFinished());
            status.addToEventLog(msg);
            MessageFormatter message = Reason.getMessageFormatter(msg, status.getEventLog(), true);
            status.setSubmitTimedOut(true);
            status.setSubmitOk(false);
            ExecutionException e = new ExecutionException(message);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEvent(Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        boolean added = this._events.add(event);
        this.logQueuedEvent(event, status, handler, listener);
        this.logListenerRequestingLock("addEvent()", status, handler, listener);
        SASSubmitHandler sASSubmitHandler = this;
        synchronized (sASSubmitHandler) {
            this.logListenerObtainedLock("addEvent()", status, handler, listener);
            this.logListenerNotifyingLock("addEvent()", status, handler, listener);
            this.notifyAll();
            this.logListenerReleasingLock("addEvent()", status, handler, listener);
        }
        return added;
    }

    void processEvents(Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Event event = this._events.poll();
        while (event != null) {
            if (!status.isActive()) {
                this.logIgnoringEvent("processEvents()", event, status, handler, listener);
            } else {
                try {
                    if (event instanceof EventSubmitComplete) {
                        this.logProcessingEvent(event, status, handler, listener);
                        int sasrc = ((EventSubmitComplete)event).getSasrc();
                        boolean newSubmitOk = status.isSubmitOK();
                        if (sasrc != 0 && sasrc != 4) {
                            newSubmitOk = false;
                        }
                        status.setAsyncFinished(handler, listener);
                        status.setSubmitOk(newSubmitOk, handler, listener);
                        status.setSasrc(sasrc, handler, listener);
                    } else if (event instanceof EventGlobalstmtError) {
                        this.logProcessingEvent(event, status, handler, listener);
                        status.setSubmitOk(false, handler, listener);
                        status.setGlobalstmtErrored(handler, listener);
                    } else if (event instanceof EventStepError) {
                        this.logProcessingEvent(event, status, handler, listener);
                        status.setSubmitOk(false, handler, listener);
                    } else if (event instanceof EventProcStart) {
                        this.logProcessingEvent(event, status, handler, listener);
                    } else if (event instanceof EventProcComplete) {
                        this.logProcessingEvent(event, status, handler, listener);
                    } else if (event instanceof EventDatastepStart) {
                        this.logProcessingEvent(event, status, handler, listener);
                    } else if (event instanceof EventDatastepComplete) {
                        this.logProcessingEvent(event, status, handler, listener);
                    } else if (event instanceof EventGlobalstmtComplete) {
                        this.logProcessingEvent(event, status, handler, listener);
                    } else {
                        this.logUnknownEventType(event, status, handler, listener);
                    }
                }
                catch (RuntimeException e) {
                    this.logExceptionDuringEvent(event, e, status, handler, listener);
                    throw e;
                }
                finally {
                    this.logFinishedEvent(event, status, handler, listener);
                    this.logHandlerNotifyingLock("processEvents()", status, handler, listener);
                    handler.notifyAll();
                }
            }
            event = this._events.poll();
        }
    }

    void doReset(ILanguageService languageService, Status status) throws GenericError {
        try {
            this.logLanguageServiceCancel("doReset()", this);
            languageService.Cancel();
        }
        catch (GenericError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (SystemException e) {
            status.addToEventLog("languageService.Cancel() failed: " + e.toString());
        }
        try {
            this.logLanguageServiceReset("doReset()", this);
            languageService.Reset();
        }
        catch (GenericError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (SystemException e) {
            status.addToEventLog("languageService.Reset() failed: " + e.toString());
        }
        try {
            this.logLanguageServiceContinue("doReset()", this);
            languageService.Continue();
        }
        catch (GenericError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (SystemException e) {
            status.addToEventLog("languageService.Continue() failed: " + e.toString());
            this.handleLanguageServiceError(status, e);
        }
    }

    private void handleLanguageServiceError(Status status, SystemException e) {
        boolean isTimedOut = status.isSubmitTimedOut();
        status.addToEventLog("  submit timed out = " + isTimedOut);
        if (!isTimedOut) {
            Throwable cause = e.getCause();
            boolean isClosed = cause instanceof ClosedChannelException;
            status.addToEventLog("  channel closed = " + isClosed + (cause != null ? " (" + ((java.lang.Object)((java.lang.Object)e)).getClass().getSimpleName() + ")" : ""));
            if (isClosed) {
                boolean isMissing = e instanceof OBJECT_NOT_EXIST;
                status.addToEventLog("  bridge object missing = " + isMissing + " (" + ((java.lang.Object)((java.lang.Object)e)).getClass().getSimpleName() + ")");
                if (!isMissing) {
                    throw e;
                }
            }
        }
    }

    public LanguageEventsListener newLanguageEventsListener(SASSubmitHandler submitHandler, Status status) {
        return new LanguageEventsListener(submitHandler, status);
    }

    public long getPollMillisecs() {
        return this._pollMillisecs;
    }

    public void setPollMillisecs(long pollMillisecs) {
        this._pollMillisecs = pollMillisecs;
    }

    private long defaultPollMilliseconds() {
        long pollMilliseconds = 1000L;
        Long interval = Long.getLong("SASQueryServices.sasSubmitPolls");
        if (interval != null && (pollMilliseconds = interval.longValue()) < 0L) {
            pollMilliseconds = -1L;
        }
        return pollMilliseconds;
    }

    private void pollConnection(long startMillis, long lastPollMillis, long pollMillis, Status status, SASSubmitHandler handler, LanguageEventsListener listener) throws ExecutionException {
        Exception connectionFailure;
        long tickMillis = System.currentTimeMillis();
        long elaspedMillis = tickMillis - lastPollMillis;
        if (elaspedMillis > pollMillis && (connectionFailure = status.isConnectionOK()) != null) {
            status.addToEventLog("Error polling connection: " + connectionFailure.toString());
            _logger.error("Connection is invalid", (Throwable)connectionFailure);
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitHandler.ConnectionPollFailed.fmt.txt", tickMillis - startMillis, status.isSubmitOK(), status.isSubmitFinished());
            status.addToEventLog(msg);
            MessageFormatter message = Reason.getMessageFormatter(msg, status.getEventLog(), true);
            status.setSubmitOk(false);
            throw new ExecutionException(message, (Throwable)connectionFailure);
        }
    }

    private MessageFormatter getStatusChangeMessage(String format, java.lang.Object whatChanged, boolean oldValue, boolean newValue, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        Integer oldAsNumber = oldValue ? 1 : 0;
        Integer newAsNumber = newValue ? 1 : 0;
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive, whatChanged, oldAsNumber, newAsNumber);
    }

    private MessageFormatter getSasrcChangeMessage(String format, java.lang.Object whatChanged, int oldValue, int newValue, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        Integer oldAsNumber = oldValue;
        Integer newAsNumber = newValue;
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive, whatChanged, oldAsNumber, newAsNumber);
    }

    private MessageFormatter getFinalValueMessage(String format, java.lang.Object what, boolean value, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        Integer valueAsNumber = value ? 1 : 0;
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive, what, valueAsNumber);
    }

    private MessageFormatter getRequestMessage(String format, ServerRequest request, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive, request == null ? null : request.operation());
    }

    private MessageFormatter getEventMessage(String format, Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive, event == null ? null : event.getMessageFormatter());
    }

    private synchronized void logReceivedEvent(ServerRequest request, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getRequestMessage(LISTENER_RECV_EVENT, request, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, request, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logQueuedEvent(Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getEventMessage(LISTENER_QUEUED_EVENT, event, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, event, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logStatusChanged(MessageFormatter whatChanged, boolean oldValue, boolean newValue, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getStatusChangeMessage(STATUS_CHANGED, whatChanged, oldValue, newValue, status, handler, listener);
        if (_statusLogger.isDebugEnabled()) {
            _statusLogger.debug(this.addDebugInfo(message, handler, listener));
        } else if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, handler, listener));
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(this.addDebugInfo(message, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logSasrcChanged(MessageFormatter whatChanged, int oldValue, int newValue, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getSasrcChangeMessage(SASRC_CHANGED, whatChanged, oldValue, newValue, status, handler, listener);
        if (_statusLogger.isDebugEnabled()) {
            _statusLogger.debug(this.addDebugInfo(message, handler, listener));
        } else if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, handler, listener));
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(this.addDebugInfo(message, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logConnectionPoint(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_CONNECTIONPOINT, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, where, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logStartingListener(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_STARTINGLISTENER, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, where, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logListenerStarted(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_LISTENERSTARTED, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, where, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logStatementSubmitted(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_SUBMITTEDSTATEMENT, status, handler, listener);
        if (_logger.isDebugEnabled()) {
            _logger.debug(this.addDebugInfo(message, where, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logProcessingEvent(Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getEventMessage(HANDLER_PROCESSING_EVENT, event, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logUnknownEventType(Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getEventMessage(HANDLER_UNKNOWN_EVENT, event, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logFinishedEvent(Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getEventMessage(HANDLER_FINISHED_EVENT, event, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logIgnoringEvent(String where, Event event, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = null;
        boolean afterOk = status.isSubmitOK();
        if (afterOk) {
            boolean isImportantOperation;
            message = this.getEventMessage(HANDLER_IGNORED_EVENT_AND_AFTER_OK, event, status, handler, listener);
            boolean bl = isImportantOperation = event instanceof EventSubmitComplete || event instanceof EventStepError || event instanceof EventGlobalstmtError;
            if (isImportantOperation) {
                if (_listenerLogger.isEnabled(Level.WARN)) {
                    _listenerLogger.warn(this.addDebugInfo(message, event, handler, listener));
                }
            } else if (_listenerLogger.isDebugEnabled()) {
                _listenerLogger.debug(this.addDebugInfo(message, event, handler, listener));
            }
        } else {
            message = this.getEventMessage(HANDLER_IGNORED_EVENT_AND_AFTER_ERROR, event, status, handler, listener);
            if (_listenerLogger.isDebugEnabled()) {
                _listenerLogger.debug(this.addDebugInfo(message, event, handler, listener));
            }
        }
        status.addToEventLog(message);
    }

    private synchronized void logExceptionDuringEvent(Event event, RuntimeException e, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        ConnectionPoint connectionPoint = listener.getConnectionPoint();
        MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter(HANDLER_ENCOUNTERED_EXCEPTION, listenerValue, isActive, event.getText(), event, handleHolder, connectionPoint, handler);
        if (_listenerLogger.isEnabled(Level.ERROR)) {
            _listenerLogger.error(message.toString(), (Throwable)e);
        }
        status.addToEventLog(message);
        status.addToEventLog(IQDataServicesResourceBundle.getMessageFormatter(HANDLER_EXCEPTION_TEXT, listenerValue, isActive, e));
        Throwable rootCause = ChainedException.getRootException((Throwable)e);
        if (rootCause != null && rootCause != e) {
            status.addToEventLog(IQDataServicesResourceBundle.getMessageFormatter(HANDLER_CAUSED_BY_TEXT, listenerValue, isActive, rootCause));
        }
    }

    private synchronized void logStoppingListener(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_STOPPINGLISTENER, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, where, handler, listener));
        }
        status.addToEventLog(message);
    }

    private synchronized void logListenerStopped(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        MessageFormatter message = this.getWhereMessage(HANDLER_LISTENERSTOPPED, status, handler, listener);
        if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message, where, handler, listener));
        }
    }

    private synchronized void logFinalValues(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        boolean isSubmitOK = status.isSubmitOK();
        boolean isFinished = status.isSubmitFinished();
        boolean isGlobalError = status.isGlobalStmtError();
        MessageFormatter message2 = this.getFinalValueMessage(HANDLER_FINALVALUE, this.labelSubmitOk, isSubmitOK, status, handler, listener);
        MessageFormatter message3 = this.getFinalValueMessage(HANDLER_FINALVALUE, this.labelSubmitFinished, isFinished, status, handler, listener);
        MessageFormatter message4 = this.getFinalValueMessage(HANDLER_FINALVALUE, this.labelSubmitGlobalStmtError, isGlobalError, status, handler, listener);
        boolean isSubmitTimedOut = status.isSubmitTimedOut();
        if (isSubmitTimedOut) {
            MessageFormatter message5 = this.getFinalValueMessage(HANDLER_FINALVALUE, "\"isSubmitTimedOut\"", isSubmitTimedOut, status, handler, listener);
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.addDebugInfo(message5, where, handler, listener));
            } else if (_listenerLogger.isDebugEnabled()) {
                _listenerLogger.debug(this.addDebugInfo(message5, where, handler, listener));
            } else if (_statusLogger.isDebugEnabled()) {
                _statusLogger.debug(this.addDebugInfo(message5, where, handler, listener));
            }
            status.addToEventLog(message5);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug(this.addDebugInfo(message2, where, handler, listener));
            _logger.debug(this.addDebugInfo(message3, where, handler, listener));
            _logger.debug(this.addDebugInfo(message4, where, handler, listener));
        } else if (_listenerLogger.isDebugEnabled()) {
            _listenerLogger.debug(this.addDebugInfo(message2, where, handler, listener));
            _listenerLogger.debug(this.addDebugInfo(message3, where, handler, listener));
            _listenerLogger.debug(this.addDebugInfo(message4, where, handler, listener));
        } else if (_statusLogger.isDebugEnabled()) {
            _statusLogger.debug(this.addDebugInfo(message2, where, handler, listener));
            _statusLogger.debug(this.addDebugInfo(message3, where, handler, listener));
            _statusLogger.debug(this.addDebugInfo(message4, where, handler, listener));
        }
        status.addToEventLog(message2);
        status.addToEventLog(message3);
        status.addToEventLog(message4);
    }

    private String addDebugInfo(MessageFormatter message, ServerRequest request, SASSubmitHandler handler, LanguageEventsListener listener) {
        IntHolder handleHolder = listener.getHandleHolder();
        ConnectionPoint connectionPoint = listener.getConnectionPoint();
        StringBuffer buffer = new StringBuffer(message.toString());
        buffer.append(" (request=").append(request).append(", handleHolder=").append(handleHolder).append(", cp=").append(connectionPoint).append(", handler=").append(handler).append(")");
        return buffer.toString();
    }

    private String addDebugInfo(MessageFormatter message, Event event, SASSubmitHandler handler, LanguageEventsListener listener) {
        IntHolder handleHolder = listener.getHandleHolder();
        ConnectionPoint connectionPoint = listener.getConnectionPoint();
        StringBuffer buffer = new StringBuffer(message.toString());
        buffer.append(" (event=").append(event).append(", handleHolder=").append(handleHolder).append(", cp=").append(connectionPoint).append(", handler=").append(handler).append(")");
        return buffer.toString();
    }

    private MessageFormatter getWhereMessage(String format, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        return IQDataServicesResourceBundle.getMessageFormatter(format, listenerValue, isActive);
    }

    private String addDebugInfo(MessageFormatter message, String where, SASSubmitHandler handler, LanguageEventsListener listener) {
        IntHolder handleHolder = listener.getHandleHolder();
        ConnectionPoint connectionPoint = listener.getConnectionPoint();
        StringBuffer buffer = new StringBuffer(where);
        buffer.append(": ").append(message).append(" (handleHolder=").append(handleHolder).append(", cp=").append(connectionPoint).append(", handler=").append(handler).append(")");
        return buffer.toString();
    }

    private String addDebugInfo(MessageFormatter message, SASSubmitHandler handler, LanguageEventsListener listener) {
        IntHolder handleHolder = listener.getHandleHolder();
        ConnectionPoint connectionPoint = listener.getConnectionPoint();
        StringBuffer buffer = new StringBuffer(message.toString());
        buffer.append(" (handleHolder=").append(handleHolder).append(", cp=").append(connectionPoint).append(", handler=").append(handler).append(")");
        return buffer.toString();
    }

    private void logExecutionException(String where, Exception e, Throwable e2, String msg, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": ==== Exception Submitting SAS Statements ====", (Throwable)e);
        }
        _logger.error(msg, e2);
    }

    private void logLanguageServiceContinue(String where, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": Continue...");
        }
    }

    private void logLanguageServiceReset(String where, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": Reset...");
        }
    }

    private void logLanguageServiceCancel(String where, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": Cancel...");
        }
    }

    private void logExecutionCompleteStatus(String where, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": Summit OK = " + status.isSubmitOK());
        }
    }

    private void logExecutionFailure(String where, ExecutionContext context, String sasStatementString, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": An error occurred while attempting to submit statements to SAS.  SAS Statement: " + sasStatementString + "\n" + context.getSASLog());
        }
    }

    private void logExecutionComplete(String where, Status status, SASSubmitHandler handler, long start) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": ==== Submit complete (_submitOk=" + status.isSubmitOK() + ") ====");
        }
        if (_perfDSLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogDataServerPerformance("< done (" + (end - start) + "ms)");
        }
    }

    private long logExecutionStarting(String where, String sasStatementString, boolean aSyncState, boolean readSASLog, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": ==== Submitting SAS Statements (aSync=" + aSyncState + ", readLogAfter=" + readSASLog + ") ====");
            _logger.debug(sasStatementString);
        }
        long startTime = 0L;
        if (_perfDSLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogDataServerPerformance("> Submitting relational SAS code.  (aSync=" + aSyncState + ", readLogAfter=" + readSASLog + ")  code=" + sasStatementString);
            startTime = System.currentTimeMillis();
        }
        return startTime;
    }

    private void logChangingLanguageServiceSyncState(String where, boolean asyncState, boolean savedAsyncState, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": <start> ASYNC = " + asyncState + "(will restore ASYNC to " + savedAsyncState + ")");
        }
    }

    private void logRestoringLanguageServiceAsync(String where, boolean asyncState, boolean savedAsyncState, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": <end> ASYNC = " + asyncState + "(restoring ASYNC to " + savedAsyncState + ")");
        }
    }

    private void logFinallyStoppingListener(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": finally{} - stop listening");
        }
    }

    private void logFinallyStoppedListener(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": finally{} - stopped listening");
        }
    }

    private void logSasStatmentToSubmit(String where, String sasStatementString, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            int len = sasStatementString.length();
            _logger.debug("----------------------------------------------------------");
            _logger.debug("[" + sasStatementString + "] len=" + len);
        }
    }

    private void logLockingObject(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": lock event processing and handling on " + handler);
        }
    }

    private void logUsingAsynchronous(String where, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": asynchronous submit being used");
        }
    }

    private void logUsingSynchronous(String where, Status status, SASSubmitHandler handler) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": synchronous submit being used");
        }
    }

    private void logProcessingFinishedStatus(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (status.isSubmitFinished()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(where + ": Submit looks finished (_submitOk=" + status.isSubmitOK() + ")");
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": Submit does not look finished (_submitOk=" + status.isSubmitOK() + ")");
        }
    }

    private void logWaitingForEvent(String where, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": suspending lock on " + handler + " to wait for an event...");
        }
    }

    private void logIterationOfProcessing(String where, int i, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled() && IQSystemProperties.isVerboseLoggingEnabled()) {
            _logger.debug(where + ": Listener state after iteration=" + i + ", _submitOk=" + status.isSubmitOK() + ", _submitFinished=" + status.isSubmitFinished());
        }
    }

    private void logStartOfProcessing(String where, long maxSubmitMilliSeconds, long waitIntervalMilliSeconds, long startMillis, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ": timeout interval=" + waitIntervalMilliSeconds + " ms, maxWait=" + maxSubmitMilliSeconds + " ms, startMillis=" + startMillis + " ms");
        }
    }

    private long logMessageAboutWaiting(String where, long startWait, long waitIntervalMilliSeconds, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        long waited;
        if (_logger.isDebugEnabled()) {
            _logger.debug(where + ":regained lock on " + handler + " after waiting on an event.");
        }
        if ((waited = System.currentTimeMillis() - startWait) <= waitIntervalMilliSeconds - 10L) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(where + ":awoke to a notify after " + waited + "ms (timeout=" + waitIntervalMilliSeconds + "ms)");
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(where + ":timed out while waiting for event (timeout=" + waitIntervalMilliSeconds + "ms)");
        }
        return waited;
    }

    private String getLockMessage(String msgFormat, String lockLocation, java.lang.Object lockObject, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        Integer isActive = status.isActive() ? 1 : 0;
        IntHolder handleHolder = listener.getHandleHolder();
        String listenerValue = handleHolder == null ? "-" : Integer.valueOf(handleHolder.value);
        return MessageFormat.format(msgFormat, listenerValue, isActive, lockLocation, lockObject);
    }

    private synchronized void logHandlerRequestingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            String message = this.getLockMessage(HANDLER_REQUESTING_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _logger.debug(message);
        }
    }

    private synchronized void logHandlerObtainedLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            String message = this.getLockMessage(HANDLER_OBTAINED_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _logger.debug(message);
        }
    }

    private synchronized void logHandlerInterruptedNotifyingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            String message = this.getLockMessage(HANDLER_INTERRUPTED_NOTIFYING_LOCK, lockLocation, handler, status, handler, listener);
            _logger.debug(message);
        }
    }

    private synchronized void logHandlerNotifyingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            String message = this.getLockMessage(HANDLER_NOTIFYING_THREADS_LOCK, lockLocation, handler, status, handler, listener);
            _logger.debug(message);
        }
    }

    private synchronized void logHandlerReleasingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_logger.isDebugEnabled()) {
            String message = this.getLockMessage(HANDLER_RELEASING_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _logger.debug(message);
        }
    }

    private synchronized void logListenerRequestingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_listenerLogger.isDebugEnabled()) {
            String message = this.getLockMessage(LISTENER_REQUESTING_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _listenerLogger.debug(message);
        }
    }

    private synchronized void logListenerObtainedLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_listenerLogger.isDebugEnabled()) {
            String message = this.getLockMessage(LISTENER_OBTAINED_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _listenerLogger.debug(message);
        }
    }

    private synchronized void logListenerNotifyingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_listenerLogger.isDebugEnabled()) {
            String message = this.getLockMessage(LISTENER_NOTIFYING_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _listenerLogger.debug(message);
        }
    }

    private synchronized void logListenerReleasingLock(String lockLocation, Status status, SASSubmitHandler handler, LanguageEventsListener listener) {
        if (_listenerLogger.isDebugEnabled()) {
            String message = this.getLockMessage(LISTENER_RELEASING_HANDLER_LOCK, lockLocation, handler, status, handler, listener);
            _listenerLogger.debug(message);
        }
    }

    private void outputToLog(String what, String sasStatementString) {
        StringTokenizer st = new StringTokenizer(sasStatementString, "\n", true);
        boolean skipCr = false;
        while (st.hasMoreTokens()) {
            String string = st.nextToken();
            if (string.equals("\n")) {
                if (!skipCr) {
                    _logger.info(what + ": ");
                }
                skipCr = false;
                continue;
            }
            _logger.info(what + ": " + string);
            skipCr = true;
        }
    }

    private void silentError(ExecutionContext context, StringBuffer statementErrors, ILanguageService languageService, IWorkspace workspace, Status status) {
        _logger.info("**** silent error condition ****");
        statementErrors.append(context.getSASLog());
        if (!status.getEventLog().isEmpty()) {
            this.silentError(languageService, workspace, status, statementErrors);
        }
    }

    private void silentError(ILanguageService languageService, IWorkspace workspace, Status status, StringBuffer statementErrors) {
        boolean foundErr = false;
        try {
            _logger.info("--- querying server for vars ---");
            LinkedHashSet<String> macroNames = new LinkedHashSet<String>();
            macroNames.add("SYSERR");
            macroNames.add("SYSERRORTEXT");
            macroNames.add("SYSCC");
            macroNames.add("SYSRC");
            _logger.info("   " + macroNames);
            try {
                this.logLanguageServiceReset("doReset()", this);
                languageService.Reset();
                IDataService dataService = IOMServerUtils.GetIDataService(workspace);
                Map<String, String> outputMacroVariables = SASSubmitHandler.getMacroVarValues(dataService, "SYSERR", "SYSERRORTEXT", "SYSCC", "SYSRC");
                _logger.info("Results:");
                for (Map.Entry<String, String> entry : outputMacroVariables.entrySet()) {
                    _logger.info("  " + entry.getKey() + "='" + entry.getValue());
                }
                String sysErrorText = outputMacroVariables.get("SYSERRORTEXT");
                if (sysErrorText != null && sysErrorText.trim().length() > 0) {
                    statementErrors.append("\nSelected server SAS Macro Variables:\n");
                    for (Map.Entry<String, String> entry : outputMacroVariables.entrySet()) {
                        statementErrors.append(entry.getKey() + "='" + entry.getValue() + "'\n");
                    }
                    foundErr = true;
                } else {
                    _logger.info("--- querying server for _ALL_ vars ---");
                    Map<String, String> map = SASSubmitHandler.getMacroVarValues(dataService, new String[0]);
                    statementErrors.append("\nALL server SAS Macro Variables:\n");
                    _logger.info("Results:");
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        _logger.info("  " + entry.getKey() + "='" + entry.getValue());
                        statementErrors.append(entry.getKey() + "='" + entry.getValue() + "'\n");
                    }
                }
                _logger.info("--- done querying server for vars ---");
            }
            catch (GenericError e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (SystemException e) {
                status.addToEventLog("languageService.Reset() failed: " + e.toString());
            }
        }
        catch (Exception e) {
            Throwable e2 = ChainedException.getRootException((Throwable)e);
            this.logExecutionException("execute()", e, e2, "Error reading SYSERR and SYSERRORTEXT from server.", status, this);
        }
        if (!foundErr) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.noErrorFoundInLog.txt", new java.lang.Object[0]);
            MessageFormatter message = Reason.getMessageFormatter(errorMsg, status.getEventLog(), true);
            statementErrors.append(message.toString());
        }
    }

    public void setSASLogPageDimensions(boolean async, ExecutionContext context, String lineSize, String pageSize) throws ExecutionException {
        String text;
        if (lineSize != null) {
            text = "OPTIONS LINESIZE=" + lineSize + ";";
            this.execute(async, context, text, true);
        }
        if (pageSize != null) {
            text = "OPTIONS PAGESIZE=" + pageSize + ";";
            this.execute(async, context, text, true);
        }
    }

    public void clearSessionVars(boolean async, ExecutionContext context, boolean ignoreError) throws ExecutionException {
        try {
            this.execute(async, context, CLEAR_SYSCC_FOR_NEW_QUERY, true);
        }
        catch (Throwable e) {
            if (ignoreError) {
                String msg = "WARNING: clear session variables failed.";
                context.appendRunningLog(msg + " " + e);
                _logger.warn(msg, e);
            }
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            throw new ExecutionException(e);
        }
    }

    public void logSessionVarsFromJdbc(ExecutionContext context, IDataService dataService) {
        try {
            Map<String, String> macroVarValues = SASSubmitHandler.getMacroVarValues(dataService, new String[0]);
            if (macroVarValues != null) {
                String title = "Startup macro variables (" + macroVarValues.size() + "):";
                _logger.info(title);
                context.appendRunningLog(title + "\n");
                for (Map.Entry<String, String> entry : macroVarValues.entrySet()) {
                    String string = "  " + entry.getKey() + "=\"" + entry.getValue() + "\"";
                    _logger.info(string);
                    context.appendRunningLog(string + "\n");
                }
            }
        }
        catch (Throwable e) {
            String msg = "WARNING: jdbc get of session vars failed.";
            context.appendRunningLog(msg + " " + e + "\n");
            _logger.warn(msg, e);
        }
    }

    public void logSessionVarsFromProc(boolean async, ExecutionContext context) {
        try {
            this.execute(async, context, SHOW_VARIABLES, true);
        }
        catch (Throwable e) {
            String msg = "WARNING: show session vars failed.";
            context.appendRunningLog(msg + " " + e + "\n");
            _logger.warn(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMacroVarValues(IDataService dataService, String ... macroNames) throws UserException {
        LinkedHashMap<String, String> outputParameterMap = new LinkedHashMap<String, String>();
        boolean print = _logger.isDebugEnabled();
        String QUERY = "SELECT scope, name, offset, value FROM sashelp.vmacro";
        StringBuffer fullQuery = new StringBuffer("SELECT scope, name, offset, value FROM sashelp.vmacro");
        if (macroNames != null && macroNames.length > 0) {
            String sep = "";
            fullQuery.append(" WHERE UPPER(name) in (");
            for (String name : macroNames) {
                fullQuery.append(sep).append("'").append(name.toUpperCase()).append("'");
                sep = ",";
                outputParameterMap.put(name, null);
            }
            fullQuery.append(")");
        }
        fullQuery.append(" ORDER BY name, offset, value");
        if (print) {
            _logger.debug("macro results query: " + fullQuery);
        }
        IDBMSConnection connection = null;
        try {
            LinkedHashSet<String> outputParamNames = new LinkedHashSet<String>();
            if (macroNames != null) {
                for (String outputParameterName : macroNames) {
                    outputParamNames.add(outputParameterName.toUpperCase());
                }
            }
            IntHolder warning = new IntHolder();
            StringHolder warningMessage = new StringHolder();
            IntHolder bookmarkLength = new IntHolder();
            IntHolder numberColumns = new IntHolder();
            StringSeqHolder columnNames = new StringSeqHolder();
            LongSeqHolder columnTypes = new LongSeqHolder();
            LongSeqHolder columnLengths = new LongSeqHolder();
            StringSeqHolder columnLabels = new StringSeqHolder();
            StringSeqHolder formatNames = new StringSeqHolder();
            ShortSeqHolder formatWidths = new ShortSeqHolder();
            ShortSeqHolder formatDecimals = new ShortSeqHolder();
            ShortSeqHolder formatLengths = new ShortSeqHolder();
            StringSeqHolder informatNames = new StringSeqHolder();
            ShortSeqHolder informatWidths = new ShortSeqHolder();
            ShortSeqHolder informatDecimals = new ShortSeqHolder();
            OctetSeqHolder sortedBy = new OctetSeqHolder();
            IntHolder logicalRecordCount = new IntHolder();
            IntHolder physicalRecordCount = new IntHolder();
            VariableArray2dOfStringHolder characterValues = new VariableArray2dOfStringHolder();
            VariableArray2dOfDoubleHolder numericValues = new VariableArray2dOfDoubleHolder();
            VariableArray2dOfOctetHolder missingNumericValues = new VariableArray2dOfOctetHolder();
            OctetSeqHolder bookmarks = new OctetSeqHolder();
            IntHolder status = new IntHolder();
            connection = dataService.ConnectToDBMS("SQLVIEW", "", warning, warningMessage);
            if (print) {
                _logger.debug("macro results connect: warning=" + warning.value + ", warningMessage=\"" + warningMessage.value + "\"");
            }
            IDataSet iDataSet = connection.ExecuteQuery(fullQuery.toString(), true, bookmarkLength, warning, warningMessage);
            if (print) {
                _logger.debug("macro results execute: warning=" + warning.value + ", warningMessage=\"" + warningMessage.value + "\"");
            }
            iDataSet.GetColumnDefs(new boolean[0], numberColumns, columnNames, columnTypes, columnLengths, columnLabels, formatNames, formatWidths, formatDecimals, formatLengths, informatNames, informatWidths, informatDecimals, sortedBy);
            if (print) {
                _logger.debug("macro results numberColumns=" + numberColumns.value);
            }
            List<String> columnNamesList = Arrays.asList(columnNames.value);
            if (print) {
                _logger.debug("macro results columnNames=" + columnNamesList);
            }
            iDataSet.GetRecordCounts(logicalRecordCount, physicalRecordCount);
            if (print) {
                _logger.debug("macro results logicalRecordCount=" + logicalRecordCount.value + ", physicalRecordCount=" + physicalRecordCount.value);
            }
            iDataSet.ReadRecords(0, 0, new byte[0], logicalRecordCount.value, 0, characterValues, numericValues, missingNumericValues, bookmarks, status);
            if (print) {
                _logger.debug("macro results read: status=" + status.value);
            }
            double[][] doubleValues = numericValues.value;
            String[][] stringValues = characterValues.value;
            int rowCount = stringValues.length;
            String currentMacroName = null;
            StringBuffer currentMacroValue = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                String[] strings = stringValues[i];
                if (print) {
                    _logger.debug("macro results [" + i + "] strings=" + strings.length);
                    for (int index = 0; index < strings.length; ++index) {
                        _logger.debug("macro results [" + i + "] string[" + index + "] = \"" + strings[index] + "\"");
                    }
                }
                double[] doubles = doubleValues[i];
                if (print) {
                    _logger.debug("macro results [" + i + "] doubles=" + doubles.length);
                    for (int index = 0; index < doubles.length; ++index) {
                        _logger.debug("macro results [" + i + "] double[" + index + "] = " + doubles[index] + "");
                    }
                }
                double offset = doubles[0];
                String name = strings[1].trim();
                String value = strings[2].trim();
                if (print) {
                    _logger.debug("macro results PUT name=\"" + name + "\", offset=" + offset + ", value=\"" + value + "\"");
                }
                if (currentMacroName != null && !currentMacroName.equalsIgnoreCase(name)) {
                    if (print) {
                        _logger.debug("macro results [" + i + "] PUT name=\"" + currentMacroName + "\", value=\"" + currentMacroValue + "\"");
                    }
                    outputParameterMap.put(currentMacroName, currentMacroValue.toString());
                    currentMacroValue.setLength(0);
                }
                if (offset == 0.0) {
                    currentMacroName = name;
                }
                currentMacroValue.append(offset != 0.0 ? " " : "").append(value);
            }
            if (currentMacroName != null) {
                if (print) {
                    _logger.debug("macro results PUT name=\"" + currentMacroName + "\", value=\"" + currentMacroValue + "\"");
                }
                outputParameterMap.put(currentMacroName, currentMacroValue.toString());
            }
        }
        finally {
            if (connection != null) {
                connection.Disconnect();
                connection._release();
                connection = null;
            }
        }
        return outputParameterMap;
    }

    private final class EventStepError
    extends Event {
        private EventStepError() {
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_STEPERROR.fmt.txt", new java.lang.Object[0]);
        }
    }

    private final class EventDatastepComplete
    extends Event {
        private EventDatastepComplete() {
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_DATASTEPCOMPLETE.fmt.txt", new java.lang.Object[0]);
        }
    }

    private final class EventDatastepStart
    extends Event {
        private EventDatastepStart() {
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_DATASTEPSTART.fmt.txt", new java.lang.Object[0]);
        }
    }

    private final class EventProcComplete
    extends Event {
        String _procname;

        EventProcComplete(String procname) {
            this._procname = procname;
        }

        String getProcname() {
            return this._procname;
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_PROCCOMPLETE.fmt.txt", this.getProcname());
        }
    }

    private final class EventProcStart
    extends Event {
        String _procname;

        EventProcStart(String procname) {
            this._procname = procname;
        }

        String getProcname() {
            return this._procname;
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_PROCSTART.fmt.txt", this.getProcname());
        }
    }

    private final class EventGlobalstmtError
    extends Event {
        String _stmt;

        EventGlobalstmtError(String stmt) {
            this._stmt = stmt;
        }

        String getStmt() {
            return this._stmt;
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_GLOBALSTMTERROR.fmt.txt", this.getStmt());
        }
    }

    private final class EventGlobalstmtComplete
    extends Event {
        String _stmt;

        EventGlobalstmtComplete(String stmt) {
            this._stmt = stmt;
        }

        String getStmt() {
            return this._stmt;
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_GLOBALSTMTCOMPLETE.fmt.txt", this.getStmt());
        }
    }

    private final class EventSubmitComplete
    extends Event {
        int _sasrc;

        EventSubmitComplete(int sasrc) {
            this._sasrc = sasrc;
        }

        int getSasrc() {
            return this._sasrc;
        }

        @Override
        public MessageFormatter getMessageFormatter() {
            return IQDataServicesResourceBundle.getMessageFormatter("SASSubmitInstruction.EVENT_SUBMITCOMPLETE.fmt.txt", this._sasrc);
        }
    }

    private abstract class Event {
        private Event() {
        }

        public abstract MessageFormatter getMessageFormatter();

        public String getText() {
            return this.getMessageFormatter().toString();
        }
    }

    public class LanguageEventsListener
    extends _ILanguageEvents_1_1ImplBase {
        private Status _status = null;
        private ConnectionPoint _cp;
        private IntHolder _handleHolder;
        private SASSubmitHandler _handler = null;

        public LanguageEventsListener(SASSubmitHandler handler, Status status) {
            this._handler = handler;
            this._status = status;
        }

        public IntHolder getHandleHolder() {
            return this._handleHolder;
        }

        public ConnectionPoint getConnectionPoint() {
            return this._cp;
        }

        public void invoke(ServerRequest _request) {
            SASSubmitHandler.this.logReceivedEvent(_request, this._status, this._handler, this);
            super.invoke(_request);
        }

        public void ProcStart(String procname) {
            this.addEvent(new EventProcStart(procname));
        }

        public void SubmitComplete(int sasrc) {
            this.addEvent(new EventSubmitComplete(sasrc));
        }

        public void ProcComplete(String procname) {
            this.addEvent(new EventProcComplete(procname));
        }

        public void DatastepStart() {
            this.addEvent(new EventDatastepStart());
        }

        public void DatastepComplete() {
            this.addEvent(new EventDatastepComplete());
        }

        public void StepError() {
            this.addEvent(new EventStepError());
        }

        public void GlobalstmtComplete(String stmt) {
            this.addEvent(new EventGlobalstmtComplete(stmt));
        }

        public void GlobalstmtError(String stmt) {
            this.addEvent(new EventGlobalstmtError(stmt));
        }

        public synchronized void addEvent(Event event) {
            this._handler.addEvent(event, this._status, this._handler, this);
        }

        void startListening(ILanguageService languageService) {
            this._cp = this.getConnectionPoint(languageService);
            SASSubmitHandler.this.logConnectionPoint("startListening()", this._status, this._handler, this);
            this._handleHolder = new IntHolder();
            SASSubmitHandler.this.logStartingListener("startListening()", this._status, this._handler, this);
            this._status.setActive(true);
            this._cp.Advise((Object)this, this._handleHolder);
            SASSubmitHandler.this.logListenerStarted("startListening()", this._status, this._handler, this);
        }

        private ConnectionPoint getConnectionPoint(ILanguageService languageService) {
            CP_ID cpid = CP_IDConverter.stringToCP_ID((String)ILanguageEvents_1_1Helper.id());
            ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)languageService);
            ConnectionPointHolder cpHolder = new ConnectionPointHolder();
            cpContainer.FindConnectionPoint(cpid, cpHolder);
            ConnectionPoint cp = cpHolder.value;
            return cp;
        }

        void stopListening() {
            block2: {
                int handle = this._handleHolder.value;
                SASSubmitHandler.this.logStoppingListener("stopListening()", this._status, this._handler, this);
                try {
                    this._cp.Unadvise(handle);
                }
                catch (SystemException e) {
                    this._status.addToEventLog("Unadvise failed: " + e.toString());
                    Throwable cause = e.getCause();
                    boolean isClosed = cause instanceof ClosedChannelException;
                    boolean isMissing = e instanceof OBJECT_NOT_EXIST;
                    boolean isTimedOut = this._status.isSubmitTimedOut();
                    if (isTimedOut || isClosed || isMissing) break block2;
                    throw e;
                }
            }
            SASSubmitHandler.this.logListenerStopped("stopListening()", this._status, this._handler, this);
        }
    }

    public class Status {
        private boolean _active = false;
        private boolean _submitOk = true;
        private boolean _submitFinished = false;
        private boolean _globalstmtError = false;
        private List<java.lang.Object> _eventLog = Collections.synchronizedList(new ArrayList());
        private int _sasrc = 0;
        private boolean _submitTimedOut = false;
        private ConnectionInterface _connection = null;

        private Status() {
        }

        private Status(boolean submitOk, boolean submitFinished) {
            this._submitOk = submitOk;
            this._submitFinished = submitFinished;
        }

        public synchronized List<java.lang.Object> getEventLog() {
            return Collections.unmodifiableList(this._eventLog);
        }

        private synchronized void addToEventLog(java.lang.Object obj) {
            this._eventLog.add(obj);
        }

        public boolean isActive() {
            return this._active;
        }

        private synchronized void setActive(boolean active) {
            this._active = active;
        }

        public void setConnection(ConnectionInterface connection) {
            this._connection = connection;
        }

        public Exception isConnectionOK() {
            IllegalStateException exception = null;
            if (this._connection != null) {
                try {
                    this._connection.getObject();
                }
                catch (IllegalStateException e) {
                    exception = e;
                }
            }
            return exception;
        }

        public boolean isSubmitOK() {
            return this._submitOk;
        }

        public boolean isSubmitFinished() {
            return this._submitFinished;
        }

        public boolean isGlobalStmtError() {
            return this._globalstmtError;
        }

        public boolean isSubmitTimedOut() {
            return this._submitTimedOut;
        }

        public int getSasrc() {
            return this._sasrc;
        }

        private synchronized void setGlobalstmtErrored(SASSubmitHandler handler, LanguageEventsListener listener) {
            if (!this._globalstmtError) {
                SASSubmitHandler.this.logStatusChanged(SASSubmitHandler.this.labelSubmitGlobalStmtError, this._globalstmtError, true, this, handler, listener);
                this._globalstmtError = true;
            }
        }

        private synchronized void setAsyncFinished(SASSubmitHandler handler, LanguageEventsListener listener) {
            if (!this._submitFinished) {
                SASSubmitHandler.this.logStatusChanged(SASSubmitHandler.this.labelSubmitFinished, this._submitFinished, true, this, handler, listener);
                this._submitFinished = true;
            }
        }

        private synchronized void setSubmitOk(boolean newSubmitOk, SASSubmitHandler handler, LanguageEventsListener listener) {
            if (this._submitOk != newSubmitOk) {
                SASSubmitHandler.this.logStatusChanged(SASSubmitHandler.this.labelSubmitOk, this._submitOk, newSubmitOk, this, handler, listener);
                this.setSubmitOk(newSubmitOk);
            }
        }

        private synchronized void setSubmitOk(boolean newSubmitOk) {
            this._submitOk = newSubmitOk;
        }

        private synchronized void setSubmitTimedOut(boolean newSubmitTimedOut) {
            this._submitTimedOut = newSubmitTimedOut;
        }

        private synchronized void setSasrc(int newSasrc, SASSubmitHandler handler, LanguageEventsListener listener) {
            if (this._sasrc != newSasrc) {
                SASSubmitHandler.this.logSasrcChanged(SASSubmitHandler.this.labelSubmitOk, this._sasrc, newSasrc, this, handler, listener);
                this.setSasrc(newSasrc);
            }
        }

        public void setSasrc(int sasrc) {
            this._sasrc = sasrc;
        }
    }
}

