/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASLogReader;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution.relational.offline.CachedTabularResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.MLSResultSet;
import com.sas.iquery.execution2.TabularResultSet;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVADualResultSet;
import com.sas.rio.MVAStatement;
import com.sas.services.connection.ConnectionInterface;
import com.sas.util.ChainedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASOperations {
    private static final Logger _logger = LogManager.getLogger(SASOperations.class);

    public static Connection createConnection(ExecutionContext context, ExecutionOptions options) throws ExecutionException {
        MVAConnection sqlConnection;
        IWorkspace workspace = context.getWorkspace();
        Properties connectionProps = new Properties();
        String formatApplyString = null;
        formatApplyString = options.isFormatted() ? "True" : "False";
        connectionProps.put("applyFormats", formatApplyString);
        connectionProps.put("coerceNumericTypes", "false");
        try {
            sqlConnection = new MVAConnection(workspace, connectionProps);
        }
        catch (SQLException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SASOperations.UnableToCreateSqlConnection.txt", new Object[0]);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            SASOperations.readLogForException(context, "  Connection properties: " + connectionProps, e, errorMsg, e2);
            throw e2;
        }
        return sqlConnection;
    }

    public static TabularResultSet createTabularResultSet(ResultSet jdbcResultSet, ExecutionContext executionContext, boolean isDual) throws ExecutionException {
        TabularResultSet tabularResult = null;
        RetrievalPolicy retrievalPolicy = executionContext.getRetrievalPolicy();
        OfflineResultSetConfiguration offlineResultSetConfiguration = retrievalPolicy.getOfflineResultSetConfiguration();
        ConnectionInterface _pfsConnection = executionContext.getConnection();
        if (offlineResultSetConfiguration.isOfflineResultSetsEnabled()) {
            try {
                StpNames stpNames;
                CachedTabularResultSet offlineRS = new CachedTabularResultSet(jdbcResultSet, retrievalPolicy);
                Locale computationalLocale = executionContext.getComputationalLocale();
                if (computationalLocale != null) {
                    offlineRS.setComputationalLocale(computationalLocale);
                }
                if ((stpNames = executionContext.getStpNames()) != null) {
                    offlineRS.setStpNames(stpNames);
                }
                offlineRS.initialise(jdbcResultSet, isDual);
                offlineRS.setConnection(_pfsConnection);
                offlineRS.releaseResources();
                tabularResult = offlineRS;
            }
            catch (GenerationException e1) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("SQLInstruction.createTable.GenerationException.txt", new Object[0]), (Throwable)e1);
            }
        } else {
            tabularResult = new TabularResultSet(jdbcResultSet);
            tabularResult.setConnection(_pfsConnection);
        }
        return tabularResult;
    }

    public static Statement createStatement(ExecutionContext executionContext, Connection sqlConnection, ExecutionOptions options) throws ExecutionException {
        Statement statement;
        try {
            statement = sqlConnection.createStatement(1004, 1007);
            if (options.getMaxOutputRows() > -1) {
                int maxRows = options.getMaxOutputRows();
                statement.setMaxRows(maxRows);
            }
        }
        catch (SQLException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SQLInstruction.createStatement.SQLException.txt", new Object[0]);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            if (executionContext == null) {
                Throwable t = ChainedException.getRootException((Throwable)e);
                if (t == null) {
                    t = e;
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getMessage(), t);
                }
            } else {
                SASOperations.readLogForException(executionContext, "  Could not create java.sql.Statement.", e, errorMsg, e2);
            }
            throw e2;
        }
        return statement;
    }

    public static ResultSet createTable(ExecutionContext context, Statement statement, String JDBCStatementString) throws ExecutionException {
        ResultSet jdbcResultSet = null;
        try {
            jdbcResultSet = statement.executeQuery(JDBCStatementString);
        }
        catch (SQLException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SQLInstruction.createTable.SQLException.fmt.txt", JDBCStatementString);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            SASOperations.readLogForException(context, "  JDBC Statement: " + JDBCStatementString, e, errorMsg, e2);
            throw e2;
        }
        return jdbcResultSet;
    }

    private static void readLogForException(ExecutionContext executionContext, String statementString, Exception e, MessageFormatter errorMsg, ExecutionException e2) {
        StringBuffer statementErrors = new StringBuffer();
        SASLogReader.flushLogForError(executionContext, statementErrors);
        SASLogReader.prepException((IQueryServicesException)e2, errorMsg, executionContext, statementErrors.toString());
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("An exception occurred while attempting to execute a query." + statementString + "\n" + statementErrors, (Throwable)e);
        }
    }

    public static ResultSet createDualResultSet(ExecutionContext context, Statement statement, String libref, String tableNm, String JDBCStatementString) throws ExecutionException {
        MVADualResultSet jdbcResultSet = null;
        try {
            MVAStatement mvaStatment = (MVAStatement)statement;
            jdbcResultSet = mvaStatment.createDualResultSet(libref, tableNm, null, null);
        }
        catch (SQLException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("SQLInstruction.createTable.SQLException.fmt.txt", JDBCStatementString);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            SASOperations.readLogForException(context, "  JDBC Statement: " + JDBCStatementString, e, errorMsg, e2);
            throw e2;
        }
        return jdbcResultSet;
    }

    public static ResultSet addMLSResultSetExtension(CredentialResolver resolver, ExecutionContext executionContext, ResultSet jdbcResultSet) throws ExecutionException {
        ResultSet resultSet;
        Locale jdbcResultsLocale = executionContext.getComputationalLocale();
        Map<String, MLSLookup> mlsLookups = executionContext.getMLSLookups();
        if (mlsLookups != null && mlsLookups.size() > 0) {
            try {
                resultSet = new MLSResultSet(resolver, jdbcResultSet, jdbcResultsLocale, mlsLookups);
            }
            catch (SQLException e) {
                throw new ExecutionException(e);
            }
        } else {
            resultSet = jdbcResultSet;
        }
        return resultSet;
    }
}

