/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.TransportException;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.util.GetPropertyAction;
import com.sas.util.ChainedException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASLogReader {
    private static final SASLogReader _instance = new SASLogReader();
    private static final Logger _logger = LogManager.getLogger(SASLogReader.class);
    public static final String LOG_STARTING_LINE_OLD = "sasLogStartingLine";
    public static final String LOG_ENDING_LINE_OLD = "sasLogEndingLine";
    public static final String LOG_NUMBER_TO_READ_OLD = "sasLogNumberToRead";
    public static final String LOG_LINENUMBER_IS_PREPENDED = "SASQueryServices.sasLogAddLineNum";
    public static final String LOG_LINETYPE_IS_PREPENDED = "SASQueryServices.sasLogAddLineType";
    public static final String LOG_LINECC_IS_PREPENDED = "SASQueryServices.sasLogAddLineCarriageControl";
    public static final String LOG_STARTING_LINE = "SASQueryServices.sasLogStartingLine";
    public static final String LOG_ENDING_LINE = "SASQueryServices.sasLogEndingLine";
    public static final int DEFAULT_STARTING_LINE = 1;
    public static final int DEFAULT_ENDING_LINE = 1024;
    public static final String LOG_NUMBER_TO_READ = "SASQueryServices.sasLogNumberToRead";
    public static final int DEFAULT_LINES_TO_READ = 200;
    private static final String NUMBERED_SASLOG_LINE_PATTERN = "[\\d]+[\\s]+.*";
    private static final String NUMBERED_SASLOG_PAGEHEADING_PATTERN = "[\\d]+[\\s]*The SAS System[\\s]{15}[\\s]*[\\d]+:[\\d]+.*[\\d]+, [\\d]{4}";

    private SASLogReader() {
    }

    public static SASLogReader getInstance() {
        return _instance;
    }

    public String getSASLog(ILanguageService language) throws GenericError, TransportException, RemoteException, IllegalStateException {
        return this.getSASLog(language, null);
    }

    public String getSASLog(ILanguageService language, StringBuffer errorText) throws GenericError, TransportException, RemoteException, IllegalStateException {
        return this._getSASLog(language, errorText);
    }

    private String _getSASLog(Object reader, StringBuffer errorText) throws GenericError, TransportException, RemoteException, IllegalStateException {
        int numLinesToRead;
        boolean areLineNumsArePrepended = Boolean.getBoolean(LOG_LINENUMBER_IS_PREPENDED);
        boolean areLineTypesArePrepended = Boolean.getBoolean(LOG_LINETYPE_IS_PREPENDED);
        boolean areLineCarriageControlsArePrepended = Boolean.getBoolean(LOG_LINECC_IS_PREPENDED);
        Integer startingLineInt = Integer.getInteger(LOG_STARTING_LINE_OLD);
        int startingLine = startingLineInt == null ? IQSystemProperties.getIntProperty(LOG_STARTING_LINE, 1) : startingLineInt;
        Integer endingLineInt = Integer.getInteger(LOG_ENDING_LINE_OLD);
        int endingLine = endingLineInt == null ? IQSystemProperties.getIntProperty(LOG_ENDING_LINE, 1024) : endingLineInt;
        Integer numLinesToReadInt = Integer.getInteger(LOG_NUMBER_TO_READ_OLD);
        int n = numLinesToRead = numLinesToReadInt == null ? IQSystemProperties.getIntProperty(LOG_NUMBER_TO_READ, 200) : numLinesToReadInt;
        if (startingLine > 0) {
            --startingLine;
        }
        if (startingLine < 0) {
            startingLine = 0;
            _logger.debug("Setting sasLogStartingLine to 0.");
        }
        if (endingLine < startingLine) {
            startingLine = 0;
            endingLine = 1024;
            _logger.debug("Setting sasLogStartingLine to 0, sasLogEndingLine to default.");
        }
        return this._getSASLog(reader, errorText, startingLine, endingLine, numLinesToRead, areLineNumsArePrepended, areLineTypesArePrepended, areLineCarriageControlsArePrepended);
    }

    public String getSASLog(ILanguageService language, StringBuffer errorText, int startingLine, int endingLine, int numLinesToRead, boolean areLineNumsArePrepended, boolean areLineTypesArePrepended, boolean areLineCarriageControlsArePrepended) throws GenericError, TransportException, RemoteException, IllegalStateException {
        return this._getSASLog(language, errorText, startingLine, endingLine, numLinesToRead, areLineNumsArePrepended, areLineTypesArePrepended, areLineCarriageControlsArePrepended);
    }

    public String _getSASLog(Object reader, StringBuffer errorText, int startingLine, int endingLine, int numLinesToRead, boolean areLineNumsArePrepended, boolean areLineTypesArePrepended, boolean areLineCarriageControlsArePrepended) throws GenericError, TransportException, RemoteException, IllegalStateException {
        StringBuffer sasLog = new StringBuffer();
        int currentLineCursor = 0;
        StringSeqHolder logLines = new StringSeqHolder();
        CarriageControlSeqHolder ccHolder = new CarriageControlSeqHolder();
        LineTypeSeqHolder ltHolder = new LineTypeSeqHolder();
        StringBuffer prevLine = null;
        String[] str = null;
        LineType[] lineTypes = null;
        CarriageControl[] carrControls = null;
        String what = reader instanceof ILanguageService ? ((ILanguageService)reader).Parent().Name() + "=" + ((ILanguageService)reader).Parent().UniqueIdentifier() : (reader instanceof Execution2Interface ? "StoredProcess2.SessionID=" + ((Execution2Interface)reader).getSessionID() : String.valueOf(reader));
        boolean readLines = this.flush(reader, numLinesToRead, logLines, ccHolder, ltHolder);
        if (readLines) {
            _logger.info("--- flushed log read ---");
            while (readLines) {
                str = logLines.value;
                lineTypes = ltHolder.value;
                carrControls = ccHolder.value;
                int numLinesRead = str.length;
                this.outputToLogger(what, str, lineTypes, carrControls, numLinesRead);
                int startLine = 0;
                if (currentLineCursor < startingLine) {
                    startLine = Math.min(numLinesRead, startingLine - currentLineCursor);
                }
                int lastLine = numLinesRead;
                if (currentLineCursor < endingLine && currentLineCursor + numLinesRead > endingLine) {
                    lastLine = Math.min(endingLine, endingLine - currentLineCursor);
                }
                prevLine = this.format(sasLog, areLineNumsArePrepended, areLineTypesArePrepended, areLineCarriageControlsArePrepended, errorText, prevLine, currentLineCursor, startLine, lastLine, lineTypes, carrControls, str);
                if ((currentLineCursor += numLinesRead) >= endingLine || reader instanceof Execution2Interface) break;
                readLines = this.flush(reader, numLinesToRead, logLines, ccHolder, ltHolder);
            }
            _logger.info("--- done flushing log ---");
        }
        return sasLog.toString();
    }

    private void outputToLogger(Object what, String[] str, LineType[] lineTypes, CarriageControl[] carrControls, int numLinesRead) {
        for (int k = 0; k < numLinesRead; ++k) {
            int carrControl = carrControls[k].value();
            String cc = "  ";
            cc = carrControl == 1 ? "NP" : (carrControl == 0 ? "  " : (carrControl == 2 ? "OP" : (carrControl == 3 ? "SL" : (carrControl == 4 ? "2L" : carrControl + "?"))));
            int lineType = lineTypes[k].value();
            String lt = "          ";
            lt = lineType == 0 ? " Normal   " : (lineType == 3 ? " Title    " : (lineType == 2 ? " Source   " : (lineType == 6 ? " Error    " : (lineType == 7 ? " Warning  " : (lineType == 8 ? " Note     " : (lineType == 9 ? " Message  " : (lineType == 1 ? " Highlite " : (lineType == 5 ? " Footnote " : (lineType == 4 ? " Byline   " : " " + lineType + "? ")))))))));
            _logger.info(what + ": " + cc + lt + str[k]);
        }
    }

    private boolean flush(Object reader, int numLinesToRead, StringSeqHolder logLines, CarriageControlSeqHolder ccHolder, LineTypeSeqHolder ltHolder) throws GenericError, TransportException, RemoteException {
        if (reader instanceof ILanguageService) {
            ILanguageService language = (ILanguageService)reader;
            language.FlushLogLines(numLinesToRead, ccHolder, ltHolder, logLines);
        } else if (reader instanceof Execution2Interface) {
            Execution2Interface spExecution = (Execution2Interface)reader;
            this.flushLogLines(spExecution, ccHolder, ltHolder, logLines);
        }
        return logLines.value != null && logLines.value.length != 0;
    }

    private StringBuffer format(StringBuffer sasLog, boolean areLineNumsArePrepended, boolean areLineTypesArePrepended, boolean areLineCarriageControlsArePrepended, StringBuffer errorText, StringBuffer prevLine, int currentLineCursor, int startLine, int lastLine, LineType[] lineTypes, CarriageControl[] carrControls, String[] textStrs) {
        for (int i = startLine; i < lastLine; ++i) {
            String line = textStrs[i];
            LineType lineType = lineTypes[i];
            CarriageControl cc = carrControls[i];
            if (areLineNumsArePrepended) {
                sasLog.append(currentLineCursor + i + 1).append(":");
            }
            if (areLineTypesArePrepended) {
                sasLog.append(lineType.value()).append(":");
            }
            if (areLineCarriageControlsArePrepended) {
                sasLog.append(cc.value()).append(":");
            }
            sasLog.append(line).append("\n");
            if (errorText == null) continue;
            if (lineType == LineType.LineTypeSource) {
                if (prevLine == null) {
                    prevLine = new StringBuffer();
                }
                if (prevLine.length() > 0) {
                    prevLine.append("\n");
                }
                prevLine.append(line.replace('\t', ' '));
                continue;
            }
            if (lineType != LineType.LineTypeError) continue;
            if (errorText.length() > 0) {
                errorText.append("\n");
            }
            if (prevLine != null) {
                errorText.append(prevLine).append("\n");
                prevLine = null;
            }
            errorText.append(line);
        }
        return prevLine;
    }

    public String getSASLog(Execution2Interface spExecutionInterface) throws TransportException, RemoteException {
        Integer numLinesToReadInt = Integer.getInteger(LOG_NUMBER_TO_READ_OLD);
        int numLinesToRead = numLinesToReadInt == null ? IQSystemProperties.getIntProperty(LOG_NUMBER_TO_READ, -1) : numLinesToReadInt;
        return this.getSASLog(spExecutionInterface, numLinesToRead);
    }

    public String getSASLog(Execution2Interface spExecutionInterface, int numLinesToRead) throws TransportException, RemoteException {
        StringBuffer logLines = new StringBuffer("\n");
        String aBlockOfLines = null;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Log Lines for >" + spExecutionInterface);
        }
        do {
            aBlockOfLines = spExecutionInterface.readSASLog(1, numLinesToRead);
            logLines.append(aBlockOfLines);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("Log Lines Read in block [" + aBlockOfLines + "]");
        } while (aBlockOfLines.length() > 0);
        return logLines.toString();
    }

    public static void prepException(IQueryServicesException iqException, MessageFormatter errorMsg, ExecutionContext context, String errorsString) {
        String sasLog = context.getRunningLog();
        SASLogReader.prepException(iqException, errorMsg, sasLog, errorsString);
    }

    public static void prepException(IQueryServicesException iqException, MessageFormatter errorMsg, String sasLog, String errorsString) {
        MessageFormatter withStatement = errorMsg;
        StringBuilder logMessage = new StringBuilder();
        logMessage.append('\n').append(sasLog).append(withStatement);
        Throwable t = ChainedException.getRootException((Throwable)iqException);
        if (t != null && t != iqException) {
            logMessage.append('\n').append(t.getLocalizedMessage());
        }
        MessageFormatter withErrors = withStatement;
        if (errorsString != null && errorsString.length() > 0) {
            String line;
            int i;
            logMessage.append('\n');
            String[] lines = errorsString.split("\n");
            int len = lines.length;
            for (i = len - 1; i >= 0; --i) {
                line = lines[i];
                if (!line.matches(NUMBERED_SASLOG_LINE_PATTERN) || i + 1 >= len) continue;
                String nextLine = lines[i + 1];
                if (nextLine == null) {
                    lines[i] = null;
                    continue;
                }
                if (!nextLine.matches(NUMBERED_SASLOG_LINE_PATTERN)) continue;
                lines[i] = null;
            }
            for (i = 0; i < len; ++i) {
                line = lines[i];
                if (line == null) continue;
                logMessage.append(line).append('\n');
            }
            withErrors = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, withStatement, errorsString);
            iqException.setMessage(withErrors);
        }
        iqException.setSASLog(logMessage.toString());
    }

    public static void flushLog(ExecutionContext executionContext, ILanguageService languageService) throws TransportException, GenericError, RemoteException, IllegalStateException {
        if (languageService == null) {
            IWorkspace workspace = executionContext.getWorkspace();
            languageService = IOMServerUtils.GetILanguageService(workspace);
        }
        String languageServiceLog = SASLogReader.getInstance().getSASLog(languageService, null);
        executionContext.setSASLog(languageServiceLog);
        languageService.ResetLogLineNumbers();
    }

    public static void flushLogForError(ExecutionContext executionContext, StringBuffer statementErrors) {
        SASLogReader.flushLogForError(executionContext, null, statementErrors);
    }

    public static void flushLogForError(ExecutionContext executionContext, ILanguageService languageService, StringBuffer statementErrors) {
        String msg;
        Throwable e2;
        if (languageService == null) {
            try {
                IWorkspace workspace = executionContext.getWorkspace();
                languageService = IOMServerUtils.GetILanguageService(workspace);
            }
            catch (Exception e) {
                e2 = ChainedException.getRootException((Throwable)e);
                msg = IQDataServicesResourceBundle.getStringResource("SASSubmitInstruction.getSubmitLog.GenericError.txt");
                executionContext.appendRunningLog(msg + "> " + e2);
                _logger.error(msg, e2);
            }
        }
        if (languageService != null) {
            try {
                String languageServiceLog = SASLogReader.getInstance().getSASLog(languageService, statementErrors);
                executionContext.setSASLog(languageServiceLog);
            }
            catch (Exception e) {
                e2 = ChainedException.getRootException((Throwable)e);
                msg = IQDataServicesResourceBundle.getStringResource("SASSubmitInstruction.getSubmitLog.GenericError.txt");
                executionContext.appendRunningLog(msg + "> " + e2);
                _logger.error(msg, e2);
            }
            try {
                languageService.ResetLogLineNumbers();
            }
            catch (Exception e) {
                e2 = ChainedException.getRootException((Throwable)e);
                msg = IQDataServicesResourceBundle.getStringResource("SASSubmitInstruction.getSubmitLog.GenericError.txt");
                executionContext.appendRunningLog(msg + "> " + e2);
                _logger.error(msg, e2);
            }
        }
    }

    public String getSASLog(Execution2Interface spExecution, StringBuffer errorText) throws GenericError, TransportException, RemoteException, IllegalStateException {
        return this._getSASLog(spExecution, errorText);
    }

    private void flushLogLines(Execution2Interface spExecution, CarriageControlSeqHolder ccHolder, LineTypeSeqHolder ltHolder, StringSeqHolder logLines) throws TransportException, RemoteException, IllegalStateException {
        String htmlText = spExecution.readSASLog(2, -1);
        this.parse(htmlText, ccHolder, ltHolder, logLines);
    }

    private void parse(String htmlText, CarriageControlSeqHolder ccHolder, LineTypeSeqHolder ltHolder, StringSeqHolder logLines) throws TransportException, RemoteException, IllegalStateException {
        String lineSep = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        MessageFormat warningEndReader = new MessageFormat("</font></em>{0}");
        MessageFormat noteStartReader = new MessageFormat("<font color=blue>{0}");
        MessageFormat noteEndReader = new MessageFormat("</font>{0}");
        MessageFormat errorStartReader = new MessageFormat("<strong><font color=red>{0}");
        MessageFormat errorEndReader = new MessageFormat("</font></strong>{0}");
        MessageFormat warningStartReader = new MessageFormat("<em><font color=green>{0}");
        MessageFormat preReader = new MessageFormat("{1}<pre>{0}</pre>{2}");
        ParsePosition pos = new ParsePosition(0);
        Object[] parts = preReader.parse(htmlText, pos);
        if (pos.getIndex() != 0) {
            String insidePre = (String)parts[0];
            insidePre = insidePre.replaceAll(lineSep, "\u0000");
            String[] lines = insidePre.split("\u0000");
            ArrayList<String> strings = new ArrayList<String>();
            ArrayList<LineType> lts = new ArrayList<LineType>();
            ArrayList<CarriageControl> ccs = new ArrayList<CarriageControl>();
            LineType lineType = LineType.LineTypeNormal;
            for (int i = 0; i < lines.length; ++i) {
                String htmlLine;
                String textLine = htmlLine = lines[i];
                if (lineType == LineType.LineTypeError) {
                    pos.setIndex(0);
                    parts = errorEndReader.parse(textLine, pos);
                    if (pos.getIndex() != 0) {
                        lineType = LineType.LineTypeNormal;
                        textLine = (String)parts[0];
                    }
                } else if (lineType == LineType.LineTypeWarning) {
                    pos.setIndex(0);
                    parts = warningEndReader.parse(textLine, pos);
                    if (pos.getIndex() != 0) {
                        lineType = LineType.LineTypeNormal;
                        textLine = (String)parts[0];
                    }
                } else if (lineType == LineType.LineTypeNote) {
                    pos.setIndex(0);
                    parts = noteEndReader.parse(textLine, pos);
                    if (pos.getIndex() != 0) {
                        lineType = LineType.LineTypeNormal;
                        textLine = (String)parts[0];
                    }
                } else if (lineType == LineType.LineTypeTitle) {
                    lineType = LineType.LineTypeNormal;
                }
                if (lineType == LineType.LineTypeNormal || lineType == LineType.LineTypeSource) {
                    pos.setIndex(0);
                    parts = errorStartReader.parse(textLine, pos);
                    if (pos.getIndex() != 0) {
                        lineType = LineType.LineTypeError;
                        textLine = (String)parts[0];
                    } else {
                        pos.setIndex(0);
                        parts = warningStartReader.parse(textLine, pos);
                        if (pos.getIndex() != 0) {
                            lineType = LineType.LineTypeWarning;
                            textLine = (String)parts[0];
                        } else {
                            pos.setIndex(0);
                            parts = noteStartReader.parse(textLine, pos);
                            if (pos.getIndex() != 0) {
                                lineType = LineType.LineTypeNote;
                                textLine = (String)parts[0];
                            }
                        }
                    }
                }
                String realText = SASLogReader.unescape(textLine);
                CarriageControl cctl = CarriageControl.CarriageControlNormal;
                if (lineType == LineType.LineTypeNormal || lineType == LineType.LineTypeSource) {
                    if (realText.matches(NUMBERED_SASLOG_PAGEHEADING_PATTERN)) {
                        lineType = LineType.LineTypeTitle;
                        cctl = CarriageControl.CarriageControlNewPage;
                    } else if (realText.matches(NUMBERED_SASLOG_LINE_PATTERN)) {
                        lineType = LineType.LineTypeSource;
                    }
                }
                ccs.add(cctl);
                lts.add(lineType);
                strings.add(SASLogReader.unescape(textLine));
            }
            logLines.value = strings.toArray(new String[strings.size()]);
            ltHolder.value = lts.toArray(new LineType[lts.size()]);
            ccHolder.value = ccs.toArray(new CarriageControl[ccs.size()]);
        }
    }

    private static String unescape(String escapedString) {
        return escapedString.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
    }
}

