/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionCancelQueryListener;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.ChainedException;
import com.sas.util.anno.NotNull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPDataSetFactory {
    private static final Object DATASET_FACTORY_PROPERTY_NAME = "com.sas.iquery.execution.instructions.OLAPDataSetFactory.DATASET_FACTORY";
    private static final Logger _logger = LogManager.getLogger(OLAPDataSetFactory.class);

    public static OLAPDataSetFactory getFactory(DataSelection dataSelection) throws ExecutionException {
        OLAPDataSetFactory dataSetFactory = null;
        if (!(dataSelection instanceof DataSelectionImpl)) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataSetFactory.getDataSet.DataSelectionImpl.txt", new Object[0]));
        }
        HashMap<Object, OLAPDataSetFactory> strategyProperties = ((DataSelectionImpl)dataSelection).getStrategyProperties();
        if (strategyProperties == null) {
            strategyProperties = new HashMap<Object, OLAPDataSetFactory>();
            ((DataSelectionImpl)dataSelection).setStrategyProperties(strategyProperties);
        }
        if ((dataSetFactory = (OLAPDataSetFactory)strategyProperties.get(DATASET_FACTORY_PROPERTY_NAME)) == null) {
            dataSetFactory = new OLAPDataSetFactory();
            strategyProperties.put(DATASET_FACTORY_PROPERTY_NAME, dataSetFactory);
        }
        return dataSetFactory;
    }

    public OLAPDataSetInterface getDataSet(DataSelection dataSelection, LogicalServerInterface logicalServer, String queryString, Integer contextType, RetrievalPolicy retrievalPolicy, Locale computationalLocale) throws ExecutionException {
        return this.getDataSet(dataSelection, logicalServer, queryString, contextType, retrievalPolicy);
    }

    public OLAPDataSetInterface getDataSet(DataSelection dataSelection, LogicalServerInterface logicalServer, String queryString, Integer contextType, RetrievalPolicy retrievalPolicy) throws ExecutionException {
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        return this.getDataSet(dataSelection, logicalServer, queryString, contextType, retrievalPolicy, computationalLocale, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OLAPDataSetInterface getDataSet(DataSelection dataSelection, LogicalServerInterface logicalServer, String queryString, Integer contextType, RetrievalPolicy retrievalPolicy, Locale computationalLocale, Map<String, String> labelNameMap) throws ExecutionException {
        IQOLAPDataSet olapDataSet;
        block13: {
            int contextTypeValue = contextType != null ? contextType : 0;
            ConnectionConfiguration connectionConfiguration = retrievalPolicy.getConnectionConfiguration();
            int connectionLifetime = connectionConfiguration.getConnectionLifetime();
            boolean aquireRelease = connectionLifetime == 0;
            String constructor = "GENERATION";
            olapDataSet = null;
            OLAPConnectionResource connectionResource = null;
            boolean isOk = false;
            try {
                connectionResource = OLAPConnectionInfoUtil.getOLAPConnectionResource(dataSelection, logicalServer, retrievalPolicy, computationalLocale);
                ConnectionInterface pfsConnection = aquireRelease ? connectionResource.getConnection() : null;
                Locale connectionLocale = connectionResource.getConnectionLocale(dataSelection);
                ISession isession = connectionResource.getISession(dataSelection, constructor, connectionLocale);
                olapDataSet = ConnectionResources.newOLAPDataSet(isession, contextTypeValue, pfsConnection);
                if (dataSelection != null) {
                    olapDataSet.setBusinesModel(dataSelection);
                }
                olapDataSet.setRelatedConnection(connectionResource);
                connectionResource.addOlapDataSet(isession, olapDataSet, connectionLocale);
                olapDataSet.setLocale(connectionLocale);
                if (labelNameMap != null) {
                    if (labelNameMap.size() > 0) {
                        olapDataSet.setQueryStatement(queryString, null, labelNameMap);
                    } else {
                        olapDataSet.setQueryStatement(queryString, null);
                    }
                } else {
                    olapDataSet.setQueryStatement(queryString, null);
                }
                if (queryString != null) {
                    olapDataSet.executeQuery();
                }
                if (isOk = true) return olapDataSet;
                if (!aquireRelease || connectionResource == null) break block13;
            }
            catch (OLAPException e) {
                try {
                    MessageFormatter msg = this.getArrayMessageFormatter("OLAPDataSetFactory.getDataSet.CreationFailed.txt", queryString, (Exception)((Object)e));
                    throw new ExecutionException(msg, (Throwable)e);
                    catch (GenerationException e2) {
                        msg = this.getArrayMessageFormatter("OLAPDataSetFactory.getDataSet.CreationFailed.txt", queryString, e2);
                        throw new ExecutionException(msg, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (isOk) throw throwable;
                    if (aquireRelease && connectionResource != null) {
                        ConnectionResources.close(connectionResource);
                    }
                    if (olapDataSet == null) throw throwable;
                    ConnectionResources.close(olapDataSet);
                    throw throwable;
                }
            }
            ConnectionResources.close(connectionResource);
        }
        if (olapDataSet == null) return olapDataSet;
        ConnectionResources.close(olapDataSet);
        return olapDataSet;
    }

    private MessageFormatter getArrayMessageFormatter(String resourceKey, String queryString, Exception e) {
        Object[] objectArray;
        String msg = IQDataServicesResourceBundle.getStringResource(resourceKey);
        Throwable t = ChainedException.getRootException((Throwable)e);
        if (e != t && t != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = msg;
            objectArray2[1] = queryString;
            objectArray = objectArray2;
            objectArray2[2] = t;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = msg;
            objectArray3[1] = queryString;
            objectArray = objectArray3;
            objectArray3[2] = e;
        }
        Object[] msgArgs2 = objectArray;
        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
        _logger.error(msg + ":" + queryString, (Throwable)e);
        return msF;
    }

    public static void writeOutStatment(String olapStatementString) {
        String writeSasStatements = System.getProperty("SASQueryServices.writeOLAPStatements");
        if (writeSasStatements == null) {
            writeSasStatements = System.getProperty("IQ.writeOLAPStatements");
        }
        if (writeSasStatements != null) {
            if (writeSasStatements.equalsIgnoreCase("System.err")) {
                System.err.println(olapStatementString);
            } else if (writeSasStatements.equalsIgnoreCase("System.out")) {
                System.out.println(olapStatementString);
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(writeSasStatements, true);
                    PrintStream ps = new PrintStream(out);
                    ps.println(olapStatementString);
                    ps.close();
                    ((OutputStream)out).close();
                }
                catch (IOException io) {
                    System.err.println("IO exception writing log to filename '" + writeSasStatements + "', " + io);
                }
            }
        }
    }

    @NotNull
    public static OLAPConnectionResource getOLAPConnectionResource(DataSelection dataSelection, LogicalServerInterface logicalServer, RetrievalPolicy retrievalPolicy, Locale connectionLocale) throws ExecutionException {
        SessionContextInterface sessionContext = dataSelection.getSession();
        ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
        OLAPConnectionResource connectionResource = null;
        UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
        ConnectionInterface connection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, retrievalPolicy, connectionLocale);
        ConnectionCancelQueryListener postConnectionListener = new ConnectionCancelQueryListener(dataSelection, true, connection);
        CancelQuerySupport.registerQueryListener(dataSelection, postConnectionListener, connection);
        if (connection instanceof UserSessionConnectionDecorator) {
            connection = ((UserSessionConnectionDecorator)connection).getComponent();
        }
        ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPDataSetFactory.class, connection);
        connectionResource = (OLAPConnectionResource)connection;
        return connectionResource;
    }
}

