/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.OLAPDataSetFactory;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.MultiDimResultSet;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MDXInstruction
extends AbstractExecutionInstruction {
    private String _queryString = null;
    private LogicalServerInterface _logicalServer = null;
    private DataSelection _dataSelection = null;
    private Integer _contextID = null;
    private Map<String, String> _labelNameMap = new LinkedHashMap<String, String>();
    private static final Logger _logger = LogManager.getLogger(MDXInstruction.class);

    public MDXInstruction(LogicalServerInterface logicalServer, DataSelection dataSelection, String queryString, Integer contextID) {
        this._queryString = queryString;
        this._logicalServer = logicalServer;
        this._dataSelection = dataSelection;
        if (contextID != null) {
            this._contextID = contextID;
        }
    }

    @Override
    public void execute() throws ExecutionException {
        ExecutionContext executionContext = this.getExecutionContext();
        RetrievalPolicy retrievalPolicy = executionContext.getRetrievalPolicy();
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, executionContext);
        OLAPDataSetInterface mdDataSet = null;
        _logger.debug("Executing an MDX query");
        OLAPDataSetFactory dataSetFactory = OLAPDataSetFactory.getFactory(this._dataSelection);
        mdDataSet = this._labelNameMap.size() == 0 ? dataSetFactory.getDataSet(this._dataSelection, this._logicalServer, this._queryString, this._contextID, retrievalPolicy, effectiveComputationLocale) : dataSetFactory.getDataSet(this._dataSelection, this._logicalServer, this._queryString, this._contextID, retrievalPolicy, effectiveComputationLocale, this._labelNameMap);
        ResultSetInterface result = this.createResultSetInterface(mdDataSet);
        executionContext.setResult(result);
        this._labelNameMap.clear();
        if (result instanceof ResultSetUpdateInterface) {
            ((ResultSetUpdateInterface)((Object)result)).setComputationalLocale(effectiveComputationLocale);
            StpNames stpNames = executionContext.getStpNames();
            ((ResultSetUpdateInterface)((Object)result)).setStpNames(stpNames);
        }
    }

    public void setLabelNameMap(Map<String, String> labelNameMap) {
        this._labelNameMap = labelNameMap;
    }

    public Map<String, String> getLabelNameMap() {
        return this._labelNameMap;
    }

    protected ResultSetInterface createResultSetInterface(OLAPDataSetInterface mdDataSet) throws ExecutionException {
        MultiDimResultSet result = new MultiDimResultSet(mdDataSet);
        Date date = new Date();
        result.setResultSetDate(date);
        return result;
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        return this._queryString;
    }

    @Override
    public ResultSetInterface getResult() {
        return this.getExecutionContext().getResult();
    }
}

