/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.OptionsInstruction;
import com.sas.iquery.execution.relational.offline.CachedTabularResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import java.util.ArrayList;
import java.util.List;

public class ExecutionBlock
implements ExecutionInstructionInterface {
    private List<ExecutionInstructionInterface> _instructionList = new ArrayList<ExecutionInstructionInterface>();
    private String _id = null;
    private ExecutionContext _context = null;

    @Override
    public void execute() throws ExecutionException {
        for (ExecutionInstructionInterface instruction : this._instructionList) {
            instruction.execute();
        }
        ResultSetInterface rsi = this._context.getResult();
        if (rsi instanceof CachedTabularResultSet) {
            ((CachedTabularResultSet)rsi).setInstructions(this._instructionList);
        }
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this._context;
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        for (ExecutionInstructionInterface instruction : this._instructionList) {
            instruction.setExecutionContext(context);
        }
        this._context = context;
    }

    @Override
    public ResultSetInterface getResult() {
        return this._context.getResult();
    }

    public void addInstruction(ExecutionInstructionInterface instruction) {
        instruction.setExecutionContext(this.getExecutionContext());
        this._instructionList.add(instruction);
    }

    public ExecutionInstructionInterface[] getInstructions() {
        return this._instructionList.toArray(new ExecutionInstructionInterface[this._instructionList.size()]);
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public void setID(String id) {
        this._id = id;
    }

    public String toString() {
        try {
            return this.getText();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        StringBuffer stringBuffer = new StringBuffer();
        for (ExecutionInstructionInterface instruction : this._instructionList) {
            String text = instruction.getText();
            boolean ignoreEmptyOptions = instruction instanceof OptionsInstruction && text.length() == 0;
            if (ignoreEmptyOptions) continue;
            stringBuffer.append(text + "\n");
        }
        return stringBuffer.toString();
    }
}

