/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASOperations;
import com.sas.iquery.execution.instructions.SASSubmitInstruction;
import com.sas.iquery.execution2.EmptyResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.TabularResultSet;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.metadata.remote.CredentialResolver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DualSubmitInstruction
extends SASSubmitInstruction {
    private static final Logger _logger = LogManager.getLogger(DualSubmitInstruction.class);

    public DualSubmitInstruction(String sasStatement, String resultTableReplacementPattern, ExecutionOptions executionOptions, DataSelection dataSelection) {
        super(sasStatement, resultTableReplacementPattern, executionOptions, dataSelection);
        this.setOutputTableName(resultTableReplacementPattern);
    }

    @Override
    protected ResultSetInterface buildResultSet() throws ExecutionException {
        ExecutionContext executionContext = this.getExecutionContext();
        ExecutionOptions executionOptions = this.getExecutionOptions();
        _logger.debug("Executing a DualSubmitInstruction query");
        assert (this._libref != null);
        assert (this._tableNm != null);
        ResultSet dualResultSet = this.buildDualResultSet(executionContext, executionOptions, this._libref, this._tableNm, this.getJDBCStatementString());
        TabularResultSet tabularResultSet = SASOperations.createTabularResultSet(dualResultSet, executionContext, true);
        return tabularResultSet;
    }

    private ResultSet buildDualResultSet(ExecutionContext executionContext, ExecutionOptions executionOptions, String libref, String tableNm, String jdbcStatement) throws ExecutionException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Executing an DualSubmitInstruction query");
        }
        ResultSet ret = null;
        List<ExportRule> returnList = this._dataSelection.getEffectiveRules(ExportRule.class);
        if (returnList.isEmpty()) {
            Connection sqlConnection = SASOperations.createConnection(executionContext, executionOptions);
            Statement statement = SASOperations.createStatement(executionContext, sqlConnection, executionOptions);
            ResultSet jdbcResultSet = SASOperations.createDualResultSet(executionContext, statement, libref, tableNm, jdbcStatement);
            CredentialResolver resolver = IQModelImplUtilities.getResolver(this._dataSelection);
            ret = SASOperations.addMLSResultSetExtension(resolver, executionContext, jdbcResultSet);
        } else {
            ret = new EmptyResultSet();
        }
        return ret;
    }
}

