/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionCancelQueryListener;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.SASLogReader;
import com.sas.iquery.execution.instructions.SASSubmitHandler;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ConnectionInstruction
extends AbstractExecutionInstruction {
    private LogicalServerInterface _logicalServer = null;
    private DataSelection _dataSelection = null;
    private static final Logger _logger = LogManager.getLogger(ConnectionInstruction.class);

    public ConnectionInstruction(DataSelection dataSelection, LogicalServerInterface logicalServer) {
        if (dataSelection == null || logicalServer == null) {
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.IllegalState.txt", new java.lang.Object[0]));
        }
        boolean invalidServer = false;
        try {
            invalidServer = logicalServer.getName() == null || logicalServer.getReposId() == null;
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.IllegalState.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new IQueryServicesIllegalStateException(msg, (Throwable)e);
        }
        if (invalidServer) {
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.IllegalState.txt", new java.lang.Object[0]));
        }
        this._dataSelection = dataSelection;
        this._logicalServer = logicalServer;
    }

    @Override
    public void execute() throws ExecutionException {
        boolean newConnection;
        ConnectionInterface connection = null;
        ExecutionContext context = this.getExecutionContext();
        IWorkspace iWorkspace = null;
        boolean isOLAP = false;
        SessionContextInterface sessionContext = this._dataSelection.getSession();
        ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
        connection = context.getConnection();
        boolean bl = newConnection = connection == null;
        if (newConnection) {
            RetrievalPolicy retrievalPolicy = context.getRetrievalPolicy();
            Locale effectiveComputationalLocale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, context);
            UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
            connection = ConnectionUtil.findConnection(recycler, this._dataSelection, this._logicalServer, userContext, retrievalPolicy, effectiveComputationalLocale);
            ConnectionUtil.LoggerDebugConnectionObtained(_logger, this, connection);
        }
        boolean newWorkspace = false;
        try {
            IMDXServer mdxServer;
            Object obj = connection.getObject();
            iWorkspace = context.getWorkspace();
            boolean bl2 = newWorkspace = iWorkspace == null;
            if (newWorkspace) {
                iWorkspace = IOMServerUtils.GetIWorkspace(obj);
            }
            isOLAP = (mdxServer = IOMServerUtils.GetIMDXServer(obj)) != null;
        }
        catch (SystemException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.Service.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            if (newConnection) {
                ConnectionResources.close(connection);
            }
            throw new ExecutionException(msg, (Throwable)e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("    tested mdxServer and isOLAP=" + isOLAP);
        }
        if (newConnection) {
            context.setConnection(connection);
        }
        if (newWorkspace) {
            context.setWorkspace(iWorkspace);
        }
        String newTemporaryTableName = recycler.getNewTemporaryTableName();
        context.setTemporaryTableName(newTemporaryTableName);
        ConnectionCancelQueryListener postConnectionListener = new ConnectionCancelQueryListener(this._dataSelection, isOLAP, connection);
        CancelQuerySupport.registerQueryListener(this._dataSelection, postConnectionListener, connection);
        if (!isOLAP) {
            boolean showVarsFromJdbc;
            SASLogReader.flushLogForError(context, null);
            SASSubmitHandler handler = new SASSubmitHandler();
            IWorkspace workspace = context.getWorkspace();
            ILanguageService languageService = IOMServerUtils.GetILanguageService(workspace);
            boolean currentAsyncState = languageService.Async();
            boolean showVarsFromProc = Boolean.getBoolean("SASQueryServices.logStartVarsFromProc");
            if (showVarsFromProc) {
                handler.logSessionVarsFromProc(currentAsyncState, context);
            }
            if (showVarsFromJdbc = Boolean.getBoolean("SASQueryServices.logStartVarsFromJDBC")) {
                IDataService dataService = workspace.DataService();
                handler.logSessionVarsFromJdbc(context, dataService);
            }
            boolean ignoreSetSyscc = Boolean.getBoolean("SASQueryServices.ignoreSysccOnStartup");
            handler.clearSessionVars(currentAsyncState, context, ignoreSetSyscc);
            String useSasLogPageWidth = System.getProperty("SASQueryServices.sasLogLineSize", null);
            String useSasLogPageSize = System.getProperty("SASQueryServices.sasLogPageSize", null);
            handler.setSASLogPageDimensions(currentAsyncState, context, useSasLogPageWidth, useSasLogPageSize);
            boolean useNOCODEGEN = Boolean.getBoolean("SASQueryServices.NOCODEGEN");
            if (useNOCODEGEN) {
                String text = "\n/* Turning off CODEGEN optimizer as per Java VM setting: -DSASQueryServices.NOCODEGEN=" + useNOCODEGEN + "  */\nOPTIONS NOCODEGEN;\n\n";
                handler.execute(currentAsyncState, context, text, true);
            }
        }
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        StringBuffer connectionDescription = new StringBuffer();
        connectionDescription.append("\n/* clear syscc before new query */\n%let syscc=0;\n%let sysrc=0;\n");
        return connectionDescription.toString();
    }
}

