/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution.instructions;

import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.SASSubmitHandler;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.util.impl.MessageFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSASSubmitInstruction
extends AbstractExecutionInstruction {
    protected boolean aSyncState = IQSystemProperties.isSasSubmitAsync();
    private static final Logger _logger = LogManager.getLogger(AbstractSASSubmitInstruction.class);

    @Override
    public void execute() throws ExecutionException {
        String statement = this.getLanguageInstruction();
        if (statement.length() > 0) {
            try {
                this.submitLanguageInstructions(statement);
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExecutionException(this.getGeneralFailureMsg(), (Throwable)e);
            }
        }
    }

    protected abstract String getLanguageInstruction();

    protected abstract MessageFormatter getGeneralFailureMsg();

    protected void writeOutStatment(String sasStatementString) {
    }

    protected void delay() {
    }

    protected boolean readSASOutput() {
        return false;
    }

    protected void submitLanguageInstructions(String sasStatementString) throws ExecutionException {
        ExecutionContext context = this.getExecutionContext();
        if (sasStatementString != null && sasStatementString.length() > 0) {
            _logger.debug(sasStatementString);
            this.writeOutStatment(sasStatementString);
            this.delay();
            SASSubmitHandler submitHandler = new SASSubmitHandler();
            submitHandler.execute(this.aSyncState, context, sasStatementString, this.readSASOutput());
            if (_logger.isDebugEnabled()) {
                _logger.debug(context.getSASLog());
            }
        }
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        return this.getLanguageInstruction();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof AbstractSASSubmitInstruction) {
            AbstractSASSubmitInstruction toCompare = (AbstractSASSubmitInstruction)obj;
            String thisStr = this.getLanguageInstruction();
            String objStr = toCompare.getLanguageInstruction();
            equals = thisStr == null ? objStr == null : thisStr.equals(objStr);
        }
        return equals;
    }

    public int hashCode() {
        return this.getLanguageInstruction().hashCode();
    }
}

