/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.EmptySet;
import com.sas.iom.SASMDX.ICubeSet;
import com.sas.iom.SASMDX.IMDXAdmin;
import com.sas.iom.SASMDX.IMDXAdmin_1_1;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iom.SASMDX.InvalidMask;
import com.sas.iom.SASMDX.NoSuchSession;
import com.sas.iom.SASMDX.ResultSetTypeSeqHolder;
import com.sas.iom.orb.UUIDConverter;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.SessionCloseThread;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.strategies.sas.oma.olap.util.CubeAssociatedISessionContainer;
import com.sas.iquery.strategies.sas.oma.olap.util.IQISession;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSetInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.ISessionCacheContainer;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.PreFilterDLLGeneration;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeRangeFilter;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.util.anno.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class OLAPConnectionResource
implements ConnectionInterface {
    private static final boolean[] _cubeFieldInclusion = new boolean[]{true, true, true, true, false, false, true, false, false, false, false, false, true, false, true, true};
    private static final Logger _logger = LogManager.getLogger(OLAPConnectionResource.class);
    private static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");
    private static final Logger _olapUtilLogger = LogManager.getLogger(OLAPConnectionInfoUtil.class);
    private ConnectionInterface _connection = null;
    private boolean _isClosed = false;
    private Locale _connectionLocale = null;
    private ISession _olapSchemaISession = null;
    private ConnectionInterface _olapSchemaConnection = null;
    private HashMap _cubeKeyedContainerCache = new HashMap();
    private HashMap<ISession, IQISession> _IQISessionContainerCache = new HashMap();
    private HashMap _metaIConnectionToSession = new HashMap();
    private HashMap _olapDataSetConnectionToSession = new HashMap();
    private ISession _defaultOpenSession = null;
    private HashMap _sessionKeyedContainerCache = new HashMap();
    private List _sessionsThatAreInactive = new ArrayList();
    private List _listToCacheToRemove = new ArrayList();
    private IdentityList _cubesWithIsessions = new IdentityList();
    private HashMap _listOfSessionID = new HashMap();
    private IMDXAdmin_1_1 _obMDXAdmin_1_1 = null;

    public OLAPConnectionResource(ConnectionInterface connection, Locale connectionLocale) throws GenerationException, ExecutionException {
        this.init(connection, connectionLocale);
    }

    public OLAPConnectionResource() {
    }

    public void init(ConnectionInterface connection, Locale connectionLocale) throws ExecutionException, GenerationException {
        this._connection = connection;
        if (connectionLocale == null) {
            connectionLocale = this.getDefaultConnectionLocale(null);
        } else {
            this.setDefaultConnectionLocale(connectionLocale);
        }
        this._defaultOpenSession = this.createSingleISession(null, connectionLocale);
        Object obj = this.getObject();
        IMDXAdmin mdxAdmin = IOMServerUtils.GetIMDXAdmin(obj);
        _logger.debug("Narrowing the IMDXAdmin object");
        if (mdxAdmin == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadIDMMDXADMObj.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        this._obMDXAdmin_1_1 = IOMServerUtils.GetIMDXAdmin_1_1(obj);
        if (this._obMDXAdmin_1_1 == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadIDMMDXADMObj.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        _logger.debug("Narrowing the IMDXAdmin_1_1 object to perform cancel.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCubeToCache(ISession session, String cubeName, String cacheSessionkey) {
        if (!this._cubeKeyedContainerCache.containsKey(cubeName)) {
            CubeAssociatedISessionContainer cubeContainer = new CubeAssociatedISessionContainer(session, cacheSessionkey);
            HashMap hashMap = this._cubeKeyedContainerCache;
            synchronized (hashMap) {
                this._cubeKeyedContainerCache.put(cubeName, cubeContainer);
            }
            this._cubesWithIsessions.add(cubeName);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Add to value to cube cache: " + cubeName + cacheSessionkey);
            }
        } else {
            CubeAssociatedISessionContainer container = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeName);
            container.setISessionActive(session, cacheSessionkey);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Update value in cube cache: " + cubeName + cacheSessionkey);
            }
        }
    }

    public void setOLAPSchemaISession(ISession isession) {
        if (this._olapSchemaISession != null) {
            throw new IllegalStateException("OLAP Schema ISession already set on OLAP Connection Resource: " + this);
        }
        this._olapSchemaISession = isession;
    }

    public void setOLAPSchemaISession(ISession isession, ConnectionInterface connection) {
        if (this._olapSchemaConnection != null) {
            throw new IllegalStateException("OLAP Schema Connection already set on OLAP Connection Resource: " + this);
        }
        this.setOLAPSchemaISession(isession);
        this._olapSchemaConnection = connection;
    }

    private UUIDSeqHolder getOpenResultSetsForISession(ISession session) {
        StringSeqHolder queryStmt;
        UUIDSeqHolder queryID;
        block4: {
            queryID = new UUIDSeqHolder();
            ISession_1_1 isession2 = IOMServerUtils.GetISession_1_1((Object)session);
            queryStmt = new StringSeqHolder();
            ResultSetTypeSeqHolder type1 = new ResultSetTypeSeqHolder();
            StringSeqHolder lastUpdateTime = new StringSeqHolder();
            LongSeqHolder size1 = new LongSeqHolder();
            LongSeqHolder totalCells = new LongSeqHolder();
            LongSeqHolder readCells = new LongSeqHolder();
            try {
                isession2.ListQueries_2(queryID, queryStmt, type1, lastUpdateTime, size1, totalCells, readCells);
                if (_olapUtilLogger.isDebugEnabled()) {
                    _olapUtilLogger.debug(queryStmt.toString());
                }
            }
            catch (GenericError e) {
                if (!_logger.isEnabled(Level.ERROR)) break block4;
                String msgArgs2 = queryStmt.value[0] + " the result set for this query can not get a value from the ISesssion_1_1 IOM call.";
                _logger.error(msgArgs2);
            }
        }
        if (queryID.value.length > 0 && _logger.isDebugEnabled()) {
            _logger.debug("Any open results using this query statment:" + queryStmt.value[0]);
        }
        return queryID;
    }

    private UUIDSeqHolder getOpenResultSetsForISession(UUID sessionID, ISession session) {
        _logger.debug("Narrowing the IMDXAdmin_1_1 object.");
        UUIDSeqHolder queryID = new UUIDSeqHolder();
        StringSeqHolder queryStmt = new StringSeqHolder();
        ResultSetTypeSeqHolder type1 = new ResultSetTypeSeqHolder();
        StringSeqHolder lastUpdateTime = new StringSeqHolder();
        LongSeqHolder size1 = new LongSeqHolder();
        LongSeqHolder totalCells = new LongSeqHolder();
        LongSeqHolder readCells = new LongSeqHolder();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Getting MDX Query for this MDXAdmin and session." + sessionID);
            }
            this._obMDXAdmin_1_1.ListMDXQueries(sessionID, queryID, queryStmt, type1, lastUpdateTime, size1, totalCells, readCells);
            if (queryStmt != null && _logger.isDebugEnabled()) {
                _logger.debug("Number of queries that are open: " + queryStmt.value.length);
            }
        }
        catch (Exception e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(e.getLocalizedMessage(), (Throwable)e);
            }
            queryID = this.getOpenResultSetsForISession(session);
        }
        return queryID;
    }

    public void cancelAllRunningQueries() throws ExecutionException {
        String query = "";
        long start = 0L;
        if (this._connection != null && !this._isClosed) {
            if (_perfCLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogConnectionPerformance("> Canceling a set of queries: " + this.getClass().getCanonicalName());
                start = System.currentTimeMillis();
            }
            List<ISession> sessionList = this.getIsessionList();
            Iterator<ISession> keysForQueries = sessionList.iterator();
            UUIDSeqHolder listOfResultSetOpen = null;
            while (keysForQueries.hasNext()) {
                ISession session = keysForQueries.next();
                UUID sessionID = (UUID)this._listOfSessionID.get(session);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("SessionId that is about to be canceled. " + sessionID);
                }
                if (sessionID == null && _logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadISession.txt"));
                }
                if (!session._non_existent()) {
                    ISession_1_1 isession2 = IOMServerUtils.GetISession_1_1((Object)session);
                    listOfResultSetOpen = this.getOpenResultSetsForISession(sessionID, session);
                    if (listOfResultSetOpen == null) continue;
                    if (listOfResultSetOpen.value.length == 0) {
                        _logger.debug("No queries are running for this Isession:");
                    }
                    for (int a = 0; a < listOfResultSetOpen.value.length; ++a) {
                        UUID ui = listOfResultSetOpen.value[a];
                        this.closeResultSet(isession2, sessionID, ui, query);
                    }
                    continue;
                }
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.noSessionToClearOut.txt"));
            }
        } else {
            _logger.debug("The base connection has already been closed and released.");
        }
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
    }

    private void closeResultSet(ISession_1_1 isession2, UUID sessionID, UUID ui, String query) {
        boolean retry = true;
        try {
            this._obMDXAdmin_1_1.CancelMDXResultSet(sessionID, ui);
            MDXGenerationUtil.applyDebugStatement("Canceling this MDX query for this session: " + sessionID.toString(), this.getClass());
            retry = false;
        }
        catch (NoSuchSession e) {
            _logger.warn("Error cancelling query: " + query + " : session uuid=" + UUIDConverter.uuidToString((UUID)sessionID) + " : result set uuid=" + UUIDConverter.uuidToString((UUID)ui), (Throwable)e);
            retry = false;
        }
        catch (GenericError e) {
            _logger.warn("Error cancelling query: " + query + " : session uuid=" + UUIDConverter.uuidToString((UUID)sessionID) + " : result set uuid=" + UUIDConverter.uuidToString((UUID)ui), (Throwable)e);
        }
        catch (NO_PERMISSION e) {
            _logger.warn("Error cancelling query: " + query + " : session uuid=" + UUIDConverter.uuidToString((UUID)sessionID) + " : result set uuid=" + UUIDConverter.uuidToString((UUID)ui), (Throwable)e);
        }
        if (retry) {
            UUID[] listOfOpenResultSets = this.getOpenResultSetsForISession((ISession)isession2).value;
            for (int i = 0; i < listOfOpenResultSets.length; ++i) {
                UUID resultSetOpen = listOfOpenResultSets[i];
                try {
                    isession2.CloseResultSet(resultSetOpen);
                    continue;
                }
                catch (GenericError e) {
                    _logger.warn("Error closing result set with uuid = " + UUIDConverter.uuidToString((UUID)resultSetOpen), (Throwable)e);
                    String message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceOldISessionClose.txt");
                    _logger.warn(message, (Throwable)e);
                }
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.warn("Query Canceled: " + query + " : session uuid=" + UUIDConverter.uuidToString((UUID)sessionID) + " : result set uuid=" + UUIDConverter.uuidToString((UUID)ui));
        }
    }

    public void closeAllReleasedUnusedISessions() throws ExecutionException {
        for (ISession session : this.getIsessionList()) {
            if (session != null && !session._non_existent() && !session.equals(this._defaultOpenSession)) {
                block4: {
                    try {
                        Metadata.clearCache((java.lang.Object)session, (int)2);
                    }
                    catch (OLAPException e) {
                        if (!_logger.isDebugEnabled()) break block4;
                        _logger.debug(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                session._release();
                _logger.debug("ISession is being released. ");
                this.closeISessionSafely(session);
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.noSessionToClearOut.txt"));
        }
        this.closeOutISessionResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addISessionToCache(String key, ISessionCacheContainer value) {
        if (!this._sessionKeyedContainerCache.containsKey(key)) {
            HashMap hashMap = this._sessionKeyedContainerCache;
            synchronized (hashMap) {
                this._sessionKeyedContainerCache.put(key, value);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Add to value to Isession cache: " + key);
            }
        } else {
            this._sessionKeyedContainerCache.remove(key);
            this._sessionKeyedContainerCache.put(key, value);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Update value in Isession cache: " + key);
            }
        }
    }

    public void applyFilterStateOnCube(BusinessModel model, String key, OLAPDataSetInterface dataSet, OLAPValues olapValues) throws ExecutionException, GenerationException {
        if (olapValues == null) {
            List<DataItem> resultItems = model.getObjects(65535, DataItem.class);
            try {
                MetadataInterface metaI = ConnectionResources.newOLAPMetadataInterface(this._defaultOpenSession);
                if (model instanceof DataSelection) {
                    olapValues = new OLAPValues(metaI, resultItems, (DataSelection)model);
                }
            }
            catch (OLAPException e) {
                throw new ExecutionException(e, e.getLocalizedMessage() + " " + key);
            }
        }
        this.applyFilterStateOnCube(model, key, olapValues);
    }

    public void applyFilterStateOnCube(BusinessModel model, String key, MetadataInterface metaI, OLAPValues olapValues) throws ExecutionException, GenerationException {
        if (olapValues == null) {
            List<DataItem> resultItems = model.getObjects(65535, DataItem.class);
            if (model instanceof DataSelection) {
                olapValues = new OLAPValues(metaI, resultItems, (DataSelection)model);
            }
        }
        this.applyFilterStateOnCube(model, key, olapValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyFilterStateOnCube(BusinessModel model, String key, OLAPValues olapValues) throws ExecutionException, GenerationException {
        CubeAssociatedISessionContainer containerCube;
        if (olapValues == null) {
            throw new IllegalArgumentException();
        }
        String cubeName = OLAPConnectionInfoUtil.getCubeName(model);
        ISessionCacheContainer container = (ISessionCacheContainer)this._sessionKeyedContainerCache.get(key);
        if (container == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{key, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilNullPrefilter.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new ExecutionException(msF);
        }
        PreFilterDLLGeneration preFilterDLL = container.getPreFilterContainer();
        if (preFilterDLL == null) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, key, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilNullPrefilter.txt"));
            throw new ExecutionException(msF);
        }
        if (olapValues != null) {
            preFilterDLL.setOLAPValues(olapValues);
        }
        if (preFilterDLL.getOLAPValues() == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{key, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilNoOLAPValues.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new ExecutionException(msF);
        }
        ISession isession = this.getBusinessModelISession(key);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Apply pre-filtered state: " + preFilterDLL.getPreFilterClause());
        }
        if ((containerCube = this.getCubeContainerFromCache(cubeName)) == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{cubeName, key, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilNullPrefilter.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new ExecutionException(msF);
        }
        if (this.getListOfParentFilterStringValue(model).size() > 0) {
            containerCube.setISessionFilter(isession);
        }
        preFilterDLL.applyFilter(isession, model);
        container.setReapply(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession clearOutContentsOfSingleISession(ISession session, Cube cube, Schema schema, boolean keepOpenResultSetsOnISession, BusinessModel businessModel) throws ExecutionException {
        ISession newSession = null;
        try {
            UUID sessionID;
            if (keepOpenResultSetsOnISession) {
                if (this.isISessionBeingUsed(session)) {
                    String message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceUnUsualClearFilterCase.txt");
                    java.lang.Object[] msgArgs2 = new java.lang.Object[]{schema, cube.getCubeName(), message};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    _logger.debug("Ignoring this session because it is in use; creating a new one. ");
                    _logger.debug(msF.toString());
                    newSession = this.createSingleISession(businessModel, this._connectionLocale);
                    return newSession;
                }
            } else {
                sessionID = session.UniqueIdentifier();
                UUIDSeqHolder listOfResultSetOpen = this.getOpenResultSetsForISession(sessionID, session);
                for (int i = 0; i < listOfResultSetOpen.value.length; ++i) {
                    UUID resultSetOpen = listOfResultSetOpen.value[i];
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error("Closing resultSet that is left open when it should not be.. " + cube.getIdentityString());
                    }
                    try {
                        this._obMDXAdmin_1_1.CancelMDXResultSet(sessionID, resultSetOpen);
                        continue;
                    }
                    catch (NoSuchSession e) {
                        throw new ExecutionException(e);
                    }
                }
            }
            sessionID = session;
            synchronized (sessionID) {
                ICubeSet cubeSet = session.CubeMetadata("", schema.getLabel(), cube.getCubeName(), _cubeFieldInclusion);
                cubeSet.Close();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Closing rowset: " + cubeSet.toString());
                }
            }
        }
        catch (MetadataException e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyOLAPGServer.txt", new java.lang.Object[0]), (Throwable)e);
        }
        catch (GenericError e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyOLAPGServer.txt", new java.lang.Object[0]), (Throwable)e);
        }
        catch (InvalidMask e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyOLAPIMServer.txt", new java.lang.Object[0]), (Throwable)e);
        }
        catch (EmptySet e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyOLAPEServer.txt", new java.lang.Object[0]), (Throwable)e);
        }
        return newSession;
    }

    private void clearOutFilterStateOnCube(BusinessModel businessModel, PreFilterDLLGeneration prefilter, ISession session, boolean keepOpenResultSetsOnISession, String constructor, Cube cube, Schema schema) throws GenerationException, ExecutionException {
        String cubeName = null;
        try {
            cubeName = cube.getCubeName();
        }
        catch (MetadataException e1) {
            throw new GenerationException(e1, e1.getLocalizedMessage());
        }
        String schemaName = schema.getLabel();
        MDXGenerationUtil.applyDebugStatement("Clear out a filtered state on a cube. " + cubeName, this.getClass());
        if (cubeName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.noCubeToClearOut.txt"));
            }
            return;
        }
        if (session == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.noSessionToClearOut.txt"));
            }
            return;
        }
        if (schemaName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.noSchemaToClearOut.txt"));
            }
            return;
        }
        Semaphore semi = new Semaphore(1);
        try {
            semi.acquire();
        }
        catch (InterruptedException e) {
            _logger.error("Semaphone interruption: " + e.getLocalizedMessage());
        }
        ISession newSession = this.clearOutContentsOfSingleISession(session, cube, schema, keepOpenResultSetsOnISession, businessModel);
        if (newSession != null) {
            MDXGenerationUtil.applyDebugStatement("We are throwing away a open but in transit ISession.", this.getClass());
            session = newSession;
        }
        semi.release();
        CubeAssociatedISessionContainer containerCube = this.getCubeContainerFromCache(cubeName);
        Locale connectionLocale = this.getConnectionLocale(businessModel);
        if (this._sessionsThatAreInactive.contains(session)) {
            MDXGenerationUtil.applyDebugStatement("Remove ISession from inactive list and use it.", this.getClass());
            this._sessionsThatAreInactive.remove(session);
            String key = MDXGenerationUtil.buildCacheKey(businessModel, connectionLocale, constructor);
            containerCube.setISessionActive(session, key);
        }
        if (prefilter != null && containerCube.isCubeSessionFiltered(session)) {
            MDXGenerationUtil.applyDebugStatement("Used ISession now no longer has any filter applied.", this.getClass());
            prefilter.removeFilter(session);
            containerCube.setISessionUnFilter(session);
        } else {
            _logger.debug("No filter was applied for this ISession, we will continue.  ISession is resolved when the ISession is closed.");
        }
    }

    public void close() {
        ISession defaultOpenSession = this._defaultOpenSession;
        ISession olapSchemaISession = this._olapSchemaISession;
        ConnectionInterface olapSchemaConnection = this._olapSchemaConnection;
        ConnectionInterface connection = this._connection;
        boolean isClosed = this._isClosed;
        this._defaultOpenSession = null;
        this._olapSchemaISession = null;
        this._olapSchemaConnection = null;
        this._isClosed = true;
        this._connection = null;
        this.close(defaultOpenSession, olapSchemaISession, olapSchemaConnection, connection, isClosed);
    }

    private void closeISessionSafely(ISession session) {
        if (session != null) {
            String name = "";
            try {
                name = String.valueOf(session);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String threadName = "ClosingISession(" + name + ")";
            SessionCloseThread myRunnable = new SessionCloseThread(session);
            Thread t = new Thread((Runnable)myRunnable, threadName);
            t.start();
        }
    }

    public void cancelQueryThreads() throws IQueryServicesException {
        for (ISession session : this.getIsessionList()) {
            if (!session._non_existent() && session != null && !session.equals(this._defaultOpenSession)) {
                try {
                    Metadata.clearCache((java.lang.Object)session, (int)2);
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage());
                }
                MDXGenerationUtil.applyDebugStatement("ISession is being released. ", this.getClass());
                this.closeISessionSafely(session);
                continue;
            }
            _logger.debug("No Isession to close out");
        }
        try {
            Metadata.clearCache((java.lang.Object)this._defaultOpenSession, (int)2);
        }
        catch (OLAPException e) {
            _logger.error(e.getLocalizedMessage());
        }
        _logger.debug("Closing down the _default Open Session");
        this.closeISessionSafely(this._defaultOpenSession);
        this.closeOutISessionResource();
    }

    private void close(ISession defaultOpenSession, ISession olapSchemaISession, ConnectionInterface olapSchemaConnection, ConnectionInterface connection, boolean isClosed) {
        String message;
        if (defaultOpenSession != null && !defaultOpenSession._non_existent()) {
            try {
                Metadata.clearCache((java.lang.Object)defaultOpenSession, (int)2);
            }
            catch (OLAPException e) {
                message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.cachedISessionClose.txt");
                _logger.warn(message, (Throwable)e);
            }
            _logger.debug("close the last default Isession");
            this.closeISessionSafely(this._defaultOpenSession);
        }
        if (olapSchemaISession != null && !olapSchemaISession._non_existent()) {
            try {
                Metadata.clearCache((java.lang.Object)olapSchemaISession, (int)2);
            }
            catch (OLAPException e) {
                message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.cachedISessionClose.txt");
                _logger.warn(message, (Throwable)e);
            }
            _logger.debug("close the Isession left opened for the olapSchema connection. ");
            try {
                olapSchemaISession.Close();
            }
            catch (GenericError e) {
                message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.cachedISessionClose.txt");
                _logger.warn(message, (Throwable)e);
            }
        }
        if (olapSchemaConnection != null) {
            _logger.debug("close the Connection left opened for the olapSchema connection. ");
            ConnectionResources.close(olapSchemaConnection);
        }
        _logger.debug("Closed this OLAPConnectionResource and all its resources");
        if (connection != null && !isClosed) {
            ConnectionResources.close(connection);
        }
    }

    private ISession closePreviousParentFilterDefinition(String key, BusinessModel businessModel, ISession session, ISessionCacheContainer container, CubeAssociatedISessionContainer cubeContainer, String constructor, Cube cube, Schema schema, List currentFilterDefinition) throws ExecutionException, MetadataException, GenerationException {
        PreFilterDLLGeneration prefilter = this.getFullParentFilterObjectForBusinessModel(businessModel, key);
        List activeIsessions = cubeContainer.getActiveISessions();
        Locale connectionLocale = this.getDefaultConnectionLocale(businessModel);
        if (!activeIsessions.contains(session) && !this._sessionsThatAreInactive.contains(session)) {
            session = this.createSingleISession(businessModel, connectionLocale);
            this.storeInformationInCache(currentFilterDefinition, key, businessModel, session, cube, prefilter);
            return session;
        }
        if ((!activeIsessions.contains(session) || this._sessionsThatAreInactive.contains(session)) && !activeIsessions.contains(session) && this._sessionsThatAreInactive.contains(session)) {
            this._sessionsThatAreInactive.remove(session);
            cubeContainer.setISessionActive(session, key);
        }
        if (this.isISessionBeingUsed(session)) {
            session = this.createSingleISession(businessModel, connectionLocale);
            this.storeInformationInCache(currentFilterDefinition, key, businessModel, session, cube, prefilter);
        } else {
            this.clearOutFilterStateOnCube(businessModel, prefilter, session, true, constructor, cube, schema);
            this.removeCacheEntries(key);
        }
        return session;
    }

    private void setDefaultConnectionLocale(Locale connectionLocale) {
        this._connectionLocale = connectionLocale;
    }

    private Locale getDefaultConnectionLocale(BusinessModel businessModel) {
        Locale connectionLocale = this._connectionLocale;
        if (connectionLocale == null) {
            if (_logger.isDebugEnabled()) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.fetchPFSConnection.NoLocale.txt", new java.lang.Object[0]);
                _logger.debug(msg.toString());
            }
            connectionLocale = this.findDefaultConnectionLocale(businessModel);
            this.setDefaultConnectionLocale(connectionLocale);
        }
        return connectionLocale;
    }

    private Locale findDefaultConnectionLocale(BusinessModel businessModel) {
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
        return connectionLocale;
    }

    public List<ISession> getIsessionList() {
        ArrayList<ISession> returnList = new ArrayList<ISession>();
        Set listOfCubes = this._cubeKeyedContainerCache.keySet();
        if (listOfCubes.size() == 0) {
            if (this._IQISessionContainerCache.containsKey(this._defaultOpenSession)) {
                returnList.add(this._defaultOpenSession);
            }
        } else {
            Iterator iterator = listOfCubes.iterator();
            IdentityList listOfSessions = new IdentityList();
            while (iterator.hasNext()) {
                String cubeName = iterator.next().toString();
                CubeAssociatedISessionContainer cubeCache = this.getCubeContainerFromCache(cubeName);
                listOfSessions.addAll(cubeCache.getActiveISessions());
            }
            for (ISession isessionObject : listOfSessions.toList()) {
                if (!this._IQISessionContainerCache.containsKey(isessionObject)) continue;
                IQISession iqISession = this._IQISessionContainerCache.get(isessionObject);
                returnList.add(iqISession.getISession());
            }
        }
        return returnList;
    }

    private void closeOutISessionResource() {
        Set listOfCubes = this._cubeKeyedContainerCache.keySet();
        if (listOfCubes.size() == 0) {
            if (this._IQISessionContainerCache.containsKey(this._defaultOpenSession)) {
                IQISession iqISession = this._IQISessionContainerCache.get(this._defaultOpenSession);
                _logger.debug("IQISession is being released and removed from keyed list. ");
                this._IQISessionContainerCache.remove(this._defaultOpenSession);
                iqISession.releaseISessionResources();
            }
        } else {
            Iterator iterator = listOfCubes.iterator();
            IdentityList listOfSessions = new IdentityList();
            while (iterator.hasNext()) {
                String cubeName = iterator.next().toString();
                CubeAssociatedISessionContainer cubeCache = this.getCubeContainerFromCache(cubeName);
                listOfSessions.addAll(cubeCache.getActiveISessions());
            }
            for (ISession isessionObject : listOfSessions.toList()) {
                if (!this._IQISessionContainerCache.containsKey(isessionObject)) continue;
                _logger.debug("IQISession is being released and removed from keyed list. ");
                IQISession iqISession = this._IQISessionContainerCache.get(isessionObject);
                this._IQISessionContainerCache.remove(isessionObject);
                iqISession.releaseISessionResources();
            }
        }
        this._listOfSessionID.clear();
        for (java.lang.Object obj : this._cubesWithIsessions.toList()) {
            this._cubesWithIsessions.remove(obj);
        }
        this._cubeKeyedContainerCache.clear();
        this._IQISessionContainerCache.clear();
        this._listToCacheToRemove.clear();
        this._metaIConnectionToSession.clear();
        this._olapDataSetConnectionToSession.clear();
        this._sessionKeyedContainerCache.clear();
        this._sessionsThatAreInactive.clear();
        _logger.debug("Clear out all objects that are in any lists that are stored in this connection object. ");
    }

    public void closeUnusedConnectionObjects(String cubeName) throws ExecutionException {
        CubeAssociatedISessionContainer cubeContainer;
        ArrayList<String> cubesToDelete = new ArrayList<String>();
        _logger.debug("Close down unused connection objects");
        for (String cubeToCheck : this._cubesWithIsessions.toList()) {
            CubeAssociatedISessionContainer cubeContainer2 = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeToCheck);
            IdentityList otherPossibleInactiveISession = new IdentityList();
            List activeISessions = cubeContainer2.getActiveISessions();
            otherPossibleInactiveISession.addAll(activeISessions);
            for (ISession isessiontoClose : otherPossibleInactiveISession.toList()) {
                boolean isUsed;
                if (isessiontoClose == null || (isUsed = this.isISessionBeingUsed(isessiontoClose)) || isessiontoClose.equals(this._defaultOpenSession)) continue;
                String keyOld = null;
                List keyOldCache = cubeContainer2.getKeyCache(isessiontoClose);
                if (keyOldCache == null) continue;
                Iterator it = keyOldCache.iterator();
                int ct = 0;
                while (it.hasNext()) {
                    keyOld = cubeContainer2.getSpecifiKeyCache(isessiontoClose, ct);
                    ISessionCacheContainer containerOld = this.getISessionContainerFromCache(keyOld);
                    if (containerOld != null) {
                        if (cubeContainer2.isCubeSessionFiltered(isessiontoClose)) {
                            cubeContainer2.removeKeyCache(isessiontoClose, keyOld);
                        }
                        this.removeCacheEntries(keyOld);
                    } else {
                        this.removeCacheEntries(keyOld);
                        if (keyOld == null) break;
                        ++ct;
                    }
                    if (ct < keyOldCache.size()) continue;
                    break;
                }
                if (this._sessionsThatAreInactive.contains(isessiontoClose) || isessiontoClose.equals(this._defaultOpenSession)) continue;
                this._sessionsThatAreInactive.add(isessiontoClose);
                cubeContainer2.setISessionUnFilter(isessiontoClose);
            }
        }
        for (ISession isessiontoClose : this._sessionsThatAreInactive) {
            if (this.isISessionBeingUsed(isessiontoClose) || isessiontoClose.equals(this._defaultOpenSession)) continue;
            this._listOfSessionID.remove(isessiontoClose);
            for (String cubeNameFromCubeList : this._cubesWithIsessions.toList()) {
                cubeContainer = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeNameFromCubeList);
                if (cubeContainer == null) continue;
                cubeContainer.removeActiveISession(isessiontoClose);
                if (cubeContainer.getActiveISessions().size() != 0) continue;
                cubesToDelete.add(cubeNameFromCubeList);
            }
            if (this._IQISessionContainerCache.containsKey(isessiontoClose)) {
                _logger.debug("Finding a single isession that is no longer used.  ");
                IQISession iqISession = this._IQISessionContainerCache.get(isessiontoClose);
                this._IQISessionContainerCache.remove(isessiontoClose);
                this.reportOpenConnectionInAISessionDebugMode(iqISession);
                if (iqISession != null) {
                    iqISession.releaseISessionResources();
                    iqISession = null;
                }
            }
            if (isessiontoClose != null && !isessiontoClose._non_existent()) {
                this.closeISessionSafely(isessiontoClose);
                _logger.debug("Close down a single isession that is no longer used.  ");
            }
            isessiontoClose = null;
            _logger.debug("****Closing unused ISession");
        }
        boolean sessionBeingUsed = this.isISessionBeingUsed(this._defaultOpenSession);
        if (!sessionBeingUsed && this._cubesWithIsessions.size() > 0) {
            for (String cubeNameFromCubeList : this._cubesWithIsessions.toList()) {
                String keyOld;
                ISessionCacheContainer containerOld;
                if (cubeNameFromCubeList.equalsIgnoreCase(cubeName) || (cubeContainer = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeNameFromCubeList)) == null || (containerOld = this.getISessionContainerFromCache(keyOld = cubeContainer.getFirstKeyCache(this._defaultOpenSession))) == null || cubeContainer.isCubeSessionFiltered(this._defaultOpenSession)) continue;
                cubeContainer.removeActiveISession(this._defaultOpenSession);
                _logger.debug("****Closing unused ISession");
                if (cubeContainer.getActiveISessions().size() == 0) {
                    cubesToDelete.add(cubeNameFromCubeList);
                }
                if (!this._IQISessionContainerCache.containsKey(this._defaultOpenSession)) continue;
                _logger.debug("Finding a single isession that is no longer used and release stale resources.  ");
                IQISession iqISession = this._IQISessionContainerCache.get(this._defaultOpenSession);
                if (iqISession == null) continue;
                iqISession.releaseISessionResources();
            }
        }
        this._sessionsThatAreInactive.clear();
        Iterator iter6 = cubesToDelete.iterator();
        while (iter6.hasNext()) {
            _logger.debug("Getting rid of any key cache list that may be associated to a closed down ISession.  ");
            String cubeDeleting = (String)iter6.next();
            _logger.debug("Removing " + cubeDeleting);
            this._cubeKeyedContainerCache.remove(cubeDeleting);
            this._cubesWithIsessions.remove(cubeDeleting);
        }
        cubesToDelete = null;
    }

    private ISession resetStaleIsession(CubeAssociatedISessionContainer cubeContainer, ISession isessionIn, BusinessModel businessModel) {
        java.lang.Object isessionObject;
        block2: {
            cubeContainer.setISessionUnFilter(isessionIn);
            this._listToCacheToRemove.add(isessionIn);
            isessionObject = isessionIn;
            Locale connectionLocale = this.getDefaultConnectionLocale(businessModel);
            _logger.debug("This session is defined as filter but there is no prefilter applied. Close it out and get rid of it.");
            try {
                isessionObject.Close();
                isessionObject = isessionObject.equals(this._defaultOpenSession) ? this.createSingleISession(businessModel, connectionLocale) : null;
            }
            catch (Exception e) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return isessionObject;
    }

    public ISession createCachedISession(BusinessModel businessModel, String key, String constructor, Locale connectionLocale, Cube cube) throws GenerationException, ExecutionException {
        ISession isessionToUse = this._defaultOpenSession;
        if (constructor.equalsIgnoreCase("IGNOREISESSION")) {
            return isessionToUse;
        }
        boolean shouldApplyFilter = false;
        PreFilterDLLGeneration prefilter = null;
        try {
            String cubeName = cube.getCubeName();
            OlapSchema schema = cube.getOwningOlapSchema();
            CubeAssociatedISessionContainer cubeContainer = this.getCubeContainerFromCache(cubeName);
            if (_logger.isDebugEnabled()) {
                _logger.debug(">>>>>>>>>>>>>>> Begin create cacheISession: ");
                if (cubeContainer != null) {
                    _logger.debug(this.reportISessionInDebugMode(cubeContainer));
                    _logger.debug(cubeContainer.reportISessionCaches(cubeName));
                }
            }
            List<java.lang.Object> previousFilterDefinition = new ArrayList();
            ISessionCacheContainer container = null;
            List<java.lang.Object> currentFilterDefinition = this.getListOfParentFilterStringValue(businessModel);
            if (cubeContainer != null) {
                List listOfISessionsToCheck = cubeContainer.getActiveISessions();
                Iterator iterator = listOfISessionsToCheck.iterator();
                boolean ignoreFilterSession = false;
                while (iterator.hasNext()) {
                    ISession isessionObject = (ISession)iterator.next();
                    if (this.isISessionBeingUsed(isessionObject)) continue;
                    String keyOld = null;
                    List keyOldCache = cubeContainer.getKeyCache(isessionObject);
                    if (keyOldCache != null) {
                        Iterator it = keyOldCache.iterator();
                        int ct = 0;
                        while (it.hasNext()) {
                            keyOld = cubeContainer.getSpecifiKeyCache(isessionObject, ct);
                            ISessionCacheContainer containerOld = this.getISessionContainerFromCache(keyOld);
                            if (containerOld != null) {
                                PreFilterDLLGeneration prefilterOld;
                                if (cubeContainer.isCubeSessionFiltered(isessionObject)) {
                                    prefilterOld = containerOld.getPreFilterContainer();
                                    if (prefilterOld.getPreFilterClause().length() > 0) {
                                        this.clearOutFilterStateOnCube(businessModel, prefilterOld, isessionObject, true, constructor, cube, schema);
                                    }
                                    cubeContainer.removeKeyCache(isessionObject, keyOld);
                                } else {
                                    prefilterOld = containerOld.getPreFilterContainer();
                                    if (prefilterOld.getPreFilterClause().length() > 0) {
                                        this.clearOutFilterStateOnCube(businessModel, prefilterOld, isessionObject, true, constructor, cube, schema);
                                    }
                                }
                                this.removeCacheEntries(keyOld);
                            } else {
                                this.removeCacheEntries(keyOld);
                                if (keyOld == null) break;
                                ++ct;
                            }
                            if (ct < keyOldCache.size()) continue;
                            break;
                        }
                    } else if (cubeContainer.isCubeSessionFiltered(isessionObject)) {
                        ISession isessionObjectout = this.resetStaleIsession(cubeContainer, isessionObject, businessModel);
                        if (isessionObjectout != null) {
                            this._defaultOpenSession = isessionObjectout;
                            isessionToUse = isessionObjectout;
                        }
                        ignoreFilterSession = true;
                    }
                    if (ignoreFilterSession) continue;
                    if (this.isISessionBeingUsed(isessionToUse)) {
                        this._defaultOpenSession = isessionToUse = isessionObject;
                        cubeContainer.setISessionUnFilter(this._defaultOpenSession);
                        if (!this._sessionsThatAreInactive.contains(this._defaultOpenSession)) continue;
                        this._sessionsThatAreInactive.remove(this._defaultOpenSession);
                        continue;
                    }
                    if (this._sessionsThatAreInactive.contains(isessionObject) || isessionObject.equals(this._defaultOpenSession)) continue;
                    this._sessionsThatAreInactive.add(isessionObject);
                    cubeContainer.setISessionUnFilter(isessionObject);
                }
            }
            Iterator int2 = this._listToCacheToRemove.iterator();
            while (int2.hasNext()) {
                cubeContainer.removeActiveISession((ISession)int2.next());
            }
            this._listToCacheToRemove.clear();
            container = this.getISessionContainerFromCache(key);
            if (container != null && container.isPreviouslyFilter()) {
                previousFilterDefinition = container.getDDLDefinition();
            }
            boolean sessionIsFiltered = false;
            if (cubeContainer != null) {
                sessionIsFiltered = cubeContainer.isCubeSessionFiltered(isessionToUse);
            }
            if (businessModel instanceof InformationMap) {
                if (sessionIsFiltered) {
                    isessionToUse = this.setNewParentFilterDefinition(key, isessionToUse, businessModel, cube, schema, currentFilterDefinition, constructor, cubeContainer, connectionLocale);
                }
            } else if (businessModel instanceof LookThroughDataSelection) {
                if (!this._sessionKeyedContainerCache.containsKey(key)) {
                    if (currentFilterDefinition.size() > 0 || sessionIsFiltered) {
                        shouldApplyFilter = true;
                        isessionToUse = this.setNewParentFilterDefinition(key, isessionToUse, businessModel, cube, schema, currentFilterDefinition, constructor, cubeContainer, connectionLocale);
                    }
                } else {
                    ISession isessionObject;
                    this._defaultOpenSession = isessionToUse = (isessionObject = container.getISession());
                    boolean isDifferent = MDXGenerationUtil.areListsDifferent(currentFilterDefinition, previousFilterDefinition);
                    if (isDifferent) {
                        if (this.isISessionBeingUsed(isessionToUse)) {
                            this.clearOutFilterStateOnCube(businessModel, container.getPreFilterContainer(), isessionToUse, false, constructor, cube, schema);
                        }
                        shouldApplyFilter = true;
                        container.setDDLDefinition(currentFilterDefinition);
                    }
                }
            } else if (constructor.equalsIgnoreCase("GENERATION")) {
                if (!this._sessionKeyedContainerCache.containsKey(key)) {
                    if (currentFilterDefinition.size() > 0 || sessionIsFiltered) {
                        shouldApplyFilter = true;
                        isessionToUse = this.setNewParentFilterDefinition(key, isessionToUse, businessModel, cube, schema, currentFilterDefinition, constructor, cubeContainer, connectionLocale);
                    }
                } else {
                    ISession isessionObject = container.getISession();
                    if (isessionObject == null) {
                        _logger.debug("isession for this container object was null. use default.");
                        isessionObject = this._defaultOpenSession;
                    }
                    isessionToUse = isessionObject;
                    boolean isDifferent = MDXGenerationUtil.areListsDifferent(currentFilterDefinition, previousFilterDefinition);
                    if (isDifferent) {
                        if (this.isISessionBeingUsed(isessionToUse)) {
                            this.clearOutFilterStateOnCube(businessModel, container.getPreFilterContainer(), isessionToUse, false, constructor, cube, schema);
                        }
                        container.setDDLDefinition(currentFilterDefinition);
                        shouldApplyFilter = true;
                    } else if (!cubeContainer.isCubeSessionFiltered(isessionObject) && currentFilterDefinition.size() > 0) {
                        shouldApplyFilter = true;
                        isessionToUse = this.setNewParentFilterDefinition(key, isessionObject, businessModel, cube, schema, currentFilterDefinition, constructor, cubeContainer, connectionLocale);
                    }
                }
            } else if (businessModel instanceof DataSelection) {
                shouldApplyFilter = false;
                if (currentFilterDefinition.size() == 0) {
                    if (previousFilterDefinition.size() > 0 || sessionIsFiltered) {
                        ISession session = container == null ? isessionToUse : container.getISession();
                        isessionToUse = this.closePreviousParentFilterDefinition(key, businessModel, session, container, cubeContainer, constructor, cube, schema, currentFilterDefinition);
                    }
                } else {
                    isessionToUse = this.setNewParentFilterDefinition(key, isessionToUse, businessModel, cube, schema, currentFilterDefinition, constructor, cubeContainer, connectionLocale);
                }
            }
            if (container == null) {
                container = this.getISessionContainerFromCache(key);
            }
            if (container != null) {
                container.setReapply(shouldApplyFilter);
            }
            if (container == null && currentFilterDefinition.size() == 0) {
                cubeContainer = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeName);
                if (cubeContainer == null) {
                    cubeContainer = new CubeAssociatedISessionContainer(isessionToUse, key);
                    this._cubesWithIsessions.add(cubeName);
                    this._cubeKeyedContainerCache.put(cubeName, cubeContainer);
                } else {
                    cubeContainer.setISessionActive(isessionToUse, key);
                    cubeContainer.setISessionUnFilter(isessionToUse);
                }
            }
            if (shouldApplyFilter && !this.isISessionBeingUsed(isessionToUse)) {
                this.clearOutFilterStateOnCube(businessModel, prefilter, isessionToUse, true, constructor, cube, schema);
            }
            this._defaultOpenSession = isessionToUse;
            if (_logger.isDebugEnabled()) {
                _logger.debug(">>>>>>>>>>>>>>> End of create cached ISession:: ");
                if (cubeContainer != null) {
                    _logger.debug(this.reportISessionInDebugMode(cubeContainer));
                    _logger.debug(cubeContainer.reportISessionCaches(cubeName));
                }
            }
        }
        catch (MetadataException e) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("OLAPStrategyOLAPExceptionGetIsession.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new GenerationException((MessageFormatter)msF, (Throwable)e);
        }
        if (this._sessionsThatAreInactive.contains(this._defaultOpenSession)) {
            this._sessionsThatAreInactive.remove(this._defaultOpenSession);
        }
        return isessionToUse;
    }

    @NotNull
    public MetadataInterface createMetadataInterface(BusinessModel businessModel) throws GenerationException, ExecutionException, MetadataException {
        String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
        DataSourceCube cube = OLAPConnectionInfoUtil.getCube(businessModel);
        return this.createMetadataInterface(businessModel, constructor, cube, true, true, null);
    }

    @NotNull
    public MetadataInterface createMetadataInterface(BusinessModel dataSelection, String constructor) throws ExecutionException, MetadataException, GenerationException {
        DataSourceCube cube = OLAPConnectionInfoUtil.getCube(dataSelection);
        return this.createMetadataInterface(dataSelection, constructor, cube, false, false, null);
    }

    @NotNull
    public IQMetadataInterface createMetadataInterface(BusinessModel dataSelection, String constructor, Cube cube, boolean setCached, boolean filterCube, OLAPValues olapValues) throws GenerationException, ExecutionException {
        Locale connectionLocale = this.getConnectionLocale(dataSelection);
        String key = MDXGenerationUtil.buildCacheKey(dataSelection, connectionLocale, constructor);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a cached ISession: " + dataSelection.getIdentityString());
        }
        ISession session = this.createCachedISession(dataSelection, key, constructor, connectionLocale, cube);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a metadataInterface: " + dataSelection.getIdentityString());
        }
        IQMetadataInterface metaI = this.createMetadataInterface(dataSelection, key, constructor, connectionLocale, session);
        if (setCached) {
            metaI.setCacheKey(key);
            metaI.setRelatedBusinessModel(dataSelection);
        }
        if (filterCube && dataSelection instanceof LookThroughDataSelection && this.isFilterToBeApplied(key)) {
            this.applyFilterStateOnCube(dataSelection, key, metaI, olapValues);
        }
        return metaI;
    }

    @NotNull
    public IQMetadataInterface createMetadataInterface(BusinessModel businessModel, String key, String constructor, Locale connectionLocale, ISession session) throws ExecutionException {
        IQMetadataInterface metadataInterface = null;
        try {
            metadataInterface = ConnectionResources.newIQMetadata(session, connectionLocale);
            metadataInterface.setRelatedConnection(this);
            connectionLocale = ConnectionUtil.getConnectionLocale(metadataInterface);
            IQISession iqSession = this.getIQISession(session, connectionLocale);
            iqSession.setMetadataInterface(metadataInterface);
            this._metaIConnectionToSession.put(metadataInterface, iqSession);
        }
        catch (OLAPException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionResource.OLAPEX.noMeta.txt", new java.lang.Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, new java.lang.Object[]{e, businessModel, key, constructor, connectionLocale});
            throw new ExecutionException(message, (Throwable)e);
        }
        if (metadataInterface == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new java.lang.Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, key, constructor, connectionLocale);
            throw new ExecutionException(message);
        }
        return metadataInterface;
    }

    public Locale getConnectionLocale(BusinessModel businessModel) {
        return this.getDefaultConnectionLocale(businessModel);
    }

    public ISession createSingleISession(BusinessModel businessModel, Locale connectionLocale) throws ExecutionException {
        ISession session = null;
        Object iomConnectionObject = this._connection.getObject();
        IMDXServer mdxServer = IOMServerUtils.GetIMDXServer(iomConnectionObject);
        Locale cubeConnectionLocale = connectionLocale;
        if (businessModel != null) {
            DataSourceCube dataCube = null;
            try {
                dataCube = OLAPConnectionInfoUtil.getCube(businessModel);
            }
            catch (GenerationException e1) {
                throw new ExecutionException(e1);
            }
            cubeConnectionLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, connectionLocale, businessModel.getComputationalLocale());
        }
        try {
            session = ConnectionResources.newISession(mdxServer, cubeConnectionLocale);
        }
        catch (Exception e) {
            ArrayList<java.lang.Object> msg = new ArrayList<java.lang.Object>();
            msg.add(e);
            if (businessModel != null) {
                msg.add(businessModel.getIdentityString());
            }
            msg.add(IQDataServicesResourceBundle.getStringResource("OLAPStrategyOLAPExceptionGetIsession.txt"));
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msg.toArray());
            throw new ExecutionException((MessageFormatter)msF, (Throwable)e);
        }
        if (session == null) {
            ArrayList<String> msg = new ArrayList<String>();
            if (businessModel != null) {
                msg.add(businessModel.getIdentityString());
            }
            msg.add(IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadISession.txt"));
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msg.toArray());
            throw new ExecutionException(msF);
        }
        IQISession iqISession = this.newIQISession(session, connectionLocale);
        this._IQISessionContainerCache.put(session, iqISession);
        this._listOfSessionID.put(session, session.UniqueIdentifier());
        return session;
    }

    public void generatePassword(String arg0, StringHolder arg1, StringHolder arg2) throws ConnectionFactoryException {
        this._connection.generatePassword(arg0, arg1, arg2);
    }

    private ISession getBusinessModelISession(String key) throws ExecutionException {
        ISession session = null;
        if (this._sessionKeyedContainerCache.containsKey(key)) {
            ISessionCacheContainer container = this.getISessionContainerFromCache(key);
            session = container.getISession();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Getting value from cache for: " + key);
            }
        } else {
            session = this._defaultOpenSession;
        }
        if (_logger.isDebugEnabled()) {
            boolean sessionBeingUsed = this.isISessionBeingUsed(session);
            _logger.debug("The business query Isession that you are requesting is being used... " + sessionBeingUsed);
        }
        if (session == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{key, IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadISession.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new ExecutionException(msF);
        }
        return session;
    }

    public ConnectionInterface getConnection() {
        if (this._isClosed) {
            return null;
        }
        return this._connection;
    }

    public CubeAssociatedISessionContainer getCubeContainerFromCache(String cubeName) {
        CubeAssociatedISessionContainer value = null;
        if (this._cubeKeyedContainerCache.containsKey(cubeName)) {
            value = (CubeAssociatedISessionContainer)this._cubeKeyedContainerCache.get(cubeName);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Getting ISession from cache for this key:" + cubeName);
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(" No cached container found for: " + cubeName + ": constructing one.");
        }
        return value;
    }

    public PreFilterDLLGeneration getFullParentFilterObjectForBusinessModel(BusinessModel model, String key) throws GenerationException {
        String cubeName = OLAPConnectionInfoUtil.getCubeName(model);
        PreFilterDLLGeneration preFilterDLLContainer = null;
        ISessionCacheContainer cacheContainer = this.getISessionContainerFromCache(key);
        if (cacheContainer != null && (preFilterDLLContainer = cacheContainer.getPreFilterContainer()) == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Could not find a prefilter container for this key, creating one:" + key + " " + model.getIdentityString());
            }
            preFilterDLLContainer = new PreFilterDLLGeneration();
            if (cacheContainer != null) {
                cacheContainer.setPreFilerContainer(preFilterDLLContainer);
            }
            if (this._cubeKeyedContainerCache.containsKey(cubeName)) {
                String cacheKey;
                CubeAssociatedISessionContainer cubeContainer = this.getCubeContainerFromCache(cubeName);
                ISession cachISession = cacheContainer.getISession();
                if (cachISession != null && (cacheKey = cubeContainer.getFirstKeyCache(cachISession)) == null) {
                    cubeContainer.setISessionActive(cachISession, key);
                }
            }
        }
        return preFilterDLLContainer;
    }

    public ISessionCacheContainer getISessionContainerFromCache(String key) {
        ISessionCacheContainer value = null;
        if (this._sessionKeyedContainerCache.containsKey(key)) {
            value = (ISessionCacheContainer)this._sessionKeyedContainerCache.get(key);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Getting ISession from cache for this key:" + key);
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(" No cached container found for: " + key + ": constructing one.");
        }
        return value;
    }

    public List<String> getListOfParentFilterStringValue(BusinessModel businessModel) throws GenerationException {
        ArrayList<String> filterStringList = new ArrayList<String>();
        if (businessModel instanceof DataSelection) {
            DataSelection model = (DataSelection)businessModel;
            for (FilterItem filterItemDefinition : model.getEffectiveFilters()) {
                ExpressionInterface filterExpression = MDXGenerationUtil.getRealEffectiveFilter(filterItemDefinition, model);
                if (filterExpression == null) continue;
                String logInfo = filterExpression.toString();
                String filterExpressionString = "";
                if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression)) {
                    _logger.debug(logInfo);
                    filterExpressionString = MemberFilter.getMDXExpression(model, "", (MemberFilterExpression)filterExpression);
                } else if (filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
                    _logger.debug(logInfo);
                    filterExpressionString = TimeFirstLastPeriodsFilter.getMDXExpression((TimeFilterFirstLastPeriodsExpression)filterExpression, model);
                } else if (filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
                    _logger.debug(logInfo);
                    filterExpressionString = TimeNParallelPeriodsFilter.getMDXExpression((TimeFilterNParallelPeriodsExpression)filterExpression, model);
                } else if (filterExpression instanceof TimeFilterNPeriodsExpression) {
                    _logger.debug(logInfo);
                    filterExpressionString = TimeNPeriodsFilter.getMDXExpression((TimeFilterNPeriodsExpression)filterExpression, model);
                } else if (filterExpression instanceof TimeRangeFilterExpression) {
                    _logger.debug(logInfo);
                    filterExpressionString = TimeRangeFilter.getMDXExpression((TimeRangeFilterExpression)filterExpression, model);
                }
                if (filterExpressionString.length() <= 0) continue;
                filterStringList.add(filterExpressionString);
            }
        }
        return filterStringList;
    }

    public Object getObject() {
        if (this._isClosed) {
            return null;
        }
        return this._connection.getObject();
    }

    public ISession getSession() {
        return this._defaultOpenSession;
    }

    public boolean isCubeFiltered(String cubeName) {
        boolean isCubeFiltered = false;
        CubeAssociatedISessionContainer cubeContainer = this.getCubeContainerFromCache(cubeName);
        if (cubeContainer != null) {
            isCubeFiltered = cubeContainer.isCubeFiltered();
        }
        return isCubeFiltered;
    }

    public boolean isFilterToBeApplied(String key) {
        ISessionCacheContainer container = this.getISessionContainerFromCache(key);
        if (container == null) {
            return false;
        }
        return container.toReapply();
    }

    public boolean isFilterApplied(String key, String cube) {
        ISessionCacheContainer container;
        boolean returnValue = false;
        if (this.isCubeFiltered(cube) && (container = this.getISessionContainerFromCache(key)) != null) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isISessionBeingUsed(ISession session) throws ExecutionException {
        boolean isISessionBeingUsed = false;
        if (this._IQISessionContainerCache.containsKey(session)) {
            IQISession iqSession = this._IQISessionContainerCache.get(session);
            if (iqSession != null) {
                MDXGenerationUtil.applyDebugStatement("ISession is " + iqSession.isFree(), this.getClass());
                if (!iqSession.isFree()) {
                    isISessionBeingUsed = true;
                }
            } else {
                _logger.error("IQISession was null while ISession was not.");
            }
        }
        return isISessionBeingUsed;
    }

    public void releaseMetadataInterfaceFromISession(IQMetadataInterface metaInterface) {
        if (this._metaIConnectionToSession.containsKey(metaInterface)) {
            MDXGenerationUtil.applyDebugStatement("Release the metadata Interface", this.getClass());
            IQISession iqISession = (IQISession)this._metaIConnectionToSession.get(metaInterface);
            iqISession.releaseMetadataInterface(metaInterface);
        }
        metaInterface = null;
    }

    public void releaseOLAPDataSetFromISession(IQOLAPDataSetInterface olapDataSetInterface) {
        if (this._olapDataSetConnectionToSession.containsKey(olapDataSetInterface)) {
            IQISession iqISession = (IQISession)this._olapDataSetConnectionToSession.get(olapDataSetInterface);
            if (iqISession != null) {
                MDXGenerationUtil.applyDebugStatement("Release the OLAPDataSet Interface", this.getClass());
                iqISession.releaseOLAPDataSetInterface(olapDataSetInterface);
            } else {
                _logger.error("Can not find IQOLAP dataset interface for this ISession.");
            }
            this._olapDataSetConnectionToSession.remove(olapDataSetInterface);
        }
    }

    private synchronized void removeCacheEntries(String key) throws ExecutionException {
        ISessionCacheContainer container = this.getISessionContainerFromCache(key);
        if (container != null) {
            PreFilterDLLGeneration pff = container.getPreFilterContainer();
            OLAPValues olapValues = pff.getOLAPValues();
            if (olapValues != null) {
                olapValues.release();
            }
            List pffList = container.getDDLDefinition();
            pffList.clear();
            pffList = null;
            pff = null;
            container.setPreFilerContainer(null);
            container.setISession(null);
            this._sessionKeyedContainerCache.remove(key);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Associated List being removed for this key:" + key);
        }
    }

    public String reportISessionInDebugMode(CubeAssociatedISessionContainer cubeContainer) {
        StringBuilder avalue = new StringBuilder();
        if (cubeContainer != null) {
            List activeISessions = cubeContainer.getActiveISessions();
            for (ISession isessionObject : activeISessions) {
                try {
                    boolean isBeingUsed = this.isISessionBeingUsed(isessionObject);
                    avalue.append(MDXGenerationUtil.NEWLINE + "ActiveISession: ").append(isessionObject).append(" Used: ");
                    if (isBeingUsed) {
                        avalue.append("<<true>>");
                    } else {
                        avalue.append("<<false>>");
                    }
                    avalue.append(" Filtered: ").append(cubeContainer.isCubeSessionFiltered(isessionObject));
                    StringSeqHolder QryStmt = new StringSeqHolder();
                    ResultSetTypeSeqHolder RSType = new ResultSetTypeSeqHolder();
                    BooleanSeqHolder isRunning = new BooleanSeqHolder();
                    LongSeqHolder Size = new LongSeqHolder();
                    ISession_1_1 isession2 = IOMServerUtils.GetISession_1_1((Object)isessionObject);
                    isession2.ListQueries(QryStmt, RSType, isRunning, Size);
                    String[] queries = QryStmt.value;
                    for (int j = 0; j < queries.length; ++j) {
                        int start = queries[j].indexOf(91) + 1;
                        int end = queries[j].indexOf(93, start);
                        String cube = queries[j].substring(start, end).trim();
                        avalue.append(MDXGenerationUtil.NEWLINE).append("     ").append(" Cube: ").append(cube).append(MDXGenerationUtil.NEWLINE).append("     ").append("     ").append(" MDX: ").append(queries[j]);
                    }
                }
                catch (GenericError e) {
                    avalue.append("A determination for this Isession use could not occur.." + e.getLocalizedMessage());
                }
                catch (Exception e) {
                    avalue.append("A determination for this Isession use could not occur.." + e.getLocalizedMessage());
                }
            }
        }
        return avalue.toString();
    }

    private void reportOpenConnectionInAISessionDebugMode(IQISession isessionContainer) {
        block6: {
            try {
                if (_logger.isDebugEnabled()) {
                    int counterM = 0;
                    int counterD = 0;
                    if (isessionContainer != null) {
                        for (MetadataInterface metaa : isessionContainer.getMetadataList().toList()) {
                            _logger.debug("**MetdataInteface associated to this ISession to be closed: " + metaa.getConnection() + " " + metaa.toString());
                            ++counterM;
                        }
                        for (OLAPDataSetInterface metaa : isessionContainer.getOLAPDataSetList().toList()) {
                            _logger.debug("**MetdataInteface associated to this ISession to be closed: " + metaa.getConnection() + " " + metaa.getQueryStatement());
                            ++counterD;
                        }
                    }
                    _logger.debug("** Number of MetdataInteface associated to ISession: " + counterM);
                    _logger.debug("** Number of MetdataInteface associated to ISession: " + counterD);
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block6;
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("OLAPStrategyOLAPExceptionGetIsession.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                _logger.error(msF.toString());
            }
        }
    }

    private ISession setNewParentFilterDefinition(String key, ISession iSessionUsed, BusinessModel businessModel, Cube cube, Schema schema, List currentFilterDefinition, String constructor, CubeAssociatedISessionContainer cubeContainer, Locale connectionLocale) throws ExecutionException, MetadataException, GenerationException {
        PreFilterDLLGeneration prefilter = null;
        MDXGenerationUtil.applyDebugStatement("Setting a new Parent Filter Definition on a used ISession", this.getClass());
        ISession session = iSessionUsed;
        ISessionCacheContainer container = this.getISessionContainerFromCache(key);
        if (container != null) {
            ISession containerSession = container.getISession();
            if (session != null) {
                session = containerSession;
            }
            prefilter = this.getFullParentFilterObjectForBusinessModel(businessModel, key);
            if (constructor.equalsIgnoreCase("DEFAULT_CONSTRUCTOR_BEHAVIOR") && cubeContainer.isCubeSessionFiltered(session)) {
                if (this.isISessionBeingUsed(session)) {
                    session = this.createSingleISession(businessModel, connectionLocale);
                } else {
                    this.clearOutFilterStateOnCube(businessModel, prefilter, session, true, constructor, cube, schema);
                }
            }
        } else {
            prefilter = new PreFilterDLLGeneration();
            if (this.isISessionBeingUsed(session)) {
                if (constructor.equals("GENERATION")) {
                    session = this.createSingleISession(businessModel, connectionLocale);
                } else if (businessModel instanceof LookThroughDataSelection) {
                    session = this.createSingleISession(businessModel, connectionLocale);
                } else {
                    boolean isSessionFiltered = false;
                    if (cubeContainer != null) {
                        isSessionFiltered = cubeContainer.isCubeSessionFiltered(session);
                    }
                    if (isSessionFiltered) {
                        for (ISession potentialsession : cubeContainer.getActiveISessions()) {
                            if (cubeContainer.isCubeSessionFiltered(potentialsession)) continue;
                            isSessionFiltered = false;
                            session = potentialsession;
                        }
                    }
                    if (isSessionFiltered) {
                        session = this.createSingleISession(businessModel, connectionLocale);
                    }
                }
            } else {
                MDXGenerationUtil.applyDebugStatement("Setting a new Parent Filter Definition on a newly minted, but in process ISession", this.getClass());
                Semaphore semi = new Semaphore(1);
                try {
                    semi.acquire();
                }
                catch (InterruptedException e) {
                    _logger.error("Semaphone interruption: " + e.getLocalizedMessage());
                }
                ISession newSession = this.clearOutContentsOfSingleISession(session, cube, schema, true, businessModel);
                if (newSession != null) {
                    MDXGenerationUtil.applyDebugStatement("We are throwing away a open but in transit ISession.", this.getClass());
                    session = newSession;
                }
                semi.release();
            }
        }
        this.storeInformationInCache(currentFilterDefinition, key, businessModel, session, cube, prefilter);
        return session;
    }

    private void storeInformationInCache(List currentFilterDefinition, String key, BusinessModel model, ISession isession, Cube cube, PreFilterDLLGeneration prefilter) throws MetadataException {
        if (currentFilterDefinition.size() > 0) {
            String cubeName = cube.getCubeName();
            ISessionCacheContainer container = this.getISessionContainerFromCache(key);
            if (container == null) {
                if (prefilter == null) {
                    prefilter = new PreFilterDLLGeneration();
                }
                container = new ISessionCacheContainer(isession, cubeName, prefilter, currentFilterDefinition, key, model);
                this.addISessionToCache(key, container);
            } else {
                container.setDDLDefinition(currentFilterDefinition);
                container.setISession(isession);
                if (model instanceof DataSelection) {
                    container.setTotalIndicator(((DataSelection)model).getTotalType(Role.ROW), Role.ROW);
                    container.setTotalIndicator(((DataSelection)model).getTotalType(Role.COLUMN), Role.COLUMN);
                }
            }
            this.addCubeToCache(isession, cubeName, key);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Associated List being stored for this ISession cache key:" + key);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " wrapping " + (this._isClosed ? "(closed) " : "") + (this._connection == null ? "null connection" : this._connection.toString());
    }

    public IMDXAdmin_1_1 getAdmin() {
        return this._obMDXAdmin_1_1;
    }

    public IQISession getIQISession(ISession isession, Locale connectionLocale) {
        IQISession iqISession = this._IQISessionContainerCache.get(isession);
        if (iqISession == null) {
            _logger.error("ISession could not be found in the cache so create one and move on. ");
            iqISession = this.newIQISession(isession, connectionLocale);
            this._IQISessionContainerCache.put(isession, iqISession);
        }
        return iqISession;
    }

    public IQISession newIQISession(ISession isession, Locale connectionLocale) {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new IQISession object");
            start = System.currentTimeMillis();
        }
        IQISession out = new IQISession(isession, connectionLocale);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return out;
    }

    public void addOlapDataSet(ISession isession, IQOLAPDataSet olapDataSet, Locale connectionLocale) {
        IQISession iqISession = this.getIQISession(isession, connectionLocale);
        iqISession.setOLAPDataSetInterface(olapDataSet);
        this._olapDataSetConnectionToSession.put(olapDataSet, iqISession);
    }

    public ISession getISession(DataSelection dataSelection, String constructor, Locale connectionLocale) throws GenerationException {
        ISession isession;
        String sessionCacheContainerKey = MDXGenerationUtil.buildCacheKey(dataSelection, connectionLocale, constructor);
        ISessionCacheContainer container = this.getISessionContainerFromCache(sessionCacheContainerKey);
        if (container == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("No container for this cache was found: " + sessionCacheContainerKey + " " + dataSelection.getIdentityString() + " " + constructor + " Using default ISession.");
            }
            isession = this._defaultOpenSession;
        } else if (container.getISession() == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("No Isession associated to this container for this cache was found: " + sessionCacheContainerKey + " Using default ISession.");
            }
            isession = this._defaultOpenSession;
        } else {
            isession = container.getISession();
        }
        return isession;
    }
}

