/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OverrideConnectionInterface;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.services.connection.ConnectionInterface;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExecutionProcessor
implements OverrideLocaleInterface,
OverrideMLSLookupsInterface,
OverrideStpNamesInterface,
OverrideConnectionInterface {
    List<ExecutionInstructionInterface> _executionInstructions = null;
    private RetrievalPolicy _retrievalPolicy;
    private Locale _computationalLocale = null;
    private StpNames _stpNames = null;
    private Map<String, MLSLookup> _mlsLookups = null;
    private ConnectionInterface _connection = null;
    private IWorkspace _workspace = null;
    private String _temporaryTableName = null;

    public ExecutionProcessor(RetrievalPolicy retrievalPolicy) {
        this.setRetrievalPolicy(retrievalPolicy);
    }

    public void execute(List<ExecutionInstructionInterface> executionInstructions) throws ExecutionException {
        ConnectionInterface preExistingConnection = this.getConnection();
        for (ExecutionInstructionInterface instruction : executionInstructions) {
            ExecutionContext context = this.newExecutionContext();
            instruction.setExecutionContext(context);
            try {
                instruction.execute();
            }
            catch (ExecutionException e) {
                ConnectionInterface connection;
                if (this.isAcquireRelease(context) && preExistingConnection == null && (connection = context.getConnection()) != null) {
                    CancelQuerySupport.unRegisterConnection(connection);
                    ConnectionResources.close(connection);
                }
                throw e;
            }
        }
        this._executionInstructions = executionInstructions;
    }

    protected ExecutionContext newExecutionContext() {
        String preExistingTempTableName;
        IWorkspace preExistingWorkspace;
        RetrievalPolicy retrievalPolicy = this.getRetrievalPolicy();
        ExecutionContext context = new ExecutionContext(retrievalPolicy);
        ConnectionInterface preExistingConnection = this.getConnection();
        if (preExistingConnection != null) {
            context.setConnection(preExistingConnection);
        }
        if ((preExistingWorkspace = this.getWorkspace()) != null) {
            context.setWorkspace(preExistingWorkspace);
        }
        if ((preExistingTempTableName = this.getTemporaryTableName()) != null) {
            context.setTemporaryTableName(preExistingTempTableName);
        }
        context.setComputationalLocale(this.getComputationalLocale());
        context.setStpNames(this.getStpNames());
        context.setMLSLookups(this.getMLSLookups());
        return context;
    }

    private boolean isAcquireRelease(ExecutionContext context) {
        int connectionLifeTime = context.getRetrievalPolicy().getConnectionConfiguration().getConnectionLifetime();
        return connectionLifeTime == 0;
    }

    public ResultSetInterface getResult(String modelID) throws ExecutionException {
        ResultSetInterface rs = null;
        StringBuffer queryString = new StringBuffer();
        Iterator<ExecutionInstructionInterface> it = this._executionInstructions.iterator();
        while (rs == null && it.hasNext()) {
            String text;
            ExecutionInstructionInterface instruction = it.next();
            try {
                text = instruction.getText();
            }
            catch (GenerationException e) {
                throw new ExecutionException(e);
            }
            catch (MetadataException e) {
                throw new ExecutionException(e);
            }
            queryString.append(text);
            if (!instruction.getID().equalsIgnoreCase(modelID) || !((rs = instruction.getResult()) instanceof ResultSetUpdateInterface)) continue;
            ((ResultSetUpdateInterface)((Object)rs)).setQuery(queryString.toString());
        }
        if (rs == null) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ExecutionProcessor.getResult.Execution.txt", new Object[0]));
        }
        return rs;
    }

    public void setRetrievalPolicy(RetrievalPolicy retrievalPolicy) {
        this._retrievalPolicy = retrievalPolicy;
    }

    private RetrievalPolicy getRetrievalPolicy() {
        return this._retrievalPolicy;
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationalLocale;
    }

    @Override
    public void setComputationalLocale(Locale overrideComputationalLocale) {
        this._computationalLocale = overrideComputationalLocale;
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames;
    }

    @Override
    public Map<String, MLSLookup> getMLSLookups() {
        return this._mlsLookups;
    }

    @Override
    public void setMLSLookups(Map<String, MLSLookup> mlsLookupsByColumnName) {
        this._mlsLookups = mlsLookupsByColumnName;
    }

    @Override
    @SASScope(value="sas")
    public void setConnection(ConnectionInterface connection) {
        this._connection = connection;
    }

    @Override
    @SASScope(value="sas")
    public ConnectionInterface getConnection() {
        return this._connection;
    }

    @Override
    @SASScope(value="sas")
    public void setWorkspace(IWorkspace workspace) {
        this._workspace = workspace;
    }

    @Override
    @SASScope(value="sas")
    public IWorkspace getWorkspace() {
        return this._workspace;
    }

    @SASScope(value="sas")
    public void setTemporaryTableName(String tableName) {
        this._temporaryTableName = tableName;
    }

    @SASScope(value="sas")
    public String getTemporaryTableName() {
        return this._temporaryTableName;
    }
}

