/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.execution;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadata;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.RetryUtil;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.SystemException;

public class ConnectionResources {
    private static final Logger _logger = LogManager.getLogger(ConnectionResources.class);
    private static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");

    public static ConnectionInterface getConnection(LogicalServerInterface logicalServer, UserContextInterface userContext) throws ServiceException, RemoteException, ConnectionFactoryException {
        return ConnectionResources.getConnection(logicalServer, userContext, userContext.getLocale(), 0L);
    }

    public static ConnectionInterface getConnection(LogicalServerInterface logicalServer, UserContextInterface userContext, Locale connectionLocale) throws ServiceException, RemoteException, ConnectionFactoryException {
        return ConnectionResources.getConnection(logicalServer, userContext, connectionLocale, 0L);
    }

    public static ConnectionInterface getConnection(LogicalServerInterface logicalServer, UserContextInterface userContext, Locale connectionLocale, long maxConnectionWaitTime) throws ServiceException, RemoteException, ConnectionFactoryException {
        SessionContextInterface sessionContext = userContext.getSessionContext();
        boolean defaultUseAsync = false;
        long defaultMaxWait = maxConnectionWaitTime < 0L ? -maxConnectionWaitTime : maxConnectionWaitTime;
        long defaultInterval = ConnectionResources.ToMillisecs(0, 0, 0, 0, 100);
        boolean useAsync = ConnectionResources.getIQSystemProp_ConnectionAsyncEnabled(defaultUseAsync);
        long maxMilliseconds = ConnectionResources.getIQSystemProp_MaxMilliseconds(defaultMaxWait);
        long waitIntervalMilliseconds = ConnectionResources.getIQSystemProp_WaitIntervalMilliseconds(defaultInterval);
        ConnectionInterface connection = useAsync ? ConnectionResources.getConnectionWithTimeOut(logicalServer, userContext, connectionLocale, sessionContext, maxMilliseconds, waitIntervalMilliseconds) : ConnectionResources.getConnectionDirect(logicalServer, userContext, connectionLocale, sessionContext, maxMilliseconds, waitIntervalMilliseconds);
        return connection;
    }

    private static void logConnectionAcquired(ConnectionInterface connection) {
        if (connection != null && _logger.isDebugEnabled()) {
            _logger.debug("A Connection to the server was acquired. " + connection.getClass().getName());
            _logger.debug("[ConnectionResouces] new connection = (" + connection.getClass().getName() + ") " + connection + ", getObject()=(" + (connection.getObject() == null ? "null" : connection.getObject().getClass().getName()) + ") " + connection.getObject());
        }
    }

    public static void close(ConnectionInterface connection) {
        if (connection != null) {
            long start = 0L;
            if (_perfCLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogConnectionPerformance("> Closing connection: " + connection.toString());
                start = System.currentTimeMillis();
            }
            ConnectionResources.logConnectionClosing(connection);
            try {
                connection.close();
            }
            catch (SystemException e2) {
                _logger.error((Object)e2);
            }
            if (_perfCLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
            }
        }
    }

    private static void logConnectionClosing(ConnectionInterface connection) {
        if (connection != null && _logger.isDebugEnabled()) {
            _logger.debug("A Connection to the server is closing. " + connection.getClass().getName());
            _logger.debug("[ConnectionResouces] connection.close() = (" + connection.getClass().getName() + ") " + connection);
        }
    }

    public static MetadataInterface newOLAPMetadataInterface(ISession iSession) throws OLAPException {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new com.sas.storage.olap.sasmdx.Metadata object");
            start = System.currentTimeMillis();
        }
        Metadata metaI = new Metadata(iSession);
        ConnectionResources.logMetadataInterfaceAquired((MetadataInterface)metaI, iSession);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return metaI;
    }

    private static void logMetadataInterfaceAquired(MetadataInterface metaI, ISession iSession) {
        if (metaI != null && _logger.isDebugEnabled()) {
            _logger.debug("A Metadata Interfrace to the server was acquired. " + metaI.getClass().getName());
            _logger.debug("[ConnectionResouces] new Metadata Interface = (" + metaI.getClass().getName() + ") " + metaI);
        }
    }

    public static IQMetadataInterface newIQMetadata(ISession iSession, Locale connectionLocale) throws OLAPException {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new IQMetadata object");
            start = System.currentTimeMillis();
        }
        IQMetadata out = new IQMetadata(iSession, connectionLocale);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return out;
    }

    public static ISession newISession(IMDXServer mdxServer, Locale connectionLocale) throws GenericError, OLAPException {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new ISession via IMDXServer.CreateSession()");
            start = System.currentTimeMillis();
        }
        String desiredLocale = connectionLocale.toString();
        ISession iSession = mdxServer.CreateSession(desiredLocale);
        ConnectionResources.logISessionAquired(iSession);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return iSession;
    }

    private static void logISessionAquired(ISession iSession) {
        if (iSession != null && _logger.isDebugEnabled()) {
            _logger.debug("A ISession to the server was acquired. " + iSession.getClass().getName());
            _logger.debug("[ConnectionResouces] new ISession = (" + iSession.getClass().getName() + ") " + iSession);
        }
    }

    public static IQOLAPDataSet newOLAPDataSet(ISession isession, int contextType, ConnectionInterface pfsConnection) throws OLAPException {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new IQOLAPDataSet object");
            ExtraLoggingContexts.debugLogConnectionPerformance("> using ISession=" + isession);
            start = System.currentTimeMillis();
        }
        IQOLAPDataSet olapDataSet = new IQOLAPDataSet(isession, contextType, pfsConnection);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return olapDataSet;
    }

    public static IQOLAPDataSet newOLAPDataSet(IMDXServer mdxServer, int contextType) throws OLAPException {
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Creating new IQOLAPDataSet object");
            ExtraLoggingContexts.debugLogConnectionPerformance("> using IMDXServer=" + mdxServer);
            start = System.currentTimeMillis();
        }
        IQOLAPDataSet olapDataSet = new IQOLAPDataSet(mdxServer, null, contextType, null);
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
        return olapDataSet;
    }

    public static void close(IQOLAPDataSet olapDataSet) {
        if (olapDataSet != null) {
            try {
                olapDataSet.close();
            }
            catch (OLAPException oe) {
                String message = "Error while closing the OlapDataSet, just continue: ";
                _logger.debug(message, (Throwable)oe);
            }
        }
    }

    public static PlatformConnectionFactoryConfiguration createPlatformConnectionFactoryConfiguration(final LogicalServerInterface lsi, final SessionContextInterface session) throws ServiceException, RemoteException, ConnectionFactoryException {
        RetryUtil.Actor<PlatformConnectionFactoryConfiguration> actor = new RetryUtil.Actor<PlatformConnectionFactoryConfiguration>(){

            @Override
            public PlatformConnectionFactoryConfiguration action() throws RetryUtil.RedoAction, RetryUtil.FailAction {
                try {
                    return PlatformConnectionFactoryConfiguration.createFactoryConfiguration((LogicalServerInterface)lsi, (SessionContextInterface)session);
                }
                catch (ConcurrentModificationException e) {
                    throw new RetryUtil.RedoAction(e);
                }
                catch (ServiceException e) {
                    throw new RetryUtil.FailAction(e);
                }
                catch (RemoteException e) {
                    throw new RetryUtil.FailAction(e);
                }
                catch (ConnectionFactoryException e) {
                    throw new RetryUtil.FailAction(e);
                }
            }
        };
        return ConnectionResources.createPlatformConnectionFactoryConfiguration(actor);
    }

    public static PlatformConnectionFactoryInterface getPlatformConnectionFactory(PlatformConnectionFactoryConfiguration config) throws ConnectionFactoryException {
        PlatformConnectionFactoryInterface factory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
        return factory;
    }

    public static ConnectionInterface getConnection(PlatformConnectionFactoryInterface factory, UserContextInterface userContext) throws ConnectionFactoryException {
        return ConnectionResources.getConnection(factory, userContext, 0L);
    }

    public static ConnectionInterface getConnection(PlatformConnectionFactoryInterface factory, UserContextInterface userContext, long timeout) throws ConnectionFactoryException {
        ConnectionInterface connection = factory.getConnection(userContext, timeout);
        return connection;
    }

    public static PlatformConnectionFactoryConfiguration createWorkspaceServerFactoryConfiguration(final ServerContextInterface serverContext, final SessionContextInterface session) throws ServiceException, RemoteException, ConnectionFactoryException {
        RetryUtil.Actor<PlatformConnectionFactoryConfiguration> actor = new RetryUtil.Actor<PlatformConnectionFactoryConfiguration>(){

            @Override
            public PlatformConnectionFactoryConfiguration action() throws RetryUtil.RedoAction, RetryUtil.FailAction {
                try {
                    return PlatformConnectionFactoryConfiguration.createWorkspaceServerFactoryConfiguration((ServerContextInterface)serverContext, (SessionContextInterface)session);
                }
                catch (ConcurrentModificationException e) {
                    throw new RetryUtil.RedoAction(e);
                }
                catch (ServiceException e) {
                    throw new RetryUtil.FailAction(e);
                }
                catch (RemoteException e) {
                    throw new RetryUtil.FailAction(e);
                }
                catch (ConnectionFactoryException e) {
                    throw new RetryUtil.FailAction(e);
                }
            }
        };
        return ConnectionResources.createPlatformConnectionFactoryConfiguration(actor);
    }

    private static PlatformConnectionFactoryConfiguration createPlatformConnectionFactoryConfiguration(RetryUtil.Actor<PlatformConnectionFactoryConfiguration> actor) throws ServiceException, RemoteException, ConnectionFactoryException {
        PlatformConnectionFactoryConfiguration config = null;
        try {
            config = RetryUtil.tryAction(actor, _logger);
        }
        catch (RetryUtil.ActionFailed e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServiceException) {
                throw (ServiceException)cause;
            }
            if (cause instanceof RemoteException) {
                throw (RemoteException)cause;
            }
            if (cause instanceof ConnectionFactoryException) {
                throw (ConnectionFactoryException)cause;
            }
            throw new IllegalStateException(cause);
        }
        return config;
    }

    private static long ToMillisecs(int days, int hours, int minutes, int seconds, int milliseconds) {
        return (((days * 24 + hours) * 60 + minutes) * 60 + seconds) * 1000 + milliseconds;
    }

    private static boolean getIQSystemProp_ConnectionAsyncEnabled(boolean defaultUseAsync) {
        char charAt;
        String propertyText = null;
        try {
            propertyText = System.getProperty("SASQueryServices.sasConnectAsync");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        boolean isAsync = defaultUseAsync;
        if (propertyText != null && propertyText.trim().length() > 0 && ((charAt = propertyText.trim().toUpperCase().charAt(0)) == 'Y' || charAt == 'T')) {
            isAsync = true;
        }
        return isAsync;
    }

    private static long getIQSystemProp_MaxMilliseconds(long maxConnectionWaitTime) {
        long maxSubmitMillisecs = maxConnectionWaitTime;
        Long timeout = Long.getLong("SASQueryServices.sasConnectTimeout");
        if (timeout != null && (maxSubmitMillisecs = timeout.longValue()) < 0L) {
            maxSubmitMillisecs = -maxSubmitMillisecs;
        }
        return maxSubmitMillisecs;
    }

    private static long getIQSystemProp_WaitIntervalMilliseconds(long defaultInterval) {
        long intervalMilliseconds = defaultInterval;
        Long interval = Long.getLong("SASQueryServices.sasConnectInterval");
        if (interval != null && (intervalMilliseconds = interval.longValue()) < 0L) {
            intervalMilliseconds = -intervalMilliseconds;
        }
        return intervalMilliseconds;
    }

    private static ConnectionInterface getConnectionDirect(LogicalServerInterface logicalServer, UserContextInterface userContext, Locale connectionLocale, SessionContextInterface sessionContext, long maxMilliseconds, long waitIntervalMilliseconds) throws ServiceException, RemoteException, ConnectionFactoryException {
        long maxMillisecs = 0L;
        long sleepMillis = 0L;
        String userName = userContext.getName();
        String serverName = logicalServer.getName();
        NewConnectionRequest connectionRequest = new NewConnectionRequest(sessionContext, userContext, userName, logicalServer, serverName, connectionLocale, 0L, 0L);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Using unthreaded getConnection(maxMillisecs=0,waitIntervalMilliseconds=" + waitIntervalMilliseconds + ")");
        }
        connectionRequest.run();
        boolean isSuccessful = connectionRequest._isSuccessful;
        ConnectionInterface connection = connectionRequest._connection;
        Throwable thrownException = connectionRequest._thrownException;
        if (!isSuccessful) {
            if (thrownException != null) {
                _logger.error("ConnectionResources unthreaded getConnection() failed.", thrownException);
            }
            ConnectionResources.close(connection);
            if (thrownException instanceof ServiceException) {
                throw (ServiceException)thrownException;
            }
            if (thrownException instanceof RemoteException) {
                throw (RemoteException)thrownException;
            }
            if (thrownException instanceof ConnectionFactoryException) {
                throw (ConnectionFactoryException)thrownException;
            }
            ConnectionFailedException e = new ConnectionFailedException(serverName, userName, connectionLocale, thrownException);
            if (thrownException == null) {
                _logger.error("ConnectionResources unthreaded getConnection() failed.", (Throwable)((Object)e));
            }
            throw e;
        }
        return connection;
    }

    private static ConnectionInterface getConnectionWithTimeOut(LogicalServerInterface logicalServer, UserContextInterface userContext, Locale connectionLocale, SessionContextInterface sessionContext, long maxMilliseconds, long waitIntervalMilliseconds) throws ServiceException, RemoteException, ConnectionFactoryException {
        long sleepMillis = waitIntervalMilliseconds < 0L ? 100L : waitIntervalMilliseconds;
        long maxMillisecs = maxMilliseconds < 0L ? 0L : maxMilliseconds;
        String serverName = logicalServer.getName();
        String userName = userContext.getName();
        NewConnectionRequest connectionRequest = new NewConnectionRequest(sessionContext, userContext, userName, logicalServer, serverName, connectionLocale, maxMillisecs, sleepMillis);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Using threaded getConnection(maxMillisecs=" + maxMillisecs + ",waitIntervalMilliseconds=" + waitIntervalMilliseconds + "). **********");
        }
        connectionRequest.start();
        boolean isSuccessful = connectionRequest._isSuccessful;
        ConnectionInterface connection = connectionRequest._connection;
        Throwable thrownException = connectionRequest._thrownException;
        if (!isSuccessful) {
            if (thrownException != null) {
                _logger.error("ConnectionResources threaded getConnection() failed.", thrownException);
            }
            ConnectionResources.close(connection);
            ThreadConnectionFailedException e = new ThreadConnectionFailedException(connectionRequest._threadName, serverName, userName, connectionLocale, thrownException);
            if (thrownException == null) {
                _logger.error("ConnectionResources threaded getConnection() failed.", thrownException);
            }
            throw e;
        }
        return connection;
    }

    private static String getUnthreadedGetConnectionFailedExceptionMsg(String serverName, String userName, Locale connectionLocale) {
        String msg = IQDataServicesResourceBundle.getMessageString("ConnectionResources.UnthreadedGetConnectionFailedExceptionMsg.fmt.txt", serverName, userName, connectionLocale);
        return msg;
    }

    private static String getThreadedGetConnectionFailedExceptionMsg(String threadName, String serverName, String userName, Locale connectionLocale) {
        String msg = IQDataServicesResourceBundle.getMessageString("ConnectionResources.ThreadedGetConnectionFailedExceptionMsg.fmt.txt", threadName, serverName, userName, connectionLocale);
        return msg;
    }

    private static String getThreadedGetConnectionInterruptedExceptionMsg(String threadName, String serverName, String userName, Locale connectionLocale) {
        String msg = IQDataServicesResourceBundle.getMessageString("ConnectionResources.ThreadedGetConnectionInterruptedExceptionMsg.fmt.txt", threadName, serverName, userName, connectionLocale);
        return msg;
    }

    private static String getThreadedGetConnectionSessionContextClosedExceptionMsg(String threadName, String serverName, String userName, Locale connectionLocale) {
        String msg = IQDataServicesResourceBundle.getMessageString("ConnectionResources.ThreadedGetConnectionSessionContextClosedExceptionMsg.fmt.txt", threadName, serverName, userName, connectionLocale);
        return msg;
    }

    private static String getThreadedGetConnectionTimedOutExceptionMsg(String threadName, String serverName, String userName, Locale connectionLocale, long maxMillisecs) {
        String msg = IQDataServicesResourceBundle.getMessageString("ConnectionResources.ThreadedGetConnectionTimedOutExceptionMsg.fmt.txt", threadName, serverName, userName, connectionLocale, maxMillisecs);
        return msg;
    }

    static {
        if (_logger.isDebugEnabled()) {
            boolean useAsync = ConnectionResources.getIQSystemProp_ConnectionAsyncEnabled(false);
            long maxMilliseconds = ConnectionResources.getIQSystemProp_MaxMilliseconds(0L);
            long waitIntervalMilliseconds = ConnectionResources.getIQSystemProp_WaitIntervalMilliseconds(ConnectionResources.ToMillisecs(0, 0, 0, 0, 100));
            _logger.debug("getConnnection: useAsync = " + useAsync);
            _logger.debug("getConnnection: maxMilliseconds = " + maxMilliseconds);
            _logger.debug("getConnnection: waitIntervalMilliseconds = " + waitIntervalMilliseconds);
        }
    }

    public static class ConnectionFailedException
    extends ConnectionFactoryException {
        private static final long serialVersionUID = 2097236112032945293L;

        private ConnectionFailedException(String serverName, String userName, Locale connectionLocale, Throwable e) {
            super(ConnectionResources.getUnthreadedGetConnectionFailedExceptionMsg(serverName, userName, connectionLocale));
            if (e != null) {
                this.initCause(e);
            }
        }
    }

    public static class ThreadConnectionFailedException
    extends ConnectionFactoryException {
        private static final long serialVersionUID = 2097236112032945293L;

        private ThreadConnectionFailedException(String threadName, String serverName, String userName, Locale connectionLocale, Throwable e) {
            super(ConnectionResources.getThreadedGetConnectionFailedExceptionMsg(threadName, serverName, userName, connectionLocale));
            if (e != null) {
                this.initCause(e);
            }
        }
    }

    public static class ThreadConnectionInterruptedException
    extends ConnectionFactoryException {
        private static final long serialVersionUID = 583313950391322605L;

        private ThreadConnectionInterruptedException(String threadName, String serverName, String userName, Locale connectionLocale, Throwable e) {
            super(ConnectionResources.getThreadedGetConnectionInterruptedExceptionMsg(threadName, serverName, userName, connectionLocale));
            if (e != null) {
                this.initCause(e);
            }
        }
    }

    public static class SessionContextClosedException
    extends ConnectionFactoryException {
        private static final long serialVersionUID = 4242904553437259170L;

        private SessionContextClosedException(String threadName, String serverName, String userName, Locale connectionLocale, Throwable e) {
            super(ConnectionResources.getThreadedGetConnectionSessionContextClosedExceptionMsg(threadName, serverName, userName, connectionLocale));
            if (e != null) {
                this.initCause(e);
            }
        }
    }

    public static class ConnectionTimedOutException
    extends ConnectionFactoryException {
        private static final long serialVersionUID = 4242904553437259170L;

        private ConnectionTimedOutException(String threadName, String serverName, String userName, Locale connectionLocale, long maxMillisecs, Throwable e) {
            super(ConnectionResources.getThreadedGetConnectionTimedOutExceptionMsg(threadName, serverName, userName, connectionLocale, maxMillisecs));
            if (e != null) {
                this.initCause(e);
            }
        }
    }

    static abstract class SessionContextStateChangedListener
    extends UnicastRemoteObject
    implements RemoteSessionContextStateChangedListener {
        private static final long serialVersionUID = 7531769140169335735L;

        protected SessionContextStateChangedListener() throws RemoteException {
        }
    }

    static class NewConnectionRequest
    implements Runnable {
        public String _threadName = null;
        public final long _sleepMillis;
        public final long _maxMillisecs;
        public final SessionContextInterface _sessionContext;
        public final UserContextInterface _userContext;
        public final String _userName;
        public final LogicalServerInterface _logicalServer;
        public final String _serverName;
        public final Locale _connectionLocale;
        public boolean[] _sessionClosed = null;
        public boolean _isSuccessful = false;
        public Throwable _thrownException = null;
        public ConnectionInterface _connection = null;
        public LogicalServerInterface _actualLogicalServer = null;
        public Locale _actualConnectionLocale = null;

        public NewConnectionRequest(SessionContextInterface sessionContext, UserContextInterface userContext, String userName, LogicalServerInterface reqLogicalServer, String serverName, Locale connectionLocale, long maxMillisecs, long sleepMillis) {
            this._sessionContext = sessionContext;
            this._userContext = userContext;
            this._userName = userName;
            this._logicalServer = reqLogicalServer;
            this._serverName = serverName;
            this._connectionLocale = connectionLocale;
            this._maxMillisecs = maxMillisecs;
            this._sleepMillis = sleepMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start() {
            boolean doLaunch = true;
            this._threadName = "newConnection(" + this._serverName + "," + this._userName + "," + this._connectionLocale + ")@" + Long.toHexString(System.currentTimeMillis());
            String attributeName = null;
            try {
                String key = this._threadName;
                int i = 1;
                while (this._sessionContext.getAttribute(key) != null) {
                    key = this._threadName + "#" + i;
                    ++i;
                }
                attributeName = key;
            }
            catch (RemoteException e) {
                this._thrownException = e;
                this._isSuccessful = false;
                doLaunch = false;
            }
            if (doLaunch) {
                final boolean[] sessionClosed = new boolean[]{false};
                this._sessionClosed = sessionClosed;
                try {
                    SessionContextStateChangedListener listener = new SessionContextStateChangedListener(){
                        private static final long serialVersionUID = -7121273822656586025L;

                        public void contextStateChanged(SessionContextStateChangedEvent arg0) throws RemoteException {
                            sessionClosed[0] = true;
                        }
                    };
                    this._sessionContext.setAttribute(attributeName, (Object)listener);
                }
                catch (RemoteException e) {
                    this._thrownException = e;
                    this._isSuccessful = false;
                    doLaunch = false;
                }
            }
            if (doLaunch) {
                try {
                    this.launchThread();
                }
                finally {
                    block15: {
                        try {
                            this._sessionContext.removeAttribute(attributeName);
                        }
                        catch (RemoteException e) {
                            if (this._thrownException != null) break block15;
                            this._thrownException = e;
                        }
                    }
                }
            }
        }

        private void launchThread() {
            boolean timedOut = false;
            boolean destroyPending = false;
            Thread runner = new Thread((Runnable)this, this._threadName);
            try {
                long startTime = System.currentTimeMillis();
                runner.start();
                do {
                    boolean bl = timedOut = this._maxMillisecs > 0L && this._maxMillisecs < System.currentTimeMillis() - startTime;
                    if (timedOut) {
                        runner.interrupt();
                        break;
                    }
                    if (this._sessionClosed[0]) {
                        runner.interrupt();
                        break;
                    }
                    try {
                        destroyPending = this._sessionContext.isDestroyPending();
                    }
                    catch (RemoteException e) {
                        destroyPending = false;
                        this._thrownException = e;
                        this._isSuccessful = false;
                        runner.interrupt();
                        break;
                    }
                    if (destroyPending) {
                        runner.interrupt();
                        break;
                    }
                    Thread.sleep(this._sleepMillis);
                } while (runner.isAlive());
            }
            catch (InterruptedException e) {
                this._thrownException = new ThreadConnectionInterruptedException(this._threadName, this._serverName, this._userName, this._connectionLocale, e);
                this._isSuccessful = false;
            }
            if (timedOut) {
                this._thrownException = new ConnectionTimedOutException(this._threadName, this._serverName, this._userName, this._connectionLocale, this._maxMillisecs, this._thrownException);
                this._isSuccessful = false;
            } else if (this._sessionClosed[0]) {
                this._thrownException = new SessionContextClosedException(this._threadName, this._serverName, this._userName, this._connectionLocale, this._thrownException);
                this._isSuccessful = false;
            } else if (destroyPending) {
                this._thrownException = new SessionContextClosedException(this._threadName, this._serverName, this._userName, this._connectionLocale, this._thrownException);
                this._isSuccessful = false;
            }
        }

        @Override
        public void run() {
            try {
                this.newConnection();
            }
            catch (Throwable e) {
                this._isSuccessful = false;
                this._thrownException = e;
            }
        }

        private void newConnection() {
            this._isSuccessful = false;
            long start = 0L;
            if (_perfCLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogConnectionPerformance("> Getting server connection.");
                start = System.currentTimeMillis();
            }
            PlatformConnectionFactoryConfiguration config = null;
            try {
                config = ConnectionResources.createPlatformConnectionFactoryConfiguration(this._logicalServer, this._sessionContext);
            }
            catch (Throwable e) {
                this._thrownException = e;
                return;
            }
            PlatformConnectionFactoryInterface factory = null;
            try {
                factory = ConnectionResources.getPlatformConnectionFactory(config);
            }
            catch (Throwable e) {
                this._thrownException = e;
                return;
            }
            this._connection = null;
            try {
                this._connection = ConnectionResources.getConnection(factory, this._userContext);
            }
            catch (Throwable e) {
                this._thrownException = e;
                return;
            }
            this._isSuccessful = true;
            try {
                this._actualConnectionLocale = IOMServerUtils.ChangeServerLocale(this._connection, this._connectionLocale);
                if (!(this._actualConnectionLocale == null || this._connectionLocale != null && this._actualConnectionLocale.toString().equals(this._connectionLocale.toString()))) {
                    _logger.warn("The workspace locale could not be set to '" + this._connectionLocale + "', it has been set to '" + this._actualConnectionLocale + "' instead.");
                }
            }
            catch (Throwable e) {
                this._thrownException = e;
                this._actualConnectionLocale = null;
                _logger.warn("Ignoring error trying to configure server locale to be '" + this._connectionLocale + "'.", e);
            }
            ConnectionResources.logConnectionAcquired(this._connection);
            try {
                this._actualLogicalServer = config.getLogicalServer();
            }
            catch (Throwable e) {
                this._thrownException = e;
                this._actualLogicalServer = this._logicalServer;
                _logger.warn("Ignoring error trying to get configured logical server.", e);
            }
            if (_perfCLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                String serverName = "";
                if (this._actualLogicalServer != null) {
                    try {
                        serverName = this._actualLogicalServer.getName();
                    }
                    catch (Throwable e) {
                        this._thrownException = e;
                        serverName = String.valueOf(this._actualLogicalServer);
                        _logger.warn("Could not get the logical server name for " + serverName);
                    }
                }
                ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms).  Connection is to " + serverName + ".  Connection is: " + this._connection.toString());
            }
        }
    }
}

