/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience.olap;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.CommandFlag;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.convenience.ElasticItem;
import com.sas.iquery.dataretrieval.convenience.GroupedFilterDataProvider;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.strategies.sas.oma.olap.util.IQISession;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

@SASScope
public class OLAPGroupedFilterDataProviderImpl
implements GroupedFilterDataProvider {
    private static final Logger _logger = LogManager.getLogger(OLAPGroupedFilterDataProviderImpl.class);
    String _cubeName = null;
    Map<DataItem, String> _dataItemsByLevel = new LinkedHashMap<DataItem, String>();
    DataSelection _dataSelection = null;
    Map<String, ElasticItem> _elasticItemCurrentLevelMap = new LinkedHashMap<String, ElasticItem>();
    List<ElasticItem> _elasticItems = new ArrayList<ElasticItem>();
    Map<FilterItem, List> _filterCurrentLevelMap = new LinkedHashMap<FilterItem, List>();
    Map<FilterItem, List<String>> _filterLevelsMap = new LinkedHashMap<FilterItem, List<String>>();
    ISession _isession = null;
    Map<String, String> _isessionFilterAdds = new LinkedHashMap<String, String>();
    Map<String, String> _isessionFilterRemoves = new LinkedHashMap<String, String>();
    Map<String, String> _levelMap = new LinkedHashMap<String, String>();
    IMDXServer _mdxServer = null;
    MetadataInterface _metadataInterface = null;
    LookThroughDataSelection _newLookThroughDataSelection = null;
    Map<ElasticItem, String> _preDrilledItems = new LinkedHashMap<ElasticItem, String>();
    Map<String, String> _preFilterItemsAdds = new LinkedHashMap<String, String>();
    Map<String, String> _preFilterRemoves = new LinkedHashMap<String, String>();
    Map<String, List<String>> _selectedItems = new LinkedHashMap<String, List<String>>();
    RetrievalPolicy _retrievalPolicy = new RetrievalPolicy();
    BusinessGroup _thisGroup = null;
    Locale _connectionLocale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLAPGroupedFilterDataProviderImpl(DataSelection ds, BusinessGroup group) throws DataRetrievalException {
        if (group.getType() != BusinessGroup.Type.ELASTIC_FILTER) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNotElastic.txt", new java.lang.Object[0]));
        }
        this._thisGroup = group;
        this._dataSelection = ds;
        this._connectionLocale = LocaleUtilities.getDefaultComputationalLocale(ds);
        DataSourceCube dataCube = null;
        try {
            dataCube = OLAPConnectionInfoUtil.getCube(ds);
        }
        catch (GenerationException e1) {
            throw new DataRetrievalException(e1);
        }
        this._connectionLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, this._connectionLocale, this._connectionLocale);
        this._retrievalPolicy.setPolicyValue(0);
        DataSourceCube cube = null;
        try {
            cube = OLAPConnectionInfoUtil.getCube(ds);
        }
        catch (GenerationException e) {
            throw new DataRetrievalException(e);
        }
        try {
            this._cubeName = cube.getCubeName();
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        OLAPConnectionResource olapConnection = null;
        try {
            olapConnection = OLAPConnectionInfoUtil.getConnection(this._dataSelection, this._retrievalPolicy, this._connectionLocale);
        }
        catch (GenerationException e) {
            throw new DataRetrievalException(e);
        }
        catch (IQueryServicesException e) {
            throw new DataRetrievalException(e);
        }
        Object connection = olapConnection.getObject();
        this._mdxServer = IOMServerUtils.GetIMDXServer(connection);
        boolean buildFailed = true;
        try {
            this.build();
            buildFailed = false;
        }
        finally {
            if (buildFailed) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilterToISession(ISession iSession, String command) throws GenerationException {
        if (command.length() > 0) {
            ISession iSession2 = iSession;
            synchronized (iSession2) {
                try {
                    iSession.MDXCommand(command, CommandFlag.CommandFlagExecute);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("MDX pass to ISession: " + command);
                    }
                    MDXGenerationUtil.applyDebugStatement("Added parent filter:" + command, this.getClass());
                }
                catch (GenericError e) {
                    _logger.error(command);
                    throw new GenerationException(e);
                }
            }
        }
    }

    private void build() throws DataRetrievalException {
        try {
            ElasticItem elasticItem;
            FilterItem filterItem;
            this._isession = ConnectionResources.newISession(this._mdxServer, this._connectionLocale);
            List<BusinessModelObject> groupItems = this._thisGroup.getItems();
            LinkedHashMap<FilterItem, ElasticItem> initialLevelElasticItems = new LinkedHashMap<FilterItem, ElasticItem>();
            this._newLookThroughDataSelection = DataSelectionFactory.newLookThroughDataSelection(this._dataSelection);
            ArrayList<FilterItem> filters = new ArrayList<FilterItem>(this._dataSelection.getEffectiveFilters());
            for (BusinessModelObject businessModelObject : groupItems) {
                filterItem = (FilterItem)businessModelObject;
                elasticItem = new ElasticItem(filterItem);
                DataItem elasticDataItem = elasticItem.getFilterDataItem();
                ExpressionInterface expression = elasticDataItem.getExpression();
                if (expression instanceof Hierarchy) {
                    this._newLookThroughDataSelection.setLabel("ElasticItem" + elasticDataItem.getLabel());
                    DataItemReference dataItemReference = this._newLookThroughDataSelection.newDataItemReference(elasticDataItem);
                    this._newLookThroughDataSelection.addBusinessItem(dataItemReference);
                    this._newLookThroughDataSelection.addResultItem(dataItemReference, Role.COLUMN);
                    String hierarchyName = ((Hierarchy)expression).getHierarchyName();
                    String dimensionName = ((Hierarchy)expression).getDimensionName();
                    if (hierarchyName == null || dimensionName == null) {
                        throw new DataRetrievalException("Hierarchy name or dimension name is null.");
                    }
                    elasticItem.setDimensionName(dimensionName);
                    elasticItem.setHierarchyName(hierarchyName);
                    for (FilterItem filter : filters) {
                        ExpressionInterface filterExpression = filter.getExpression();
                        DataItem filterDataItem = null;
                        if ((!(filterExpression instanceof MemberFilterExpression) || filterExpression instanceof BusinessGroupMemberFilterExpression) && !(filterExpression instanceof SlicerFilterExpression)) continue;
                        BaseFilterExpression baseFilter = (BaseFilterExpression)filterExpression;
                        ExpressionInterface whatToCompare = baseFilter.getWhatToCompare();
                        while (whatToCompare instanceof DataItemReference) {
                            filterDataItem = ((DataItemReference)whatToCompare).getBaseDataItem();
                            whatToCompare = filterDataItem;
                        }
                        if (!(whatToCompare instanceof DataItem) || !(filterDataItem = (DataItem)whatToCompare).equals(elasticDataItem)) continue;
                        this.defineAnInitialMemberLevelStartingPoint(this._isession, filterExpression, elasticItem);
                        filters.remove(filter);
                        break;
                    }
                    List<StepInterface> steps = elasticDataItem.getSteps();
                    for (StepInterface step : steps) {
                        this.defineAnInitialMemberLevelStartingPoint(this._isession, step, elasticItem);
                    }
                    initialLevelElasticItems.put(filterItem, elasticItem);
                    continue;
                }
                _logger.error((java.lang.Object)IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNotHier.txt", new java.lang.Object[0]));
            }
            this._metadataInterface = ConnectionResources.newIQMetadata(this._isession, this._connectionLocale);
            for (Map.Entry entry : initialLevelElasticItems.entrySet()) {
                filterItem = (FilterItem)entry.getKey();
                elasticItem = (ElasticItem)entry.getValue();
                List<String> levelsForFilter = this.buildElasticItemForEachLevel(this._metadataInterface, elasticItem, filterItem);
                this._filterLevelsMap.put(filterItem, levelsForFilter);
            }
        }
        catch (OLAPException e) {
            throw new DataRetrievalException(e);
        }
        catch (GenerationException e) {
            throw new DataRetrievalException(e);
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        catch (IQueryServicesException e) {
            throw new DataRetrievalException(e);
        }
        catch (GenericError e) {
            throw new DataRetrievalException(e);
        }
    }

    private List<String> buildElasticItemForEachLevel(MetadataInterface _metadataInterface, ElasticItem elasticItem, FilterItem filterItem) throws DataRetrievalException {
        LevelInterface[] levels;
        Filter filter = new Filter();
        ArrayList<String> levelsForFilter = new ArrayList<String>();
        filter.setCubeName(this._cubeName);
        filter.setHierarchyName(elasticItem.getHierarchyName());
        filter.setDimensionName(elasticItem.getDimensionName());
        try {
            levels = _metadataInterface.getLevels(filter);
        }
        catch (OLAPException e) {
            throw new DataRetrievalException(e);
        }
        try {
            int end = levels.length;
            int ct = 1;
            if (elasticItem.getLevel() == null) {
                LevelInterface level = levels[0];
                if (levels.length > 1) {
                    ++ct;
                    level = levels[1];
                } else {
                    _logger.error((java.lang.Object)IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplOnlyAll.txt" + level.getHierarchy(), new java.lang.Object[0]));
                }
                String unalteredLevelName = level.getUniqueName();
                String unalteredLevelLabel = level.getLabel();
                this._levelMap.put(unalteredLevelName, unalteredLevelLabel);
                levelsForFilter.add(unalteredLevelLabel);
                this._dataItemsByLevel.put(elasticItem.getFilterDataItem(), unalteredLevelName);
                this._elasticItemCurrentLevelMap.put(unalteredLevelName, elasticItem);
                elasticItem.setLevel(unalteredLevelName);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Level: " + unalteredLevelName);
                }
                ArrayList<ElasticItem> elastics = new ArrayList<ElasticItem>();
                elastics.add(elasticItem);
                this.buildIncludeExclude(elasticItem, _metadataInterface);
                for (int i = ct; i < end; ++i) {
                    ElasticItem elasticItem2 = new ElasticItem(filterItem);
                    elasticItem2.setDimensionName(elasticItem.getDimensionName());
                    elasticItem2.setHierarchyName(elasticItem.getHierarchyName());
                    String levelUniqueName = levels[i].getUniqueName();
                    String levelLabel = levels[i].getLabel();
                    elasticItem2.setLevel(levelUniqueName);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Level: " + levelUniqueName);
                    }
                    elastics.add(elasticItem2);
                    this._elasticItemCurrentLevelMap.put(levelUniqueName, elasticItem2);
                    this._levelMap.put(levelUniqueName, levelLabel);
                    levelsForFilter.add(levelLabel);
                    this.buildIncludeExclude(elasticItem2, _metadataInterface);
                }
                this._elasticItems.addAll(elastics);
            } else {
                String adjustedLevelName = this.getCurrentLevelLabel(filterItem);
                int check = 1;
                for (LevelInterface level : levels) {
                    if (level.getUniqueName().equalsIgnoreCase(adjustedLevelName)) {
                        levelsForFilter.add(level.getLabel());
                        ct = check;
                        break;
                    }
                    ++check;
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Level: " + adjustedLevelName);
                }
                ArrayList<ElasticItem> elastics = new ArrayList<ElasticItem>();
                elastics.add(elasticItem);
                String drillName = this._preDrilledItems.get(elasticItem);
                int ctt = 0;
                for (int i = ct; i < end; ++i) {
                    ElasticItem elasticItem2 = new ElasticItem(filterItem);
                    elasticItem2.setDimensionName(elasticItem.getDimensionName());
                    elasticItem2.setHierarchyName(elasticItem.getHierarchyName());
                    String levelUniqueName = levels[i].getUniqueName();
                    String levelLabel = levels[i].getLabel();
                    elasticItem2.setLevel(levelUniqueName);
                    if (ctt == 0) {
                        this.setCurrentLevel(filterItem, levelUniqueName);
                        elasticItem2.setLevel(levelUniqueName);
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Level: " + levelUniqueName);
                    }
                    elastics.add(elasticItem2);
                    this._levelMap.put(levelUniqueName, levelLabel);
                    this._elasticItemCurrentLevelMap.put(levelUniqueName, elasticItem2);
                    levelsForFilter.add(levelLabel);
                    Filter filter3 = new Filter();
                    filter3.setCubeName(this._cubeName);
                    filter3.setLevelName(levelUniqueName);
                    if (drillName != null) {
                        filter3.setUniqueMemberName(drillName);
                        filter3.setTreeOperator(Filter.DESCENDENTS_TREE_OPERATOR);
                        MemberInterface[] membersOfChildren = _metadataInterface.getMembers(filter3, 0, -1);
                        Map<String, String> original = elasticItem2.getOriginalIncludedItems();
                        Map<String, String> included = elasticItem2.getIncludedItems();
                        if (membersOfChildren != null) {
                            for (MemberInterface member : membersOfChildren) {
                                original.put(member.getUniqueName(), member.getName());
                                included.put(member.getUniqueName(), member.getName());
                            }
                        }
                    } else {
                        this.buildIncludeExclude(elasticItem2, _metadataInterface);
                    }
                    ++ctt;
                }
                this._elasticItems.addAll(elastics);
            }
        }
        catch (OLAPException e) {
            throw new DataRetrievalException(e);
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        return levelsForFilter;
    }

    private void buildIncludeExclude(ElasticItem elasticItem, MetadataInterface metadataInterface) throws DataRetrievalException {
        try {
            String levelName = elasticItem.getLevel();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Level: " + levelName);
            }
            Filter filter = new Filter();
            filter.setCubeName(this._cubeName);
            filter.setHierarchyName(elasticItem.getHierarchyName());
            filter.setDimensionName(elasticItem.getDimensionName());
            filter.setUniqueLevelName(levelName);
            MemberInterface[] members = metadataInterface.getMembers(filter, 0, -1);
            Map<String, String> orginalIncludedItems = elasticItem.getOriginalIncludedItems();
            Map<String, String> includedItems = elasticItem.getIncludedItems();
            if (orginalIncludedItems.size() == 0) {
                for (MemberInterface member : members) {
                    orginalIncludedItems.put(member.getUniqueName(), member.getName());
                    includedItems.put(member.getUniqueName(), member.getName());
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug(member.getUniqueName() + ":" + member.getName());
                }
            }
            ArrayList<String> selectUNames = new ArrayList<String>(elasticItem.getIncludedItems().keySet());
            String keySelected = elasticItem.getDimensionName() + elasticItem.getHierarchyName() + levelName;
            this._selectedItems.put(keySelected, selectUNames);
        }
        catch (OLAPException e) {
            throw new DataRetrievalException(e);
        }
    }

    private void defineAnInitialMemberLevelStartingPoint(ISession iSession, java.lang.Object nonElasticPreviousFilter, ElasticItem elasticItem) throws GenerationException, DataRetrievalException {
        IQMetadataInterface metadataInterface;
        block27: {
            String dimensionName = elasticItem.getDimensionName();
            String hierarchyName = elasticItem.getHierarchyName();
            String keyToDLL = dimensionName + hierarchyName;
            boolean hasRevisedStartingPoint = false;
            boolean parentFilter = false;
            boolean isDrilled = false;
            String startingPointName = null;
            metadataInterface = null;
            try {
                MemberFilterExpression mfe;
                boolean hasMembers;
                metadataInterface = ConnectionResources.newIQMetadata(iSession, this._connectionLocale);
                Filter firstFilter = new Filter();
                firstFilter.setCubeName(this._cubeName);
                firstFilter.setDimensionName(dimensionName);
                firstFilter.setHierarchyName(hierarchyName);
                HierarchyInterface hierarchy = metadataInterface.getHierarchy(firstFilter);
                String hierUName = hierarchy.getUniqueName();
                List<String> filteredMembers = null;
                if (nonElasticPreviousFilter instanceof DataItemNavigationFilter) {
                    DataItemNavigationFilter dnf = (DataItemNavigationFilter)nonElasticPreviousFilter;
                    if (dnf.getNavigationFilterType() == 4 && dnf.getActionType() == 0) {
                        hasRevisedStartingPoint = true;
                        DataItemNavigationFilter navFilter = (DataItemNavigationFilter)nonElasticPreviousFilter;
                        startingPointName = navFilter.getNavigationName();
                        if (startingPointName != null) {
                            isDrilled = true;
                        }
                    }
                } else if (nonElasticPreviousFilter instanceof MemberFilterExpression && (hasMembers = this.hasMembersInExpression(mfe = (MemberFilterExpression)nonElasticPreviousFilter, elasticItem))) {
                    parentFilter = true;
                    hasRevisedStartingPoint = true;
                    java.lang.Object exprText = hierarchy.getUniqueName() + ".members";
                    String memberName = hierarchy.getUniqueName();
                    LevelInterface[] levels = metadataInterface.getLevels(firstFilter);
                    if (elasticItem.getLevel() == null) {
                        LevelInterface level = levels[0];
                        if (levels.length > 1) {
                            level = levels[1];
                            startingPointName = memberName = level.getUniqueName();
                            exprText = memberName + ".members";
                        } else {
                            _logger.error((java.lang.Object)IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplOnlyAll.txt" + level.getHierarchy(), new java.lang.Object[0]));
                        }
                    }
                    String coreExpression = MDXGenerationUtil.buildMemberQuery((String)exprText, this._cubeName, memberName, false);
                    filteredMembers = this.getFilterMemberMDX(mfe, coreExpression);
                }
                if (!hasRevisedStartingPoint) break block27;
                StringBuilder filterClause = new StringBuilder();
                filterClause.delete(0, filterClause.length());
                filterClause.append("FILTERED_TOTAL ADD ").append(MDXGenerationUtil.NEWLINE).append(this._cubeName).append(" ").append(hierUName).append(" '{");
                if (parentFilter && filteredMembers != null) {
                    int ct = 1;
                    for (String memberFiltered : filteredMembers) {
                        filterClause.append(memberFiltered);
                        if (ct < filteredMembers.size()) {
                            filterClause.append(", ");
                        }
                        ++ct;
                    }
                } else if (isDrilled) {
                    filterClause.append(startingPointName).append(", Descendants(").append(startingPointName).append(")");
                    this._preDrilledItems.put(elasticItem, startingPointName);
                }
                filterClause.append("}'");
                StringBuilder filterClause2 = new StringBuilder();
                filterClause2.delete(0, filterClause2.length());
                filterClause2.append("FILTERED_TOTAL REMOVE ").append(MDXGenerationUtil.NEWLINE).append(this._cubeName).append(" ").append(hierUName);
                this._preFilterRemoves.put(keyToDLL, filterClause2.toString());
                this._preFilterItemsAdds.put(keyToDLL, filterClause.toString());
                this.applyFilterToISession(iSession, filterClause.toString());
                if (parentFilter) {
                    LevelInterface[] levels = metadataInterface.getLevels(firstFilter);
                    int ct = 0;
                    for (LevelInterface level : levels) {
                        if (level.getMemberCount() > 0 && ct > 0) {
                            String levelUniqueName = level.getUniqueName();
                            elasticItem.setLevel(levelUniqueName);
                            this._levelMap.put(levelUniqueName, level.getLabel());
                            this.buildIncludeExclude(elasticItem, metadataInterface);
                            break block27;
                        }
                        ++ct;
                    }
                    break block27;
                }
                if (isDrilled) {
                    Filter drillFilter = new Filter();
                    drillFilter.setCubeName(this._cubeName);
                    String levelUniqueName = null;
                    drillFilter.setUniqueMemberName(startingPointName);
                    drillFilter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
                    MemberInterface[] membersOfChildren = metadataInterface.getMembers(drillFilter, 0, -1);
                    if (membersOfChildren.length > 0) {
                        MemberInterface memberFirst = membersOfChildren[0];
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Elastic Item is started on the level: " + memberFirst.getUniqueName());
                        }
                        LevelInterface level = memberFirst.getLevel();
                        levelUniqueName = level.getUniqueName();
                        this._levelMap.put(levelUniqueName, level.getLabel());
                        elasticItem.setLevel(levelUniqueName);
                        this.setCurrentLevel(elasticItem.getThisFilter(), levelUniqueName);
                    } else {
                        _logger.error(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNoMember.txt", new java.lang.Object[0]) + elasticItem.getHierarchyName());
                    }
                    if (levelUniqueName != null) {
                        ArrayList<String> selectUNames = new ArrayList<String>(elasticItem.getIncludedItems().keySet());
                        String keySelected = elasticItem.getDimensionName() + elasticItem.getHierarchyName() + levelUniqueName;
                        this._selectedItems.put(keySelected, selectUNames);
                    }
                } else if (_logger.isDebugEnabled()) {
                    _logger.debug("No drill navigation step");
                }
            }
            catch (OLAPException e) {
                try {
                    throw new GenerationException(e);
                }
                catch (Throwable throwable) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadataInterface);
                    throw throwable;
                }
            }
        }
        BusinessQueryOLAPUtil.releaseMetadataInterface(metadataInterface);
    }

    @Override
    public void dispose() {
        this._newLookThroughDataSelection.dispose();
        BusinessQueryOLAPUtil.releaseMetadataInterface(this._metadataInterface);
        this._metadataInterface = null;
        if (this._isession != null) {
            if (this._isession instanceof IQISession) {
                ((IQISession)this._isession).releaseISessionResources();
            }
            try {
                ISession clearSession;
                Metadata.clearCache((java.lang.Object)this._isession, (int)2);
                if (this._isession instanceof IQISession && (clearSession = ((IQISession)this._isession).getISession()) != null) {
                    Metadata.clearCache((java.lang.Object)clearSession, (int)2);
                }
            }
            catch (OLAPException e) {
                _logger.error(e.getLocalizedMessage());
            }
            try {
                this._isession.Close();
            }
            catch (GenericError e) {
                _logger.error(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public String getCurrentLevelLabel(FilterItem filterItem) {
        String returnValue = null;
        try {
            DataItem dataItem = this.getFilterDataItem(filterItem);
            returnValue = this._dataItemsByLevel.get(dataItem);
        }
        catch (DataRetrievalException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return returnValue;
    }

    @Override
    public Map<String, String> getExcludedValues(FilterItem filterItem) {
        String levelUniqueName = this.getCurrentLevelLabel(filterItem);
        ElasticItem elasticItem = this._elasticItemCurrentLevelMap.get(levelUniqueName);
        return elasticItem.getExcludedItems();
    }

    private DataItem getFilterDataItem(FilterItem filterItem) throws DataRetrievalException {
        BusinessGroupMemberFilterExpression mfe;
        ExpressionInterface obj;
        DataItem dataItem = null;
        ExpressionInterface expression = filterItem.getExpression();
        if (expression instanceof BusinessGroupMemberFilterExpression && (obj = (mfe = (BusinessGroupMemberFilterExpression)expression).getWhatToCompare()) instanceof DataItem) {
            dataItem = (DataItem)obj;
        }
        if (dataItem == null) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNoMemberFilter.txt", new java.lang.Object[0]));
        }
        return dataItem;
    }

    @Override
    public String getFilterLabel(FilterItem filter) {
        return filter.getLabel();
    }

    private List<String> getFilterMemberMDX(MemberFilterExpression mfe, String coreExpression) throws GenerationException {
        ArrayList<String> filterStrings = new ArrayList<String>();
        if (mfe.getResources(Prompt.class, 65535).size() > 0) {
            ArrayList promptList2 = new ArrayList();
            String memberFilterString = MemberFilter.getMDXExpression(this._dataSelection, coreExpression, mfe, promptList2);
            if (!filterStrings.contains(memberFilterString)) {
                filterStrings.add(memberFilterString);
                StringBuilder valueWithAttributes = new StringBuilder();
                valueWithAttributes.append(MDXGenerationUtil.NEWLINE).append("Descendants(").append(memberFilterString).append(")");
                filterStrings.add(valueWithAttributes.toString());
            }
        } else {
            String memberFilterString = MemberFilter.getMDXExpression(this._dataSelection, coreExpression, mfe);
            if (!filterStrings.contains(memberFilterString)) {
                filterStrings.add(memberFilterString);
                StringBuilder valueWithAttributes = new StringBuilder();
                valueWithAttributes.append(MDXGenerationUtil.NEWLINE).append("Descendants(").append(memberFilterString).append(")");
                filterStrings.add(valueWithAttributes.toString());
            }
        }
        return filterStrings;
    }

    @Override
    public List<FilterItem> getGroupedFilters(BusinessGroup group) {
        ArrayList<FilterItem> returnValue = new ArrayList<FilterItem>();
        List<BusinessModelObject> groupItems = group.getItems();
        for (BusinessModelObject groupItem : groupItems) {
            FilterItem filterItem = (FilterItem)groupItem;
            returnValue.add(filterItem);
        }
        return returnValue;
    }

    @Override
    public Map<String, String> getIncludedValues(FilterItem filterItem) {
        Map<String, String> returnValue = null;
        String levelUniqueName = this.getCurrentLevelLabel(filterItem);
        ElasticItem elasticItem = this._elasticItemCurrentLevelMap.get(levelUniqueName);
        returnValue = elasticItem.getIncludedItems();
        return returnValue;
    }

    @Override
    public List<String> getLevelLabels(FilterItem filter) {
        return this._filterLevelsMap.get(filter);
    }

    private void getOLAPResultsPopulateValueList(TupleInterface[] element, String mdx, ElasticItem elasticItem, Map<String, String> originalIncludedItems) throws DataRetrievalException {
        if (element.length > 0) {
            MDXGenerationUtil.applyDebugStatement("MDX generated for get members: " + mdx, IQDataServices.class);
            Map<String, String> includedItems = elasticItem.getIncludedItems();
            includedItems.clear();
            try {
                for (int i = 0; i < element.length; ++i) {
                    TupleElementInterface[] tupleElement = element[i].getElements(0, 1);
                    String uniqueName = tupleElement[0].getName();
                    String labelName = tupleElement[0].getLabel();
                    includedItems.put(uniqueName, labelName);
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug("Tuple: " + uniqueName + " " + labelName);
                }
            }
            catch (OLAPException e) {
                _logger.error(mdx);
                throw new DataRetrievalException(e);
            }
            this.processExcludedItems(elasticItem, originalIncludedItems, includedItems);
        }
    }

    private boolean hasMembersInExpression(MemberFilterExpression mfe, ElasticItem elastic) throws GenerationException {
        boolean memberFilterHasValues = false;
        try {
            List<ExpressionInterface> membersExpressions = mfe.getMemberNames();
            if (membersExpressions.size() > 0) {
                ExpressionInterface expression = membersExpressions.get(0);
                memberFilterHasValues = true;
                if (expression instanceof Prompt) {
                    PromptDefinitionInterface promptDefinition;
                    List<Prompt> pl = elastic.getThisFilter().getResources(Prompt.class, 0);
                    PromptValuesInterface promptValues = this._dataSelection.getPromptValues();
                    List pvalue = promptValues.getPromptValueAsList(promptDefinition = ((Prompt)expression).getPromptDefinition());
                    if (pvalue.size() == 1) {
                        Prompt p = pl.get(0);
                        if (ExpressionUtil.returnsSpecialValuesALL(p, this._dataSelection)) {
                            memberFilterHasValues = false;
                        }
                    } else if (pvalue.size() == elastic.getOriginalIncludedItems().size()) {
                        memberFilterHasValues = false;
                    }
                } else if (membersExpressions.size() == elastic.getOriginalIncludedItems().size()) {
                    memberFilterHasValues = false;
                }
            }
        }
        catch (PromptValueNotFoundException e) {
            throw new GenerationException(e);
        }
        return memberFilterHasValues;
    }

    private void processExcludedItems(ElasticItem elasticItem, Map<String, String> originalElasticItems, Map<String, String> elasticsOriginalItems) {
        Map<String, String> excluded = elasticItem.getExcludedItems();
        excluded.clear();
        ArrayList<String> originalItems = new ArrayList<String>(originalElasticItems.keySet());
        for (String item : originalItems) {
            if (elasticsOriginalItems.containsKey(item)) continue;
            excluded.put(item, originalElasticItems.get(item));
        }
    }

    public void refresh(BusinessGroup group) throws DataRetrievalException {
        List<BusinessModelObject> groupItems = group.getItems();
        for (BusinessModelObject groupItem : groupItems) {
            FilterItem filterItem = (FilterItem)groupItem;
            this.refresh(filterItem);
        }
    }

    @Override
    public void refresh(FilterItem activeFilter) throws DataRetrievalException {
        try {
            String levelUniqueName = this.getCurrentLevelLabel(activeFilter);
            ElasticItem activeElasticItem = this._elasticItemCurrentLevelMap.get(levelUniqueName);
            if (activeElasticItem == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNullElastic.fmt.txt", levelUniqueName);
                throw new GenerationException(mft);
            }
            this.restrictQueryForActiveFilter(this._isession, this._metadataInterface, activeElasticItem, activeFilter);
            String keyForDLL = activeElasticItem.getDimensionName() + activeElasticItem.getHierarchyName();
            String definitionOfDLL = this._isessionFilterAdds.get(keyForDLL);
            if (definitionOfDLL != null) {
                this.applyFilterToISession(this._isession, definitionOfDLL);
            }
            ArrayList<ElasticItem> effectedElasticItems = new ArrayList<ElasticItem>();
            for (ElasticItem effectedElasticItem : this._elasticItems) {
                String levelUname = this.getCurrentLevelLabel(effectedElasticItem.getThisFilter());
                if (effectedElasticItem.getHierarchyName().equals(activeElasticItem.getHierarchyName()) || !effectedElasticItem.getLevel().equals(levelUname)) continue;
                effectedElasticItems.add(effectedElasticItem);
            }
            for (ElasticItem effectedElasticItem : effectedElasticItems) {
                DataItem elasticDataItem = effectedElasticItem.getFilterDataItem();
                Map<String, String> originalItemsMinusIncludedKey = effectedElasticItem.getOriginalIncludedItems();
                ExpressionInterface expression = elasticDataItem.getExpression();
                if (!(expression instanceof Hierarchy)) continue;
                String memberName = this.getCurrentLevelLabel(effectedElasticItem.getThisFilter());
                String coreExpression = memberName + ".members";
                FilterItem effectedFilterItem = effectedElasticItem.getThisFilter();
                MemberFilterExpression mfe = (MemberFilterExpression)effectedFilterItem.getExpression();
                boolean hasMembers = this.hasMembersInExpression(mfe, effectedElasticItem);
                String keySelected = effectedElasticItem.getDimensionName() + effectedElasticItem.getHierarchyName() + effectedElasticItem.getLevel();
                List<String> selectedItems = this._selectedItems.get(keySelected);
                if (hasMembers) {
                    if (selectedItems != null) {
                        selectedItems.clear();
                    } else {
                        selectedItems = new ArrayList<String>();
                    }
                    List<ExpressionInterface> expressionValues = mfe.getMemberNames();
                    for (ExpressionInterface expressionValue : expressionValues) {
                        String valueString = MDXGenerationUtil.getExpressionValue(expressionValue, this._dataSelection, mfe.getMemberLocale());
                        if (expressionValue instanceof Prompt) {
                            List pvalue;
                            PromptValuesInterface promptValues = this._dataSelection.getPromptValues();
                            PromptDefinitionInterface promptDefinition = ((Prompt)expressionValue).getPromptDefinition();
                            try {
                                pvalue = promptValues.getPromptValueAsList(promptDefinition);
                            }
                            catch (PromptValueNotFoundException e) {
                                throw new GenerationException(e);
                            }
                            if (pvalue.size() != 1) continue;
                            java.lang.Object object = pvalue.get(0);
                            if (object.equals(SpecialValues.ALL)) {
                                selectedItems.addAll(effectedElasticItem.getOriginalIncludedItems().values());
                                continue;
                            }
                            selectedItems.add((String)object);
                            continue;
                        }
                        selectedItems.add(valueString);
                    }
                    this._selectedItems.put(keySelected, selectedItems);
                }
                String memberFilterString = MemberFilter.getMDXExpression(this._dataSelection, coreExpression, mfe);
                String mdx = MDXGenerationUtil.buildMemberQuery(memberFilterString, this._cubeName, memberName, false);
                this.runQueryGetMembers(this._isession, mdx, effectedElasticItem, originalItemsMinusIncludedKey, hasMembers);
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug(mdx);
            }
        }
        catch (GenerationException e) {
            throw new DataRetrievalException(e);
        }
    }

    public String getActiveFilterString() {
        StringBuilder builder = new StringBuilder();
        for (String value : this._isessionFilterAdds.values()) {
            builder.append("ISession: ").append(value).append(MDXGenerationUtil.NEWLINE);
        }
        return builder.toString();
    }

    public String getActiveFilterSelection(FilterItem filter) {
        StringBuilder builder = new StringBuilder();
        String levelUniqueName = this.getCurrentLevelLabel(filter);
        ElasticItem elasticItem = this._elasticItemCurrentLevelMap.get(levelUniqueName);
        String selKey = elasticItem.getDimensionName() + elasticItem.getHierarchyName() + levelUniqueName;
        List<String> values = this._selectedItems.get(selKey);
        for (String value : values) {
            builder.append("Elastic: ").append(levelUniqueName).append(":").append(value).append(MDXGenerationUtil.NEWLINE);
        }
        return builder.toString();
    }

    @Override
    public void reset() throws DataRetrievalException {
        this._dataItemsByLevel.clear();
        this._elasticItemCurrentLevelMap.clear();
        this._elasticItems.clear();
        this._filterCurrentLevelMap.clear();
        this._filterLevelsMap.clear();
        this._isessionFilterAdds.clear();
        this._isessionFilterRemoves.clear();
        this._levelMap.clear();
        this._preDrilledItems.clear();
        this._selectedItems.clear();
        this.dispose();
        boolean buildFailed = true;
        try {
            this.build();
            buildFailed = false;
        }
        finally {
            if (buildFailed) {
                this.dispose();
            }
        }
    }

    private void restrictQueryForActiveFilter(ISession iSession, MetadataInterface metadataInterface, ElasticItem elastic, FilterItem filterItem) throws GenerationException {
        ExpressionInterface filterExpression;
        String previousRemoveString;
        List<String> filterStrings = null;
        StringBuilder filterClause = new StringBuilder();
        String keyForDDL = elastic.getDimensionName() + elastic.getHierarchyName();
        if (this._isessionFilterRemoves.containsKey(keyForDDL)) {
            previousRemoveString = this._isessionFilterRemoves.get(keyForDDL);
            this.applyFilterToISession(iSession, previousRemoveString);
        }
        if (this._preFilterRemoves.containsKey(keyForDDL)) {
            previousRemoveString = this._preFilterRemoves.get(keyForDDL);
            this.applyFilterToISession(iSession, previousRemoveString);
        }
        if ((filterExpression = elastic.getThisFilter().getExpression()) instanceof BusinessGroupMemberFilterExpression) {
            boolean memberFilterHasValues = false;
            BusinessGroupMemberFilterExpression mfe = (BusinessGroupMemberFilterExpression)filterExpression;
            memberFilterHasValues = this.hasMembersInExpression(mfe, elastic);
            if (memberFilterHasValues) {
                String memberName = this.getCurrentLevelLabel(elastic.getThisFilter());
                String exprText = memberName + ".members";
                String coreExpression = MDXGenerationUtil.buildMemberQuery(exprText, this._cubeName, memberName, false);
                filterStrings = this.getFilterMemberMDX(mfe, coreExpression);
            }
        } else {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplOnlyBusinessGroupGroup.txt", new java.lang.Object[0]));
        }
        if (filterStrings != null) {
            Filter filter2 = new Filter();
            filter2.setCubeName(this._cubeName);
            filter2.setDimensionName(elastic.getDimensionName());
            filter2.setHierarchyName(elastic.getHierarchyName());
            HierarchyInterface hierarchy = null;
            String hierarachyUniqueName = null;
            try {
                hierarchy = metadataInterface.getHierarchy(filter2);
                hierarachyUniqueName = hierarchy.getUniqueName();
            }
            catch (OLAPException e) {
                throw new GenerationException(e);
            }
            if (hierarachyUniqueName != null) {
                if (filterStrings.size() > 0) {
                    filterClause.delete(0, filterClause.length());
                    filterClause.append("FILTERED_TOTAL ADD ").append(MDXGenerationUtil.NEWLINE).append(this._cubeName).append(" ").append(hierarachyUniqueName).append(" '{");
                    int ct = 1;
                    for (String filterStr : filterStrings) {
                        filterClause.append(filterStr);
                        if (ct < filterStrings.size()) {
                            filterClause.append(", ");
                        }
                        ++ct;
                    }
                    filterClause.append("}'");
                    this._isessionFilterAdds.put(keyForDDL, filterClause.toString());
                    StringBuilder filterClause2 = new StringBuilder();
                    filterClause2.delete(0, filterClause2.length());
                    filterClause2.append("FILTERED_TOTAL REMOVE ").append(MDXGenerationUtil.NEWLINE).append(this._cubeName).append(" ").append(hierarachyUniqueName);
                    this._isessionFilterRemoves.put(keyForDDL, filterClause2.toString());
                }
            } else {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("OLAPDataProviderImplNoHierName.txt", new java.lang.Object[0]));
            }
        }
    }

    private void runQueryGetMembers(ISession iSession, String mdx, ElasticItem elasticItem, Map<String, String> originalElasticItemList, boolean hasMembers) throws DataRetrievalException {
        ResultSetMetadataInterface resultSetMeta = null;
        IQOLAPDataSet olapDataSet = null;
        try {
            olapDataSet = ConnectionResources.newOLAPDataSet(iSession, 1, null);
            olapDataSet.setQueryStatement(mdx, null);
            olapDataSet.setLocale(this._connectionLocale);
            olapDataSet.executeQuery();
        }
        catch (OLAPException e) {
            _logger.error(mdx);
            if (olapDataSet != null) {
                ConnectionResources.close(olapDataSet);
            }
            throw new DataRetrievalException(e);
        }
        try {
            String[] cells = olapDataSet.getFormattedCells(0L, -1L);
            if (cells.length > 0) {
                resultSetMeta = olapDataSet.getResultSetMetadata();
                if (resultSetMeta == null) {
                    _logger.error(mdx);
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilNoOLAPDataSet.txt", new java.lang.Object[0]);
                    throw new DataRetrievalException(formatter);
                }
                TupleInterface[] element = resultSetMeta.getTuples(0, 0, -1);
                this.getOLAPResultsPopulateValueList(element, mdx, elasticItem, originalElasticItemList);
            } else {
                elasticItem.getIncludedItems().clear();
                Map<String, String> originalItems = elasticItem.getOriginalIncludedItems();
                String selKey = elasticItem.getDimensionName() + elasticItem.getHierarchyName() + this.getCurrentLevelLabel(elasticItem.getThisFilter());
                List<String> selectedItems = this._selectedItems.get(selKey);
                if (hasMembers) {
                    for (String selectedItem : selectedItems) {
                        if (!originalItems.containsKey(selectedItem)) continue;
                        elasticItem.getIncludedItems().put(selectedItem, originalItems.get(selectedItem));
                    }
                }
                Map<String, String> excluded = elasticItem.getExcludedItems();
                excluded.putAll(originalItems);
                if (hasMembers) {
                    for (String selectedItem : selectedItems) {
                        if (!originalItems.containsKey(selectedItem)) continue;
                        excluded.remove(selectedItem);
                    }
                }
            }
        }
        catch (OLAPException e) {
            _logger.error(mdx);
            throw new DataRetrievalException(e);
        }
        finally {
            block22: {
                if (olapDataSet != null) {
                    try {
                        olapDataSet.close();
                    }
                    catch (OLAPException e) {
                        _logger.error(e.getLocalizedMessage());
                        if (!_logger.isDebugEnabled()) break block22;
                        _logger.debug("Error while closing the OlapDataSet, just continue: " + e.getLocalizedMessage());
                    }
                }
            }
            if (resultSetMeta != null) {
                resultSetMeta = null;
            }
        }
    }

    @Override
    public void setCurrentLevel(FilterItem filterItem, String level) {
        try {
            DataItem dataItem = this.getFilterDataItem(filterItem);
            this._dataItemsByLevel.put(dataItem, level);
        }
        catch (DataRetrievalException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

