/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.convenience.ContextValue;
import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.relational.AbstractComparisonWithQueryResultsExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.strategies.combined.CombinedDataSelectionFactory;
import com.sas.iquery.strategies.sas.oma.CloneDataSelectionFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class HiddenValueSupport {
    private static final String MODEL_ELEMENT_BUSINESS_QUERY = "BusinessQuery";

    public BusinessQuery newCategoryQuery(List<DataItem> hiddenItems, List<ContextValue> contextValues, BusinessQuery bq) throws DataRetrievalException {
        BusinessQuery returnQuery = null;
        try {
            returnQuery = this.newQuery(false, hiddenItems, contextValues, bq);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.newQuery.Exception.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        catch (DataServicesException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.newQuery.Exception.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        return returnQuery;
    }

    public BusinessQuery newMeasureQuery(List<DataItem> hiddenItems, List<ContextValue> contextValues, BusinessQuery bq) throws DataRetrievalException {
        BusinessQuery returnQuery = null;
        try {
            returnQuery = this.newQuery(true, hiddenItems, contextValues, bq);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.newQuery.Exception.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        catch (DataServicesException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.newQuery.Exception.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        return returnQuery;
    }

    private BusinessQuery newQuery(boolean isMeasures, List<DataItem> hiddenItems, List<ContextValue> contextValues, BusinessQuery businessQuery) throws MetadataException, DataRetrievalException, DataServicesException {
        this.validateItems(isMeasures, hiddenItems);
        DataSelection cloneDS = CloneDataSelectionFactory.copyBottomUp((DataSelection)businessQuery);
        this.removeMeasureFilters(cloneDS);
        this.convertROLAPToRelational(cloneDS);
        Role inactiveRole = this.hideOriginalCategoriesMeasures(isMeasures, cloneDS);
        if (!isMeasures) {
            cloneDS.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        }
        this.setHiddenItemsOnQuery(isMeasures, hiddenItems, cloneDS, inactiveRole);
        for (SelectedItem si : cloneDS.getSelectedItems()) {
            si.setFormatType(1);
            DataItem item = si.getItem();
            item.setFormattingForced(false);
        }
        this.removeRanking(cloneDS);
        this.removeSorting(cloneDS);
        this.removeTotals(cloneDS);
        List<FilterItem> cloneDSFilters = cloneDS.getFilters();
        List<FilterItem> newFilters = this.createContextFilters((DataSelection)businessQuery, cloneDS, contextValues);
        cloneDSFilters.addAll(newFilters);
        cloneDS.setFilters(cloneDSFilters);
        List<Join> joinPath = ((ExplicitJoinPathSupport)((Object)businessQuery)).getExplicitJoinPath();
        ((ExplicitJoinPathSupport)((Object)cloneDS)).setExplicitJoinPath(joinPath);
        return cloneDS;
    }

    private void validateItems(boolean isMeasures, List<DataItem> hiddenItems) throws DataRetrievalException, MetadataException {
        if (hiddenItems == null || hiddenItems.size() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.noHiddenItems.txt", new Object[0]);
            throw new DataRetrievalException(formatter);
        }
        if (!isMeasures) {
            for (DataItem item : hiddenItems) {
                if (this.isMeasure(item)) {
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.mustBeCategories.txt", new Object[0]);
                    throw new DataRetrievalException(formatter);
                }
                if (!item.getStructure().isOLAP()) continue;
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.noOLAPItems.txt", new Object[0]);
                throw new DataRetrievalException(formatter);
            }
        } else {
            for (DataItem item : hiddenItems) {
                MessageFormatter formatter;
                if (!this.isMeasure(item)) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.mustBeMeasures.txt", new Object[0]);
                    throw new DataRetrievalException(formatter);
                }
                if (item.getStructure().isOLAP()) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.noOLAPMeasures.txt", new Object[0]);
                    throw new DataRetrievalException(formatter);
                }
                ExpressionInterface expression = item.getExpression();
                if (!(expression instanceof FractionOfTotalExpression)) continue;
                MessageFormatter formatter2 = IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport.validateItems.noFOT.txt", new Object[0]);
                throw new DataRetrievalException(formatter2);
            }
        }
    }

    private boolean isMeasure(DataItem di) {
        return di.getUsage() == DataItemActionType.USAGE_AGGREGATE;
    }

    private void removeMeasureFilters(DataSelection cloneDS) throws MetadataException, DataRetrievalException, GenerationException {
        boolean isROLAP = DataRetrievalUtil.isModelROLAP(cloneDS);
        if (isROLAP) {
            ROLAPFilterAndRankExaminer filterExaminer = new ROLAPFilterAndRankExaminer(cloneDS);
            List<FilterItem> preAggFilters = filterExaminer.getPreAggregationFilters();
            List<FilterItem> postAggSubTotalFilters = filterExaminer.getPostAggregationSubtotalFilters();
            Map<ExpressionInterface, FilterItem> splitFilterExprs = this.getSplitFilterExpressions(cloneDS, preAggFilters);
            this.findAndReplaceMeasureFilterExpressions(cloneDS, splitFilterExprs);
            splitFilterExprs.clear();
            splitFilterExprs = this.getSplitFilterExpressions(cloneDS, postAggSubTotalFilters);
            this.findAndReplaceMeasureFilterExpressions(cloneDS, splitFilterExprs);
        } else {
            List<FilterItem> filters = cloneDS.getEffectiveFilters();
            Map<ExpressionInterface, FilterItem> splitFilterExprs = this.getSplitFilterExpressions(cloneDS, filters);
            this.findAndReplaceMeasureFilterExpressions(cloneDS, splitFilterExprs);
        }
    }

    private Map<ExpressionInterface, FilterItem> getSplitFilterExpressions(DataSelection ds, List<FilterItem> filters) {
        LinkedHashMap<ExpressionInterface, FilterItem> splitFilterExprs = new LinkedHashMap<ExpressionInterface, FilterItem>();
        for (FilterItem filterItem : filters) {
            this.splitFilters(filterItem, splitFilterExprs);
        }
        return splitFilterExprs;
    }

    private void splitFilters(FilterItem filter, Map<ExpressionInterface, FilterItem> splitFilterExpressions) {
        if (filter instanceof CompoundFilter) {
            CompoundFilter cf = (CompoundFilter)filter;
            FilterItem leftFilter = cf.getLeftFilter();
            FilterItem rightFilter = cf.getRightFilter();
            this.splitFilters(leftFilter, splitFilterExpressions);
            this.splitFilters(rightFilter, splitFilterExpressions);
        } else {
            this.splitExpressions(filter, filter.getExpression(), splitFilterExpressions);
        }
    }

    private void splitExpressions(FilterItem filter, ExpressionInterface expression, Map<ExpressionInterface, FilterItem> splitFilterExpressions) {
        if (expression instanceof CompoundConditionalExpression) {
            CompoundConditionalExpression exp = (CompoundConditionalExpression)expression;
            this.splitExpressions(filter, exp.getLeftExpression(), splitFilterExpressions);
            this.splitExpressions(filter, exp.getRightExpression(), splitFilterExpressions);
        } else if (expression instanceof MultipleConditionalExpression) {
            MultipleConditionalExpression exp = (MultipleConditionalExpression)expression;
            if (exp.getExpressionCount() == 1) {
                for (int i = 0; i < exp.getExpressionCount(); ++i) {
                    this.splitExpressions(filter, exp.getExpression(i), splitFilterExpressions);
                }
            }
        } else if (expression instanceof ConditionalExpressionAdapter) {
            ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)expression;
            ExpressionInterface innerExpr = cea.getExpression();
            if (innerExpr instanceof MultipleConditionalExpression || innerExpr instanceof CompoundConditionalExpression || innerExpr instanceof ConditionalExpressionAdapter) {
                this.splitExpressions(filter, innerExpr, splitFilterExpressions);
            }
        } else {
            splitFilterExpressions.put(expression, filter);
        }
    }

    private void findAndReplaceMeasureFilterExpressions(DataSelection cloneDS, Map<ExpressionInterface, FilterItem> splitFilterExprs) throws DataRetrievalException, MetadataException, GenerationException {
        for (Map.Entry<ExpressionInterface, FilterItem> entry : splitFilterExprs.entrySet()) {
            ExpressionInterface expr = entry.getKey();
            if (!this.isaMeasureFilterExpr(cloneDS, expr)) continue;
            ExpressionInterface newExpr = this.createBooleanFilterExpression(cloneDS, StringExpressionUtil.getInstance().getReadableText(expr));
            FilterItem filter = entry.getValue();
            this.replaceOldExpressionWithNew(filter, filter.getExpression(), expr, newExpr);
        }
    }

    private boolean isaMeasureFilterExpr(BusinessModel model, ExpressionInterface expression) throws DataRetrievalException {
        boolean isaMeasure = false;
        if ("HAVING".equals(this.getWhereOrHavingFilterExprType(model, expression))) {
            isaMeasure = true;
        }
        return isaMeasure;
    }

    /*
     * Unable to fully structure code
     */
    private String getWhereOrHavingFilterExprType(BusinessModel model, ExpressionInterface expression) throws DataRetrievalException {
        returnFilterType = "WHERE";
        if (expression instanceof MultipleConditionalExpression) {
            conditional = (MultipleConditionalExpression)expression;
            for (i = 0; i < conditional.getExpressionCount(); ++i) {
                expr = conditional.getExpression(i);
                filterType = this.getWhereOrHavingFilterExprType(model, expr);
                if (!"HAVING".equals(filterType)) continue;
                returnFilterType = "HAVING";
                break;
            }
            return returnFilterType;
        }
        if (expression instanceof DataBasedFilterExpression) {
            dbfe = (DataBasedFilterExpression)expression;
            filterType = "WHERE";
            expr = dbfe.getWhatToCompare();
            filterType = this.getWhereOrHavingFilterExprType(model, expr);
            if ("HAVING".equals(filterType)) {
                returnFilterType = "HAVING";
            }
            if ("WHERE".equals(filterType) && "HAVING".equals(filterType = this.getWhereOrHavingFilterExprType(model, expr = dbfe.getWhatToFilter()))) {
                returnFilterType = "HAVING";
            }
            leftExpressions = dbfe.getLeftExpression();
            rightExpressions = dbfe.getRightExpression();
            for (ExpressionInterface expr : leftExpressions) {
                filterType = this.getWhereOrHavingFilterExprType(model, expr);
                if (!"HAVING".equals(filterType)) continue;
                returnFilterType = "HAVING";
                break;
            }
            if ("WHERE".equals(filterType)) {
                for (ExpressionInterface expr : rightExpressions) {
                    filterType = this.getWhereOrHavingFilterExprType(model, expr);
                    if (!"HAVING".equals(filterType)) continue;
                    returnFilterType = "HAVING";
                    break;
                }
            }
            return returnFilterType;
        }
        leftFilterType = null;
        middleFilterType = null;
        rightFilterType = null;
        if (expression instanceof SimpleConditionalExpression_Comparison) {
            comparison = (SimpleConditionalExpression_Comparison)expression;
            left = comparison.getLeftExpression();
            right = comparison.getRightExpression();
            leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
            rightFilterType = this.getWhereOrHavingFilterExprType(model, right);
        } else if (expression instanceof SimpleConditionalExpression_Between) {
            between = (SimpleConditionalExpression_Between)expression;
            left = between.getLeftExpression();
            right = between.getRightExpression();
            middle = between.getWhatToCompare();
            leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
            middleFilterType = this.getWhereOrHavingFilterExprType(model, middle);
            rightFilterType = this.getWhereOrHavingFilterExprType(model, right);
        } else if (expression instanceof SimpleConditionalExpression_In) {
            in = (SimpleConditionalExpression_In)expression;
            middle = in.getWhatToCompare();
            middleFilterType = this.getWhereOrHavingFilterExprType(model, middle);
        } else if (expression instanceof SimpleConditionalExpression_TestForNull) {
            left = ((SimpleConditionalExpression_TestForNull)expression).getWhatToCompare();
            leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
        } else if (expression instanceof ConditionalExpressionAdapter) {
            cea = (ConditionalExpressionAdapter)expression;
            returnFilterType = this.getWhereOrHavingFilterExprType(model, cea.getExpression());
        } else if (!(expression instanceof Prompt || expression instanceof ConstantExpression || expression instanceof AbstractTimeValueExpression || expression instanceof AbstractRelativeTimeValueExpression)) {
            if (expression instanceof SimpleConditionalExpression_Like) {
                like = (SimpleConditionalExpression_Like)expression;
                left = like.getWhatToCompare();
                right = like.getPatternExpression();
                leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
                rightFilterType = this.getWhereOrHavingFilterExprType(model, right);
            } else if (expression instanceof SimpleConditionalExpression_Contains) {
                contains = (SimpleConditionalExpression_Contains)expression;
                left = contains.getWhatToCompare();
                right = contains.getWhatToContain();
                leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
                rightFilterType = this.getWhereOrHavingFilterExprType(model, right);
            } else if (expression instanceof CompoundConditionalExpression) {
                conditional = (CompoundConditionalExpression)expression;
                left = conditional.getLeftExpression();
                right = conditional.getRightExpression();
                leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
                rightFilterType = this.getWhereOrHavingFilterExprType(model, right);
            } else if (expression instanceof ResourceAwareStringExpression) {
                rase = (ResourceAwareStringExpression)expression;
                try {
                    if (rase.containsUserTypedAggregation()) {
                        returnFilterType = "HAVING";
                    }
                    left = rase.getResources(DataItem.class, 65535).iterator();
                    while (left.hasNext() && !"HAVING".equals(returnFilterType = this.getWhereOrHavingFilterExprType(model, item = left.next()))) {
                    }
                }
                catch (MetadataException e) {
                    throw new DataRetrievalException(e);
                }
            } else if (expression instanceof StringExpression) {
                try {
                    props = model.getServerProperties();
                    text = StringExpressionUtil.getInstance().getText(expression);
                    aggInExpression = props.containsAggregateFunction(text);
                    if (!aggInExpression) ** GOTO lbl143
                    returnFilterType = "HAVING";
                }
                catch (MetadataException e) {
                    throw new DataRetrievalException(e);
                }
            } else if (expression instanceof FunctionCall) {
                call = (FunctionCall)expression;
                args = call.getArguments();
                argType = null;
                for (index = 0; index < args.size(); ++index) {
                    argType = this.getWhereOrHavingFilterExprType(model, args.get(index));
                    if (!"HAVING".equals(argType)) continue;
                    returnFilterType = "HAVING";
                }
            } else if (expression instanceof DataItem) {
                item = (DataItem)expression;
                if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                    returnFilterType = "HAVING";
                } else {
                    try {
                        if (!item.containsUserTypedAggregation()) ** GOTO lbl143
                        returnFilterType = "HAVING";
                    }
                    catch (MetadataException e) {
                        throw new DataRetrievalException(e);
                    }
                }
            } else if (!(expression instanceof Column)) {
                if (expression instanceof DataItemFormattingExpression) {
                    item = ((DataItemFormattingExpression)expression).getDataItem();
                    returnFilterType = this.getWhereOrHavingFilterExprType(model, item);
                } else if (expression instanceof AbstractComparisonWithQueryResultsExpression) {
                    comparison = (AbstractComparisonWithQueryResultsExpression)expression;
                    left = comparison.getWhatToCompare();
                    leftFilterType = this.getWhereOrHavingFilterExprType(model, left);
                } else if (expression != null) {
                    throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("SQLSASFilterExaminer._examineFilterExpressions.UnknownExpression.fmt.txt", new Object[]{expression.getClass().getName()}));
                }
            }
        }
lbl143:
        // 24 sources

        if ("HAVING".equals(leftFilterType)) {
            returnFilterType = "HAVING";
        }
        if ("HAVING".equals(middleFilterType)) {
            returnFilterType = "HAVING";
        }
        if ("HAVING".equals(rightFilterType)) {
            returnFilterType = "HAVING";
        }
        return returnFilterType;
    }

    private ExpressionInterface createBooleanFilterExpression(DataSelection ds, String expressionString) throws MetadataException {
        StringExpression filterStringExpression = new StringExpression();
        boolean showFilterExpr = Boolean.getBoolean("SASQueryServices.HiddenValuesShowFilterExpressions");
        if (showFilterExpr) {
            filterStringExpression.setText("1 = 1 /* " + expressionString + " */");
        } else {
            filterStringExpression.setText("1 = 1");
        }
        return filterStringExpression;
    }

    private boolean replaceOldExpressionWithNew(FilterItem filter, ExpressionInterface filterExpr, ExpressionInterface oldExpr, ExpressionInterface newExpr) throws MetadataException {
        boolean found = false;
        if (filterExpr == oldExpr) {
            filter.setExpression(newExpr);
            found = true;
        }
        return found;
    }

    private void convertROLAPToRelational(DataSelection cloneDS) throws GenerationException {
        boolean isROLAP = DataRetrievalUtil.isModelROLAP(cloneDS);
        if (isROLAP) {
            for (SelectedItem selectedItem : cloneDS.getSelectedItems()) {
                Role siRole = selectedItem.getRole();
                if (siRole != Role.BACKGROUND || siRole != Role.HIDDEN) {
                    selectedItem.setRole(Role.COLUMN);
                    continue;
                }
                selectedItem.setRole(Role.HIDDEN);
            }
        }
    }

    private Role hideOriginalCategoriesMeasures(boolean isMeasures, DataSelection cloneDS) {
        List<SelectedItem> selectedItems = cloneDS.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            if (!isMeasures) {
                selectedItem.setRole(Role.HIDDEN);
                continue;
            }
            if (!isMeasures || !this.isMeasure(item)) continue;
            selectedItem.setRole(Role.HIDDEN);
        }
        return Role.HIDDEN;
    }

    private void setHiddenItemsOnQuery(boolean isMeasures, List<DataItem> hiddenItems, DataSelection cloneDS, Role inactiveRole) throws MetadataException {
        for (DataItem hiddenItem : hiddenItems) {
            for (SelectedItem cloneSelectedHiddenItem : cloneDS.getSelectedItems(inactiveRole)) {
                DataItem cloneItem = cloneSelectedHiddenItem.getItem();
                if (hiddenItem.getLabel().equals(cloneItem.getLabel())) {
                    cloneSelectedHiddenItem.setRole(Role.COLUMN);
                }
                if (isMeasures || !cloneItem.isActionSupported(DataItemActionType.USAGE_DETAIL)) continue;
                cloneItem.setUsage(DataItemActionType.USAGE_DETAIL);
            }
        }
    }

    private void removeRanking(DataSelection cloneDS) throws MetadataException {
        ArrayList emptySteps = new ArrayList(0);
        for (SelectedItem selectedItem : cloneDS.getSelectedItems()) {
            DataItem item = selectedItem.getItem();
            List<StepInterface> steps = item.getSteps(true);
            if (steps == null || steps.size() <= 0) continue;
            item.setSteps(emptySteps);
        }
        cloneDS.setSteps(new ArrayList<StepInterface>(0), Role.COLUMN);
        cloneDS.setSteps(new ArrayList<StepInterface>(0), Role.ROW);
    }

    private void removeSorting(DataSelection cloneDS) throws MetadataException {
        List<SelectedItem> selectedItems = cloneDS.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            item.setSortDirection(DataItemActionType.SORT_NONE);
        }
        cloneDS.setSortOrderPrecedence(Collections.emptyList());
    }

    private void removeTotals(DataSelection cloneDS) throws MetadataException {
        cloneDS.setTotalType(BusinessQuery.TOTAL_NONE, Role.COLUMN);
        cloneDS.setTotalType(BusinessQuery.TOTAL_NONE, Role.ROW);
    }

    private List<FilterItem> createContextFilters(DataSelection clientDS, DataSelection cloneDS, List<ContextValue> contextValues) throws MetadataException, DataRetrievalException {
        ArrayList<FilterItem> returnList = new ArrayList<FilterItem>();
        ArrayList<FilterItem> simpleFilters = new ArrayList<FilterItem>();
        for (ContextValue cv : contextValues) {
            FilterItem filter = this.createSimpleFilter(clientDS, cloneDS, cv);
            if (filter == null) continue;
            simpleFilters.add(filter);
        }
        if (simpleFilters.size() > 0) {
            int currentIndex = 0;
            returnList.add(this.newSimpleOrCompoundFilter(cloneDS, currentIndex, simpleFilters));
        }
        return returnList;
    }

    private FilterItem newSimpleOrCompoundFilter(BusinessModel ds, int currentIndex, List<FilterItem> inputFilter) throws MetadataException {
        FilterItem currentFilterItem = inputFilter.get(currentIndex);
        if (++currentIndex < inputFilter.size()) {
            CompoundFilter compoundFilter = ds.newCompoundFilter();
            compoundFilter.setLeftFilter(currentFilterItem);
            compoundFilter.setRelationType(ConditionalRelationType.AND);
            compoundFilter.setRightFilter(this.newSimpleOrCompoundFilter(ds, currentIndex, inputFilter));
            ds.addBusinessItem(compoundFilter);
            currentFilterItem = compoundFilter;
        }
        return currentFilterItem;
    }

    private FilterItem createSimpleFilter(DataSelection clientDS, DataSelection cloneDS, ContextValue cv) throws MetadataException, DataRetrievalException {
        FilterItem filter = null;
        DataItem di = cv.getItem();
        boolean isFormatted = cv.isFormatted();
        DataItemFormattingExpression dife = new DataItemFormattingExpression();
        DataItem equivItem = DataSelectionUtilities.getEquivalentDataItem(cloneDS, di);
        DataItemReference dir = cloneDS.newDataItemReference(equivItem);
        cloneDS.addBusinessItem(dir);
        dir.setFormat(di.getFormat());
        if (dir.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
            dir.setUsage(DataItemActionType.USAGE_DETAIL);
        }
        dife.setDataItem(dir);
        dife.setIsFormatted(isFormatted);
        ConstantExpression expr = new ConstantExpression();
        expr.setExpressionType(dife.getExpressionType());
        Object value = cv.getData();
        String string = null;
        string = value instanceof MissingValues ? MissingValues.toQueryString((MissingValues)((MissingValues)value)) : value.toString();
        expr.setValue(string);
        filter = cloneDS.newFilterItem();
        cloneDS.addBusinessItem(filter);
        ExpressionInterface filterExpression = this.createSimpleConditionalExpression(dife, expr);
        filter.setExpression(filterExpression);
        return filter;
    }

    private ExpressionInterface createSimpleConditionalExpression(ExpressionInterface left, ExpressionInterface right) {
        SimpleConditionalExpression_Comparison expression;
        SimpleConditionalExpression_Comparison scec = expression = new SimpleConditionalExpression_Comparison();
        scec.setLeftExpression(left);
        scec.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
        scec.setRightExpression(right);
        return expression;
    }

    public String getQueryPersistenceText(BusinessQuery query) throws MetadataException {
        Element element = this.getQueryPersistenceElement(query);
        return IQModelImplUtilities.toString(element);
    }

    public BusinessQuery getQuery(String queryXML, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws DataRetrievalException {
        return this._getQuery(queryXML, metadataService, session);
    }

    Element getQueryPersistenceElement(BusinessQuery query) throws MetadataException {
        Element bqElement = IQModelImplUtilities.newDocumentWithElementName(MODEL_ELEMENT_BUSINESS_QUERY);
        LinkedList<BusinessQuery> queries = new LinkedList<BusinessQuery>();
        queries.add(query);
        for (BusinessQuery parent = query.getParentQuery(); parent != null; parent = parent.getParentQuery()) {
            queries.add(0, parent);
        }
        for (BusinessQuery q : queries) {
            q.write(bqElement);
        }
        return bqElement;
    }

    private BusinessQuery _getQuery(String queryXML, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws DataRetrievalException {
        Document doc = null;
        try {
            doc = IQModelImplUtilities.newDocument(queryXML);
        }
        catch (MetadataException e) {
            throw new DataRetrievalException(e);
        }
        Element queryElement = doc.getDocumentElement();
        return this._getQuery(queryElement, metadataService, session);
    }

    private BusinessQuery _getQuery(Element queryElement, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws DataRetrievalException {
        String qeTagName = queryElement.getTagName();
        if (!qeTagName.equalsIgnoreCase(MODEL_ELEMENT_BUSINESS_QUERY)) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("HiddenValueSupport._getQuery.queryTagMissing.fmt.txt", MODEL_ELEMENT_BUSINESS_QUERY));
        }
        HashMap<BusinessModelReferenceInfo, BusinessModel> map = new HashMap<BusinessModelReferenceInfo, BusinessModel>();
        DataSelection result = null;
        NodeList queries = queryElement.getChildNodes();
        for (int i = 0; i < queries.getLength(); ++i) {
            Node qNode = queries.item(i);
            if (!(qNode instanceof Element)) continue;
            DataSelection ds = null;
            try {
                ds = CombinedDataSelectionFactory.readDataSelection((Element)qNode, map, metadataService, session);
            }
            catch (MetadataException e) {
                throw new DataRetrievalException(e);
            }
            map.put(ds.getReferenceInfo(), ds);
            result = ds;
        }
        return result;
    }
}

