/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.convenience.ByGroupData;
import com.sas.iquery.dataretrieval.convenience.ByGroupRowData;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.intelligentquery.QueryConnectionInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.CloneDataSelectionFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ByGroupDataExtractor
implements Iterable<ByGroupRowData> {
    private static final String TXT_SAS_LOG = "SAS Log:\n";
    private static final String TXT_STORED_PROCESS_LOG = "Stored Process Log:\n";
    private static final String TXT_ERROR = "ERROR: ";
    private List<DataItem> _dataItems = null;
    private ByGroupData _byGroupData = null;
    private int _columnCount = 0;
    private final StringBuffer _log = new StringBuffer();
    private String _query = null;
    private static final Logger _logger = LogManager.getLogger(ByGroupDataExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByGroupDataExtractor(BusinessQuery businessQuery, QueryConnectionInterface queryConnector) throws DataRetrievalException {
        List<DataItem> dataItems = businessQuery.getResultItems();
        this._dataItems = dataItems;
        this._columnCount = dataItems.size();
        DataSelection clonedDataSelection = null;
        try {
            clonedDataSelection = CloneDataSelectionFactory.createCloneDataSelection((DataSelection)businessQuery);
        }
        catch (GenerationException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.ByGroupDataExtractor.Generation.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        try {
            if (businessQuery.getInputStructure().isOLAP()) {
                this.prepareOLAP(clonedDataSelection, dataItems, queryConnector);
            } else {
                this.prepareSQL(clonedDataSelection, dataItems, queryConnector);
            }
        }
        finally {
            CloneDataSelectionFactory.removeOldClonesOfRelational(clonedDataSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareOLAP(BusinessQuery businessQuery, List<DataItem> dataItems, QueryConnectionInterface queryConnector) throws DataRetrievalException {
        try {
            businessQuery.setQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA, true);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareOLAP.QueryProperty.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        ResultSetInterface resultSetInterface = null;
        OLAPDataSet olapDataSet = null;
        try {
            Map<String, ResultSetInterface> resultMap;
            try {
                resultMap = queryConnector.retrieveQueryResultMap(Collections.singletonList(businessQuery));
            }
            catch (IntelligentQueryException e) {
                this.extractLog(e);
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareOLAP.Intelligent.txt", new Object[0]);
                throw new DataRetrievalException(formatter, (Throwable)e);
            }
            resultSetInterface = resultMap.get(businessQuery.getID());
            try {
                this.extactQueryAndLogs(resultSetInterface);
                olapDataSet = (OLAPDataSet)resultSetInterface.getResultSet();
            }
            catch (ExecutionException e) {
                this.extractLog(e);
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareOLAP.Execution.txt", new Object[0]);
                throw new DataRetrievalException(formatter, (Throwable)e);
            }
            this._byGroupData = new ByGroupData(dataItems, (OLAPDataSetInterface)olapDataSet);
        }
        finally {
            block20: {
                try {
                    if (olapDataSet != null) {
                        olapDataSet.close();
                    } else if (resultSetInterface != null) {
                        resultSetInterface.close();
                    }
                }
                catch (ExecutionException e) {
                    this.extractLog(e);
                    if (_logger.isEnabled(Level.ERROR)) {
                        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.close.txt", new Object[0]);
                        _logger.error((Object)formatter);
                    }
                }
                catch (OLAPException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block20;
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.close.txt", new Object[0]);
                    _logger.error((Object)formatter);
                }
            }
        }
    }

    private void prepareSQL(BusinessQuery businessQuery, List<DataItem> dataItems, QueryConnectionInterface queryConnector) throws DataRetrievalException {
        Map<String, ResultSetInterface> resultMap = null;
        ResultSet resultSet = null;
        try {
            businessQuery.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            for (SelectedItem si : businessQuery.getSelectedItems()) {
                if (si.getFormatType() == 1) continue;
                si.setFormatType(1);
            }
            resultMap = queryConnector.retrieveQueryResultMap(Collections.singletonList(businessQuery));
        }
        catch (IntelligentQueryException e) {
            this.extractLog(e);
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.Intelligent.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        catch (MetadataException e) {
            this.extractLog(e);
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.Metadata.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        ResultSetInterface resultSetInterface = resultMap.get(businessQuery.getID());
        try {
            this.extactQueryAndLogs(resultSetInterface);
            resultSet = (ResultSet)resultSetInterface.getResultSet();
            this._byGroupData = new ByGroupData(dataItems, resultSet);
        }
        catch (ExecutionException e) {
            this.extractLog(e);
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.Execution.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        finally {
            block14: {
                try {
                    resultSetInterface.close();
                }
                catch (ExecutionException e) {
                    this.extractLog(e);
                    if (!_logger.isEnabled(Level.ERROR)) break block14;
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ByGroupDataExtractor.prepareSQL.close.txt", new Object[0]);
                    _logger.error((Object)formatter);
                    throw new DataRetrievalException(formatter, (Throwable)e);
                }
            }
        }
    }

    private void extractLog(IQueryServicesException e) {
        String sasLog = e.getSASLog(true, true);
        if (sasLog != null && sasLog.trim().length() > 0) {
            this._log.append(TXT_ERROR).append(e.toString()).append('\n').append(sasLog);
        }
    }

    private void extactQueryAndLogs(ResultSetInterface resultSetInterface) throws ExecutionException {
        String saslog;
        String splog = resultSetInterface.getStoredProcessLog();
        if (splog != null && splog.trim().length() > 0) {
            this._log.append(TXT_STORED_PROCESS_LOG).append(splog);
        }
        if ((saslog = resultSetInterface.getSASLog()) != null && saslog.trim().length() > 0) {
            this._log.append(TXT_SAS_LOG).append(saslog);
        }
        this._query = resultSetInterface.getQuery();
    }

    @Override
    public Iterator<ByGroupRowData> iterator() {
        return this._byGroupData;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public List<DataItem> getDataItems() {
        return this._dataItems;
    }

    public String getQuery() {
        return this._query;
    }

    public String getLog() {
        return this._log.toString();
    }
}

