/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.convenience.ByGroupRowData;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.ChainedException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ByGroupData
implements Iterator<ByGroupRowData> {
    private int _row = 0;
    private ByGroupRowData[] _byGroupRowData = null;
    private static final Logger _logger = LogManager.getLogger(ByGroupData.class);
    private static final String MISSING_VALUE_CHAR = MissingValues.toQueryString((MissingValues)MissingValues._BLANK_);
    private static final String MISSING_VALUE_NUMERIC = MissingValues.toQueryString((MissingValues)MissingValues.Dot);

    /*
     * Unable to fully structure code
     */
    public ByGroupData(List<DataItem> dataItems, OLAPDataSetInterface olapDataSet) throws DataRetrievalException {
        super();
        resultSetMeta = null;
        try {
            resultSetMeta = olapDataSet.getResultSetMetadata();
            tuples = resultSetMeta.getTuples(0, 0, -1);
            this._byGroupRowData = new ByGroupRowData[tuples.length];
            numberOfColumns = dataItems.size();
            for (i = 0; i < tuples.length; ++i) {
                this._byGroupRowData[i] = new ByGroupRowData(numberOfColumns);
                tupleElement = tuples[i].getElements(0, -1);
                column = 0;
                lastCheck = "";
                getLabelMap = new HashMap<String, String>();
                for (elementNumber = 0; elementNumber < tupleElement.length; ++elementNumber) {
                    a = tupleElement[elementNumber].getUniqueLevelName();
                    aa = tupleElement[elementNumber].getName();
                    point = a.indexOf("].") + 1;
                    point2 = aa.lastIndexOf(".[") + 2;
                    point3 = aa.lastIndexOf("]");
                    point4 = a.lastIndexOf(".[") + 2;
                    point5 = a.lastIndexOf("]");
                    c = aa.substring(point2, point3);
                    d = a.substring(point4, point5);
                    b = a.substring(0, point);
                    buffer = new StringBuffer();
                    getIt = getLabelMap.get(b);
                    if (getIt != null && !d.equalsIgnoreCase(lastCheck)) {
                        appended = (String)getLabelMap.get(b);
                        buffer.append(appended);
                        buffer.append(".");
                    }
                    buffer.append(c);
                    lastCheck = d;
                    getLabelMap.put(b, buffer.toString());
                    if (tupleElement[elementNumber].isContextual()) continue;
                    getIt2 = dataItems.get(column);
                    startingLevel = null;
                    if (getIt2 instanceof DataItemReference) {
                        dR = (DataItemReference)getIt2;
                        try {
                            startingLevel = dR.getStartingLevelName();
                            if (startingLevel != null) ** GOTO lbl60
                            getIt3 = dR.getBaseDataItem();
                            startingLevel = getIt3.getStartingLevelName();
                        }
                        catch (MetadataException e) {
                            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupData.ByGroupData.OLAP.txt", new Object[0]), (Throwable)e);
                        }
                    } else if (getIt2 instanceof DataItem) {
                        dI = getIt2;
                        try {
                            startingLevel = dI.getStartingLevelName();
                        }
                        catch (MetadataException e) {
                            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupData.ByGroupData.OLAP.txt", new Object[0]), (Throwable)e);
                        }
                    }
lbl60:
                    // 5 sources

                    if (startingLevel == null) {
                        labelElement = tupleElement[elementNumber].getLabel();
                        this._byGroupRowData[i].setLabel(labelElement, column);
                    } else {
                        this._byGroupRowData[i].setLabel(buffer.toString(), column);
                    }
                    this._byGroupRowData[i].setValue(tupleElement[elementNumber].getName().trim(), column);
                    ++column;
                }
            }
        }
        catch (OLAPException e) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupData.ByGroupData.OLAP.txt", new Object[0]), (Throwable)e);
        }
    }

    public ByGroupData(List<DataItem> dataItems, ResultSet resultSet) throws DataRetrievalException {
        try {
            resultSet.beforeFirst();
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupData.ByGroupData.SQL.txt", new Object[0]), (Throwable)e);
        }
        ArrayList<ByGroupRowData> allRows = new ArrayList<ByGroupRowData>();
        int numberOfColumns = dataItems.size();
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                ByGroupRowData rowData = new ByGroupRowData(numberOfColumns);
                for (int column = 0; column < numberOfColumns; ++column) {
                    boolean isCharValue;
                    String label = resultSet.getString(column + 1);
                    boolean wasNull = resultSet.wasNull();
                    String columnName = metaData.getColumnName(column + 1);
                    DataItem dataItem = this.getMatchingDataItem(dataItems, columnName);
                    boolean useFormattedValue = true;
                    if (dataItem != null) {
                        useFormattedValue = GenerationUtil.useFormattedValueForReference(dataItem);
                    }
                    boolean bl = isCharValue = useFormattedValue || ExpressionUtil.getExprType(metaData.getColumnType(column + 1)) == 3;
                    if (wasNull && label == null) {
                        label = isCharValue ? MISSING_VALUE_CHAR : MISSING_VALUE_NUMERIC;
                    }
                    Object value = label;
                    if (!useFormattedValue) {
                        value = resultSet.getObject(column + 1);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("   for " + GenerationUtil.toString(dataItem) + "\n    useFormattedValue=" + useFormattedValue + ", wasNull=" + wasNull);
                            _logger.debug("    String=" + resultSet.getString(column + 1) + ", label='" + label + "'");
                        }
                        if (wasNull && value == null) {
                            Object object = value = isCharValue ? MISSING_VALUE_CHAR : MISSING_VALUE_NUMERIC;
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("    Object=" + value + " *FORCED TO MISSING VALUE*");
                            }
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("    Object=" + value + (value == null ? "" : "(" + value.getClass().getName() + ")"));
                        }
                    }
                    rowData.setValue(String.valueOf(value), column);
                    rowData.setLabel(label, column);
                }
                allRows.add(rowData);
            }
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupData.ByGroupData.ErrorReadingElement.txt", new Object[0]), (Throwable)e);
        }
        this._byGroupRowData = allRows.toArray(new ByGroupRowData[allRows.size()]);
    }

    private DataItem getMatchingDataItem(List<DataItem> dataItems, String columnName) {
        DataItem dataItem = null;
        for (DataItem item : dataItems) {
            if (!columnName.equals(item.getResultSetID())) continue;
            dataItem = item;
            break;
        }
        return dataItem;
    }

    @Override
    public boolean hasNext() {
        boolean hasMore = false;
        if (this._row < this._byGroupRowData.length) {
            hasMore = true;
        }
        return hasMore;
    }

    @Override
    public void remove() {
    }

    @Override
    public ByGroupRowData next() {
        if (this._row >= this._byGroupRowData.length) {
            String errMsg = IQDataServicesResourceBundle.getStringResource("ByGroupData.ByGroupData.NoMoreElements.txt");
            throw new NoSuchElementException(errMsg);
        }
        return this._byGroupRowData[this._row++];
    }
}

