/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryContainer;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OverrideConnectionInterface;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.services.connection.ConnectionInterface;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public class StrategySelector {
    Map<String, Class<? super StrategyInterface>> _strategyClassMap = new LinkedHashMap<String, Class<? super StrategyInterface>>();

    public StrategyInterface getStrategy(QueryContainer queryContainer) throws DataRetrievalException {
        Map<String, MLSLookup> mlsLookups;
        StpNames overrideStpNames;
        BusinessQuery iqi = queryContainer.getBusinessQuery();
        String strategyClassName = iqi.retrieveStrategyClassName();
        StrategyInterface strategy = null;
        Class<? super StrategyInterface> strategyClass = this._strategyClassMap.get(strategyClassName);
        if (strategyClass == null) {
            strategyClass = this.createStrategyClass(strategyClassName);
            strategy = this.createStrategyInstance(strategyClass);
            this._strategyClassMap.put(strategyClassName, strategyClass);
        } else {
            strategy = this.createStrategyInstance(strategyClass);
        }
        Locale overrideLocale = queryContainer.getComputationalLocale();
        if (overrideLocale != null && strategy instanceof OverrideLocaleInterface) {
            ((OverrideLocaleInterface)((Object)strategy)).setComputationalLocale(overrideLocale);
        }
        if ((overrideStpNames = queryContainer.getStpNames()) != null && strategy instanceof OverrideStpNamesInterface) {
            ((OverrideStpNamesInterface)((Object)strategy)).setStpNames(overrideStpNames);
        }
        if ((mlsLookups = queryContainer.getMLSLookups()) != null && strategy instanceof OverrideMLSLookupsInterface) {
            ((OverrideMLSLookupsInterface)((Object)strategy)).setMLSLookups(mlsLookups);
        }
        if (strategy instanceof OverrideConnectionInterface) {
            ConnectionInterface overrideConnectionInterface;
            IWorkspace overrideWorkspace = queryContainer.getWorkspace();
            if (overrideWorkspace != null) {
                ((OverrideConnectionInterface)((Object)strategy)).setWorkspace(overrideWorkspace);
            }
            if ((overrideConnectionInterface = queryContainer.getConnection()) != null) {
                ((OverrideConnectionInterface)((Object)strategy)).setConnection(overrideConnectionInterface);
            }
        }
        return strategy;
    }

    private Class<? super StrategyInterface> createStrategyClass(String strategyClassName) throws DataRetrievalException {
        Class<?> strategyClass;
        try {
            strategyClass = Class.forName(strategyClassName);
        }
        catch (ClassNotFoundException e) {
            String[] args = new String[]{strategyClassName};
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("StrategySelector.createStrategy.NoClass.fmt.txt", args));
        }
        if (strategyClassName == null) {
            String[] args = new String[]{strategyClassName};
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("StrategySelector.extractStrategy.NoStrategy.fmt.txt", args));
        }
        return strategyClass;
    }

    private StrategyInterface createStrategyInstance(Class<? super StrategyInterface> strategyClass) throws DataRetrievalException {
        StrategyInterface strategyInstance;
        try {
            strategyInstance = strategyClass.newInstance();
        }
        catch (InstantiationException e) {
            String[] args = new String[]{strategyClass.getName()};
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("StrategySelector.createStrategy.NotInstantiate.fmt.txt", args));
        }
        catch (IllegalAccessException e) {
            String[] args = new String[]{strategyClass.getName()};
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("StrategySelector.createStrategy.IllegalAccess.fmt.txt", args));
        }
        if (strategyInstance == null) {
            String[] args = new String[]{strategyClass.getName()};
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("StrategySelector.extractStrategy.NoStrategy.fmt.txt", args));
        }
        return strategyInstance;
    }
}

