/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.SASLogReader;
import com.sas.iquery.execution.instructions.SASSubmitHandler;
import com.sas.iquery.execution.util.StoredProcessUtils;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.physical.StoredProcess;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.IQProcStpV2;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.StoredProcess2_Stub;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class StoredProcessHandler {
    private DataSelection _dataSelection;
    private List<RunStoredProcess> _storedProcesses;
    private StringBuffer _lastLog = new StringBuffer();
    private static final Logger _logger = LogManager.getLogger(StoredProcessHandler.class);
    private static final Logger _perfSPLogger = LogManager.getLogger((String)"com.sas.iquery.perf.StoredProcess");

    public StoredProcessHandler(DataSelection dataSelection) throws GenerationException {
        this._dataSelection = dataSelection;
        this.initializeStoredProcessMap();
    }

    private void initializeStoredProcessMap() throws GenerationException {
        if (this._storedProcesses == null) {
            this._storedProcesses = new LinkedList<RunStoredProcess>();
        } else {
            this._storedProcesses.clear();
        }
        List<RunStoredProcess> rspList = this._dataSelection.getObjects(true, RunStoredProcess.class);
        if (!rspList.isEmpty()) {
            this._storedProcesses.addAll(rspList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStoredProcesses(ExecutionContext context) throws ExecutionException {
        boolean clearedLog = false;
        ConnectionInterface connection = context.getConnection();
        try {
            ArrayList<RunStoredProcess> v1spRules = new ArrayList<RunStoredProcess>();
            ArrayList<RunStoredProcess> v2spRules = new ArrayList<RunStoredProcess>();
            PromptValuesInterface promptValues = this._dataSelection.getPromptValues();
            for (RunStoredProcess spRule : this._storedProcesses) {
                StoredProcess spResource = spRule.getStoredProcess();
                if (spResource == null) continue;
                StoredProcessInterface spInterface = spResource.getStoredProcessInterface();
                UsageVersion usageVersion = spInterface.getUsageVersion();
                boolean is92 = usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION);
                boolean is93 = usageVersion.equals((Object)StoredProcessInterface.NINETHREE_VERSION);
                if (is92) {
                    v1spRules.add(spRule);
                }
                if (is93) {
                    v2spRules.add(spRule);
                }
                String spEntityKey = spInterface.getEntityKey();
                Entry spEntry = this.hasBeenExecuted(spEntityKey, connection);
                boolean hasAlreadyBeenExecuted = false;
                if (spEntry == null) {
                    spEntry = new Entry();
                } else {
                    hasAlreadyBeenExecuted = true;
                }
                Entry entry = spEntry;
                synchronized (entry) {
                    boolean stpIsUnchanged;
                    PromptValuesInterface spPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues(spRule, promptValues);
                    boolean notForcedToRun = context.getRetrievalPolicy().getPolicyValue() != 0;
                    boolean promptsAlreadyRun = spEntry.hasBeenConsumed(spPromptValues, this._dataSelection);
                    boolean bl = stpIsUnchanged = !StoredProcessUtils.hasStoredProcessBeenUpdated(spInterface, spInterface.getModifyDate().getTime());
                    if (hasAlreadyBeenExecuted && notForcedToRun && promptsAlreadyRun && stpIsUnchanged) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Skipping execution of stored process '" + spEntityKey + (spPromptValues != null ? "  args: " + spPromptValues.toString() : "") + "' since it has already been executed on the connection, " + connection + (spPromptValues != null ? ", with the same parameters once before" : ")"));
                        }
                        continue;
                    }
                    if (clearedLog) {
                        clearedLog = true;
                        this._lastLog.setLength(0);
                    }
                    if (is92) {
                        this.executeV1(spInterface, spEntityKey, spPromptValues, context);
                    }
                    if (is93) {
                        this.executeV2(spInterface, spEntityKey, spPromptValues, context);
                    }
                    this.registerAsCompleted(spEntityKey, spPromptValues, spEntry, connection);
                }
            }
            if (!v1spRules.isEmpty() && !v2spRules.isEmpty()) {
                _logger.warn("Both v1 and v2 stored processes found, this is potentially a problem.  The v1 will execute using the 9.2 api and the v2 using PROC STP.");
            }
        }
        catch (ServiceException e) {
            throw new ExecutionException(e);
        }
        catch (RemoteException e) {
            throw new ExecutionException(e);
        }
        catch (PromptValueNotFoundException e) {
            throw new ExecutionException(e);
        }
        catch (MetadataException e) {
            throw new ExecutionException(e);
        }
        catch (GenerationException e) {
            throw new ExecutionException(e);
        }
        catch (IllegalStateException e) {
            throw new ExecutionException(e);
        }
    }

    private void executeV1(StoredProcessInterface spInterface, String spEntityKey, PromptValuesInterface spPromptValues, ExecutionContext context) throws ServiceException, RemoteException, ExecutionException {
        ConnectionInterface connection = context.getConnection();
        StoredProcess2Interface sp = StoredProcessUtils.createStoredProcessFromMetadata(spInterface, this._dataSelection);
        LogicalServerInterface server = this.getServer(sp);
        if (server == null) {
            if (_logger.isInfoEnabled()) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.handleStoredProcesses.NoServer.txt", new Object[0]);
                _logger.info((Object)formatter);
            }
        } else {
            if (_logger.isDebugEnabled()) {
                String text = "Attempting to execute the stored process with unique key:\t" + spEntityKey;
                _logger.debug(text);
            }
            this.execute(spPromptValues, sp, connection);
        }
    }

    private void executeV2(StoredProcessInterface spInterface, String spEntityKey, PromptValuesInterface spPromptValues, ExecutionContext context) throws IllegalStateException, ServiceException, RemoteException, PromptValueNotFoundException, ExecutionException, MetadataException, GenerationException {
        Locale locale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, context);
        IQProcStpV2 iqProcStpV2 = new IQProcStpV2(this._dataSelection.getSession());
        iqProcStpV2.setStoredProcess(spInterface);
        iqProcStpV2.setExecutionContext(context);
        iqProcStpV2.setPromptValues(spPromptValues);
        iqProcStpV2.setComputationLocale(locale);
        iqProcStpV2.prepareSQL();
        SASSubmitHandler submitHandler = new SASSubmitHandler();
        if (_logger.isDebugEnabled()) {
            iqProcStpV2.setListingOnly(true);
            String spList = iqProcStpV2.write();
            submitHandler.execute(true, context, spList, true);
        }
        iqProcStpV2.setListingOnly(false);
        String spCode = iqProcStpV2.write();
        submitHandler.execute(true, context, spCode, false);
        String stpLog = this.readSASLog(context, null);
        _logger.debug(stpLog);
        if (this._lastLog.length() > 0) {
            this._lastLog.append('\n');
        }
        this._lastLog.append(stpLog);
    }

    private String readSASLog(ExecutionContext context, StringBuffer errorsFound) throws ExecutionException {
        String logLines = null;
        try {
            IWorkspace workspace = context.getWorkspace();
            ILanguageService languageService = IOMServerUtils.GetILanguageService(workspace);
            logLines = SASLogReader.getInstance().getSASLog(languageService, errorsFound);
            _logger.info(logLines);
            languageService.ResetLogLineNumbers();
        }
        catch (TransportException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
                _logger.error(formatter.toString() + ": \n" + logLines, (Throwable)e);
            }
            logLines = "";
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (GenericError e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        return logLines;
    }

    private void registerAsCompleted(String spEntityKey, PromptValuesInterface promptValues, Entry entry, ConnectionInterface connection) {
        if (connection instanceof UserSessionConnectionDecorator) {
            ((UserSessionConnectionDecorator)connection).registerStoredProcessAsExecuted(spEntityKey, entry);
        }
        entry.consumed(promptValues, this._dataSelection);
    }

    private Entry hasBeenExecuted(String spEntityKey, ConnectionInterface connection) {
        Entry entry = null;
        if (connection instanceof UserSessionConnectionDecorator) {
            entry = (Entry)((UserSessionConnectionDecorator)connection).hasStoredProcessBeenExecuted(spEntityKey);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(PromptValuesInterface promptValues, StoredProcess2Interface sp, ConnectionInterface connection) throws ExecutionException, RemoteException {
        this.addParameters(promptValues, sp);
        StringBuffer statementErrors = new StringBuffer();
        com.sas.services.storedprocess.ExecutionException caughtException = null;
        int storedProcessStatus = 1;
        com.sas.services.storedprocess.ExecutionException checkedException = null;
        int sasConditionCode = 0;
        StringBuffer errorsFound = new StringBuffer();
        Execution2Interface spExecutionInterface = null;
        String stpLog = null;
        try {
            spExecutionInterface = this.executeStoredProcess(sp, connection);
            stpLog = this.readSASLog(connection, sp, spExecutionInterface, errorsFound);
            if (this._lastLog.length() > 0) {
                this._lastLog.append('\n');
            }
            this._lastLog.append(stpLog);
            storedProcessStatus = this.getStoredProcessStatus(spExecutionInterface);
            checkedException = this.getRootException(spExecutionInterface, storedProcessStatus, statementErrors);
            sasConditionCode = this.getSasConditionCode(spExecutionInterface, storedProcessStatus);
        }
        catch (com.sas.services.storedprocess.ExecutionException e1) {
            caughtException = e1;
        }
        finally {
            block35: {
                if (spExecutionInterface != null) {
                    try {
                        spExecutionInterface.destroy();
                    }
                    catch (TransportException e) {
                        if (_logger.isEnabled(Level.WARN)) {
                            _logger.warn(e.toString(), (Throwable)e);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (_logger.isEnabled(Level.WARN)) {
                            _logger.warn(e.toString(), (Throwable)e);
                        }
                    }
                    catch (ConnectionFactoryException e) {
                        if (!_logger.isEnabled(Level.WARN)) break block35;
                        _logger.warn(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        if (caughtException != null || storedProcessStatus != 3 || checkedException != null || sasConditionCode != 0 && sasConditionCode != 4 || errorsFound.length() != 0) {
            MessageFormatter errorMsg = null;
            com.sas.services.storedprocess.ExecutionException useException = null;
            if (caughtException != null) {
                useException = caughtException;
                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.executeStoredProcess.txt", new Object[0]);
            } else if (checkedException != null) {
                useException = checkedException;
                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForExceptions.errorText.txt", new Object[0]);
            } else if (storedProcessStatus != 3) {
                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForExceptions.RemoteException.txt", new Object[0]);
            } else if (sasConditionCode != 0) {
                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForSASConditionCode.fmt.txt", sasConditionCode);
            } else if (errorsFound.length() != 0) {
                errorMsg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.errorInLog.txt", new Object[0]);
                statementErrors = errorsFound;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                if (useException != null) {
                    _logger.error(errorMsg.toString(), (Throwable)useException);
                } else {
                    _logger.error(errorMsg.toString());
                }
                _logger.error(stpLog);
                _logger.error(statementErrors.toString());
                _logger.error("StoredProcess Status =" + storedProcessStatus);
                _logger.error("SAS ConditionCode =" + sasConditionCode);
            }
            ExecutionException e = useException != null ? new ExecutionException(errorMsg, (Throwable)useException) : new ExecutionException(errorMsg);
            SASLogReader.prepException((IQueryServicesException)e, errorMsg, stpLog, statementErrors.toString());
            throw e;
        }
        _logger.debug((CharSequence)this._lastLog);
    }

    private LogicalServerInterface getServer(StoredProcess2Interface storedProcess) throws ExecutionException {
        LogicalServerInterface server;
        try {
            server = storedProcess.getServer();
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.getServer.RemoteException.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        return server;
    }

    private String readSASLog(ConnectionInterface connection, StoredProcess2Interface spInterface, Execution2Interface spExecutionInterface, StringBuffer errorsFound) throws ExecutionException {
        String logLines = null;
        try {
            logLines = SASLogReader.getInstance().getSASLog(spExecutionInterface, errorsFound);
        }
        catch (TransportException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(formatter.toString() + ": \n" + logLines, (Throwable)e);
            }
            logLines = "";
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (GenericError e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.readSASLog.Exception.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        return logLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Execution2Interface executeStoredProcess(StoredProcess2Interface storedProcess, ConnectionInterface connection) throws com.sas.services.storedprocess.ExecutionException, RemoteException {
        Execution2Interface spExecutionInterface = null;
        SessionContextInterface session = this._dataSelection.getSession();
        Object sessionLock = null;
        try {
            sessionLock = session.lock(this.getClass().getName());
            long start = 0L;
            if (_perfSPLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogStoredProcessPerformance("> Start executing stored process: " + storedProcess.getName());
                start = System.currentTimeMillis();
            }
            if (storedProcess instanceof StoredProcess2_Stub) {
                Object[] args = new Object[]{storedProcess.getName()};
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(IQDataServicesResourceBundle.getMessageString("StoredProcessHandler.remoteWarningMsg.fmt.txt", args));
                }
                spExecutionInterface = storedProcess.execute(true, null, false, null);
            } else {
                spExecutionInterface = storedProcess.execute(true, null, false, (Object)connection);
            }
            if (_perfSPLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogStoredProcessPerformance("> done SP exec (" + (end - start) + "ms)");
            }
        }
        finally {
            if (sessionLock != null) {
                session.unlock(sessionLock);
            }
        }
        return spExecutionInterface;
    }

    private int getSasConditionCode(Execution2Interface spExecutionInterface, int storedProcessStatus) throws ExecutionException {
        int sasConditionCode = 0;
        if (storedProcessStatus != 1 && storedProcessStatus != 2 && storedProcessStatus != 5) {
            try {
                sasConditionCode = spExecutionInterface.getSASConditionCode();
            }
            catch (RemoteException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForSASConditionCode.RemoteException.txt", new Object[0]);
                throw new ExecutionException(formatter, (Throwable)e);
            }
        }
        return sasConditionCode;
    }

    private int getStoredProcessStatus(Execution2Interface spExecutionInterface) throws ExecutionException {
        try {
            int status = spExecutionInterface.getStatus();
            return status;
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForExceptions.RemoteException.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
    }

    private com.sas.services.storedprocess.ExecutionException getRootException(Execution2Interface spExecutionInterface, int storedProcessStatus, StringBuffer buffer) throws ExecutionException {
        com.sas.services.storedprocess.ExecutionException rootException = null;
        try {
            com.sas.services.storedprocess.ExecutionException[] exceptions;
            if ((storedProcessStatus == 4 || storedProcessStatus == 2) && (exceptions = spExecutionInterface.getExceptions()) != null && exceptions.length > 0) {
                for (int i = 0; i < exceptions.length; ++i) {
                    com.sas.services.storedprocess.ExecutionException executionException = exceptions[i];
                    if (executionException == null) continue;
                    if (rootException == null) {
                        rootException = executionException;
                    }
                    String msg = executionException.getLocalizedMessage();
                    _logger.error(msg, (Throwable)executionException);
                    if (msg == null || msg.length() <= 0) continue;
                    if (buffer.length() > 0) {
                        buffer.append('\n');
                    }
                    buffer.append(msg);
                }
            }
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.checkForExceptions.RemoteException.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        return rootException;
    }

    private void addParameters(PromptValuesInterface promptValues, StoredProcess2Interface storedProcess) throws ExecutionException {
        try {
            if (promptValues != null) {
                storedProcess.setParameterValues(promptValues);
            }
        }
        catch (RemoteException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.addParameters.RemoteException.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.addParameters.RemoteException.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
    }

    public boolean hasStoredProcess() {
        return this._storedProcesses != null && !this._storedProcesses.isEmpty();
    }

    public String getLastLog() {
        return this._lastLog.toString();
    }

    private static SQLExpressionAbstract getSQLExpression(DataSelection dataSelection) {
        SQLExpressionAbstract sqlAb = new SQLExpressionAbstract(){

            @Override
            public void prepareSQL() throws GenerationException {
            }

            @Override
            public String writeSQL() {
                return null;
            }
        };
        sqlAb.setDataSelection(dataSelection);
        RelationalDataSelectionProcessor dsp = new RelationalDataSelectionProcessor(dataSelection);
        sqlAb.setDataSelectionProcessor(dsp);
        return sqlAb;
    }

    public static Map<String, List<String>> getPromptValuesMap(PromptValuesInterface promptValues, DataSelection dataSelection) {
        LinkedHashMap<String, List<String>> promptMapping = new LinkedHashMap<String, List<String>>();
        if (promptValues != null) {
            SQLExpressionAbstract sqlAb = StoredProcessHandler.getSQLExpression(dataSelection);
            Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
            List definitions = promptValues.getPromptGroup().getPromptDefinitions(true);
            for (PromptDefinitionInterface pDef : definitions) {
                String definitionId = pDef.getPromptID();
                List<String> definitionValue = StoredProcessHandler.extractStrings(sqlAb, promptValues, pDef, computationalLocale);
                promptMapping.put(definitionId, definitionValue);
            }
        }
        return promptMapping;
    }

    private static List<String> extractStrings(SQLExpressionAbstract sqlAb, PromptValuesInterface promptValues, PromptDefinitionInterface pDef, Locale computationalLocale) {
        ArrayList<String> values;
        block10: {
            values = new ArrayList<String>();
            try {
                int expressionType;
                Object value = promptValues.getPromptValue(pDef);
                boolean isAvail = promptValues.isPromptValueAvailable(pDef);
                if (value == null && !isAvail) break block10;
                int type = pDef.getPromptDataType().getSQLType();
                try {
                    expressionType = ExpressionUtil.getExprType(type);
                }
                catch (IQueryServicesRuntimeException e) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(e.getMessage());
                    }
                    expressionType = 3;
                }
                List<Object> pValues = sqlAb.extractValues(pDef, expressionType, value, true);
                for (Object pValue : pValues) {
                    String text = sqlAb.extractPromptValueText(pValue, pDef, expressionType, computationalLocale);
                    values.add(text);
                }
            }
            catch (PromptValueNotFoundException e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(e.getMessage());
                }
            }
            catch (MetadataException e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(e.getMessage());
                }
            }
            catch (NoSuchElementException e) {
                if (!_logger.isDebugEnabled()) break block10;
                _logger.debug(e.getMessage());
            }
        }
        return values;
    }

    public String toString() {
        return this.createDescription(null);
    }

    public String createDescription(ExecutionContext context) {
        Locale locale = context == null ? (this._dataSelection == null ? null : LocaleUtilities.getDefaultComputationalLocale(this._dataSelection)) : GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, context);
        StringBuffer description = new StringBuffer();
        if (this._storedProcesses != null) {
            try {
                boolean error = false;
                Iterator<RunStoredProcess> iter = this._storedProcesses.iterator();
                while (iter.hasNext()) {
                    RunStoredProcess runStoredProcess = iter.next();
                    StoredProcessInterface storedProcess = runStoredProcess.getStoredProcess().getStoredProcessInterface();
                    PromptValuesInterface promptValues = this._dataSelection == null ? storedProcess.getPromptValues() : this._dataSelection.getPromptValues();
                    PromptValuesInterface spPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues(runStoredProcess, promptValues);
                    UsageVersion usageVersion = storedProcess.getUsageVersion();
                    boolean is92 = usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION);
                    boolean is93 = usageVersion.equals((Object)StoredProcessInterface.NINETHREE_VERSION);
                    if (is93) {
                        try {
                            Locale procStpLocale;
                            IQProcStpV2 iqProcStpV2 = new IQProcStpV2(this._dataSelection == null ? null : this._dataSelection.getSession());
                            iqProcStpV2.setStoredProcess(storedProcess);
                            iqProcStpV2.setExecutionContext(context);
                            if (spPromptValues != null) {
                                iqProcStpV2.setPromptValues(spPromptValues);
                            }
                            if (locale == null) {
                                BusinessModel businessModel = this._dataSelection == null ? runStoredProcess.getBusinessModel() : this._dataSelection.getBusinessModel();
                                procStpLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
                            } else {
                                procStpLocale = locale;
                            }
                            iqProcStpV2.setComputationLocale(procStpLocale);
                            iqProcStpV2.prepareSQL();
                            String spCode = iqProcStpV2.write();
                            description.append(spCode);
                        }
                        catch (Exception e) {
                            _logger.error((Object)e);
                            error = true;
                        }
                    }
                    if (is92 || error) {
                        description.append("/* ");
                        description.append(storedProcess.getEntityKey());
                        if (spPromptValues != null) {
                            Map pvMap = spPromptValues.getPromptValues();
                            Set pvSet = pvMap.entrySet();
                            Iterator it = pvSet.iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                description.append(entry.getKey());
                                description.append("=");
                                description.append(entry.getValue());
                                if (!it.hasNext()) continue;
                                description.append("\t");
                            }
                        }
                        description.append(" */");
                    }
                    if (!iter.hasNext()) continue;
                    description.append("\n");
                }
            }
            catch (ServiceException e) {
                _logger.debug("", (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.debug("", (Throwable)e);
            }
        }
        return description.toString();
    }

    @SASScope
    public static class Entry {
        private Map<String, List<String>> _values = null;

        public boolean hasBeenConsumed(PromptValuesInterface promptValues, DataSelection dataSelection) {
            boolean hasBeenConsumed = false;
            if (this._values != null) {
                Map<String, List<String>> promptValuesMap = StoredProcessHandler.getPromptValuesMap(promptValues, dataSelection);
                hasBeenConsumed = this._values.equals(promptValuesMap);
            }
            return hasBeenConsumed;
        }

        public synchronized void consumed(PromptValuesInterface promptValues, DataSelection dataSelection) {
            Map<String, List<String>> valuesMap = StoredProcessHandler.getPromptValuesMap(promptValues, dataSelection);
            if (this._values == null) {
                this._values = new LinkedHashMap<String, List<String>>(valuesMap);
            } else {
                this._values.clear();
                this._values.putAll(valuesMap);
            }
        }
    }
}

