/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.services.session.SessionContextInterface;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class SessionQueryConnectorsManager {
    private static final String QUERYCONNECTORS_ATTRIBUTE_KEY = "com.sas.iquery.dataretrieval.QueryConnectorsForSession";
    private static final SessionContextDependentCache _sessionCache = SessionContextDependentCache.getNewInstance();
    private static final Logger _logger = LogManager.getLogger(SessionQueryConnectorsManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerQueryConnector(QueryConnectorInterface queryConnector, SessionContextInterface session) throws DataRetrievalException {
        List<WeakReference<QueryConnectorInterface>> queryConnectorReferences;
        List<WeakReference<QueryConnectorInterface>> list = queryConnectorReferences = SessionQueryConnectorsManager.fetchQueryConnectorReferenceList(session, true);
        synchronized (list) {
            if (!SessionQueryConnectorsManager.containsReferenceTo(queryConnectorReferences, queryConnector)) {
                queryConnectorReferences.add(new WeakReference<QueryConnectorInterface>(queryConnector));
            }
        }
    }

    private static boolean containsReferenceTo(List<WeakReference<QueryConnectorInterface>> queryConnectorReferences, QueryConnectorInterface queryConnector) {
        for (WeakReference<QueryConnectorInterface> ref : queryConnectorReferences) {
            if (!queryConnector.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<WeakReference<QueryConnectorInterface>> fetchQueryConnectorReferenceList(SessionContextInterface session, boolean create) throws DataRetrievalException {
        List queryConnectors = null;
        SessionContextDependentCache sessionContextDependentCache = _sessionCache;
        synchronized (sessionContextDependentCache) {
            Object obj = _sessionCache.get(session, QUERYCONNECTORS_ATTRIBUTE_KEY);
            queryConnectors = (List)obj;
            if (queryConnectors == null && create) {
                queryConnectors = Collections.synchronizedList(new ArrayList());
                try {
                    _sessionCache.put(session, QUERYCONNECTORS_ATTRIBUTE_KEY, queryConnectors, new EndListener());
                }
                catch (SessionContextDependentCacheException e) {
                    throw new DataRetrievalException(e);
                }
            }
        }
        return queryConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll(SessionContextInterface session, int options) throws DataRetrievalException, ExecutionException {
        List<WeakReference<QueryConnectorInterface>> queryConnectors = SessionQueryConnectorsManager.fetchQueryConnectorReferenceList(session, false);
        if (queryConnectors != null) {
            List<WeakReference<QueryConnectorInterface>> list = queryConnectors;
            synchronized (list) {
                Iterator<WeakReference<QueryConnectorInterface>> iter = queryConnectors.iterator();
                while (iter.hasNext()) {
                    WeakReference<QueryConnectorInterface> qcRef = iter.next();
                    QueryConnectorInterface queryConnector = (QueryConnectorInterface)qcRef.get();
                    if (queryConnector == null) {
                        iter.remove();
                        continue;
                    }
                    queryConnector.closeResources(session, options & 0xFFFFFEFF);
                    if ((options & 0xF000) == 0) continue;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterQueryConnector(QueryConnector queryConnector, SessionContextInterface session) throws DataRetrievalException {
        List<WeakReference<QueryConnectorInterface>> queryConnectorReferences = SessionQueryConnectorsManager.fetchQueryConnectorReferenceList(session, false);
        if (queryConnectorReferences != null) {
            List<WeakReference<QueryConnectorInterface>> list = queryConnectorReferences;
            synchronized (list) {
                Iterator<WeakReference<QueryConnectorInterface>> iter = queryConnectorReferences.iterator();
                while (iter.hasNext()) {
                    WeakReference<QueryConnectorInterface> qcRef = iter.next();
                    QueryConnectorInterface obj = (QueryConnectorInterface)qcRef.get();
                    if (!queryConnector.equals(obj)) continue;
                    iter.remove();
                }
            }
        }
    }

    private static final class EndListener
    implements SessionContextDependentCache.SessionContextEndListener {
        private EndListener() {
        }

        @Override
        public void sessionEnd(SessionContextInterface session) {
            block4: {
                _logger.debug("In SessionContextEndListener sessionEnd ");
                try {
                    SessionQueryConnectorsManager.closeAll(session, 61455);
                }
                catch (DataRetrievalException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        String msg = IQDataServicesResourceBundle.getStringResource("SessionQueryConnectorsManager.EndListener.FailedToClose.txt");
                        _logger.error(msg, (Throwable)e);
                    }
                }
                catch (ExecutionException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block4;
                    String msg = IQDataServicesResourceBundle.getStringResource("SessionQueryConnectorsManager.EndListener.FailedToClose.txt");
                    _logger.error(msg, (Throwable)e);
                }
            }
            _sessionCache.removeSessionContextEndListener(session, this, true);
        }
    }
}

