/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.util.impl.MessageFormatter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class RetrievalPolicy {
    public static final int FRESHEST = 0;
    public static final int FASTEST = 1;
    @SASScope
    public static final String ENABLE_ACQUIRE_RELEASE_PROPERTY_KEY = "com.sas.iquery.dataretrieval.RetrievalPolicy.ENABLE_ACQUIRE_RELEASE";
    @SASScope
    public static final int ACQUIRE_RELEASE = 0;
    @SASScope
    public static final int USER_SESSION = 1;
    private int _policy = 0;
    private OfflineResultSetConfiguration _offlineResultSetConfiguration = new OfflineResultSetConfiguration();
    private ConnectionConfiguration _connectionConfiguration = new ConnectionConfiguration();
    private static final Logger _logger = LogManager.getLogger(RetrievalPolicy.class);

    public RetrievalPolicy() {
    }

    public RetrievalPolicy(RetrievalPolicy retrievalPolicy) {
        this._policy = retrievalPolicy._policy;
        this._offlineResultSetConfiguration = new OfflineResultSetConfiguration(retrievalPolicy.getOfflineResultSetConfiguration());
        this._connectionConfiguration = new ConnectionConfiguration(retrievalPolicy.getConnectionConfiguration());
    }

    @SASScope
    public String toString() {
        return "{RetrivalPolicy: connection=" + this._connectionConfiguration + ", policy=" + (this._policy == 0 ? "FRESHEST" : "FASTEST") + ", offlineResultSet=" + this._offlineResultSetConfiguration + "}";
    }

    public void setPolicyValue(int policy) {
        if (policy == 0) {
            this._policy = 0;
        } else if (policy == 1) {
            this._policy = 1;
        } else {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("RetrievalPolicy.UnsupportedPolicy.Message.fmt.txt", policy);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(errorMsg.toString());
            }
        }
    }

    public int getPolicyValue() {
        return this._policy;
    }

    public void setOfflineResultSetConfiguration(OfflineResultSetConfiguration offlineResultSetConfiguration) {
        this._offlineResultSetConfiguration = offlineResultSetConfiguration;
    }

    public OfflineResultSetConfiguration getOfflineResultSetConfiguration() {
        return this._offlineResultSetConfiguration;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this._connectionConfiguration;
    }

    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this._connectionConfiguration = connectionConfiguration;
    }

    @SASScope
    public int getConnectionLifetime() {
        return this.getConnectionConfiguration().getConnectionLifetime();
    }

    @SASScope
    public void setConnectionLifetime(int connectionLifetime) {
        this.getConnectionConfiguration().setConnectionLifetime(connectionLifetime);
    }
}

