/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.ResultSetManager;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.SessionQueryConnectorsManager;
import com.sas.iquery.dataretrieval.SimpleQueryConnector;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.util.LogUtils;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SubjectToChange
public class QueryConnector
extends SimpleQueryConnector
implements QueryConnectorInterface {
    private static final Logger _logger = LogManager.getLogger(QueryConnector.class);
    private ResultSetManager _resultSetManager = new ResultSetManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    protected ResultSetInterface processIQI(BusinessQuery iqi, RetrievalPolicy retrievalPolicy) throws DataRetrievalException, ExecutionException {
        boolean success = false;
        long startTime = LogUtils.logStartTime();
        LogUtils.dumpXML(iqi, this);
        ResultSetInterface rsi = null;
        try {
            this.registerQueryConnector(iqi);
            rsi = super.processIQI(iqi, retrievalPolicy);
            this._resultSetManager.remember(iqi, rsi, new RetrievalPolicy(retrievalPolicy));
            success = true;
        }
        finally {
            LogUtils.logEndTime(startTime, success);
        }
        return rsi;
    }

    private void registerQueryConnector(BusinessQuery iqi) throws DataRetrievalException {
        SessionContextInterface session = null;
        if (iqi instanceof BusinessModel) {
            session = ((BusinessModel)((Object)iqi)).getSession();
        } else if (iqi.getBusinessModel() != null) {
            session = iqi.getBusinessModel().getSession();
        }
        if (session != null) {
            SessionQueryConnectorsManager.registerQueryConnector(this, session);
        }
    }

    @Override
    public void closeResources(SessionContextInterface sessionContext, int options) throws DataRetrievalException, ExecutionException {
        int bitMask;
        if ((options & 0xF) != 0) {
            if ((options & 0x100) != 0) {
                SessionQueryConnectorsManager.closeAll(sessionContext, options & 0xF);
            } else if ((options & 0xF) != 0) {
                this._resultSetManager.closeAll(options & 0xF);
            }
        }
        if ((options & (bitMask = 61440)) != 0) {
            try {
                ConnectionRecycler connectionRecycler = ConnectionUtil.getConnectionRecycler(sessionContext);
                connectionRecycler.closeResources(sessionContext, options & bitMask);
            }
            catch (RemoteException e) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.closeResources.RemoteException.txt", new Object[0]), (Throwable)e);
            }
        }
    }

    @Override
    public void closeResult(ResultSetInterface result) throws DataRetrievalException {
        this._resultSetManager.closeResult(result);
    }

    public void close(SessionContextInterface sessionContext) throws DataRetrievalException {
        Throwable save = null;
        try {
            this.closeResources(sessionContext, 271);
        }
        catch (Throwable e) {
            _logger.error((Object)e);
            save = e;
        }
        try {
            ConnectionRecycler connectionRecycler = ConnectionUtil.getConnectionRecycler(sessionContext);
            connectionRecycler.closeConnections(sessionContext);
        }
        catch (Throwable e) {
            save = e;
        }
        SessionQueryConnectorsManager.unRegisterQueryConnector(this, sessionContext);
        if (save != null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.close.RemoteException.txt", new Object[0]);
            throw new DataRetrievalException(message, save);
        }
    }

    public void closeResults(Map<String, ResultSetInterface> results) throws DataRetrievalException {
        for (ResultSetInterface rs : results.values()) {
            this._resultSetManager.closeResult(rs);
        }
    }

    public static class CloseOptions {
        public static final int TABULAR_CONNECTION = 4096;
        public static final int OLAP_CONNECTION = 8192;
        public static final int OLAP_SESSION = 32768;
        @SASScope
        public static final int ALL_CONNECTION_OPTIONS = 61440;
        @SASScope
        public static final int CANCEL_QUERY = 16;
        public static final int TABULAR_BASIC_RESULTSETS = 1;
        public static final int TABULAR_OFFLINE_RESULTSETS = 2;
        public static final int OLAP_RESULTSETS = 8;
        @SASScope
        public static final int ALL_RESULTSET_OPTIONS = 15;
        public static final int SCOPE_SESSION = 256;
        @SASScope
        public static final int PAGE_RENDERING_COMPLETE_OPTIONS = 4097;
        @SASScope
        public static final int CLOSE_RESULTSETS_OPTIONS = 11;
        @SASScope
        public static final int REPORT_CLOSED_OPTIONS = 4107;
        @SASScope
        public static final int USER_LOGOFF_OPTIONS = 45067;
    }
}

