/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;

@SASScope(value="ALL")
@SubjectToChange
public class OfflineResultSetConfiguration {
    @SASScope
    public static final String ENABLE_OFFLINERESULTS_PROPERTY_KEY = "com.sas.iquery.dataretrieval.OfflineResultSetConfiguration.ENABLE_OFFLINERESULTS";
    @SASScope
    public static final int DEFAULT_FILEBLOCKSIZE = 1000;
    @SASScope
    public static final int DEFAULT_MEMORYBLOCKSIZE = 100;
    private int _fileBlockSize = 1000;
    private int _memoryBlockSize = 100;
    private boolean _offlineResultSetsEnabled = false;

    public OfflineResultSetConfiguration() {
    }

    public OfflineResultSetConfiguration(OfflineResultSetConfiguration offlineResultSetConfiguration) {
        this.setFileBlockSize(offlineResultSetConfiguration.getFileBlockSize());
        this.setMemoryBlockSize(offlineResultSetConfiguration.getMemoryBlockSize());
        this.setOfflineResultSetsEnabled(offlineResultSetConfiguration.isOfflineResultSetsEnabled());
    }

    @SASScope
    public String toString() {
        return "{OfflineResultSetConfiguration: fileBlockSize=" + this._fileBlockSize + ", memoryBlockSize=" + this._memoryBlockSize + ", offlineResultSetsEnabled=" + this._offlineResultSetsEnabled + "}";
    }

    public int getFileBlockSize() {
        return this._fileBlockSize;
    }

    public int getMemoryBlockSize() {
        return this._memoryBlockSize;
    }

    private void setFileBlockSize(int fileBlockSize) {
        this._fileBlockSize = fileBlockSize;
    }

    private void setMemoryBlockSize(int memoryBlockSize) {
        this._memoryBlockSize = memoryBlockSize;
    }

    public void setBlockSizes(int memoryBlockSize, int fileBlockSizeFactor) {
        this.setMemoryBlockSize(memoryBlockSize);
        this.setFileBlockSize(this.getMemoryBlockSize() * fileBlockSizeFactor);
    }

    public boolean isOfflineResultSetsEnabled() {
        return this._offlineResultSetsEnabled;
    }

    public void setOfflineResultSetsEnabled(boolean offlineResultSetsEnabled) {
        this._offlineResultSetsEnabled = offlineResultSetsEnabled;
    }
}

