/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;

@SASScope(value="ALL")
@SubjectToChange
public class ConnectionConfiguration {
    @SASScope
    public static final String ENABLE_ACQUIRE_RELEASE_PROPERTY_KEY = "com.sas.iquery.dataretrieval.RetrievalPolicy.ENABLE_ACQUIRE_RELEASE";
    public static final int ACQUIRE_RELEASE = 0;
    @SASScope
    public static final int QUERY_CONNECTOR = 2;
    public static final int USER_SESSION = 1;
    private int _connectionLifetime = 1;
    private long _maxConnectionWaitTime = 0L;
    private ResultSetCachingSetting _resultSetCaching = ResultSetCachingSetting.DEFAULT;

    public ConnectionConfiguration() {
    }

    public ConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.setConnectionLifetime(connectionConfiguration.getConnectionLifetime());
        this.setMaxConnectionWaitTime(connectionConfiguration.getMaxConnectionWaitTime());
        this.setResultSetCaching(connectionConfiguration.getResultSetCaching());
    }

    @SASScope
    public String toString() {
        return "{ConnectionConfiguration: connectionLifetime=" + (this._connectionLifetime == 1 ? "USER_SESSION" : "ACQUIRE_RELEASE") + ", maxConnectionWaitTime=" + this._maxConnectionWaitTime + "}";
    }

    public int getConnectionLifetime() {
        return this._connectionLifetime;
    }

    public void setConnectionLifetime(int connectionLifetime) {
        switch (connectionLifetime) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IQueryServicesIllegalArgumentException(IQDataServicesResourceBundle.getMessageFormatter("ConnectionConfiguration.UnsupportedConnectionLifetime.fmt.txt", connectionLifetime));
            }
        }
        this._connectionLifetime = connectionLifetime;
    }

    public long getMaxConnectionWaitTime() {
        return this._maxConnectionWaitTime;
    }

    public void setMaxConnectionWaitTime(long maxConnectionWaitTime) {
        this._maxConnectionWaitTime = maxConnectionWaitTime;
    }

    @SASScope
    public ResultSetCachingSetting getResultSetCaching() {
        return this._resultSetCaching;
    }

    @SASScope
    public void setResultSetCaching(ResultSetCachingSetting resultSetCaching) {
        this._resultSetCaching = resultSetCaching;
    }

    @SASScope
    public boolean isCachingActive() {
        boolean isCachingOff = this.getResultSetCaching().equals(ResultSetCachingSetting.OFF);
        boolean isUserSession = this.getConnectionLifetime() == 1;
        return isUserSession && !isCachingOff;
    }

    @SASScope
    public static class ResultSetCachingSetting {
        private int _value;
        public static final ResultSetCachingSetting DEFAULT = new ResultSetCachingSetting(-1);
        public static final ResultSetCachingSetting OFF = new ResultSetCachingSetting(0);

        private ResultSetCachingSetting(int value) {
            this._value = value;
        }
    }
}

