/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.builder;

import com.sas.iquery.Builder;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.TotalingType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisabledTotalsBuilder
implements Builder<Map<DataItem, Set<TotalingType>>> {
    private static final Logger _logger = LogManager.getLogger(DisabledTotalsBuilder.class);
    private BusinessQuery _businessQuery;
    private boolean _remove = false;
    private boolean _dirty = false;
    private Boolean _persistGroups = null;
    Map<DataItem, Set<TotalingType>> _currentMapping = new LinkedHashMap<DataItem, Set<TotalingType>>();
    private TotalingType _queryTotalingTypeRow = null;
    private TotalingType _queryTotalingTypeColumn = null;

    DisabledTotalsBuilder(BusinessQuery businessQuery) {
        this._businessQuery = businessQuery;
        this.load(this._businessQuery);
    }

    public BusinessQuery getBusinessQuery() {
        return this._businessQuery;
    }

    public boolean isBuilt() {
        return !this._dirty;
    }

    public boolean isRemovePending() {
        return this._remove;
    }

    @Override
    public Map<DataItem, Set<TotalingType>> build() throws MetadataException {
        if (this._persistGroups != null) {
            DisabledTotalsBuilder.persistGroups(this._businessQuery, this._persistGroups);
        }
        if (this._queryTotalingTypeColumn != null) {
            DisabledTotalsBuilder.setQueryTotaling(this._businessQuery, this._queryTotalingTypeColumn, Role.COLUMN);
        }
        if (this._queryTotalingTypeRow != null) {
            DisabledTotalsBuilder.setQueryTotaling(this._businessQuery, this._queryTotalingTypeRow, Role.ROW);
        }
        if (this._remove) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Build removing totals for query " + this._businessQuery);
            }
            DisabledTotalsBuilder.removeTotaling(this._businessQuery);
            this._remove = false;
        } else {
            Set<DataItem> keySet = this._currentMapping.keySet();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Clear all current disabling totals for query " + this._businessQuery + ", items=" + keySet);
            }
            DataItem[] keys = keySet.toArray(new DataItem[keySet.size()]);
            DisabledTotalsBuilder.clearTotaling(this._businessQuery, null, keys);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Build disabling totals for query " + this._businessQuery + ", mapping=" + this._currentMapping);
            }
            DisabledTotalsBuilder.disableByDataItem(this._businessQuery, this._currentMapping);
        }
        this.load(this._businessQuery);
        return this._currentMapping;
    }

    public void load(BusinessQuery businessQuery) {
        LinkedHashMap<DataItem, Set<TotalingType>> disabledTotalingsByItem = new LinkedHashMap<DataItem, Set<TotalingType>>();
        DisabledTotalsBuilder.buildMappingByItem(disabledTotalingsByItem, businessQuery, true);
        LinkedHashMap<DataItem, Set<TotalingType>> byDataItems = disabledTotalingsByItem;
        this._currentMapping.clear();
        this._currentMapping.putAll(byDataItems);
        this._dirty = false;
    }

    public Map<DataItem, Set<TotalingType>> getByDataItems() {
        Map<DataItem, Set<TotalingType>> mapping = this._dirty ? DisabledTotalsBuilder.deepCopy(this._currentMapping) : DisabledTotalsBuilder.getDisabledTotalingByItem(this._businessQuery, true);
        return mapping;
    }

    public Map<TotalingType, Set<DataItem>> getByTotalingTypes() {
        Map<TotalingType, Set<DataItem>> mapping = this._dirty ? DisabledTotalsBuilder.rotate(this._currentMapping) : DisabledTotalsBuilder.rotate(this.getByDataItems());
        return mapping;
    }

    public Set<DataItem> getDisabledItemsForType(TotalingType totalingType) {
        Map<DataItem, Set<TotalingType>> mapping = this.getByDataItems();
        LinkedHashSet<DataItem> dataItemsMatched = new LinkedHashSet<DataItem>();
        for (Map.Entry<DataItem, Set<TotalingType>> entry : mapping.entrySet()) {
            DataItem dataItem = entry.getKey();
            Set<TotalingType> totalingTypes = entry.getValue();
            if (!totalingTypes.contains(totalingType)) continue;
            dataItemsMatched.add(dataItem);
        }
        return dataItemsMatched;
    }

    public Set<TotalingType> getDisabledTypesForItem(DataItem dataItem) {
        Map<DataItem, Set<TotalingType>> mapping = this.getByDataItems();
        LinkedHashSet<TotalingType> totalingTypesMatched = new LinkedHashSet<TotalingType>();
        Set<TotalingType> totalingTypes = mapping.get(dataItem);
        if (totalingTypes != null) {
            totalingTypesMatched.addAll(totalingTypes);
        }
        return totalingTypesMatched;
    }

    public DisabledTotalsBuilder totalingType(TotalingType totalingType, Role role) {
        if (totalingType == null) {
            totalingType = TotalingType.TOTAL_NONE;
        }
        if (role.equals(Role.ROW)) {
            this._queryTotalingTypeRow = totalingType;
        } else if (role.equals(Role.COLUMN)) {
            this._queryTotalingTypeColumn = totalingType;
        }
        return this;
    }

    public static void setQueryTotaling(BusinessQuery businessQuery, TotalingType totalingType, Role role) throws MetadataException {
        businessQuery.setTotalingType(totalingType, role);
    }

    public DisabledTotalsBuilder persistGroups(boolean enable) {
        this._persistGroups = enable;
        return this;
    }

    public boolean isPersistGroups() {
        boolean isPersistGroups = this._persistGroups != null ? this._businessQuery.getQueryProperty(BusinessQueryProperty.PERSIST_GROUPINGS) : this._persistGroups.booleanValue();
        return isPersistGroups;
    }

    public static void persistGroups(BusinessQuery businessQuery, boolean persistGroups) throws MetadataException {
        businessQuery.setQueryProperty(BusinessQueryProperty.PERSIST_GROUPINGS, persistGroups);
    }

    public static boolean isPersistGroups(BusinessQuery businessQuery) {
        return businessQuery.getQueryProperty(BusinessQueryProperty.PERSIST_GROUPINGS);
    }

    public DisabledTotalsBuilder disable(TotalingType totalingType, DataItem ... dataItems) throws MetadataException {
        boolean dirty = false;
        for (DataItem dataItem : dataItems) {
            dirty |= DisabledTotalsBuilder.disable(this._currentMapping, dataItem, totalingType);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    public DisabledTotalsBuilder disable(DataItem dataItem, TotalingType ... totalingTypes) {
        boolean dirty = false;
        for (TotalingType totalingType : totalingTypes) {
            dirty |= DisabledTotalsBuilder.disable(this._currentMapping, dataItem, totalingType);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    private static boolean disable(Map<DataItem, Set<TotalingType>> mapping, DataItem dataItem, TotalingType totalingType) {
        boolean dirty = false;
        Set<TotalingType> values = mapping.get(dataItem);
        if (values == null) {
            values = new LinkedHashSet<TotalingType>();
            mapping.put(dataItem, values);
            dirty = true;
        }
        return dirty |= DisabledTotalsBuilder.set(totalingType, values, null, true);
    }

    private static boolean disable(BusinessQuery businessQuery, DataItem dataItem, TotalingType totalingType, List<BusinessGroup> activeGroups, ArrayList<BusinessGroup> newGroups) throws MetadataException {
        return DisabledTotalsBuilder.set(businessQuery, dataItem, totalingType, false, true, activeGroups, newGroups);
    }

    public static void disableTotaling(BusinessQuery businessQuery, TotalingType totalingType, DataItem ... dataItems) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (DataItem dataItem : dataItems) {
            setActiveGroups |= DisabledTotalsBuilder.disable(businessQuery, dataItem, totalingType, activeGroups, newGroups);
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    public static void disableByDataItem(BusinessQuery businessQuery, Map<DataItem, Set<TotalingType>> mapping) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (Map.Entry<DataItem, Set<TotalingType>> entry : mapping.entrySet()) {
            DataItem dataItem = entry.getKey();
            Set<TotalingType> totalingTypes = entry.getValue();
            for (TotalingType totalingType : totalingTypes) {
                setActiveGroups |= DisabledTotalsBuilder.disable(businessQuery, dataItem, totalingType, activeGroups, newGroups);
            }
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    public DisabledTotalsBuilder enable(TotalingType totalingType, DataItem ... dataItems) throws MetadataException {
        boolean dirty = false;
        for (DataItem dataItem : dataItems) {
            dirty |= DisabledTotalsBuilder.enable(this._currentMapping, dataItem, totalingType);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    public DisabledTotalsBuilder enable(DataItem dataItem, TotalingType ... totalingTypes) {
        boolean dirty = false;
        for (TotalingType totalingType : totalingTypes) {
            dirty |= DisabledTotalsBuilder.enable(this._currentMapping, dataItem, totalingType);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    private static boolean enable(Map<DataItem, Set<TotalingType>> mapping, DataItem dataItem, TotalingType totalingType) {
        boolean dirty = false;
        Set<TotalingType> values = mapping.get(dataItem);
        if (values == null) {
            values = new LinkedHashSet<TotalingType>();
            mapping.put(dataItem, values);
            dirty = true;
        }
        return dirty |= DisabledTotalsBuilder.set(totalingType, values, true, false);
    }

    private static boolean enable(BusinessQuery businessQuery, DataItem dataItem, TotalingType totalingType, List<BusinessGroup> activeGroups, ArrayList<BusinessGroup> newGroups) throws MetadataException {
        return DisabledTotalsBuilder.set(businessQuery, dataItem, totalingType, true, false, activeGroups, newGroups);
    }

    public static void enableTotaling(BusinessQuery businessQuery, TotalingType totalingType, DataItem ... dataItems) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (DataItem dataItem : dataItems) {
            setActiveGroups |= DisabledTotalsBuilder.enable(businessQuery, dataItem, totalingType, activeGroups, newGroups);
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    public static void enableByDataItem(BusinessQuery businessQuery, Map<DataItem, Set<TotalingType>> mapping) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (Map.Entry<DataItem, Set<TotalingType>> entry : mapping.entrySet()) {
            DataItem dataItem = entry.getKey();
            Set<TotalingType> totalingTypes = entry.getValue();
            for (TotalingType totalingType : totalingTypes) {
                setActiveGroups |= DisabledTotalsBuilder.enable(businessQuery, dataItem, totalingType, activeGroups, newGroups);
            }
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    public DisabledTotalsBuilder clear(TotalingType ... totalingTypes) {
        boolean dirty = false;
        for (TotalingType totalingType : totalingTypes) {
            dirty |= DisabledTotalsBuilder.clear(this._currentMapping, null, totalingType);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    public DisabledTotalsBuilder clear(DataItem ... dataItems) {
        boolean dirty = false;
        for (DataItem dataItem : dataItems) {
            dirty |= DisabledTotalsBuilder.clear(this._currentMapping, dataItem, null);
        }
        if (dirty) {
            this._remove = false;
            this._dirty = true;
        }
        return this;
    }

    private static boolean clear(Map<DataItem, Set<TotalingType>> mapping, DataItem dataItem, TotalingType totalingType) {
        boolean dirty = false;
        if (dataItem == null && totalingType == null) {
            if (mapping.size() > 0) {
                mapping.clear();
                dirty = true;
            }
        } else if (dataItem == null) {
            for (Map.Entry<DataItem, Set<TotalingType>> entry : mapping.entrySet()) {
                Set<TotalingType> values = entry.getValue();
                dirty |= DisabledTotalsBuilder.set(totalingType, values, false, false);
            }
        } else {
            Set<TotalingType> values = mapping.get(dataItem);
            if (values != null) {
                if (totalingType != null) {
                    dirty = values.remove(totalingType);
                } else if (values.size() > 0) {
                    values.clear();
                    dirty = true;
                }
            }
        }
        return dirty;
    }

    private static boolean clear(BusinessQuery businessQuery, DataItem dataItem, TotalingType totalingType, List<BusinessGroup> activeGroups, ArrayList<BusinessGroup> newGroups) throws MetadataException {
        return DisabledTotalsBuilder.set(businessQuery, dataItem, totalingType, false, false, activeGroups, newGroups);
    }

    public static void clearTotaling(BusinessQuery businessQuery, TotalingType totalingType, DataItem ... dataItems) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (DataItem dataItem : dataItems) {
            setActiveGroups |= DisabledTotalsBuilder.clear(businessQuery, dataItem, totalingType, activeGroups, newGroups);
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    public static void clearByDataItem(BusinessQuery businessQuery, Map<DataItem, Set<TotalingType>> mapping) throws MetadataException {
        ArrayList<BusinessGroup> newGroups = new ArrayList<BusinessGroup>();
        boolean setActiveGroups = false;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        for (Map.Entry<DataItem, Set<TotalingType>> entry : mapping.entrySet()) {
            DataItem dataItem = entry.getKey();
            Set<TotalingType> totalingTypes = entry.getValue();
            for (TotalingType totalingType : totalingTypes) {
                setActiveGroups |= DisabledTotalsBuilder.clear(businessQuery, dataItem, totalingType, activeGroups, newGroups);
            }
        }
        if (newGroups.size() > 0) {
            for (BusinessGroup businessGroup : newGroups) {
                DisabledTotalsBuilder.add(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
    }

    private static boolean set(TotalingType totalingType, Set<TotalingType> values, Boolean overrideParent, Boolean disableTotal) {
        boolean dirty = false;
        Boolean disableParent = DisabledTotalsBuilder.disablesParent(totalingType, overrideParent, disableTotal);
        Boolean disableAxis = DisabledTotalsBuilder.disablesAxis(totalingType, overrideParent, disableTotal);
        Boolean disableSub = DisabledTotalsBuilder.disablesSub(totalingType, overrideParent, disableTotal);
        if (disableSub != null) {
            dirty = true;
            if (disableSub.booleanValue()) {
                values.add(TotalingType.SUBTOTAL);
            } else {
                values.remove(TotalingType.SUBTOTAL);
            }
        }
        if (disableAxis != null) {
            dirty = true;
            if (disableAxis.booleanValue()) {
                values.add(TotalingType.AXISTOTAL);
            } else {
                values.remove(TotalingType.AXISTOTAL);
            }
        }
        if (disableParent != null) {
            dirty = true;
            if (disableParent.booleanValue()) {
                values.add(TotalingType.TOTAL_NONE);
            } else {
                values.remove(TotalingType.TOTAL_NONE);
            }
        }
        return dirty;
    }

    private static boolean set(BusinessQuery businessQuery, DataItem dataItem, TotalingType totalingType, boolean overrideParent, boolean disableTotal, List<BusinessGroup> activeGroups, ArrayList<BusinessGroup> newGroups) throws MetadataException {
        Boolean disableParent = DisabledTotalsBuilder.disablesParent(totalingType, overrideParent, disableTotal);
        Boolean disableAxis = DisabledTotalsBuilder.disablesAxis(totalingType, overrideParent, disableTotal);
        Boolean disableSub = DisabledTotalsBuilder.disablesSub(totalingType, overrideParent, disableTotal);
        boolean setActiveGroups = false;
        if (disableSub != null) {
            setActiveGroups |= DisabledTotalsBuilder.set(businessQuery, dataItem, TotalingType.SUBTOTAL, disableSub, activeGroups, newGroups);
        }
        if (disableAxis != null) {
            setActiveGroups |= DisabledTotalsBuilder.set(businessQuery, dataItem, TotalingType.AXISTOTAL, disableAxis, activeGroups, newGroups);
        }
        if (disableParent != null) {
            setActiveGroups |= DisabledTotalsBuilder.set(businessQuery, dataItem, TotalingType.TOTAL_NONE, disableParent, activeGroups, newGroups);
        }
        return setActiveGroups;
    }

    public DisabledTotalsBuilder remove() {
        this._currentMapping.clear();
        this._remove = true;
        return this;
    }

    public static List<DataItem> removeTotaling(BusinessQuery businessQuery) throws MetadataException {
        boolean setActiveGroups = false;
        ArrayList<BusinessGroup> removeGroups = new ArrayList<BusinessGroup>();
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        Enumeration<TotalingType> enumeration = TotalingType.enumeration();
        while (enumeration.hasMoreElements()) {
            TotalingType totalingType = enumeration.nextElement();
            setActiveGroups |= DisabledTotalsBuilder.remove(businessQuery, totalingType, activeGroups, removeGroups, dataItems);
        }
        if (removeGroups.size() > 0) {
            for (BusinessGroup businessGroup : removeGroups) {
                DisabledTotalsBuilder.remove(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
        return dataItems;
    }

    private static boolean remove(BusinessQuery businessQuery, TotalingType totalingType, List<BusinessGroup> activeGroups, List<BusinessGroup> removeGroups, List<DataItem> dataItems) {
        boolean setActiveGroups = false;
        BusinessGroup disableTotalsGroup = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, totalingType.getTotalType());
        if (disableTotalsGroup != null) {
            if (disableTotalsGroup.getBusinessModel() == businessQuery.getBusinessModel()) {
                removeGroups.add(disableTotalsGroup);
            }
            for (BusinessModelObject bmo : disableTotalsGroup.getItems()) {
                if (!(bmo instanceof DataItem)) continue;
                dataItems.add((DataItem)bmo);
            }
            activeGroups.remove(disableTotalsGroup);
            setActiveGroups = true;
        }
        return setActiveGroups;
    }

    private static BusinessGroup filter(List<BusinessGroup> groups, BusinessGroup.Type type, String note) {
        BusinessGroup disableTotalsGroup = null;
        for (BusinessGroup group : groups) {
            String note2 = group.getNote();
            BusinessGroup.Type type2 = group.getType();
            if ((type != null || type2 != null) && (type == null || type2 == null || !type.equals((Object)type2)) || (note != null || note2 != null) && (note == null || note2 == null || !note.equals(note2))) continue;
            disableTotalsGroup = group;
            break;
        }
        return disableTotalsGroup;
    }

    private static boolean set(BusinessQuery businessQuery, DataItem dataItem, TotalingType totalingType, Boolean disable, List<BusinessGroup> activeGroups, ArrayList<BusinessGroup> newGroups) throws MetadataException {
        List<BusinessModelObject> items;
        boolean setActiveGroups = false;
        BusinessGroup group = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, totalingType.getTotalType());
        if (group == null || group.getBusinessModel() != businessQuery.getBusinessModel()) {
            items = group != null ? group.getItems() : new ArrayList<BusinessModelObject>();
            group = DisabledTotalsBuilder.create(businessQuery, (Object)((Object)BusinessGroup.Type.TOTALS_DISABLED) + ":" + totalingType.getTotalType(), BusinessGroup.Type.TOTALS_DISABLED, totalingType.getTotalType());
            activeGroups.add(0, group);
            setActiveGroups = true;
            newGroups.add(group);
        } else {
            items = group.getItems();
        }
        if (disable.booleanValue()) {
            if (!items.contains(dataItem)) {
                items.add(dataItem);
                group.setItems(items);
            }
        } else if (items.contains(dataItem)) {
            items.remove(dataItem);
            group.setItems(items);
        }
        return setActiveGroups;
    }

    public static Map<TotalingType, Set<DataItem>> getDisabledTotalingByType(BusinessQuery businessQuery) {
        return DisabledTotalsBuilder.getDisabledTotalingByType(businessQuery, true);
    }

    public static Map<TotalingType, Set<DataItem>> getDisabledTotalingByType(BusinessQuery businessQuery, boolean recursive) {
        LinkedHashMap<DataItem, Set<TotalingType>> disabledTotalingsByItem = new LinkedHashMap<DataItem, Set<TotalingType>>();
        DisabledTotalsBuilder.buildMappingByItem(disabledTotalingsByItem, businessQuery, recursive);
        return DisabledTotalsBuilder.rotate(disabledTotalingsByItem);
    }

    public static Map<DataItem, Set<TotalingType>> getDisabledTotalingByItem(BusinessQuery businessQuery) {
        return DisabledTotalsBuilder.getDisabledTotalingByItem(businessQuery, true);
    }

    public static Map<DataItem, Set<TotalingType>> getDisabledTotalingByItem(BusinessQuery businessQuery, boolean recursive) {
        LinkedHashMap<DataItem, Set<TotalingType>> disabledTotalingsByItem = new LinkedHashMap<DataItem, Set<TotalingType>>();
        DisabledTotalsBuilder.buildMappingByItem(disabledTotalingsByItem, businessQuery, recursive);
        return disabledTotalingsByItem;
    }

    public static boolean isDisabledTotaling(BusinessQuery businessQuery, DataItem item, TotalingType totalingType) {
        return DisabledTotalsBuilder.isDisabledTotaling(businessQuery, item, totalingType, true, true);
    }

    public static boolean isDisabledTotaling(DataSelection businessQuery, DataItem item, TotalingType totalingType, boolean checkParentModels) {
        return DisabledTotalsBuilder.isDisabledTotaling(businessQuery, item, totalingType, checkParentModels, true);
    }

    public static boolean isDisabledTotaling(BusinessQuery businessQuery, DataItem item, TotalingType totalingType, boolean checkParentModels, boolean checkRootItems) {
        Map<DataItem, Set<TotalingType>> disabledTotalingsByItem = DisabledTotalsBuilder.getDisabledTotalingByItem(businessQuery, checkParentModels);
        Set<TotalingType> disabledTotalings = disabledTotalingsByItem.get(item);
        if (checkRootItems && disabledTotalings == null && item instanceof DataItemReference) {
            DataItem baseItem = ((DataItemReference)item).getBaseDataItem();
            while (disabledTotalings == null && (disabledTotalings = disabledTotalingsByItem.get(baseItem)) == null && baseItem instanceof DataItemReference) {
                baseItem = ((DataItemReference)baseItem).getBaseDataItem();
            }
        }
        return DisabledTotalsBuilder.isDisabled(totalingType, disabledTotalings);
    }

    private static boolean isDisabled(TotalingType totalingType, Set<TotalingType> disabledTotalings) {
        boolean disabledTotal = false;
        if (disabledTotalings != null) {
            if (totalingType == null || totalingType.equals(TotalingType.ALLTOTAL)) {
                disabledTotal = disabledTotalings.contains(TotalingType.ALLTOTAL);
                if (!disabledTotal) {
                    disabledTotal = (disabledTotalings.contains(TotalingType.AXISTOTAL) || disabledTotalings.contains(TotalingType.GRANDTOTAL)) && disabledTotalings.contains(TotalingType.SUBTOTAL);
                }
            } else if (totalingType.equals(TotalingType.AXISTOTAL) || totalingType.equals(TotalingType.GRANDTOTAL)) {
                disabledTotal = disabledTotalings.contains(TotalingType.AXISTOTAL) || disabledTotalings.contains(TotalingType.GRANDTOTAL);
            } else if (totalingType.equals(TotalingType.SUBTOTAL)) {
                disabledTotal = disabledTotalings.contains(TotalingType.SUBTOTAL);
            } else if (totalingType.equals(TotalingType.TOTAL_NONE)) {
                disabledTotal = disabledTotalings.contains(TotalingType.TOTAL_NONE);
            }
        }
        return disabledTotal;
    }

    public static List<DataItem> removeTotaling(BusinessQuery businessQuery, TotalingType totalingType) throws MetadataException {
        boolean setActiveGroups = false;
        ArrayList<BusinessGroup> removeGroups = new ArrayList<BusinessGroup>();
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        setActiveGroups = DisabledTotalsBuilder.remove(businessQuery, totalingType, activeGroups, removeGroups, dataItems);
        if (removeGroups.size() > 0) {
            for (BusinessGroup businessGroup : removeGroups) {
                DisabledTotalsBuilder.remove(businessQuery, businessGroup);
            }
        }
        if (setActiveGroups) {
            DisabledTotalsBuilder.set(businessQuery, activeGroups);
        }
        return dataItems;
    }

    public static List<DataItem> clearTotaling(BusinessQuery businessQuery, TotalingType totalingType) throws MetadataException {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        BusinessGroup disableTotalsGroup = null;
        List<BusinessGroup> groups = DisabledTotalsBuilder.get(businessQuery);
        disableTotalsGroup = DisabledTotalsBuilder.filter(groups, BusinessGroup.Type.TOTALS_DISABLED, totalingType.getTotalType());
        if (disableTotalsGroup != null) {
            boolean dirty = false;
            List<BusinessModelObject> items = disableTotalsGroup.getItems();
            Iterator<BusinessModelObject> iter = items.iterator();
            while (iter.hasNext()) {
                BusinessModelObject bmo = iter.next();
                if (!(bmo instanceof DataItem)) continue;
                iter.remove();
                dataItems.add((DataItem)bmo);
                dirty = true;
            }
            if (dirty) {
                disableTotalsGroup.setItems(items);
            }
        }
        return dataItems;
    }

    private static void buildMappingByItem(Map<DataItem, Set<TotalingType>> mapping, BusinessQuery businessQuery, boolean recursive) {
        BusinessQuery parentQuery;
        if (recursive && (parentQuery = businessQuery.getParentQuery()) != null) {
            DisabledTotalsBuilder.buildMappingByItem(mapping, parentQuery, recursive);
            for (Set<TotalingType> set : mapping.values()) {
                set.remove(TotalingType.TOTAL_NONE);
            }
        }
        DisabledTotalsBuilder.getLocal(mapping, businessQuery);
    }

    private static void getLocal(Map<DataItem, Set<TotalingType>> mapping, BusinessQuery businessQuery) {
        BusinessGroup[] groups;
        List<BusinessGroup> activeGroups = DisabledTotalsBuilder.get(businessQuery);
        BusinessGroup groupTotalsNone = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, TotalingType.TOTAL_NONE.getTotalType());
        BusinessGroup groupAllTotals = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, TotalingType.ALLTOTAL.getTotalType());
        BusinessGroup groupGrandTotals = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, TotalingType.GRANDTOTAL.getTotalType());
        BusinessGroup groupAxisTotals = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, TotalingType.AXISTOTAL.getTotalType());
        BusinessGroup groupSubTotals = DisabledTotalsBuilder.filter(activeGroups, BusinessGroup.Type.TOTALS_DISABLED, TotalingType.SUBTOTAL.getTotalType());
        boolean isDirty = false;
        if (groupTotalsNone != null) {
            for (BusinessModelObject bmo : groupTotalsNone.getItems()) {
                DataItem item;
                Set<TotalingType> totalingTypesDisabled;
                if (!(bmo instanceof DataItem) || (totalingTypesDisabled = mapping.get(item = (DataItem)bmo)) == null || totalingTypesDisabled.size() <= 0) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("cleared set of disabled totalings because TOTAL NONE found.");
                }
                totalingTypesDisabled.clear();
                isDirty |= true;
            }
        }
        for (BusinessGroup group : groups = new BusinessGroup[]{groupTotalsNone, groupAllTotals, groupSubTotals, groupGrandTotals, groupAxisTotals}) {
            if (group == null) continue;
            String note = group.getNote();
            TotalingType totalingType = TotalingType.fromValue(note);
            for (BusinessModelObject bmo : group.getItems()) {
                if (!(bmo instanceof DataItem)) continue;
                DataItem dataItem = (DataItem)bmo;
                isDirty |= DisabledTotalsBuilder.disable(mapping, dataItem, totalingType);
            }
        }
        if (_logger.isDebugEnabled() && isDirty) {
            _logger.debug("local disabled totals read: " + mapping);
        }
    }

    private static Boolean disablesParent(TotalingType totalingType, Boolean overrideParent, Boolean disableTotal) {
        Boolean disableParent = null;
        if (totalingType == null || totalingType.equals(TotalingType.ALLTOTAL)) {
            disableParent = overrideParent;
        } else if (totalingType.equals(TotalingType.AXISTOTAL) || totalingType.equals(TotalingType.GRANDTOTAL)) {
            disableParent = overrideParent;
        } else if (totalingType.equals(TotalingType.SUBTOTAL)) {
            disableParent = overrideParent;
        } else if (totalingType.equals(TotalingType.TOTAL_NONE)) {
            disableParent = disableTotal;
        }
        return disableParent;
    }

    private static Boolean disablesAxis(TotalingType totalingType, Boolean overrideParent, Boolean disableTotal) {
        Boolean disableAxis = null;
        if (totalingType == null || totalingType.equals(TotalingType.ALLTOTAL)) {
            disableAxis = disableTotal;
        } else if (totalingType.equals(TotalingType.AXISTOTAL) || totalingType.equals(TotalingType.GRANDTOTAL)) {
            disableAxis = disableTotal;
        } else if (totalingType.equals(TotalingType.SUBTOTAL)) {
            disableAxis = null;
        } else if (totalingType.equals(TotalingType.TOTAL_NONE)) {
            disableAxis = null;
        }
        return disableAxis;
    }

    private static Boolean disablesSub(TotalingType totalingType, Boolean overrideParent, Boolean disableTotal) {
        Boolean disableSub = null;
        if (totalingType == null || totalingType.equals(TotalingType.ALLTOTAL)) {
            disableSub = disableTotal;
        } else if (totalingType.equals(TotalingType.AXISTOTAL) || totalingType.equals(TotalingType.GRANDTOTAL)) {
            disableSub = null;
        } else if (totalingType.equals(TotalingType.SUBTOTAL)) {
            disableSub = disableTotal;
        } else if (totalingType.equals(TotalingType.TOTAL_NONE)) {
            disableSub = null;
        }
        return disableSub;
    }

    private static <K, V> Map<K, Set<V>> deepCopy(Map<K, Set<V>> mapping) {
        LinkedHashMap<K, LinkedHashSet<V>> copy = new LinkedHashMap<K, LinkedHashSet<V>>();
        for (Map.Entry<K, Set<V>> entry : mapping.entrySet()) {
            K key = entry.getKey();
            Set<V> values = entry.getValue();
            for (V value : values) {
                LinkedHashSet<V> copiedValues = (LinkedHashSet<V>)copy.get(key);
                if (copiedValues == null) {
                    copiedValues = new LinkedHashSet<V>();
                    copy.put(key, copiedValues);
                }
                copiedValues.add(value);
            }
        }
        return copy;
    }

    private static <K, V> Map<V, Set<K>> rotate(Map<K, Set<V>> mapping) {
        LinkedHashMap<V, LinkedHashSet<K>> rotatedMapping = new LinkedHashMap<V, LinkedHashSet<K>>(mapping.size());
        for (Map.Entry<K, Set<V>> entry : mapping.entrySet()) {
            K key = entry.getKey();
            Set<V> values = entry.getValue();
            for (V value : values) {
                LinkedHashSet<K> rotatedValues = (LinkedHashSet<K>)rotatedMapping.get(value);
                if (rotatedValues == null) {
                    rotatedValues = new LinkedHashSet<K>();
                    rotatedMapping.put(value, rotatedValues);
                }
                rotatedValues.add(key);
            }
        }
        return rotatedMapping;
    }

    private static void set(BusinessQuery businessQuery, List<BusinessGroup> groups) throws MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting active groups for " + businessQuery + ". groups = " + groups);
        }
        businessQuery.setGroups(groups);
    }

    private static List<BusinessGroup> get(BusinessQuery businessQuery) {
        List<BusinessGroup> groups = businessQuery.getGroups();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Active groups for query " + businessQuery.getID() + ". groups = " + groups);
        }
        return groups;
    }

    private static BusinessGroup create(BusinessQuery businessQuery, String label, BusinessGroup.Type type, String note) throws MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating new business group of type=(" + (Object)((Object)type) + "), label=\"" + label + "\", note=\"" + note + "\"");
        }
        BusinessGroup disableTotalsGroup = businessQuery.getBusinessModel().newBusinessGroup(type);
        disableTotalsGroup.setNote(note);
        disableTotalsGroup.setLabel(label);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created business group = " + disableTotalsGroup.getIdentityString());
        }
        return disableTotalsGroup;
    }

    private static void add(BusinessQuery businessQuery, BusinessGroup businessGroup) throws MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Adding business group to query " + businessQuery.getID() + ". group = " + businessGroup.getIdentityString());
        }
        businessQuery.getBusinessModel().addBusinessGroup(businessGroup);
    }

    private static void remove(BusinessQuery businessQuery, BusinessGroup businessGroup) throws MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Removing business group from query " + businessQuery.getID() + ". group = " + businessGroup.getIdentityString());
        }
        businessQuery.getBusinessModel().removeBusinessGroup(businessGroup);
    }
}

