/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.builder;

import com.sas.iquery.Builder;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.serverprop.Function;
import java.util.List;

public class DataItemBuilder
implements Builder<DataItem> {
    private final BusinessModel _businessModel;
    private final ExpressionInterface _expression;
    private final boolean _buildReference;
    private Function _aggregationType;
    private String _resultSetID;
    private DataItemActionType _usage;
    private String _label;
    private DataItemActionType _sortDirection;
    private List<? extends StepInterface> _steps;

    DataItemBuilder(BusinessModel businessModel, ExpressionInterface expression, boolean buildReference) {
        this._businessModel = businessModel;
        this._expression = expression;
        this._buildReference = buildReference;
    }

    public DataItemBuilder aggregation(Function aggregation) {
        this._aggregationType = aggregation;
        return this;
    }

    public DataItemBuilder resultSetID(String resultSetID) {
        this._resultSetID = resultSetID;
        return this;
    }

    public DataItemBuilder usage(DataItemActionType usage) {
        this._usage = usage;
        return this;
    }

    public DataItemBuilder usageDetail() {
        this._usage = DataItemActionType.USAGE_DETAIL;
        return this;
    }

    public DataItemBuilder usageCategory() {
        this._usage = DataItemActionType.USAGE_CATEGORY;
        return this;
    }

    public DataItemBuilder usageAggregate() {
        this._usage = DataItemActionType.USAGE_AGGREGATE;
        return this;
    }

    public DataItemBuilder sort(DataItemActionType sortDirection) {
        this._sortDirection = sortDirection;
        return this;
    }

    public DataItemBuilder sortDesending() {
        this._sortDirection = DataItemActionType.SORT_DESCENDING;
        return this;
    }

    public DataItemBuilder sortAscending() {
        this._sortDirection = DataItemActionType.SORT_ASCENDING;
        return this;
    }

    public DataItemBuilder label(String label) {
        this._label = label;
        return this;
    }

    public DataItemBuilder steps(List<? extends StepInterface> steps) {
        this._steps = steps;
        return this;
    }

    @Override
    public DataItem build() throws MetadataException {
        DataItem di;
        assert (this._businessModel != null);
        assert (this._expression != null);
        if (this._buildReference) {
            di = this._businessModel.newDataItemReference((DataItem)this._expression);
        } else {
            di = this._businessModel.newDataItem();
            di.setExpression(this._expression);
        }
        if (this._aggregationType != null) {
            di.setAggregationType(this._aggregationType);
        }
        if (this._label != null) {
            di.setLabel(this._label);
        }
        if (this._sortDirection != null) {
            di.setSortDirection(this._sortDirection);
        }
        if (this._usage != null) {
            di.setUsage(this._usage);
        }
        if (this._resultSetID != null) {
            di.setResultSetID(this._resultSetID);
        }
        if (this._steps != null) {
            boolean isOLAP = this._businessModel.getStructure().equals(StructureOfData.OLAP);
            if (!isOLAP) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemBuilder.InvalidStepsOnRelationalItem.txt", new Object[0]));
            }
            di.setSteps(this._steps);
        }
        this._businessModel.addBusinessItem(di);
        return di;
    }
}

