/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.mgmt.Backup;
import com.sas.metadata.mgmt.BackupConfiguration;
import com.sas.metadata.mgmt.BackupHistory;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerException;
import com.sas.metadata.mgmt.impl.BackupConfigurationImpl;
import com.sas.metadata.mgmt.impl.BackupHistoryImpl;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MetadataManagerImpl
extends ImplFromXMLElement
implements MetadataManager,
RemoteSessionContextStateChangedListener {
    private UserContextInterface _user = null;
    private OMIServer _server = null;
    private IServer _iServer = null;
    private MdOMRConnection _connection = null;
    private BackupConfigurationImpl _backupConfiguration = null;
    private BackupHistoryImpl _backupHistory = null;
    private boolean _disposed = false;
    public static String _logContextName = "com.sas.metadata.admin";
    private String serverStateMessage = null;

    public MetadataManagerImpl(SessionContextInterface session) throws ServiceException {
        this.objectType = "MetadataManager";
        this.root = this;
        this._session = session;
        try {
            this._session.setAttribute((Object)this);
            this._logger = LogManager.getLogger((String)_logContextName);
            this._user = session.getUserContext();
            this._server = (OMIServer)this._user.getAuthServer();
            this._factory = this._server.getMdFactory();
            this._connection = this._factory.getConnection();
            this._iServer = this._connection.MakeIServerConnection();
        }
        catch (RemoteException e) {
            throw new MetadataManagerException(e.getCause());
        }
        catch (MdException e) {
            throw new MetadataManagerException(e.getCause());
        }
    }

    @Override
    public String getStaticObjectType() {
        return "MetadataManager";
    }

    public MetadataManagerImpl(MdFactory factory) throws ServiceException {
        this.root = this;
        this._logger = LogManager.getLogger((String)_logContextName);
        this._factory = factory;
        try {
            this._connection = this._factory.getConnection();
            this._iServer = this._connection.MakeIServerConnection();
        }
        catch (RemoteException e) {
            throw new MetadataManagerException(e.getCause());
        }
        catch (MdException e) {
            throw new MetadataManagerException(e.getCause());
        }
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" no details ");
        if (this._backupConfiguration != null) {
            this._backupConfiguration.debugDump();
        }
        if (this._backupHistory != null) {
            this._backupHistory.debugDump();
        }
    }

    @Override
    public BackupConfiguration getBackupConfiguration() {
        if (this._backupConfiguration == null) {
            this._backupConfiguration = new BackupConfigurationImpl(this);
        }
        return this._backupConfiguration;
    }

    @Override
    public BackupHistory getBackupHistory() throws ServiceException {
        if (this._backupHistory == null) {
            this._backupHistory = new BackupHistoryImpl(this);
        }
        return this._backupHistory;
    }

    @Override
    public SessionContextInterface getSession() throws ServiceException {
        return this._session;
    }

    @Override
    public Backup newBackup() throws ServiceException {
        if (this._backupHistory == null) {
            this.getBackupHistory();
        }
        return this._backupHistory.newBackup();
    }

    @Override
    public String getServerStateMessage() throws ServiceException {
        this.serverStateMessage = null;
        Document doc = this.doStatus("<PauseComment/>");
        if (doc != null) {
            Element stateElement = doc.getDocumentElement();
            NodeList children = stateElement.getChildNodes();
            int numChildren = children.getLength();
            for (int ix = 0; ix < numChildren; ++ix) {
                Node childNode = children.item(ix);
                short nodeType = childNode.getNodeType();
                if (nodeType != 3) continue;
                this.serverStateMessage = ((Text)childNode).getNodeValue();
            }
        }
        return this.serverStateMessage;
    }

    @Override
    public MetadataManager.ServerState getServerState() throws ServiceException {
        MetadataManager.ServerState state = MetadataManager.ServerState.OFFLINE;
        String serverStateString = null;
        try {
            int status = this._connection.getServerStatus();
            switch (status) {
                case 0: {
                    state = MetadataManager.ServerState.ONLINE;
                    break;
                }
                case 1: {
                    state = MetadataManager.ServerState.OFFLINE;
                    Document doc = this.doStatus("<ServerState/>");
                    if (doc == null) break;
                    Element stateElement = doc.getDocumentElement();
                    NodeList children = stateElement.getChildNodes();
                    int numChildren = children.getLength();
                    for (int ix = 0; ix < numChildren; ++ix) {
                        Node childNode = children.item(ix);
                        short nodeType = childNode.getNodeType();
                        if (nodeType != 3) continue;
                        serverStateString = ((Text)childNode).getNodeValue();
                        if (serverStateString.equals("ADMIN")) {
                            state = MetadataManager.ServerState.ADMIN;
                            continue;
                        }
                        if (serverStateString.equals("OFFLINE")) {
                            state = MetadataManager.ServerState.OFFLINE;
                            continue;
                        }
                        if (!serverStateString.equals("RECOVERY")) continue;
                        state = MetadataManager.ServerState.RECOVERY;
                    }
                    break;
                }
                case -1: {
                    state = MetadataManager.ServerState.OFFLINE;
                }
            }
        }
        catch (RemoteException e) {
            throw new MetadataManagerException(e.getCause());
        }
        catch (MdException e) {
            throw new MetadataManagerException(e.getCause());
        }
        return state;
    }

    @Override
    public void setServerState(MetadataManager.ServerState desiredState) throws ServiceException {
        MetadataManager.ServerState currentState = this.getServerState();
        int rc = 0;
        if (currentState == desiredState) {
            return;
        }
        if (currentState.equals((Object)MetadataManager.ServerState.RECOVERY)) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.setState.error.inRecovery.txt"));
        }
        if (desiredState.equals((Object)MetadataManager.ServerState.RECOVERY)) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.setState.error.recoverByRecovery.txt"));
        }
        String pauseCommentXML = "";
        if (this.serverStateMessage != null && this.serverStateMessage.length() > 0) {
            pauseCommentXML = "<PAUSECOMMENT>" + this.serverStateMessage + "</PAUSECOMMENT>";
        }
        try {
            switch (desiredState) {
                case ONLINE: {
                    rc = this._iServer.Resume("<SERVER/>");
                    if (rc == 0) break;
                    throw new MetadataManagerException(new Message(RB.getResources(), "mgmt_impl.setState.error.nonZeroReturnCode.fmt", (Object)"Resume", (Object)new Integer(rc).toString()).toString());
                }
                case ADMIN: 
                case READONLY: 
                case OFFLINE: {
                    rc = this._iServer.Pause(pauseCommentXML + "<SERVER State=\"" + desiredState.name() + "\"/>");
                    if (rc == 0) break;
                    throw new MetadataManagerException(new Message(RB.getResources(), "mgmt_impl.setState.error.nonZeroReturnCode.fmt", (Object)"Pause", (Object)new Integer(rc).toString()).toString());
                }
            }
        }
        catch (GenericError e) {
            throw new MetadataManagerException(e.getCause());
        }
        MetadataManager.ServerState newState = this.getServerState();
        if (newState != desiredState) {
            throw new MetadataManagerException(new Message(RB.getResources(), "mgmt_impl.setState.error.stateNotAchieved.fmt", (Object)desiredState.name()).toString());
        }
    }

    @Override
    public void setServerStateMessage(String message) throws ServiceException {
        this.serverStateMessage = message;
    }

    @Override
    public void dispose() {
        if (!this._disposed) {
            this._backupConfiguration = null;
            this._backupHistory = null;
            this._disposed = true;
            try {
                this.debugDump("disposed");
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this._disposed;
    }

    public void contextStateChanged(SessionContextStateChangedEvent event) {
        if (event.getStateChange() == 2) {
            this.dispose();
        }
    }
}

