/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.services.ServiceException;
import java.util.Date;
import org.w3c.dom.Element;

public class JournalImpl
extends ImplFromXMLElement {
    private long firstEntryNumber;
    private long lastEntryNumber;
    private long historicalDataSize;
    private long historicalOverflow;
    private long sizeLimit;
    private String path;
    private long fileSize;
    private Date modifiedDateTime;
    private Date createdDateTime;
    private MetadataOperation.Status status;
    boolean haveDetails = false;

    @Override
    public String getStaticObjectType() {
        return "Journal";
    }

    public JournalImpl(Element domElement, ImplFromXMLElement container) {
        super(domElement, container);
    }

    @Override
    protected void mapAttributes() {
        this.setPath(this.getAttribute("Pathname"));
        String temp = this.getAttribute("FirstEntryNumber");
        if (temp != null && temp.length() > 0) {
            this.setFirstEntryNumber(Long.parseLong(temp));
        } else {
            this.setFirstEntryNumber(-1L);
        }
        temp = this.getAttribute("HistoricalDataSize");
        if (temp != null && temp.length() > 0) {
            this.setHistoricalDataSize(Long.parseLong(temp));
        } else {
            this.setHistoricalDataSize(-1L);
        }
        temp = this.getAttribute("HistoricalOverflow");
        if (temp != null && temp.length() > 0) {
            this.setHistoricalOverflow(Long.parseLong(temp));
        } else {
            this.setHistoricalOverflow(-1L);
        }
        temp = this.getAttribute("LastEntryNumber");
        if (temp != null && temp.length() > 0) {
            this.setLastEntryNumber(Long.parseLong(temp));
        } else {
            this.setLastEntryNumber(-1L);
        }
        temp = this.getAttribute("lastModified");
        if (temp != null) {
            this.setModifiedDateTime(this.parseISO8601DateTime(temp, "lastModified"));
        }
        if ((temp = this.getAttribute("size")) != null && temp.length() > 0) {
            this.setFileSize(Long.parseLong(temp));
        } else {
            this.setFileSize(-1L);
        }
        temp = this.getAttribute("SizeLimit");
        if (temp != null && temp.length() > 0) {
            this.setSizeLimit(Long.parseLong(temp));
        } else {
            this.setSizeLimit(0L);
        }
    }

    protected void setStatusString(String description) {
        this.status = MetadataOperation.Status.getStatus(description);
    }

    protected void setStatus(MetadataOperation.Status status) {
        this.status = status;
    }

    public MetadataOperation.Status getStatus() {
        return this.status;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" firstEntryNumber=" + this.getFirstEntryNumber() + " lastEntryNumber=" + this.getLastEntryNumber() + " fileSize=" + this.getFileSize() + " sizeLimit=" + this.getSizeLimit() + " created=" + this.getCreatedDateTime() + " modified=" + this.getModifiedDateTime());
        this.debugDump(" historicalDataSize=" + this.getHistoricalDataSize() + " historicalOverflow=" + this.getHistoricalOverflow());
        this.debugDump(" Path=" + this.getPath());
    }

    protected void setFirstEntryNumber(long firstEntryNumber) {
        this.firstEntryNumber = firstEntryNumber;
    }

    public long getFirstEntryNumber() {
        if (this.historicalDataSize > 0L) {
            return this.firstEntryNumber;
        }
        return 0L;
    }

    protected void setLastEntryNumber(long lastEntryNumber) {
        this.lastEntryNumber = lastEntryNumber;
    }

    public long getLastEntryNumber() {
        if (this.historicalDataSize > 0L) {
            return this.lastEntryNumber;
        }
        return 0L;
    }

    protected void setHistoricalDataSize(long historicalDataSize) {
        this.historicalDataSize = historicalDataSize;
    }

    public long getHistoricalDataSize() {
        return this.historicalDataSize;
    }

    protected void setHistoricalOverflow(long historicalOverflow) {
        this.historicalOverflow = historicalOverflow;
    }

    public long getHistoricalOverflow() {
        return this.historicalOverflow;
    }

    protected void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    protected void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    protected void setModifiedDateTime(Date modifiedDateTime) {
        this.modifiedDateTime = modifiedDateTime;
    }

    public Date getModifiedDateTime() {
        return this.modifiedDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }
}

