/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.Backup;
import com.sas.metadata.mgmt.BackupHistory;
import com.sas.metadata.mgmt.BackupRecovery;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.BackupImpl;
import com.sas.metadata.mgmt.impl.BackupRecoveryImpl;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BackupHistoryImpl
extends ImplFromXMLElement
implements BackupHistory {
    private static final String GET_BACKUP_HISTORY = "      <MetadataServerBackupHistory/>\n";
    private static final String ELEMENT_NAME_BACKUPS = "Backups";
    private static final String ELEMENT_NAME_BACKUP = "Backup";
    private static final String ELEMENT_NAME_RECOVERY = "Recovery";
    private ArrayList<Backup> allBackups = new ArrayList();
    private ArrayList<Backup> availableBackups = null;
    private ArrayList<Backup> successfulBackups = new ArrayList();
    private Backup mostRecentBackup = null;
    private Backup mostRecentSuccessfulBackup = null;
    private ArrayList<BackupRecovery> allRecoveries = new ArrayList();
    private ArrayList<BackupRecovery> successfulRecoveries = new ArrayList();
    private BackupRecovery mostRecentRecovery = null;
    private BackupRecovery mostRecentSuccessfulRecovery = null;
    private static String STATUS_GET_SERVER_START_PATH = "<OMA SERVERSTARTPATH=\"\"/>";
    private String serverStartPath = null;
    private String GUID = null;

    @Override
    public String getStaticObjectType() {
        return "BackupHistory";
    }

    public BackupHistoryImpl(ImplFromXMLElement container) throws ServiceException {
        super(null, container);
        this.refresh();
    }

    @Override
    public void refresh() throws ServiceException {
        NodeList serverElementsList;
        Document doc = this.doStatus(GET_BACKUP_HISTORY);
        this.domElement = doc.getDocumentElement();
        if (this.GUID == null && (serverElementsList = this.domElement.getElementsByTagName("MetadataServer")) != null && serverElementsList.getLength() > 0) {
            Element serverElement = (Element)serverElementsList.item(0);
            this.GUID = this.getAttribute("GUID", serverElement);
        }
        NodeList backupsElementsList = this.domElement.getElementsByTagName(ELEMENT_NAME_BACKUPS);
        int maxIndex = 0;
        NodeList backupElementList = null;
        Element backupsElement = null;
        if (backupsElementsList != null && backupsElementsList.getLength() > 0) {
            backupsElement = (Element)backupsElementsList.item(0);
            backupElementList = backupsElement.getChildNodes();
            maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1) continue;
                if (nodeName.equals(ELEMENT_NAME_BACKUP)) {
                    BackupImpl oldBackup = null;
                    BackupImpl newBackup = new BackupImpl((Element)aNode, this);
                    newBackup.setIsInHistory(true);
                    String newBackupName = newBackup.getName();
                    if (newBackupName == null) {
                        this.logWarn("Some backup in the history has no name!");
                    }
                    if ((oldBackup = (BackupImpl)this.findBackup(newBackup)) == null) {
                        if (newBackup.getName() != null) {
                            this.allBackups.add(newBackup);
                            if (this.mostRecentBackup == null) {
                                this.mostRecentBackup = newBackup;
                            } else {
                                Date newBackupStart = newBackup.getStartDateTime();
                                Date mostRecentDate = this.mostRecentBackup.getStartDateTime();
                                if (mostRecentDate == null || newBackupStart != null && newBackupStart.after(mostRecentDate)) {
                                    this.mostRecentBackup = newBackup;
                                }
                            }
                            if (newBackup.isSuccessful()) {
                                this.successfulBackups.add(newBackup);
                                if (this.mostRecentSuccessfulBackup == null) {
                                    this.mostRecentSuccessfulBackup = newBackup;
                                } else if (newBackup.getStartDateTime().after(this.mostRecentSuccessfulBackup.getStartDateTime())) {
                                    this.mostRecentSuccessfulBackup = newBackup;
                                }
                            }
                        }
                    } else if (newBackup.getStatus() != oldBackup.getStatus() || newBackup.getSize() != oldBackup.getSize()) {
                        this.logDebug("Backup " + oldBackup.getName() + " seems to have changed recently.  The old status is " + oldBackup.getStatus().description() + " the new status is " + newBackup.getStatus().description());
                        if (oldBackup.equals(this.mostRecentBackup)) {
                            this.logDebug("And it is the most recent backup as well.");
                        }
                        oldBackup.refreshDetails();
                    }
                }
                if (!nodeName.equals(ELEMENT_NAME_RECOVERY)) continue;
                BackupRecoveryImpl oldRecovery = null;
                BackupRecoveryImpl newRecovery = new BackupRecoveryImpl((Element)aNode, this);
                oldRecovery = (BackupRecoveryImpl)this.findRecovery(newRecovery);
                if (oldRecovery == null) {
                    this.allRecoveries.add(newRecovery);
                    if (this.mostRecentRecovery == null) {
                        this.mostRecentRecovery = newRecovery;
                    } else {
                        Date newStarted = newRecovery.getStartDateTime();
                        Date recentStarted = this.mostRecentRecovery.getStartDateTime();
                        if (newStarted != null && recentStarted != null && newStarted.after(recentStarted)) {
                            this.mostRecentRecovery = newRecovery;
                        }
                    }
                    if (!newRecovery.isSuccessful()) continue;
                    this.successfulRecoveries.add(newRecovery);
                    if (this.mostRecentSuccessfulRecovery == null) {
                        this.mostRecentSuccessfulRecovery = newRecovery;
                        continue;
                    }
                    if (!newRecovery.getStartDateTime().after(this.mostRecentSuccessfulRecovery.getStartDateTime())) continue;
                    this.mostRecentSuccessfulRecovery = newRecovery;
                    continue;
                }
                if (newRecovery.getStatus() == oldRecovery.getStatus() && newRecovery.getSize() == oldRecovery.getSize()) continue;
                this.logDebug("Recovery " + oldRecovery.getName() + " seems to have changed recently.  The old status is " + oldRecovery.getStatus().description() + " the new status is " + newRecovery.getStatus().description());
                if (oldRecovery.equals(this.mostRecentRecovery)) {
                    this.logDebug("And it is the most recent recovery as well.");
                }
                oldRecovery.refreshDetails();
            }
        }
        if (this.mostRecentRecovery != null) {
            ((BackupRecoveryImpl)this.mostRecentRecovery).setLatestRecovery(true);
        }
    }

    @Override
    public List<Backup> getBackups() {
        ArrayList<BackupImpl> allExecutedBackups = new ArrayList<BackupImpl>();
        for (BackupImpl backupImpl : this.allBackups) {
            String reason = null;
            String aName = null;
            Object aStatus = null;
            try {
                if (!backupImpl.isInHistory()) {
                    reason = "not in the history";
                } else if (backupImpl.getStatus() == MetadataOperation.Status.NOT_STARTED || backupImpl.getStatus() == MetadataOperation.Status.STARTED || backupImpl.getStatus() == MetadataOperation.Status.UNCERTAIN) {
                    reason = "not complete";
                } else if (backupImpl.getStartDateTime() == null) {
                    reason = "missing startDateTime ";
                }
                if (reason == null) {
                    allExecutedBackups.add(backupImpl);
                    continue;
                }
                aName = backupImpl.getName();
                this.logDebug("Excluding backup that is " + reason + ": " + (aName != null ? aName : backupImpl));
            }
            catch (ServiceException e) {
                this.logDebug("Excluding backup: " + backupImpl + " due to " + (Object)((Object)e));
            }
        }
        return Collections.unmodifiableList(allExecutedBackups);
    }

    @Override
    public Backup getLastBackup() {
        return this.mostRecentBackup;
    }

    @Override
    public Backup getLastSuccessfulBackup() {
        return this.mostRecentSuccessfulBackup;
    }

    @Override
    public List<Backup> getAvailableBackups() throws ServiceException {
        if (this.availableBackups == null) {
            this.availableBackups = new ArrayList();
            for (Backup aBackup : this.allBackups) {
                if (!aBackup.isSuccessful() || !aBackup.isValid()) continue;
                this.availableBackups.add(aBackup);
            }
        }
        return Collections.unmodifiableList(this.availableBackups);
    }

    public Backup newBackup() {
        return this.newBackup(null);
    }

    public Backup newBackup(Element element) {
        BackupImpl newBackup = new BackupImpl(element, this);
        this.mostRecentBackup = newBackup;
        this.allBackups.add(newBackup);
        return newBackup;
    }

    @Override
    public void forgetBackup(Backup backup) {
        this.logDebug("We have been notified to forget about the backup: " + backup);
        this.allBackups.remove(backup);
        if (backup == this.mostRecentBackup) {
            this.mostRecentBackup = null;
        }
        if (backup == this.mostRecentSuccessfulBackup) {
            this.mostRecentSuccessfulBackup = null;
        }
    }

    public BackupRecovery newBackupRecovery(Backup backup) throws ServiceException {
        if (this.mostRecentRecovery != null) {
            ((BackupRecoveryImpl)this.mostRecentRecovery).setLatestRecovery(false);
        }
        BackupRecoveryImpl newRecovery = new BackupRecoveryImpl(null, this);
        this.mostRecentRecovery = newRecovery;
        this.allRecoveries.add(newRecovery);
        ((BackupRecoveryImpl)this.mostRecentRecovery).setLatestRecovery(true);
        return newRecovery;
    }

    @Override
    public List<BackupRecovery> getRecoveries() {
        return Collections.unmodifiableList(this.allRecoveries);
    }

    @Override
    public BackupRecovery getLastRecovery() {
        return this.mostRecentRecovery;
    }

    @Override
    public BackupRecovery getLastSuccessfulRecovery() {
        return this.mostRecentSuccessfulRecovery;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" no details ");
        this.logDebug(" All Backups: ");
        Iterator<Backup> iter = this.allBackups.iterator();
        while (iter.hasNext()) {
            ((BackupImpl)iter.next()).debugDump();
        }
    }

    public String getServerStartPath() {
        if (this.serverStartPath == null) {
            Document doc = null;
            try {
                doc = this.doStatus(STATUS_GET_SERVER_START_PATH);
                Element omaElement = doc.getDocumentElement();
                this.serverStartPath = this.getAttribute("SERVERSTARTPATH", omaElement);
            }
            catch (Exception e) {
                this.logWarn(RB.getStringResource("mgmt_impl.backupHistory.error.queryServerStartPath.txt"));
            }
        }
        return this.serverStartPath;
    }

    public Backup findBackup(Backup someBackup) throws ServiceException {
        BackupImpl backup = null;
        String backupName = someBackup.getName();
        String backupLocation = someBackup.getPath();
        if (backup == null && backupName != null) {
            for (Backup aBackup : this.allBackups) {
                String testName = aBackup.getName();
                if (testName == null) {
                    this.logWarn("Some backup in the history has no name!: " + aBackup);
                }
                String testPath = aBackup.getPath();
                if (testName == null || !testName.equals(backupName) || backupLocation != null && testPath != null && !testPath.equals(backupLocation)) continue;
                backup = (BackupImpl)aBackup;
                break;
            }
        }
        return backup;
    }

    public BackupRecovery findRecovery(BackupRecovery someRecovery) throws ServiceException {
        BackupRecoveryImpl recovery = null;
        String recoveryName = someRecovery.getName();
        String backupLocation = someRecovery.getPath();
        if (recovery == null && recoveryName != null) {
            for (BackupRecovery aRecovery : this.allRecoveries) {
                String testName = aRecovery.getName();
                String testPath = aRecovery.getPath();
                if (!testName.equals(recoveryName) || backupLocation != null && testPath != null && !testPath.equals(backupLocation)) continue;
                recovery = (BackupRecoveryImpl)aRecovery;
                break;
            }
        }
        return recovery;
    }

    @Override
    public String getGUID() throws ServiceException {
        if (this.GUID == null) {
            this.getDetails(null);
        }
        return this.GUID;
    }
}

