/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.impl.RB;

public class BackupFileSizeFormatter {
    public static String formatFileSize(double fileSize) {
        double giga = 1.073741824E9;
        double mega = 1048576.0;
        double kilo = 1024.0;
        String sizeText = fileSize > giga ? BackupFileSizeFormatter.truncateFloatingPointString(Double.toString(fileSize / giga)) + " " + RB.getStringResource("mgmt_impl.formatting.SizeGigaBytes.txt") : (fileSize > mega ? BackupFileSizeFormatter.truncateFloatingPointString(Double.toString(fileSize / mega)) + " " + RB.getStringResource("mgmt_impl.formatting.SizeMegaBytes.txt") : (fileSize > kilo ? BackupFileSizeFormatter.truncateFloatingPointString(Double.toString(fileSize / kilo)) + " " + RB.getStringResource("mgmt_impl.formatting.SizeKiloBytes.txt") : Double.toString(fileSize) + " " + RB.getStringResource("mgmt_impl.formatting.SizeBytes.txt")));
        return sizeText;
    }

    private static String truncateFloatingPointString(String in) {
        int index = in.indexOf(46);
        if (index > 0 && in.length() > index + 3) {
            in = in.substring(0, index + 3);
        }
        return in;
    }
}

