/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.sas.entities.GUID;
import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IConfiguration;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.PIPScheduler;
import com.sas.scheduler.api.servers.lsf.LSFCalendar;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.api.servers.oozie.OozieScheduler;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.api.servers.sasjfs.SASJFSServiceProxy;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.JobDeployerInterface;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.server.ServerDeployedJobUtilities;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilInterface;
import com.sas.scheduler.server.ServerUtilOMA;
import com.sas.scheduler.server.ServerUtilitiesListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerUtilities {
    private static ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ServerUtilities.class);
    private static final Logger LOGGER = LogManager.getLogger(ServerUtilities.class);
    private PromptCallbackInterface m_prompt;
    public static String SERVERCOMPONENTNAME = "ServerComponent";
    public static String NAMEATTRIBUTENAME = "Name";
    public static final String MYFOLDER_NAME = "My Folder";
    private ServerUtilInterface m_backingStoreMethod;
    private SessionContextInterface m_defaultSessionContext;
    private UserContextInterface m_defaultUserContext;
    private List<JobInfo> m_allFlowsAndJobs;
    private boolean m_listAvailable;
    private static Map<String, Scheduler> m_schedulerCache = Collections.synchronizedMap(new HashMap());
    private static Map<String, IWorkspace> m_workspaceCache = Collections.synchronizedMap(new HashMap());
    public static final int OKAY = 0;
    public static final int NOT_REMOVED_FROM_SCHEDULER = 1;
    public static final int NOT_REMOVED_FROM_METADATA = 2;
    public static final int SERVER_NOT_CONNECTED = 0;
    public static final int SERVER_CONNECTED = 1;
    public static final int USER_ABORTED = 2;
    public static final int SYSTEM_ABORTED = 3;
    public static final int SYSTEM_UNSUPPORTED = 4;
    public static final String Tzclient = "client";
    public static final String Tzserver = "server";
    public static final String OMR_FOLDER_DEFAULT = "/Shared Data";
    public static final String INVALIDFILENAMECHARACTERS = MetaUtilities.INVALIDFILENAMECHARACTERS;

    public ServerUtilities(PromptCallbackInterface prompt) {
        this.m_prompt = prompt;
    }

    public ServerUtilities(SessionContextInterface session, UserContextInterface user) throws SchedulerException {
        this.setDefaultSessionContext(session);
        this.m_backingStoreMethod = new ServerUtilOMA(session, user);
    }

    public void secondaryInitialization(boolean reset, boolean debug, String name, String repos) {
        this.m_backingStoreMethod.secondaryInitialization(reset, debug, name, repos);
    }

    public void setPromptCallbackInterface(PromptCallbackInterface prompt) {
        this.m_prompt = prompt;
        this.m_backingStoreMethod.setPrompt(this.m_prompt);
    }

    public void clearServerCaches() {
        this.clearServerCaches(false);
    }

    public void clearServerCaches(Boolean allCaches) {
        if (this.m_backingStoreMethod != null) {
            this.m_backingStoreMethod.clearServerCaches();
        }
        if (allCaches.booleanValue()) {
            Set<String> keys = m_schedulerCache.keySet();
            for (String key : keys) {
                Scheduler sch = m_schedulerCache.get(key);
                this.disconnectFromSchedulingServer(sch.getServerComponent());
            }
            m_schedulerCache = Collections.synchronizedMap(new HashMap());
        }
    }

    public void dispose() {
        if (this.m_backingStoreMethod != null) {
            this.m_backingStoreMethod.dispose();
        }
    }

    public List<SchedulerServerInfo> getSchedulingServers(int type) {
        return this.m_backingStoreMethod.getSchedulingServers(type);
    }

    public boolean checkSchedulerConnection(ServerFlowInfo info, String timezone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.checkSchedulerConnection(info, timezone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public boolean checkSchedulerConnection(ServerFlowInfo info, String timezone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.checkSchedulerConnection(info, timezone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public boolean checkSchedulerConnection(ServerFlowInfo info, String timezone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        SchedulerServerInfo sinfo = info.getInfo().getScheduler();
        if (sinfo == null) {
            return false;
        }
        Scheduler scheduler = this.getSchedulingServer(sinfo);
        if (scheduler.isConnectionNeededForAdvanceProperties() || scheduler.isConnectionNeededForTimeEvents()) {
            return this.connectToSchedulingServer(info, timezone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
        }
        return true;
    }

    @Deprecated
    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, String password, String timeZone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.makeSchedulerConnection(sinfo, user, password != null ? new SealedString(password) : null, timeZone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, SealedString password, String timeZone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.makeSchedulerConnection(sinfo, user, password, timeZone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    @Deprecated
    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, String password, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.makeSchedulerConnection(sinfo, user, password != null ? new SealedString(password) : null, timeZone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, SealedString password, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.makeSchedulerConnection(sinfo, user, password, timeZone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    @Deprecated
    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, String password, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        return this.makeSchedulerConnection(sinfo, user, password != null ? new SealedString(password) : null, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
    }

    public int makeSchedulerConnection(SchedulerServerInfo sinfo, String user, SealedString password, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        int rc = 0;
        try {
            Scheduler scheduler = this.getSchedulingServer(sinfo);
            if (user == null || user.length() == 0) {
                PasswordAuthentication pw = MetaUtilities.getLoginIdentity((SchedulerServerInfo)sinfo);
                if (pw == null) {
                    return 4;
                }
                user = pw.getUserName();
                SealedString sealedString = password = pw.getPassword() != null ? new SealedString(String.copyValueOf(pw.getPassword())) : null;
            }
            if ((rc = scheduler.makeConnection(user, password)) == 1) {
                ServerUtilities.setSchedulerDefaults(scheduler, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
                if (sinfo != null && (sinfo.getConnectionId() == null || m_schedulerCache.get(sinfo.getConnectionId()) == null)) {
                    String connectionId = GUID.newGUID();
                    sinfo.setConnectionId(connectionId);
                    scheduler.getServerComponent().setConnectionId(connectionId);
                    m_schedulerCache.put(connectionId, scheduler);
                }
            }
        }
        catch (SchedulerException e) {
            rc = 0;
            e.printStackTrace();
        }
        return rc;
    }

    private static void setClassLoader() {
        ClassLoader classloader = ServerUtilities.class.getClassLoader();
        Thread currThread = Thread.currentThread();
        currThread.setContextClassLoader(classloader);
    }

    public boolean isAllowPasswordCache() {
        return this.m_backingStoreMethod.isAllowPasswordCache();
    }

    public boolean isConnectionNeededForAdvanceProperties(SchedulerServerInfo sinfo) throws SchedulerException {
        Scheduler scheduler = this.getSchedulingServer(sinfo);
        return scheduler.isConnectionNeededForAdvanceProperties();
    }

    public boolean isConnectionNeededForTimeEvents(SchedulerServerInfo sinfo) throws SchedulerException {
        Scheduler scheduler = this.getSchedulingServer(sinfo);
        return scheduler.isConnectionNeededForTimeEvents();
    }

    public PasswordAuthentication getSchedulerLoginIdentity(SchedulerServerInfo server) throws SchedulerException {
        return this.m_backingStoreMethod.getSchedulerLoginIdentity(server);
    }

    public boolean connectToSchedulingServer(ServerFlowInfo info, String timezone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) {
        return this.connectToSchedulingServer(info, timezone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public boolean connectToSchedulingServer(ServerFlowInfo info, String timezone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) {
        return this.connectToSchedulingServer(info, timezone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public boolean connectToSchedulingServer(ServerFlowInfo info, String timezone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) {
        ServerUtilities.setClassLoader();
        SchedulerServerInfo sinfo = info.getInfo().getScheduler();
        if (sinfo == null) {
            return false;
        }
        try {
            Scheduler scheduler = this.getSchedulingServer(sinfo);
            boolean rc = scheduler.connectToSchedulingServer(this.m_prompt);
            if (rc) {
                FlowInfo finfo = info.getInfo();
                sinfo = scheduler.getServerComponent();
                finfo.setScheduler(sinfo);
                this.m_backingStoreMethod.setSchedulerAfterConnection(info, scheduler);
                ServerUtilities.setSchedulerDefaults(scheduler, timezone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
                if (sinfo.getConnectionId() == null || m_schedulerCache.get(sinfo.getConnectionId()) == null) {
                    String connectionId = GUID.newGUID();
                    sinfo.setConnectionId(connectionId);
                    scheduler.getServerComponent().setConnectionId(connectionId);
                    m_schedulerCache.put(connectionId, scheduler);
                }
            }
            return rc;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public void disconnectFromSchedulingServer(SchedulerServerInfo sinfo) {
        if (sinfo != null && sinfo.getConnectionId() != null) {
            String connectID = sinfo.getConnectionId();
            Scheduler scheduler = m_schedulerCache.get(connectID);
            if (scheduler != null) {
                scheduler.closeConnection();
            }
            sinfo.setConnectionId(null);
            m_schedulerCache.remove(connectID);
        }
    }

    public boolean isValidScheduler(SchedulerServerInfo scheduler) throws SchedulerException {
        return this.getSchedulingServer(scheduler) != null;
    }

    public void resetSchedulerDefaults(ServerFlowInfo info, String timeZone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        this.resetSchedulerDefaults(info, timeZone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public void resetSchedulerDefaults(ServerFlowInfo info, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        this.resetSchedulerDefaults(info, timeZone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public void resetSchedulerDefaults(ServerFlowInfo info, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) throws SchedulerException {
        SchedulerServerInfo sinfo = info.getInfo().getScheduler();
        Scheduler scheduler = this.getSchedulingServer(sinfo);
        scheduler.setDefaultsSet(false);
        ServerUtilities.setSchedulerDefaults(scheduler, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
    }

    public static void setSchedulerDefaults(Scheduler scheduler, String timeZone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) {
        ServerUtilities.setSchedulerDefaults(scheduler, timeZone, stdout, stderr, false, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public static void setSchedulerDefaults(Scheduler scheduler, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int maxHistory, int maxHistoryPerFlow) {
        ServerUtilities.setSchedulerDefaults(scheduler, timeZone, stdout, stderr, scoping, flowDefDir, 0, 10, maxHistory, maxHistoryPerFlow);
    }

    public static void setSchedulerDefaults(Scheduler scheduler, String timeZone, String stdout, String stderr, boolean scoping, String flowDefDir, int statusCheckTimeout, int statusCheckCycle, int maxHistory, int maxHistoryPerFlow) {
        if (scheduler == null) {
            return;
        }
        if (scheduler.areDefaultsSet()) {
            return;
        }
        if (scheduler instanceof LSFScheduler) {
            ((LSFScheduler)scheduler).setTimeZoneOrientation(timeZone);
            if (stdout != null) {
                ((LSFScheduler)scheduler).setStdout(stdout);
            }
            if (stderr != null) {
                ((LSFScheduler)scheduler).setStderr(stderr);
            }
            ((LSFScheduler)scheduler).setScoping(scoping);
            ((LSFScheduler)scheduler).setOutputDirectory(flowDefDir);
        } else if (!(scheduler instanceof SASJFScheduler)) {
            if (scheduler instanceof OSScheduler) {
                ((OSScheduler)scheduler).setMaximumsOnHistory(maxHistory, maxHistoryPerFlow);
            } else if (scheduler instanceof IPScheduler || scheduler instanceof PIPScheduler || scheduler instanceof OozieScheduler) {
                // empty if block
            }
        }
        scheduler.setDefaultsSet(true);
    }

    public List<SASAppServer> getAppServersWithDeployedDirectories() {
        return this.m_backingStoreMethod.getAppServersWithDeployedDirectories();
    }

    public List<BatchServerInfo> getBatchServers(int type, int subtype) {
        return this.m_backingStoreMethod.getBatchServers(type, subtype);
    }

    public SASAppServer getSASAppServerFromBatchServer(BatchServerInfo bsinfo) {
        return this.m_backingStoreMethod.getSASAppServerFromBatchServer(bsinfo);
    }

    public boolean isValidBatchServer(BatchServerInfo batchserver) {
        return this.m_backingStoreMethod.isValidBatchServer(batchserver);
    }

    public IWorkspace getWorkspaceServer(BatchServerInfo bsi, UserContextInterface user) throws SchedulerException, InvalidParameterException, CallbackCancelledException {
        IWorkspace iworkspace = ServerUtilities.getWorkspaceServerFromCache(bsi);
        if (iworkspace == null) {
            iworkspace = this.m_backingStoreMethod.getWorkspaceServer(bsi, user);
        }
        return iworkspace;
    }

    public IWorkspace checkConnectionToWorkspaceServer(BatchServerInfo batchserver) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        return this.checkConnectionToWorkspaceServer(batchserver, null);
    }

    public IWorkspace checkConnectionToWorkspaceServer(BatchServerInfo batchserver, PromptCallbackInterface prompt) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        return this.m_backingStoreMethod.checkConnectionToWorkspaceServer(batchserver, prompt);
    }

    public static void disconnectFromWorkspaceServer(BatchServerInfo binfo) {
        if (binfo != null && binfo.getConnectionId() != null) {
            block4: {
                IWorkspace workspace = m_workspaceCache.get(binfo.getConnectionId());
                if (workspace != null) {
                    try {
                        workspace.Close();
                    }
                    catch (GenericError e) {
                        if (!MetaUtilities.isDebug()) break block4;
                        e.printStackTrace();
                    }
                }
            }
            m_workspaceCache.remove(binfo.getConnectionId());
        }
    }

    public static IWorkspace getWorkspaceServerFromCache(BatchServerInfo bsi) {
        IWorkspace iworkspace = null;
        if (bsi != null && bsi.getConnectionId() != null) {
            iworkspace = m_workspaceCache.get(bsi.getConnectionId());
        }
        return iworkspace;
    }

    public static void putWorkspaceServerInCache(String connectionId, IWorkspace iworkspace) {
        m_workspaceCache.put(connectionId, iworkspace);
    }

    public boolean isFileSystemAccessible(SchedulerServerInfo sinfo) {
        return this.m_backingStoreMethod.isFileSystemAccessible(sinfo);
    }

    public IWorkspace checkConnectionToWorkspaceServer(SchedulerServerInfo schedserver) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        return this.checkConnectionToWorkspaceServer(schedserver, null);
    }

    public IWorkspace checkConnectionToWorkspaceServer(SchedulerServerInfo schedserver, PromptCallbackInterface prompt) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        return this.m_backingStoreMethod.checkConnectionToWorkspaceServer(schedserver, prompt);
    }

    public IWorkspace checkConnectionToWorkspaceServer(SASAppServer appserver, PromptCallbackInterface prompt) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        IWorkspace iworkspace = null;
        try {
            iworkspace = this.m_backingStoreMethod.checkConnectionToWorkspaceServer(this.getDefaultUserContext(), appserver);
        }
        catch (SchedulerException se) {
            if (prompt != null) {
                String title = MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.Login.WorkspaceServer.Title.fmt"), (Object)appserver.getName());
                while (iworkspace == null) {
                    String[] rc = prompt.promptLogin(title, null, null);
                    if (Integer.valueOf(rc[0]) == 1) {
                        iworkspace = this.m_backingStoreMethod.makeConnectionToWorkspaceServer(appserver, rc[1], rc[2]);
                        continue;
                    }
                    return null;
                }
            }
            throw se;
        }
        return iworkspace;
    }

    public IWorkspace checkConnectionToWorkspaceServer(SASAppServer appserver) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        return this.m_backingStoreMethod.checkConnectionToWorkspaceServer(this.getDefaultUserContext(), appserver);
    }

    public boolean setDefaultSessionContext(SessionContextInterface session) {
        this.m_defaultSessionContext = session;
        try {
            if (this.m_defaultSessionContext != null) {
                this.m_backingStoreMethod = new ServerUtilOMA(this.m_defaultSessionContext, this.m_defaultSessionContext.getUserContext());
                return this.m_backingStoreMethod.setDefaultSessionContext(session);
            }
            this.m_backingStoreMethod = null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return false;
    }

    public SessionContextInterface getDefaultSessionContext() {
        return this.m_defaultSessionContext;
    }

    public boolean setDefaultUserContext() {
        if (this.m_defaultSessionContext != null) {
            try {
                UserContextInterface userContext = this.m_defaultSessionContext.getUserContext();
                if (userContext != null) {
                    return this.setDefaultUserContext(userContext);
                }
            }
            catch (RemoteException e) {
                this.setDefaultUserContext(null);
            }
        }
        return false;
    }

    public boolean setDefaultUserContext(UserContextInterface user) {
        this.m_defaultUserContext = user;
        return true;
    }

    public UserContextInterface getDefaultUserContext() {
        return this.m_defaultUserContext;
    }

    public String getUserID(UserContextInterface uc) throws SchedulerException {
        return this.m_backingStoreMethod.getUserID(uc);
    }

    public boolean clearChallengeCallbackHandler() {
        try {
            if (this.m_defaultUserContext != null) {
                this.m_defaultUserContext.setChallengeCallbackHandler(null);
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean usePortableTimeEvent() {
        return MetaUtilities.usePortableTimeEvent();
    }

    public void setPortableTimeEvent(boolean flag) {
        MetaUtilities.setPortableTimeEvent((boolean)flag);
    }

    public String getFolderLocation(SASFolder folder) {
        return this.m_backingStoreMethod.getFolderLocation(folder);
    }

    public SASFolder getFolder(String name) {
        return this.m_backingStoreMethod.getFolder(name);
    }

    public void setDefaultFolder(String defaultDefaultFolder) {
        this.m_backingStoreMethod.setDefaultFolder(defaultDefaultFolder);
    }

    public SASFolder getMyFolder() {
        return this.m_backingStoreMethod.getMyFolder(this.getDefaultUserContext());
    }

    public List<DirectoryInfo> getExistingDeploymentDirectories(BatchServerInfo batchserver) {
        return this.m_backingStoreMethod.getExistingDeploymentDirectories(batchserver);
    }

    public FileInfo getSourceCodes(DisplayInfo job) {
        return this.m_backingStoreMethod.getSourceCodes(job);
    }

    public String createFullPath(FileInfo file, BatchServerInfo binfo) {
        return this.m_backingStoreMethod.createFullPath(file, binfo);
    }

    public String uniqueName(String name, String[] exclude) {
        return this.m_backingStoreMethod.uniqueName(name, exclude);
    }

    public boolean setAllowFlowPrefixForLogfile(boolean flag) {
        CommandUtilities.setAllowFlowPrefixForLogfile((boolean)flag);
        return true;
    }

    public boolean setOutputfile(boolean flag) {
        CommandUtilities.setOutputfile((boolean)flag);
        return true;
    }

    public boolean isAppServerResource() {
        return MetaUtilities.isAppServerResource();
    }

    public void setAppServerResource(boolean flag) {
        MetaUtilities.setAppServerResource((boolean)flag);
    }

    public List<JobInfo> getAllJobsAndFlows(boolean readFromServer) {
        if (readFromServer || !this.m_listAvailable) {
            this.m_allFlowsAndJobs = this.m_backingStoreMethod.getAllJobsAndFlows(readFromServer);
            if (this.m_allFlowsAndJobs != null) {
                this.m_listAvailable = true;
            }
        }
        return this.m_allFlowsAndJobs;
    }

    public List<JobInfo> getAllJobsAndFlowsByRoles(boolean readFromServer) {
        if (readFromServer || !this.m_listAvailable) {
            this.m_allFlowsAndJobs = new ArrayList<JobInfo>();
            List<JobInfo> jobs = this.m_backingStoreMethod.getAllJobsAndFlowsByRoles("SCHEDULER_JOB", readFromServer);
            List<JobInfo> flows = this.m_backingStoreMethod.getAllJobsAndFlowsByRoles("SCHEDULER_FLOW", readFromServer);
            if (jobs != null) {
                this.m_allFlowsAndJobs.addAll(jobs);
            }
            if (flows != null) {
                this.m_allFlowsAndJobs.addAll(flows);
            }
            if (this.m_allFlowsAndJobs != null && this.m_allFlowsAndJobs.size() > 0) {
                this.m_listAvailable = true;
            }
        }
        return this.m_allFlowsAndJobs;
    }

    public boolean renameInListForAllJobsAndFlows(String id, String neoName) {
        int size = this.m_allFlowsAndJobs.size();
        for (int index = 0; index < size; ++index) {
            DisplayInfo i = (DisplayInfo)this.m_allFlowsAndJobs.get(index);
            String fqid = i.getId();
            if (fqid.compareTo(id) != 0) continue;
            i.setName(neoName);
            return true;
        }
        return false;
    }

    public boolean addToListForAllJobsAndFlows(JobInfo info) {
        return this.m_allFlowsAndJobs.add(info);
    }

    public boolean deleteFromListForAllJobsAndFlows(JobInfo info) {
        int size = this.m_allFlowsAndJobs.size();
        for (int index = 0; index < size; ++index) {
            String btext;
            DisplayInfo i = (DisplayInfo)this.m_allFlowsAndJobs.get(index);
            String atext = i.getName() + i.getId();
            if (atext.compareTo(btext = info.getName() + info.getId()) != 0) continue;
            this.m_allFlowsAndJobs.remove(index);
            return true;
        }
        return false;
    }

    public boolean resetFromInfo(ServerFlowInfo info) throws SchedulerException {
        return this.m_backingStoreMethod.resetFromInfo(info);
    }

    public DisplayInfo refresh(ServerInfoInterface info) throws SchedulerException {
        return this.m_backingStoreMethod.refresh(info);
    }

    public Object generateAllInformation(ServerInfoInterface info) throws SchedulerException {
        return this.m_backingStoreMethod.generateAllInformation(info);
    }

    public Date getDateCreated(ServerInfoInterface serverinfo) {
        return this.m_backingStoreMethod.getDateCreated(serverinfo);
    }

    public String getDateCreatedStr(ServerInfoInterface serverinfo, boolean localformat) {
        return this.m_backingStoreMethod.getDateCreatedStr(serverinfo, localformat);
    }

    public Date getDateModified(ServerInfoInterface serverinfo) {
        return this.m_backingStoreMethod.getDateModified(serverinfo);
    }

    public String getDateModifiedStr(ServerInfoInterface serverinfo, boolean localformat) {
        return this.m_backingStoreMethod.getDateModifiedStr(serverinfo, localformat);
    }

    public String errorConditions(ServerInfoInterface serverinfo) throws SchedulerException {
        return this.m_backingStoreMethod.errorConditions(serverinfo);
    }

    public void checkAssociatedInfoForErrors(ServerFlowInfo flow, ServerInfoInterface info) throws SchedulerException {
        this.m_backingStoreMethod.checkAssociatedInfoForErrors(flow, info);
    }

    public boolean hasCriticalErrors(ServerFlowInfo flow) throws SchedulerException {
        return this.m_backingStoreMethod.hasCriticalErrors(flow);
    }

    public boolean isJobAssociatedError(ServerJobInfo job) throws SchedulerException {
        return this.m_backingStoreMethod.isJobAssociatedError(job);
    }

    public void reevaluateErrors(ServerInfoInterface serverinfo) throws SchedulerException {
        this.m_backingStoreMethod.reevaluateErrors(serverinfo);
    }

    public List<JobInfo> getDeployedJobs(List<?> filter) throws SchedulerException {
        return this.m_backingStoreMethod.getDeployedJobs(filter);
    }

    public List<JobInfo> getDeployedJobs(List<?> filter, boolean displayOnly) throws SchedulerException {
        return this.m_backingStoreMethod.getDeployedJobs(filter, displayOnly);
    }

    public List<DisplayInfo> getJobsForFlow(FilterSelector filter, ServerFlowInfo flow) {
        return this.m_backingStoreMethod.getJobsForFlow(filter, flow, this);
    }

    public List<JobInfo> getAvailableJobsSubflowsByLocation(String folder, List<DisplayInfo> inFlow) {
        return this.m_backingStoreMethod.getAvailableJobsSubflowsByLocation(folder, inFlow);
    }

    public List<ServerFlowInfo> getListOfFlows(ServerInfoInterface info) throws SchedulerException {
        return this.m_backingStoreMethod.getListOfFlows(info, this);
    }

    public void setJobListInFlow(FlowInfo info) {
        this.m_backingStoreMethod.setJobListInFlow(info);
    }

    public ServerFlowInfo getFlow(String id) {
        return this.m_backingStoreMethod.getFlow(id, this);
    }

    public List<ServerFlowInfo> getFlows(FilterSelector filter, List<?> itemsList) {
        return this.m_backingStoreMethod.getFlows(filter, itemsList);
    }

    public SortedSet<?> getFlowsFromRepository(int select) {
        return this.getFlowsFromRepository(select, false);
    }

    public SortedSet<?> getFlowsFromRepository(int select, boolean displayOnly) {
        return this.m_backingStoreMethod.getFlowsFromRepository(select, displayOnly);
    }

    public SortedSet<FlowInfo> getFlowsFromRepository(FilterSelector filter, boolean displayOnly) throws SchedulerException {
        return this.m_backingStoreMethod.getFlowsFromRepository(filter, displayOnly);
    }

    public List<FlowHistory> getFlowHistoryList(SchedulerServerInfo sinfo, String userid, List<FlowInfo> flowNames, int count) throws SchedulerException {
        ArrayList<FlowHistory> returnList = new ArrayList<FlowHistory>();
        Scheduler scheduler = this.getSchedulingServer(sinfo);
        if (scheduler != null) {
            List histories = scheduler.getFlowHistoryList(userid, flowNames, count);
            for (com.sas.scheduler.api.servers.FlowHistory item : histories) {
                FlowHistory record = new FlowHistory();
                record.setIdDataBinding((long)((int)item.getID()));
                Date date = item.getStartTime();
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(date);
                record.setStartTimeDataBinding((Calendar)start);
                date = item.getFinishTime();
                GregorianCalendar finish = new GregorianCalendar();
                finish.setTime(date);
                record.setFinishTimeDataBinding((Calendar)finish);
                record.setStateDataBinding(item.getState());
                record.setStatusDataBinding(item.getStatus());
                record.setInstanceNameDataBinding(item.getInstanceName());
                record.setFlowNameDataBinding(item.getFlowName());
                record.setSchedulerFlowNameDataBinding(item.getSchedulerFlowName());
                record.setErrorCodeDataBinding(item.getErrorCode());
                returnList.add(record);
            }
        }
        return returnList;
    }

    public List<FlowHistory> getFlowHistoryList(String schId, String userid, int count) throws SchedulerException {
        ArrayList<FlowHistory> returnList = new ArrayList<FlowHistory>();
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null) {
            List histories = scheduler.getFlowHistoryList(userid, count);
            for (com.sas.scheduler.api.servers.FlowHistory item : histories) {
                FlowHistory record = new FlowHistory();
                record.setIdDataBinding((long)((int)item.getID()));
                Date date = item.getStartTime();
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(date);
                record.setStartTimeDataBinding((Calendar)start);
                date = item.getFinishTime();
                if (date != null) {
                    GregorianCalendar finish = new GregorianCalendar();
                    finish.setTime(date);
                    record.setFinishTimeDataBinding((Calendar)finish);
                }
                record.setStateDataBinding(item.getState());
                record.setStatusDataBinding(item.getStatus());
                record.setInstanceNameDataBinding(item.getInstanceName());
                record.setFlowNameDataBinding(item.getFlowName());
                record.setSchedulerFlowNameDataBinding(item.getSchedulerFlowName());
                record.setErrorCodeDataBinding(item.getErrorCode());
                returnList.add(record);
            }
        }
        return returnList;
    }

    public String getFlowDefinition(String schId, String flowDefinitionId) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).getFlowDefinition(flowDefinitionId);
        }
        return null;
    }

    public boolean holdFlow(String schId, String flowDefinition) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).holdFlow(flowDefinition);
        }
        return false;
    }

    public boolean releaseFlow(String schId, String flowDefinition) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).releaseFlow(flowDefinition);
        }
        return false;
    }

    public boolean triggerFlow(String schId, String flowDefinition) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).triggerFlow(flowDefinition);
        }
        return false;
    }

    public boolean killItemInstance(String schId, String flowInstance, String itemInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).killItemInstance(flowInstance, itemInstance);
        }
        return false;
    }

    public boolean killFlowInstance(String schId, String flowInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).killFlowInstance(flowInstance);
        }
        return false;
    }

    public boolean pauseFlowInstance(String schId, String flowInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).pauseFlowInstance(flowInstance);
        }
        return false;
    }

    public boolean resumeFlowInstance(String schId, String flowInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).resumeFlowInstance(flowInstance);
        }
        return false;
    }

    public StringBuffer getStandardOutput(String schId, String flowInstance, String jobInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).getStandardOut(flowInstance, jobInstance);
        }
        return null;
    }

    public StringBuffer getStandardErr(String schId, String flowInstance, String jobInstance) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).getStandardError(flowInstance, jobInstance);
        }
        return null;
    }

    public List<JobRendererInfo> getJobrenderers(String schId) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            IConsole console = (IConsole)scheduler;
            return console.getJobRenderers(schId);
        }
        return null;
    }

    public List<String> getMessageQueues(String schId) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().showMessageQueues()) {
            IConfiguration console = (IConfiguration)scheduler;
            return console.getMessageQueues(schId);
        }
        return null;
    }

    public List<Object> getMessages(String schId, String qname) throws SchedulerException {
        SchedulerServerInfo ssi;
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && (ssi = scheduler.getServerComponent()) != null && ssi.showMessageQueues()) {
            IConfiguration console = (IConfiguration)scheduler;
            String selector = ssi.getId();
            if (ssi.getConnectionId() != null) {
                selector = ssi.getConnectionId();
            }
            return console.browseMessageQueue(qname, selector);
        }
        return null;
    }

    public int deleteScheduledFlow(ServerFlowInfo flow) {
        int rc = this.removeScheduledFlow(flow);
        if (rc == 0) {
            rc = this.deleteFlowFromMetadata(flow) ? 0 : 2;
        }
        return rc;
    }

    public int removeScheduledFlow(ServerFlowInfo flow) {
        try {
            FlowInfo info = flow.getInfo();
            Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(info.getScheduler());
            if (scheduler == null) {
                info.setFlowSubmitted(false);
                boolean metadataUpdated = this.m_backingStoreMethod.commitFlowToStore(info);
                if (!metadataUpdated) {
                    return 2;
                }
                return 1;
            }
            boolean success = false;
            try {
                success = scheduler.removeFlow(info);
            }
            catch (UnsupportedOperationException ex) {
                success = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!success) {
                info.setFlowSubmitted(false);
                boolean metadataUpdated = this.m_backingStoreMethod.commitFlowToStore(info);
                if (!metadataUpdated) {
                    return 2;
                }
                return 1;
            }
            info.setFlowSubmitted(false);
            String flowname = scheduler.genFlowName(info);
            String runnowname = scheduler.runNowName(flowname);
            if (flowname.compareTo(runnowname) != 0) {
                try {
                    scheduler.removeFlow(runnowname);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (scheduler instanceof DIPServiceProxy || scheduler instanceof SASJFSServiceProxy) {
                    flow.refresh();
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            boolean metadataUpdated = this.m_backingStoreMethod.commitFlowToStore(info);
            if (!metadataUpdated) {
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int deleteUnscheduledFlow(ServerFlowInfo flow) {
        try {
            String runnowname;
            String flowname;
            FlowInfo info = flow.getInfo();
            Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(info.getScheduler());
            if (scheduler != null && (flowname = scheduler.genFlowName(info)).compareTo(runnowname = scheduler.runNowName(flowname)) != 0) {
                scheduler.removeFlow(runnowname);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.deleteFlowFromMetadata(flow)) {
            return 0;
        }
        return 2;
    }

    public boolean deleteFlowFromMetadata(ServerFlowInfo flow) {
        return this.m_backingStoreMethod.deleteFlowFromMetadata(flow);
    }

    public boolean fixUnableToDelete(ServerFlowInfo flow) {
        return this.m_backingStoreMethod.fixUnableToDelete(flow);
    }

    public FlowInfo createFlow(FlowInfo info) throws SchedulerException {
        return this.m_backingStoreMethod.createFlow(info);
    }

    public FlowInfo createFlow(String flowname, SchedulerServerInfo scheduler, SASFolder sasfolder, List<DisplayInfo> listofJobs) throws SchedulerException {
        return this.createFlow(flowname, scheduler, sasfolder, listofJobs, null);
    }

    public FlowInfo createFlow(String flowname, SchedulerServerInfo scheduler, SASFolder sasfolder, List<DisplayInfo> listofJobs, TriggerEventInfo trigger) throws SchedulerException {
        FlowInfo info = new FlowInfo(flowname, trigger, scheduler);
        info.setJobs(listofJobs);
        info.setLocation(sasfolder.getLocation());
        return this.m_backingStoreMethod.createFlow(info);
    }

    public List<Calendar> getHolidays(Calendar queryDate, Calendar endQueryDate) {
        ArrayList<Calendar> returnList = new ArrayList<Calendar>();
        try {
            LSFScheduler sch;
            LSFCalendar lsfcal;
            List<SchedulerServerInfo> schedulers = this.m_backingStoreMethod.getSchedulingServers(102);
            if (schedulers != null && schedulers.size() > 0 && (lsfcal = (sch = (LSFScheduler)this.m_backingStoreMethod.getSchedulingServer(schedulers.get(0))).getCalendar("Holidays@Sys")) != null) {
                String[] dates = lsfcal.getJFCalendar().getExpression().split(",");
                int numDates = dates.length;
                String firstDate = dates[0];
                dates[0] = firstDate.substring(firstDate.indexOf("(") + 1);
                String lastDate = dates[numDates - 1];
                dates[numDates - 1] = lastDate.substring(0, lastDate.indexOf(")"));
                for (int x = 0; x < numDates; ++x) {
                    int day;
                    int month;
                    String dateStr = dates[x];
                    int firstSlash = dateStr.indexOf("/");
                    int secondSlash = dateStr.lastIndexOf("/");
                    int year = Integer.valueOf(dateStr.substring(0, firstSlash));
                    GregorianCalendar cal = new GregorianCalendar(year, month = Integer.valueOf(dateStr.substring(firstSlash + 1, secondSlash)) - 1, day = Integer.valueOf(dateStr.substring(secondSlash + 1)).intValue());
                    if (cal.before(queryDate) || cal.after(endQueryDate)) continue;
                    returnList.add(cal);
                }
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return returnList;
    }

    public List<Calendar> getOutages(Calendar queryDate, Calendar endQueryDate) {
        ArrayList<Calendar> returnList = new ArrayList<Calendar>();
        try {
            LSFScheduler sch;
            LSFCalendar lsfcal;
            List<SchedulerServerInfo> schedulers = this.m_backingStoreMethod.getSchedulingServers(102);
            if (schedulers != null && schedulers.size() > 0 && (lsfcal = (sch = (LSFScheduler)this.m_backingStoreMethod.getSchedulingServer(schedulers.get(0))).getCalendar("Outages@Sys")) != null) {
                String[] dates = lsfcal.getJFCalendar().getExpression().split(",");
                int numDates = dates.length;
                String firstDate = dates[0];
                dates[0] = firstDate.substring(firstDate.indexOf("(") + 1);
                String lastDate = dates[numDates - 1];
                dates[numDates - 1] = lastDate.substring(0, lastDate.indexOf(")"));
                for (int x = 0; x < numDates; ++x) {
                    int day;
                    int month;
                    String dateStr = dates[x];
                    int firstSlash = dateStr.indexOf("/");
                    int secondSlash = dateStr.lastIndexOf("/");
                    int year = Integer.valueOf(dateStr.substring(0, firstSlash));
                    GregorianCalendar cal = new GregorianCalendar(year, month = Integer.valueOf(dateStr.substring(firstSlash + 1, secondSlash)).intValue(), day = Integer.valueOf(dateStr.substring(secondSlash + 1)).intValue());
                    if (cal.before(queryDate) || cal.after(endQueryDate)) continue;
                    returnList.add(cal);
                }
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return returnList;
    }

    public List<Calendar> getNextScheduledDates(FlowInfo flow, Calendar queryDate, Calendar endQueryDate, int count) throws SchedulerException {
        ArrayList<Calendar> returnList = new ArrayList<Calendar>();
        try {
            TriggerEventInfo trigger = flow.getTriggerEvent();
            if (trigger != null && trigger.getEvent() != null) {
                Scheduler sch;
                AbstractEventInfo info = trigger.getEvent();
                List<Calendar> temp = this.processNextScheduledDates((DisplayInfo)info, sch = this.getSchedulingServer(flow.getScheduler()), queryDate, endQueryDate, count);
                if (temp.size() > 0) {
                    returnList.addAll(temp);
                } else if (MetaUtilities.isDebug()) {
                    System.out.println("getNextScheduledDates returns an empty list");
                }
            }
            return returnList;
        }
        catch (InvalidRecurrenceException e) {
            e.printStackTrace();
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private List<Calendar> processNextScheduledDates(DisplayInfo info, Scheduler sch, Calendar queryDate, Calendar endQueryDate, int count) throws InvalidRecurrenceException, SchedulerException {
        ArrayList<Calendar> returnList;
        block31: {
            block30: {
                IRecurrenceInfo rinfo;
                block32: {
                    returnList = new ArrayList<Calendar>();
                    if (!(info instanceof TimeEventInfo)) break block30;
                    TimeEventInfo tei = (TimeEventInfo)info;
                    rinfo = tei.getRecurrence();
                    if (rinfo == null) break block31;
                    List dates = rinfo.getNextDates(queryDate, endQueryDate, count);
                    if (dates == null) break block32;
                    for (Calendar cal : dates) {
                        int[] hours = sch.getListFromHourMinuteStr(tei.getHours());
                        int[] minutes = sch.getListFromHourMinuteStr(tei.getMinutes());
                        for (int x = 0; x < hours.length; ++x) {
                            for (int y = 0; y < minutes.length; ++y) {
                                cal.set(11, hours[x]);
                                cal.set(12, minutes[y]);
                                if (cal.before(queryDate)) continue;
                                returnList.add((Calendar)cal.clone());
                            }
                        }
                    }
                    break block31;
                }
                if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) break block31;
                String s = "  Null list of next dates: " + rinfo.toString();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(s);
                } else {
                    System.out.println(s);
                }
                break block31;
            }
            if (!(info instanceof FileEventInfo) && info instanceof GroupingEventInfo) {
                String s2;
                String s3;
                Integer i;
                GroupingEventInfo gei = (GroupingEventInfo)info;
                List deps = gei.getDependencies2();
                int numDeps = deps.size();
                int maxSize = 9999;
                Calendar[][] matrix = new Calendar[numDeps][maxSize];
                for (int x = 0; x < numDeps; ++x) {
                    List<Calendar> temp = this.processNextScheduledDates((DisplayInfo)deps.get(x), sch, queryDate, endQueryDate, 0);
                    int tsize = temp.size() < maxSize ? temp.size() : maxSize;
                    for (int y = 0; y < tsize; ++y) {
                        matrix[x][y] = temp.get(y);
                    }
                }
                TreeMap<Long, Integer> map = new TreeMap<Long, Integer>();
                for (int x = 0; x < numDeps; ++x) {
                    for (Calendar cal : matrix[x]) {
                        if (cal == null) continue;
                        Object obj = map.get(cal.getTime().getTime());
                        Integer i2 = obj == null ? Integer.valueOf(0) : (Integer)obj;
                        Integer n = i2;
                        Integer n2 = i2 = Integer.valueOf(i2 + 1);
                        map.put(cal.getTime().getTime(), i2);
                    }
                }
                if (count == 0) {
                    if (gei.getEventType() == 0) {
                        Set keys = map.keySet();
                        for (Long cStr : keys) {
                            GregorianCalendar c = new GregorianCalendar();
                            c.setTime(new Date(cStr));
                            i = (Integer)map.get(c.getTime().getTime());
                            s3 = "";
                            if (i == numDeps) {
                                returnList.add(c);
                                s3 = "Adding " + c.getTime().toString() + " to list of return dates";
                            }
                            if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) continue;
                            s2 = "  " + c.getTime().toString() + " is in " + i + " dependencies";
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(s2);
                                LOGGER.debug(s3);
                                continue;
                            }
                            System.out.println(s2);
                            System.out.println(s3);
                        }
                    } else {
                        Set keys = map.keySet();
                        for (Long cStr : keys) {
                            GregorianCalendar c = new GregorianCalendar();
                            c.setTime(new Date(cStr));
                            returnList.add(c);
                        }
                    }
                } else if (gei.getEventType() == 0) {
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s1 = "Comparing lists of dates for AND grouping of events: " + numDeps;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s1);
                        } else {
                            System.out.println(s1);
                        }
                    }
                    Set keys = map.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext() && returnList.size() < count) {
                        Long cStr = (Long)it.next();
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTime(new Date(cStr));
                        i = (Integer)map.get(c.getTime().getTime());
                        s3 = "";
                        if (i == numDeps) {
                            returnList.add(c);
                            s3 = "Adding " + c.getTime().toString() + " to list of return dates";
                        }
                        if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) continue;
                        s2 = "  " + c.getTime().toString() + " is in " + i + " dependencies";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s2);
                            LOGGER.debug(s3);
                            continue;
                        }
                        System.out.println(s2);
                        System.out.println(s3);
                    }
                } else {
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s1 = "Comparing lists of dates for OR grouping of events: " + numDeps;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s1);
                        } else {
                            System.out.println(s1);
                        }
                    }
                    Set keys = map.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext() && returnList.size() < count) {
                        Long cStr = (Long)it.next();
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTime(new Date(cStr));
                        returnList.add(c);
                    }
                }
            }
        }
        return returnList;
    }

    public boolean updateScheduler(SchedulerServerInfo ssi) throws SchedulerException {
        return this.m_backingStoreMethod.updateScheduler(ssi);
    }

    public boolean updateDeployedFlow(ServerFlowInfo finfo) throws SchedulerException {
        return this.m_backingStoreMethod.updateDeployedFlow(finfo);
    }

    public void updateJobCommandline(JobInfo job, String flowname) {
        this.m_backingStoreMethod.updateJobCommandline(job, flowname);
    }

    public void validateJobCmdLine() {
        this.m_backingStoreMethod.validateCmdlineForDeployedJobs();
    }

    public boolean commitFlowToOMR(FlowInfo info) throws SchedulerException {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            return this.m_backingStoreMethod.commitFlowToStore(info);
        }
        return false;
    }

    public boolean commitFlowToStore(FlowInfo info) throws SchedulerException {
        return this.m_backingStoreMethod.commitFlowToStore(info);
    }

    public boolean updateSASAppServerDirectories(SASAppServer server) throws SchedulerException {
        return this.m_backingStoreMethod.updateSASAppServerDirectories(server);
    }

    public boolean isValidFlowName(String name, SchedulerServerInfo ssi) {
        block3: {
            try {
                Scheduler scheduler = this.getSchedulingServer(ssi);
                if (!scheduler.isValidFlowName(name) || !MetaUtilities.isValidFlowName((String)name)) {
                    return false;
                }
            }
            catch (Exception ex) {
                if (DeployedFlow.isValidName((String)name)) break block3;
                return false;
            }
        }
        return true;
    }

    public String makeValidFlowName(String name, SchedulerServerInfo ssi) throws SchedulerException {
        String validFlowName = null;
        if (ssi == null) {
            validFlowName = MetaUtilities.makeValidFlowName((String)name);
        } else {
            Scheduler scheduler = this.getSchedulingServer(ssi);
            validFlowName = scheduler.makeValidFlowname(name);
        }
        return validFlowName;
    }

    public JobInfo createDeployedJob(String jobName, BatchServerInfo bsinfo, SASFolder sasFolder, DisplayInfo associatedJob, String jobArgs) throws SchedulerException {
        if (!DeployedJob.isValidName((String)jobName)) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.InvalidJobName.txt"));
        }
        return this.m_backingStoreMethod.createDeployedJob(jobName, bsinfo, sasFolder, associatedJob, jobArgs, this.getDefaultUserContext());
    }

    public SchedulerResultSet deployBatchJobs(DeployedJobInterface data, UserContextInterface user, DeployedJobCodeGenerationInterface codegen) {
        return this.m_backingStoreMethod.deployBatchJobs(data, this, user, codegen);
    }

    public SchedulerResultSet redeployBatchJobs(DeployedJobInterface data, UserContextInterface user, DeployedJobCodeGenerationInterface codegen) {
        return this.m_backingStoreMethod.redeployBatchJobs(data, user, codegen);
    }

    public JobInfo createDataStepDeployedJob(String jobName, BatchServerInfo bsinfo, SASFolder sasFolder, String sourceFileName, DirectoryInfo deploymentDir) throws SchedulerException {
        if (bsinfo.getType() != 1) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.InvalidBatchServer.txt"));
        }
        if (!DeployedJob.isValidName((String)jobName)) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.InvalidJobName.txt"));
        }
        if (deploymentDir == null) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingDeploymentDir.txt"));
        }
        if (sourceFileName == null) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingSourceFile.txt"));
        }
        return this.m_backingStoreMethod.createDataStepDeployedJob(jobName, bsinfo, sasFolder, sourceFileName, deploymentDir, this.getDefaultUserContext());
    }

    public JobInfo createDeployedJob(JobInfo job) throws SchedulerException {
        if (!DeployedJob.isValidName((String)job.getName())) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.InvalidJobName.txt"));
        }
        return this.m_backingStoreMethod.createDeployedJob(job, this.getDefaultUserContext());
    }

    public boolean commitJobToStore(JobInfo info, String flowname) throws SchedulerException {
        return this.m_backingStoreMethod.commitJobToStore(info, flowname);
    }

    public void updateDeployedJob(JobInfo jinfo, String flowname) throws SchedulerException {
        JobDeployerInterface redeployer = this.getDeployedJobUtilities(this.m_prompt, null);
        SchedulerResultSet results = redeployer.redeploy((DeployedJobInterface)new redeployJobData(jinfo, this));
        if (results.getReturnValue() == 0) {
            throw new SchedulerException(results.getMessage());
        }
    }

    public JobInfo getJobInfoFromId(String id) throws SchedulerException {
        JobInfo jinfo = new JobInfo();
        jinfo.setId(id);
        jinfo.setDisplayOnly(true);
        ServerJobInfo sjinfo = new ServerJobInfo((DisplayInfo)jinfo, null, this);
        if (!sjinfo.generateAllInformation(true)) {
            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.FailedToGetJobInfoFromId.txt"));
        }
        return (JobInfo)sjinfo.getJobInfo();
    }

    public FlowInfo getFlowInfoFromId(String id) throws SchedulerException {
        FlowInfo finfo = new FlowInfo();
        finfo.setId(id);
        ServerFlowInfo sfinfo = new ServerFlowInfo(finfo, this, null);
        try {
            if (!sfinfo.generateAllInformation(true).booleanValue()) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.FailedToGetFlowInfoFromId.txt"));
            }
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
        return sfinfo.getInfo();
    }

    public void deleteDeployedJob(JobInfo jinfo) throws SchedulerException {
        this.m_backingStoreMethod.deleteDeployedJobFromMetadata(jinfo.getId());
    }

    public boolean deleteDeployedJob(String id) throws SchedulerException {
        return this.m_backingStoreMethod.deleteDeployedJobFromMetadata(id);
    }

    public int deleteDeployedFlow(String id) throws SchedulerException {
        int result = 0;
        ServerFlowInfo sfinfo = this.m_backingStoreMethod.getFlow(id, this);
        result = sfinfo.isFlowSubmitted() ? this.deleteScheduledFlow(sfinfo) : this.deleteUnscheduledFlow(sfinfo);
        return result;
    }

    public boolean isValidJobName(String name, SchedulerServerInfo ssi) {
        if (ssi != null) {
            try {
                Scheduler scheduler = this.getSchedulingServer(ssi);
                if (!scheduler.isValidJobName(name)) {
                    return false;
                }
            }
            catch (Exception ex) {
                return DeployedJob.isValidName((String)name);
            }
        }
        return DeployedJob.isValidName((String)name);
    }

    public String getInvalidCharsJob(SchedulerServerInfo ssi) {
        try {
            Scheduler scheduler = this.getSchedulingServer(ssi);
            return scheduler.getInvalidChars(false);
        }
        catch (Exception ex) {
            return DeployedJob.getInvalidChars();
        }
    }

    public boolean isValidFilename(String filename) {
        return MetaUtilities.isValidFilename((String)filename);
    }

    public int getMaxJobPriorityFromScheduler(SchedulerServerInfo ssi) {
        try {
            Scheduler scheduler = this.getSchedulingServer(ssi);
            return scheduler.getMaxJobPriority();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public String getSourceFile(JobInfo jinfo) {
        return this.m_backingStoreMethod.getSourceFile(jinfo);
    }

    public boolean isJobSourceFile(JobInfo jinfo) {
        String filename = this.m_backingStoreMethod.getSourceFile(jinfo);
        return filename != null;
    }

    public boolean isValidJobSourceFile(JobInfo jinfo) {
        String filename = this.m_backingStoreMethod.getSourceFile(jinfo);
        return filename != null && MetaUtilities.isValidFilename((String)filename);
    }

    public String getLogfile(ServerJobInfo job, ServerFlowInfo flow, IWorkspace workspace) throws SchedulerException {
        return this.m_backingStoreMethod.getLogfile(job, flow, workspace);
    }

    public boolean writeJCL(IWorkspace iworkspace, String jclfile, String text) {
        IFileService rio = iworkspace.FileService();
        try {
            return CommandUtilities.saveToRemoteFile((IFileService)rio, (String)jclfile, (int)2, (String)text);
        }
        catch (GenericError e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getJCLDir(BatchServerInfo info) {
        return this.m_backingStoreMethod.getJCLDir(info);
    }

    public String getJCLTemplate(BatchServerInfo batchserver) {
        return this.m_backingStoreMethod.getJCLTemplate(batchserver, this.m_defaultUserContext);
    }

    public String getJCLFile(ServerJobInfo job) {
        return this.m_backingStoreMethod.getJCLFile(job);
    }

    public String readJCL(IWorkspace iworkspace, String jclfile) {
        IFileService rio = iworkspace.FileService();
        try {
            StringBuffer jcl = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)jclfile, (int)2);
            return jcl.toString();
        }
        catch (GenericError e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isRedeployable(JobInfo jinfo) {
        return this.isRedeployable(jinfo, false);
    }

    public boolean isRedeployable(JobInfo jinfo, boolean schmgr) {
        return this.m_backingStoreMethod.isRedeployable(jinfo, schmgr);
    }

    public boolean isUniqueFlow(String name, String id) {
        return this.m_backingStoreMethod.isUniqueFlow(name, id);
    }

    public JobDeployerInterface getDeployedJobUtilities(PromptCallbackInterface prompt, DeployedJobCodeGenerationInterface codegen) {
        return new ServerDeployedJobUtilities(this, prompt, codegen, this.m_defaultUserContext);
    }

    public SchedulerResultSet submitFlow(ServerFlowInfo flow, boolean modified, boolean errorOnDelete) throws SchedulerException {
        return this.m_backingStoreMethod.submitFlow(flow, modified, errorOnDelete);
    }

    public SchedulerResultSet submitFlow(ServerFlowInfo flow, boolean modified) throws SchedulerException {
        return this.submitFlow(flow, modified, false);
    }

    public List<RunHistory> getRunningJobs(String schId, String user) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            return ((IConsole)scheduler).getRunningJobs(schId, user);
        }
        return null;
    }

    public List<ScheduledFlowInfo> getScheduledFlowsByScheduler(String schId, String user) throws SchedulerException {
        Scheduler scheduler = this.m_backingStoreMethod.getSchedulingServer(schId);
        if (scheduler != null && scheduler.getServerComponent().isConsoleSupported()) {
            try {
                return ((IConsole)scheduler).getScheduledFlows(schId, user);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public List<FlowInfo> getSubmittedFlows(String message, String title, List<FlowInfo> notscheduled) throws SchedulerException {
        return this.m_backingStoreMethod.getSubmittedFlows(message, title, notscheduled);
    }

    public SchedulerResultSet batchResubmit(ServerFlowInfo flow, boolean errorOnDelete) throws SchedulerException {
        flow.updateTriggers();
        return this.submitFlow(flow, true, errorOnDelete);
    }

    public SchedulerResultSet batchSubmit(ServerFlowInfo flow, boolean modified) throws SchedulerException {
        flow.updateTriggers();
        return this.submitFlow(flow, modified, false);
    }

    public List<FlowInfo> getFlowsByParty(String party) throws SchedulerException {
        return this.m_backingStoreMethod.getFlowsByParty(party);
    }

    public boolean checkWritePermission(SASFolder folder) {
        return this.m_backingStoreMethod.checkWritePermission(folder);
    }

    public boolean removeFromFlow(ServerInfoInterface info, ServerFlowInfo flow) throws SchedulerException {
        return this.m_backingStoreMethod.removeFromFlow(info, flow);
    }

    public boolean removeFromAllFlows(ServerInfoInterface info) throws SchedulerException {
        return this.m_backingStoreMethod.removeFromAllFlows(info);
    }

    public void checkCircularDependencies(FlowInfo flow, String id) throws SchedulerException {
        this.m_backingStoreMethod.checkCircularDependencies(flow, id);
    }

    public boolean updateTriggers(ServerFlowInfo flow) throws SchedulerException {
        return this.m_backingStoreMethod.updateTriggers(flow);
    }

    public boolean isUniqueDirectory(String name) {
        return this.m_backingStoreMethod.isUniqueDirectory(name);
    }

    public List<DirectoryInfo> getDirectories(SASAppServer appserver) {
        try {
            return this.getDirectoriesFromServer(appserver);
        }
        catch (Exception ex) {
            return new ArrayList<DirectoryInfo>();
        }
    }

    public List<DirectoryInfo> getDirectoriesFromServer(SASAppServer appserver) {
        return this.m_backingStoreMethod.getDirectoriesFromServer(appserver);
    }

    public boolean okayToDeleteDirectory(DirectoryInfo info) {
        return this.m_backingStoreMethod.okayToDeleteDirectory(info);
    }

    public boolean deleteDirectory(DirectoryInfo info) {
        return this.m_backingStoreMethod.deleteDirectory(info);
    }

    public boolean doesJobExist(String name, SASFolder sasfolder) throws SchedulerException {
        return this.m_backingStoreMethod.doesJobExist(name, sasfolder);
    }

    public ServerJobInfo getJob(String id) {
        return this.m_backingStoreMethod.getJob(id, this);
    }

    public SortedSet<DisplayInfo> getNonAssociatedJobsFromRepository() throws SchedulerException {
        return this.m_backingStoreMethod.getNonAssociatedJobsFromRepository();
    }

    public SortedSet<DisplayInfo> getJobObjectsFromRepository() throws SchedulerException {
        return this.m_backingStoreMethod.getJobObjectsFromRepository();
    }

    public String getJobCommandline(JobInfo info) {
        return this.m_backingStoreMethod.getJobCommandline(info);
    }

    public String resetCommandLine(ServerJobInfo job, ServerFlowInfo flow) {
        return this.m_backingStoreMethod.resetCommandLine(job, flow);
    }

    public String XMLExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        return this.m_backingStoreMethod.XMLExport(workspace, info, name, appServer, dir);
    }

    public FlowInfo XMLImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        return this.m_backingStoreMethod.XMLImport(workspace, file, maxPredsPerJob);
    }

    public String SASExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        return this.m_backingStoreMethod.SASExport(workspace, info, name, appServer, dir);
    }

    public FlowInfo SASImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        return this.m_backingStoreMethod.SASImport(workspace, file, maxPredsPerJob);
    }

    public String CSVExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        return this.m_backingStoreMethod.CSVExport(workspace, info, name, appServer, dir);
    }

    public FlowInfo CSVImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        return this.m_backingStoreMethod.CSVImport(workspace, file, maxPredsPerJob);
    }

    public Scheduler getSchedulingServer(SchedulerServerInfo ssi) throws SchedulerException {
        Scheduler scheduler = ServerUtilities.getSchedulingServerFromCache(ssi);
        if (scheduler != null) {
            SchedulerServerInfo ssi2 = scheduler.getServerComponent();
            if (ssi != ssi2) {
                ssi.setUsername(ssi2.getUsername());
                ssi.setPassword(ssi2.getPassword());
            }
        } else {
            scheduler = this.m_backingStoreMethod.getSchedulingServer(ssi);
        }
        return scheduler;
    }

    public static Scheduler getSchedulingServerFromCache(SchedulerServerInfo ssi) {
        Scheduler scheduler = null;
        if (ssi != null && ssi.getConnectionId() != null) {
            scheduler = m_schedulerCache.get(ssi.getConnectionId());
        }
        return scheduler;
    }

    public static boolean matchTimeCriteria(Date sdate, FilterRule rule) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date udate = dateFormat.parse(rule.getValue());
            switch (rule.getCondition()) {
                case 4: {
                    if (!udate.after(sdate)) break;
                    return false;
                }
                case 5: {
                    if (!udate.before(sdate)) break;
                    return false;
                }
            }
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    public static String getSelectXMLSub(String name, int condition, String value) {
        String str = "";
        switch (condition) {
            case 0: {
                str = name + "='" + value + "'";
                break;
            }
            case 3: {
                str = name + "?'" + value + "'";
                break;
            }
            case 1: {
                if (value.compareTo("") == 0) {
                    str = name + " NE '_RSW123_SOME_STRING_THAT_DOES_NOT_MATCH_ANYTHING'";
                    break;
                }
                str = name + "=:'" + value + "'";
                break;
            }
            case 2: {
                str = name + "='*" + value + "'";
                break;
            }
            case 8: {
                String[] tokens = value.split(";");
                str = name + "='" + tokens[0] + "'";
                for (int i = 1; i < tokens.length; ++i) {
                    String v = tokens[i].toString();
                    str = str + " or " + name + "='" + v + "'";
                }
                break;
            }
            case 4: {
                str = name + " GT '" + value + "'";
                break;
            }
            case 5: {
                str = name + " LT '" + value + "'";
                break;
            }
            case 6: {
                str = name + " EQ '" + value + "'";
                break;
            }
            case 7: {
                str = name + " NE '" + value + "'";
            }
        }
        return str;
    }

    public MdObjectStore getDefaultMdStore() {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.getDefaultMdStore();
        }
        return null;
    }

    public boolean setDefaultMdStore(MdObjectStore store) {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA bsm = (ServerUtilOMA)this.m_backingStoreMethod;
            return bsm.setDefaultMdStore(store);
        }
        return false;
    }

    public String getDefaultMdRepository() {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.getDefaultMdRepository();
        }
        return null;
    }

    public boolean setDefaultMdRepository(String repos) {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.setDefaultMdRepository(repos);
        }
        return false;
    }

    public MdFactory getDefaultMdFactory() {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.getDefaultMdFactory();
        }
        return null;
    }

    public boolean setDefaultMdFactory(MdFactory factory) {
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            ServerUtilOMA store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.setDefaultMdFactory(factory);
        }
        return false;
    }

    public boolean setFactoryListener(ServerUtilitiesListener listener) {
        ServerUtilOMA store = null;
        if (this.m_backingStoreMethod instanceof ServerUtilOMA) {
            store = (ServerUtilOMA)this.m_backingStoreMethod;
            return store.setFactoryListener(listener);
        }
        return false;
    }

    public void removeFactoryListener(ServerUtilitiesListener listener) {
        ServerUtilOMA store = null;
        if (!(this.m_backingStoreMethod instanceof ServerUtilOMA)) {
            return;
        }
        store = (ServerUtilOMA)this.m_backingStoreMethod;
        store.removeFactoryListener(listener);
    }

    private static class redeployJobData
    implements DeployedJobInterface {
        private JobInfo mc_job;
        private ServerUtilities mc_serverUtil;

        public redeployJobData(JobInfo job, ServerUtilities serverUtil) {
            this.mc_job = job;
            this.mc_serverUtil = serverUtil;
        }

        public String GenerateJCLFromTemplate(String filepath, String template) {
            return this.GenerateJCLFromTemplate(filepath, this.mc_job.getRunAsDataBinding(), template);
        }

        public String GenerateJCLFromTemplate(String filename, String runas, String template) {
            return DataStepProgramDeployer.GenerateJCLFromTemplate((String)filename, (String)runas, (String)template);
        }

        public List<DisplayInfo> getAssociatedJobs() {
            ArrayList<DisplayInfo> x = new ArrayList<DisplayInfo>();
            x.add(this.mc_job.getJob());
            return x;
        }

        public BatchServerInfo getBatchServer() {
            return this.mc_job.getBatchServer();
        }

        public String[] getDeployedJobNames() {
            String[] x = new String[]{this.mc_job.getName()};
            return x;
        }

        public List<JobInfo> getDeployedJobs() {
            ArrayList<JobInfo> x = new ArrayList<JobInfo>();
            x.add(this.mc_job);
            return x;
        }

        public String getFileContent() {
            return null;
        }

        public String getJCL() {
            if (this.mc_job.getBatchServer().getOperatingSystemDataBinding() == 2) {
                JobDeployerInterface jdi = this.mc_serverUtil.getDeployedJobUtilities(null, null);
                String template = jdi.getJCLTemplate(this.mc_job.getBatchServer());
                return template;
            }
            return null;
        }

        public String getJCLPath() {
            String jclFile = CommandUtilities.normalizePath((String)this.mc_job.getJCL(), (int)2);
            int index = jclFile.lastIndexOf("/");
            if (index > 0) {
                return jclFile.substring(0, index);
            }
            return jclFile;
        }

        public int getNumberOfDirectories() {
            return this.mc_job.getBatchServer().getDirectories().size();
        }

        public SASFolder getSASFolder() {
            SASFolder x = new SASFolder(this.mc_job.getLocation());
            return x;
        }

        public DirectoryInfo getSelectedDirectory() {
            return this.mc_job.getSourceDir();
        }

        public String[] getSourceFileNames() {
            FileInfo src = this.mc_job.getOriginalSourceFileDataBinding();
            if (src != null) {
                String srcFile = CommandUtilities.createFullPath((String)src.getPath(), (String)src.getName(), (int)this.mc_job.getBatchServer().getOperatingSystem());
                if (srcFile != null && srcFile.length() > 0) {
                    String[] x = new String[]{srcFile};
                    return x;
                }
                String[] x = null;
                return x;
            }
            return null;
        }

        public String getTitle() {
            return "";
        }
    }
}

