/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.services.user.CallbackCancelledException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class ServerJobInfo
extends DisplayInfo
implements ServerInfoInterface {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ServerJobInfo.class);
    public DisplayInfo m_info = null;
    public ServerFlowInfo m_flow = null;
    private boolean m_dirty = false;
    private ServerUtilities m_serverUtil = null;
    private Icon m_icon;
    private String m_modifiedTimeStr = null;
    private Date m_modifiedTimeObj = null;
    private String m_createdTimeStr = null;
    private Date m_createdTimeObj = null;
    private String m_logfile = null;
    private IWorkspace m_iworkserver = null;
    private boolean m_logfileAvailable = false;
    public transient Object m_object = null;
    public static final String NAMECHANGE_EVENT = "NAME";
    public static final String WRITE_EVENT = "WRITECHANGE";
    public static final String GATHER_FULL_METADATA = "GATHERMETADATA";
    private Root m_localJFJobObject;

    public ServerJobInfo(DisplayInfo info, ServerFlowInfo flow, ServerUtilities server) {
        super(info.getName(), info.getDescription(), info.getIconName());
        this.m_info = info;
        this.m_flow = flow;
        this.m_serverUtil = server;
        this.setId(info.getId());
        this.setLocation(info.getLocation());
        this.setDisplayOnly(info.isDisplayInformationOnly());
    }

    public ServerUtilities getServerUtil() {
        return this.m_serverUtil;
    }

    public void persist() {
    }

    public String getLastExecuted(ServerFlowInfo flow, boolean localformat) {
        return "NOT IMPLEMENTED";
    }

    public Date getLastExecuted(ServerFlowInfo flow) {
        return null;
    }

    public String getJCLFile() {
        return this.m_serverUtil.getJCLFile(this);
    }

    public boolean isLogFileAvailable() {
        return this.m_logfileAvailable;
    }

    public String getLogFile() {
        return this.m_logfile;
    }

    public String getLogFilePath() {
        if (this.m_logfile == null || this.m_logfile.startsWith(m_bundle.getString("ServerJobInfo.UnableToDetermineLogFile.ERROR.Prefix.txt"))) {
            return null;
        }
        return this.m_logfile;
    }

    public String genLogFile(ServerFlowInfo flow) {
        return this.genLogFile(flow, null);
    }

    public String genLogFile(ServerFlowInfo flow, PromptCallbackInterface prompt) {
        if (!(this.m_info instanceof JobInfo)) {
            return "";
        }
        if (this.m_logfile != null) {
            return this.m_logfile;
        }
        try {
            if (this.m_info instanceof JobInfo) {
                BatchServerInfo batchserver = ((JobInfo)this.m_info).getBatchServer();
                this.m_iworkserver = this.m_serverUtil.checkConnectionToWorkspaceServer(batchserver, prompt);
            } else if (this.m_info instanceof FlowInfo) {
                SchedulerServerInfo server = ((FlowInfo)this.m_info).getScheduler();
                this.m_iworkserver = this.m_serverUtil.checkConnectionToWorkspaceServer(server, prompt);
            }
            if (this.m_iworkserver != null) {
                this.generateAllInformation(false);
                this.m_logfile = this.m_serverUtil.getLogfile(this, this.m_flow, this.m_iworkserver);
            } else {
                this.m_logfile = m_bundle.getString("ServerJobInfo.UnableToDetermineLogFile.FailedToCreateWorkspace.txt");
            }
        }
        catch (InvalidParameterException ipe) {
            this.m_logfile = m_bundle.getString("ServerJobInfo.UnableToDetermineLogFile.DueToMetadataException.txt");
        }
        catch (SchedulerException se) {
            this.m_logfile = m_bundle.getString("ServerJobInfo.UnableToDetermineLogFile.DueToException.txt");
        }
        catch (CallbackCancelledException e) {
            this.m_logfile = m_bundle.getString("ServerJobInfo.UnableToDetermineLogFile.DueToException.txt");
        }
        this.m_logfileAvailable = true;
        return this.m_logfile;
    }

    public StringBuffer readLogfile(ServerFlowInfo flow) {
        return this.readLogfile(flow, null);
    }

    public StringBuffer readLogfile(ServerFlowInfo flow, PromptCallbackInterface prompt) {
        StringBuffer buffer = null;
        if (!(this.m_info instanceof JobInfo)) {
            return buffer;
        }
        if (this.m_logfile == null) {
            this.genLogFile(flow, prompt);
        }
        if (this.m_iworkserver != null) {
            IFileService rio = this.m_iworkserver.FileService();
            try {
                buffer = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)this.m_logfile);
            }
            catch (GenericError genericError) {
                // empty catch block
            }
        }
        return buffer;
    }

    public String getDateCreated(boolean localformat) {
        if (this.m_createdTimeStr == null) {
            this.m_createdTimeStr = this.m_serverUtil.getDateCreatedStr(this, localformat);
        }
        return this.m_createdTimeStr;
    }

    public Date getDateCreated() {
        if (this.m_createdTimeObj == null) {
            this.m_createdTimeObj = this.m_serverUtil.getDateCreated(this);
        }
        return this.m_createdTimeObj;
    }

    public String getDateModified(boolean localformat) {
        if (this.m_modifiedTimeStr == null) {
            this.m_modifiedTimeStr = this.m_serverUtil.getDateModifiedStr(this, localformat);
        }
        return this.m_modifiedTimeStr;
    }

    public Date getDateModified() {
        if (this.m_modifiedTimeObj == null) {
            this.m_modifiedTimeObj = this.m_serverUtil.getDateModified(this);
        }
        return this.m_modifiedTimeObj;
    }

    public String getApplicationName() {
        return "NOT IMPLEMENTED YET";
    }

    public String getBatchServerName() {
        if (!(this.m_info instanceof JobInfo)) {
            return null;
        }
        JobInfo info = (JobInfo)this.m_info;
        BatchServerInfo binfo = info.getBatchServer();
        if (binfo != null && binfo.getName() != null) {
            return info.getBatchServer().getName();
        }
        return m_bundle.getString("ServerJobInfo.BatchServerUnknown.txt");
    }

    public String getDeployedBy() {
        if (this.m_info instanceof JobInfo) {
            return ((JobInfo)this.m_info).getResponsiblePartyDataBinding();
        }
        return m_bundle.getString("ServerJobInfo.UsernameUnknown.txt");
    }

    public boolean isRedeployable() {
        if (this.m_info instanceof JobInfo) {
            return this.m_serverUtil.isRedeployable((JobInfo)this.m_info, true);
        }
        return false;
    }

    public String getRunAs() {
        if (this.m_info instanceof JobInfo) {
            return ((JobInfo)this.m_info).getUserId();
        }
        return m_bundle.getString("ServerJobInfo.RunAsUnknown.txt");
    }

    public boolean setJob(DisplayInfo info) {
        if (this.m_info instanceof JobInfo) {
            JobInfo job = (JobInfo)this.m_info;
            this.m_dirty = true;
            return job.setJob(info);
        }
        return false;
    }

    public boolean isDataGathered() {
        return this.m_object != null;
    }

    public Icon getIcon(int size) {
        return this.getIcon();
    }

    public Icon getIcon() {
        this.m_icon = IconUtil.getIcon((String)JobInfo.getIconName((boolean)this.hasErrors()));
        return this.m_icon;
    }

    public String getSourceFileName() {
        if (this.m_info instanceof JobInfo) {
            return this.m_serverUtil.getSourceFile((JobInfo)this.m_info);
        }
        return null;
    }

    public void checkSourcFileName(String filename) throws InvalidParameterException {
        if (!MetaUtilities.isValidFilename((String)filename)) {
            String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("ServerJobInfo.SourceFile.InvalidChars.Message.fmt"), (Object)this.getName(), (Object)MetaUtilities.INVALIDFILENAMECHARACTERS);
            throw new InvalidParameterException(errorMessage);
        }
    }

    public DisplayInfo getJobInfo() {
        return this.m_info;
    }

    public boolean generateAllInformation(boolean always) throws SchedulerException {
        if (!this.m_dirty && !always && this.m_object != null) {
            return true;
        }
        this.m_object = this.m_serverUtil.generateAllInformation(this);
        this.m_icon = null;
        return this.m_object != null;
    }

    public List<ServerFlowInfo> getListOfFlows() throws SchedulerException {
        return this.m_serverUtil.getListOfFlows(this);
    }

    public boolean removeAll() throws SchedulerException {
        return this.m_serverUtil.removeFromAllFlows(this);
    }

    public boolean remove(ServerFlowInfo flow) {
        this.m_dirty = true;
        try {
            if (flow != null) {
                boolean rc = flow.removeJob(this);
                flow.persist();
                return rc;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean commitChangesToOMR() {
        try {
            if (!this.m_dirty && this.m_info instanceof FlowInfo) {
                this.m_dirty = ((FlowInfo)this.m_info).isDirty();
            }
            if (this.m_dirty) {
                if (this.m_info instanceof FlowInfo) {
                    if (this.m_serverUtil.commitFlowToStore((FlowInfo)this.m_info)) {
                        this.m_dirty = false;
                        return true;
                    }
                } else if (this.m_info instanceof JobInfo && this.m_serverUtil.commitJobToStore((JobInfo)this.m_info, this.m_flow != null ? this.m_flow.getName() : null)) {
                    this.m_dirty = false;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public void refreshIcon() {
        this.m_icon = null;
    }

    public void refresh() throws SchedulerException, RemoteException {
        this.m_icon = null;
        this.m_createdTimeStr = null;
        this.m_createdTimeObj = null;
        this.m_modifiedTimeStr = null;
        this.m_modifiedTimeObj = null;
        this.m_logfileAvailable = false;
        this.m_logfile = null;
        this.m_object = null;
        this.generateAllInformation(true);
    }

    public boolean hasErrors() {
        if (this.m_info instanceof JobInfo) {
            return ((JobInfo)this.m_info).hasErrors();
        }
        if (this.m_info instanceof FlowInfo) {
            return ((FlowInfo)this.m_info).hasErrors();
        }
        return true;
    }

    public boolean isJobAssociationError() {
        try {
            return this.m_serverUtil.isJobAssociatedError(this);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String errorConditions() {
        try {
            return this.m_serverUtil.errorConditions(this);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void reevaluateErrors() throws SchedulerException {
        this.m_icon = null;
        this.m_serverUtil.reevaluateErrors(this);
    }

    public void delete() throws SchedulerException {
        try {
            this.m_serverUtil.deleteDeployedJob(this.m_info.getId());
            if (this.m_info instanceof JobInfo) {
                JobInfo info = (JobInfo)this.m_info;
                this.m_serverUtil.deleteFromListForAllJobsAndFlows(info);
            }
            this.m_info = null;
            this.m_localJFJobObject = null;
            this.m_icon = null;
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        finally {
            this.m_object = null;
        }
    }

    public void setName(String name) {
        this.nameDataBinding = name;
        this.m_info.setName(name);
        this.m_dirty = true;
    }

    public void setName(String name, ServerFlowInfo flow) {
        this.nameDataBinding = name;
        this.m_info.setName(name);
        this.m_dirty = true;
    }

    public boolean setBatchServer(BatchServerInfo batchserver) {
        if (this.m_info instanceof JobInfo) {
            if (((JobInfo)this.m_info).setBatchServer(batchserver)) {
                this.m_dirty = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean resetInfo(JobInfo info) {
        if (info != this.m_info) {
            if (info.getId() == this.m_info.getId()) {
                this.m_info = info;
            } else {
                return false;
            }
        }
        this.m_object = null;
        this.m_dirty = true;
        try {
            return this.generateAllInformation(true);
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public String resetCommandLine() {
        this.m_dirty = true;
        String cmd = this.m_serverUtil.resetCommandLine(this, this.m_flow);
        if (this.m_info instanceof JobInfo) {
            ((JobInfo)this.m_info).setCommandLine(cmd, true);
        }
        return cmd;
    }

    @Override
    public Root getMetadataObject(ServerUtilities serverUtil) {
        try {
            if (this.m_localJFJobObject == null || this.m_localJFJobObject.getObjectStore() == null) {
                JFJob jfjob = this.getDeployedJob().getDeployedJobObject();
                this.m_localJFJobObject = MetaUtilities.createNewEditableObject((Root)jfjob, (MdObjectStore)((MdObjectStore)jfjob.getObjectStore()));
            }
        }
        catch (MdException ex) {
            this.m_localJFJobObject = null;
        }
        catch (RemoteException ex) {
            this.m_localJFJobObject = null;
        }
        catch (RuntimeException ex) {
            this.m_localJFJobObject = null;
        }
        return this.m_localJFJobObject;
    }

    public void addMetaDataListener(MdObjectListener mol) throws RemoteException {
        this.m_localJFJobObject.addMdObjectListener(mol);
    }

    @Override
    public List<?> getPropertyTabs() {
        return null;
    }

    public DeployedJob getDeployedJob() {
        if (this.m_object == null) {
            try {
                this.generateAllInformation(true);
                DeployedJob djob = (DeployedJob)this.m_object;
                this.m_info = djob.getInfo();
                this.m_dirty = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (DeployedJob)this.m_object;
    }
}

