/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.DelegateRemote;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionImpl;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.RB;
import com.sas.services.connection.Server;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class ConnectionFactoryUtil {
    private static final char _lParen = '(';
    private static final char _rParen = ')';
    private static final char _blank = ' ';
    private static final char _equal = '=';

    private ConnectionFactoryUtil() {
    }

    public static ConnectionInterface extractConnectionHandle(Object objRef) {
        if (objRef == null) {
            return null;
        }
        ConnectionInterface cx = null;
        try {
            DelegateRemote delegate = (DelegateRemote)((ObjectImpl)objRef)._get_delegate();
            HashSet visitedSet = new HashSet(8);
            cx = ConnectionFactoryUtil.extractConnectionHandle(delegate, visitedSet);
        }
        catch (ClassCastException delegate) {
            // empty catch block
        }
        if (cx == null) {
            String messageIndex = "cxf.600.ex.txt";
            String message = RB.getStringResource(messageIndex);
            throw new IllegalArgumentException(message);
        }
        return cx;
    }

    public static ConnectionFactoryAdminInterface extractConnectionFactoryAdmin(ConnectionInterface cx) {
        ConnectionImpl handle = null;
        try {
            handle = (ConnectionImpl)cx;
        }
        catch (ClassCastException cce) {
            String messageIndex = "cxf.600.ex.txt";
            String message = RB.getStringResource(messageIndex);
            throw new IllegalArgumentException(message);
        }
        ConnectionFactoryKernel kernel = handle.getKernel();
        ConnectionFactoryAdminProxy proxy = new ConnectionFactoryAdminProxy(kernel);
        return proxy;
    }

    public static String nvPairsToString(String[][] nvPairArr) {
        int bufL = 2;
        for (int i = 0; i < nvPairArr.length; ++i) {
            String[] nvPair = nvPairArr[i];
            int nL = nvPair[0].length();
            int vL = nvPair[1].length();
            bufL += nL + vL + 2;
        }
        StringBuffer buf = new StringBuffer(bufL);
        buf.append('(');
        for (int i = 0; i < nvPairArr.length; ++i) {
            String[] nvPair = nvPairArr[i];
            buf.append(nvPair[0]).append('=');
            buf.append(nvPair[1]).append(' ');
        }
        if (nvPairArr.length > 0) {
            int ndx = buf.length() - 1;
            buf.setLength(ndx);
        }
        buf.append(')');
        String str = buf.toString();
        return str;
    }

    protected static Server[] copyServerArray(Server[] in) {
        if (in == null) {
            return null;
        }
        int len = in.length;
        Server[] out = (Server[])in.clone();
        for (int i = 0; i < len; ++i) {
            out[i] = (Server)in[i].clone();
        }
        return out;
    }

    protected static Cluster[] copyClusterArray(Cluster[] in) {
        if (in == null) {
            return null;
        }
        int len = in.length;
        Cluster[] out = (Cluster[])in.clone();
        for (int i = 0; i < len; ++i) {
            out[i] = (Cluster)in[i].clone();
        }
        return out;
    }

    protected static Puddle[] copyPuddleArray(Puddle[] in) {
        if (in == null) {
            return null;
        }
        int len = in.length;
        Puddle[] out = (Puddle[])in.clone();
        for (int i = 0; i < len; ++i) {
            out[i] = (Puddle)in[i].clone();
        }
        return out;
    }

    protected static List copyList(List in) {
        if (in == null) {
            return null;
        }
        ArrayList out = new ArrayList(in.size());
        out.addAll(in);
        return out;
    }

    protected static String clusterArrayToString(Cluster[] clusterArr) {
        String[][] cnvPairArr = new String[clusterArr.length][2];
        for (int i = 0; i < clusterArr.length; ++i) {
            cnvPairArr[i][0] = "c" + i;
            cnvPairArr[i][1] = clusterArr[i].toString();
        }
        String cnv = ConnectionFactoryUtil.nvPairsToString(cnvPairArr);
        return cnv;
    }

    protected static String puddleArrayToString(Puddle[] puddleArr) {
        String[][] pnvPairArr = new String[puddleArr.length][2];
        for (int i = 0; i < puddleArr.length; ++i) {
            pnvPairArr[i][0] = "p" + i;
            pnvPairArr[i][1] = puddleArr[i].toString();
        }
        String pnv = ConnectionFactoryUtil.nvPairsToString(pnvPairArr);
        return pnv;
    }

    private static ConnectionInterface extractConnectionHandle(DelegateRemote delegate, Set visitedSet) {
        if (!visitedSet.add(delegate)) {
            return null;
        }
        Set refSet = delegate.getAllReferences();
        Iterator refItr = refSet.iterator();
        ConnectionInterface cx = null;
        while (refItr.hasNext()) {
            DelegateRemote parent;
            java.lang.Object ref = refItr.next();
            if (ref instanceof ConnectionInterface) {
                cx = (ConnectionInterface)ref;
                break;
            }
            if (!(ref instanceof DelegateRemote) || (cx = ConnectionFactoryUtil.extractConnectionHandle(parent = (DelegateRemote)((java.lang.Object)ref), visitedSet)) == null) continue;
            break;
        }
        return cx;
    }

    @SASScope
    private static class ConnectionFactoryAdminProxy
    implements ConnectionFactoryAdminInterface {
        private ConnectionFactoryAdminInterface _delegate;

        private ConnectionFactoryAdminProxy(ConnectionFactoryAdminInterface delegate) {
            this._delegate = delegate;
        }

        @Override
        public Logger getLogger() {
            Logger result = this._delegate.getLogger();
            return result;
        }

        @Override
        public void shutdown() {
            this._delegate.shutdown();
        }

        @Override
        public void destroy() {
            this._delegate.destroy();
        }
    }
}

