/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Column;
import com.sas.rio.MVAAnnotatedResultSet;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAConnectionProperties;
import com.sas.rio.MVADualResultSet;
import com.sas.rio.MVAPreparedStatement;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLExceptionUnsupported;
import com.sas.rio.MVASQLWarning;
import com.sas.rio.MessageCode;
import com.sas.rio.ParsedQuery;
import com.sas.rio.RB;
import com.sas.rio.RIOException;
import com.sas.rio.RIOStatementInterface;
import com.sas.rio.RIOUtil;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class MVAStatement
implements RIOStatementInterface {
    static final int SASIFY_DEFAULT = 0;
    static final int SASIFY_V91 = 1;
    static final int SASIFY_NONE = 2;
    protected final int m_sasifyTableNames;
    protected int maxFieldSize = Short.MAX_VALUE;
    private int maxRows = 0;
    private int updateCount = -1;
    protected MVAResultSet _currentResultSet;
    private final MVAConnection connection;
    private SQLWarning _warnings;
    protected boolean describe;
    private int fetchSize = 0;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final ArrayList<String> m_batchList = new ArrayList();
    private boolean randomAccess = false;
    private boolean _closed = false;
    protected boolean _closeOnCompletion = false;
    private RIOUtil rioUtil;
    protected final List<String> librefs;
    private static final Logger logger = LogManager.getLogger(MVAStatement.class);
    final AtomicLong resultSetCounter = new AtomicLong();
    final String idForLogger;
    final String logPrefix;

    @SASScope
    MVAStatement(MVAConnection connection) throws SQLException {
        this.connection = connection;
        this.idForLogger = this.connection.getIdForLogger() + "." + this.connection.statementCounter.incrementAndGet();
        this.logPrefix = this instanceof MVAPreparedStatement ? "ps(" + this.idForLogger + ")" : "stmt(" + this.idForLogger + ")";
        this.rioUtil = connection.getRioUtil();
        this.resultSetType = connection.resultSetType;
        this.resultSetConcurrency = connection.resultSetConcurrency;
        if (this.resultSetType == 1004) {
            this.randomAccess = true;
        } else if (this.resultSetType == 1003) {
            this.randomAccess = false;
        }
        String sasifyTableNames = connection.getMVAConnectionProperties().getSasifyTableNames();
        this.m_sasifyTableNames = "none".equalsIgnoreCase(sasifyTableNames) ? 2 : ("v91".equalsIgnoreCase(sasifyTableNames) ? 1 : 0);
        this.librefs = this.rioUtil.getLibraries();
        if (logger.isInfoEnabled()) {
            String logLoggerReload = this.logPrefix + " \"%s\" has been reloaded.";
            String logLoggerReloadFail = this.logPrefix + " \"%s\" configuration not reloaded.  Please specify a URL in the log4j.configuration JVM option.";
            try {
                String value = System.getProperty("log4j2.configurationFile");
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                if (value == null || value.isEmpty()) {
                    logger.warn(String.format(logLoggerReloadFail, "log4j.configuration"));
                } else {
                    URL url = new URL(value);
                    context.setConfigLocation(url.toURI());
                    logger.trace(String.format(logLoggerReload, url.getFile()));
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                logger.warn(logLoggerReloadFail);
            }
        }
    }

    String getIdForLogger() {
        return this.idForLogger;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        ParsedQuery pq = new ParsedQuery(this.librefs, query, this.m_sasifyTableNames);
        return this.executeQuery2(pq, new String[0]);
    }

    protected ResultSet executeQuery2(ParsedQuery pq, String[] parameters) throws SQLException, MVASQLException {
        long startTime = System.nanoTime();
        if (this._currentResultSet != null) {
            this._currentResultSet.close();
            this._currentResultSet = null;
        }
        this.updateCount = -1;
        this.clearWarnings();
        this.checkClosed();
        String query = pq.buildQuery(parameters);
        if (pq.useGetTable) {
            try {
                this._currentResultSet = (MVAResultSet)this.getTable(pq.libref, pq.tableNm);
                if (logger.isInfoEnabled()) {
                    long elapsedNanos = System.nanoTime() - startTime;
                    double elapsedSeconds = (double)elapsedNanos / 1.0E9;
                    this.logExecuteQuery(query, elapsedSeconds, this._currentResultSet);
                }
                return this._currentResultSet;
            }
            catch (SQLException e) {
                this._currentResultSet = null;
                MVASQLWarning warning = this.resultSetConcurrency == 1008 ? new MVASQLWarning(MessageCode.MVAStatement_CONCURCHANGE, (Throwable)e, e.getMessage()) : new MVASQLWarning(MessageCode.MVAStatement_getTableFailed, (Throwable)e, new Object[0]);
                this.addWarning(warning);
            }
        } else if (this.resultSetConcurrency == 1008) {
            MVASQLWarning warning = new MVASQLWarning(MessageCode.MVAStatement_rsNotUpdatableWarning, new Object[0]);
            this.addWarning(warning);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(this.logPrefix + ", executeQuery sasified sql " + query);
        }
        if (!pq.queryReturnsResultSet()) {
            throw new MVASQLException(MessageCode.MVAStatement_querySelectError, new Object[0]);
        }
        int hashCode = this.rioUtil.executeQuery(query, this.randomAccess);
        this.addWarning(this.rioUtil.getWarnings());
        this.rioUtil.clearWarnings();
        this._currentResultSet = new MVAResultSet(this, hashCode);
        if (logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            this.logExecuteQuery(query, elapsedSeconds, this._currentResultSet);
        }
        return this._currentResultSet;
    }

    private void logExecuteQuery(String query, double elapsedSeconds, MVAResultSet resultSet) {
        DecimalFormat formatter = new DecimalFormat();
        String logMessage = this.logPrefix + "#executeQuery " + query + "; created result set " + resultSet.getIdForLogger() + "; time= " + formatter.format(elapsedSeconds) + " secs";
        logger.info(logMessage);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        ParsedQuery pq = new ParsedQuery(this.librefs, sql, this.m_sasifyTableNames);
        return this.executeUpdate2(pq, new String[0]);
    }

    protected int executeUpdate2(ParsedQuery pq, String[] parameters) throws MVASQLException, SQLException {
        this.checkClosed();
        long startTime = System.nanoTime();
        if (this._currentResultSet != null) {
            this._currentResultSet.close();
            this._currentResultSet = null;
        }
        this.updateCount = 0;
        String query = pq.buildQuery(parameters);
        if (pq.queryReturnsResultSet()) {
            throw new MVASQLException(MessageCode.MVAStatement_noSelectInUpdateError, new Object[0]);
        }
        this.updateCount = this.rioUtil.executeUpdate(query);
        this.addWarning(this.rioUtil.getWarnings());
        this.rioUtil.clearWarnings();
        if (logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            this.logExecuteUpdate(query, elapsedSeconds);
        }
        return this.updateCount;
    }

    private void logExecuteUpdate(String query, double elapsedSeconds) {
        DecimalFormat formatter = new DecimalFormat();
        String logMessage = this.logPrefix + "#executeUpdate " + query + "; time= " + formatter.format(elapsedSeconds) + " secs";
        logger.info(logMessage);
    }

    @Override
    public void close() throws SQLException {
        if (logger.isInfoEnabled()) {
            String logClose = this.logPrefix + "#close";
            logger.info(logClose);
        }
        try {
            this._closed = true;
            this.rioUtil.releaseLibref();
            if (this._currentResultSet != null && !this._currentResultSet.isClosed()) {
                this._currentResultSet.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._currentResultSet = null;
            this.connection.deleteStatement(this);
        }
    }

    void closeResources() throws SQLException {
        try {
            if (this._currentResultSet != null) {
                this._currentResultSet.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._currentResultSet = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    protected void checkClosed() throws MVASQLException {
        if (this._closed) {
            throw new MVASQLException(MessageCode.MVAStatement_closed, new Object[0]);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new MVASQLException(MessageCode.MVAStatement_maxFieldSizeError, new Object[0]);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new MVASQLException(MessageCode.MVAStatement_maxRowsError, new Object[0]);
        }
        this.maxRows = max;
        if (this.maxRows < this.fetchSize && this.maxRows != 0) {
            this.fetchSize = this.maxRows;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new MVASQLException(MessageCode.MVAStatement_invalidTimeout, seconds);
        }
        if (seconds != 0) {
            throw new MVASQLExceptionUnsupported();
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        this.close();
    }

    private void addWarning(SQLWarning warning) {
        if (warning != null) {
            if (this._warnings == null) {
                this._warnings = warning;
            } else {
                this._warnings.setNextWarning(warning);
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this._warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this._warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        ParsedQuery pq = new ParsedQuery(this.librefs, sql, this.m_sasifyTableNames);
        return this.execute2(pq, new String[0]);
    }

    protected boolean execute2(ParsedQuery pq, String[] parameters) throws SQLException, MVASQLException {
        long startTime = System.nanoTime();
        this.clearWarnings();
        if (this._currentResultSet != null) {
            this._currentResultSet.close();
            this._currentResultSet = null;
        }
        String query = pq.buildQuery(parameters);
        this.updateCount = -1;
        this.checkClosed();
        if (!pq.queryReturnsResultSet()) {
            this.updateCount = this.rioUtil.executeUpdate(query);
            this.addWarning(this.rioUtil.getWarnings());
            this.rioUtil.clearWarnings();
            if (logger.isInfoEnabled()) {
                long elapsedNanos = System.nanoTime() - startTime;
                double elapsedSeconds = (double)elapsedNanos / 1.0E9;
                this.logExecute(query, elapsedSeconds, null);
            }
            return false;
        }
        if (pq.useGetTable) {
            try {
                this._currentResultSet = (MVAResultSet)this.getTable(pq.libref, pq.tableNm);
                if (logger.isInfoEnabled()) {
                    long elapsedNanos = System.nanoTime() - startTime;
                    double elapsedSeconds = (double)elapsedNanos / 1.0E9;
                    this.logExecute(query, elapsedSeconds, this._currentResultSet);
                }
                return true;
            }
            catch (Exception e) {
                MVASQLWarning warning = this.resultSetConcurrency == 1008 ? new MVASQLWarning(MessageCode.MVAStatement_CONCURCHANGE, e.getLocalizedMessage()) : new MVASQLWarning(MessageCode.MVAStatement_getTableFailed, (Throwable)e, new Object[0]);
                this.addWarning(warning);
                this._currentResultSet = null;
            }
        } else if (this.resultSetConcurrency == 1008) {
            MVASQLWarning warning = new MVASQLWarning(MessageCode.MVAStatement_rsNotUpdatableWarning, new Object[0]);
            this.addWarning(warning);
        }
        int hashCode = this.rioUtil.executeQuery(query, this.randomAccess);
        this.addWarning(this.rioUtil.getWarnings());
        this.rioUtil.clearWarnings();
        this._currentResultSet = new MVAResultSet(this, hashCode);
        if (logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            this.logExecute(query, elapsedSeconds, this._currentResultSet);
        }
        return true;
    }

    private void logExecute(String query, double elapsedSeconds, MVAResultSet resultSet) {
        DecimalFormat formatter = new DecimalFormat();
        String logMessage = resultSet != null ? this.logPrefix + "#execute " + query + "; created result set " + resultSet.getIdForLogger() + "; time= " + formatter.format(elapsedSeconds) + " secs" : this.logPrefix + "#execute " + query + "; no result set created; time= " + formatter.format(elapsedSeconds) + " secs";
        logger.info(logMessage);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this._currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this._currentResultSet != null) {
            this._currentResultSet.close();
            this._currentResultSet = null;
        }
        this.updateCount = -1;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new MVASQLException(MessageCode.MVAStatement_fetchDirectionError, new Object[0]);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new MVASQLException(MessageCode.MVAStatement_fetchSizeError, rows);
        }
        this.fetchSize = this.getMaxRows() != 0 && rows > this.getMaxRows() ? this.getMaxRows() : rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        ParsedQuery pq = new ParsedQuery(this.librefs, sql, this.m_sasifyTableNames);
        this.addBatch2(pq, new String[0]);
    }

    protected void addBatch2(ParsedQuery _parsedQuery, String[] parameters) throws SQLException {
        String query = _parsedQuery.buildQuery(parameters);
        if (logger.isDebugEnabled()) {
            logger.debug(this.logPrefix + "#addBatch  " + query);
        }
        this.checkClosed();
        this.m_batchList.add(query);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.m_batchList.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        if (logger.isDebugEnabled()) {
            String logExecuteBatch = this.logPrefix + "#executeBatch";
            logger.debug(logExecuteBatch);
        }
        this.checkClosed();
        int listSize = this.m_batchList.size();
        int[] updateCounts = new int[listSize];
        int uc = 0;
        boolean throwFlag = false;
        for (int i = 0; i < listSize; ++i) {
            String sql = this.m_batchList.get(i);
            ParsedQuery pq = new ParsedQuery(this.librefs, sql, this.m_sasifyTableNames);
            if (pq.queryReturnsResultSet()) {
                throwFlag = true;
                uc = -3;
            } else {
                try {
                    uc = this.executeUpdate(this.m_batchList.get(i));
                }
                catch (SQLException se) {
                    if (se.getErrorCode() == 208) {
                        throw se;
                    }
                    uc = -3;
                    throwFlag = true;
                }
                catch (Exception e) {
                    uc = -3;
                    throwFlag = true;
                }
            }
            updateCounts[i] = uc;
        }
        if (throwFlag) {
            String msg = RB.getStringResource(MessageCode.MVAStatement_batchUpdateException.getResourceKey());
            throw new BatchUpdateException(msg, null, MessageCode.MVAStatement_batchUpdateException.getMessageCode(), updateCounts);
        }
        this.m_batchList.clear();
        return updateCounts;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    @Deprecated
    public void createTable(String libref, String tableName, Column[] columnObject, String options) throws RIOException {
        try {
            this.rioUtil.createTable(libref, tableName, columnObject, options);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(MessageCode.MVAStatement_createTableError.getStringResource(), e.getLocalizedMessage());
            throw new RIOException(msg);
        }
    }

    @Override
    public ResultSet getTable(String libref, String tableName) throws SQLException {
        return this.getTable(libref, tableName, null, null, null);
    }

    @Override
    public ResultSet getTable(String libref, String tableName, String tableType, String[] password, String options) throws SQLException {
        if (libref == null || libref.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_nullLibrefError, new Object[0]);
        }
        boolean applyFormats = this.getMVAConnectionProperties().isApplyFormats();
        int bindKey = applyFormats ? 3 : 2;
        Double version = 0.0;
        try {
            String value = this.rioUtil.getDBMSVersion();
            version = Double.valueOf(value);
        }
        catch (Exception e) {
            version = 0.0;
        }
        if (version >= 9.4 && (this.resultSetConcurrency == 1008 || this.resultSetConcurrency == 1007)) {
            this._currentResultSet = new MVAAnnotatedResultSet(this, libref, tableName, password, options, bindKey, this.resultSetConcurrency, this.getMVAConnectionProperties().getSegmentLength());
            return this._currentResultSet;
        }
        this._currentResultSet = new MVAResultSet(this, libref, tableName, password, options, bindKey);
        return this._currentResultSet;
    }

    @Override
    public void deleteTable(String libref, String tableName) throws RIOException {
        this.deleteTable(libref, tableName, null, null);
    }

    @Override
    public void deleteTable(String libref, String tableName, String tableType, String alterPassword) throws RIOException {
        if (libref == null || libref.length() == 0) {
            throw new RIOException(MessageCode.MVAStatement_nullLibrefError.getStringResource());
        }
        try {
            this.rioUtil.deleteTable(libref, tableName, tableType, alterPassword);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(MessageCode.MVAStatement_deleteFailed.getStringResource(), e.getLocalizedMessage());
            throw new RIOException(msg);
        }
    }

    @SASScope
    public RIOUtil getRioUtil() {
        return this.rioUtil;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Nonnull
    MVAConnectionProperties getMVAConnectionProperties() {
        MVAConnectionProperties mvaConnProps = this.connection.getMVAConnectionProperties();
        assert (mvaConnProps != null);
        return mvaConnProps;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new MVASQLException(MessageCode.General_unwrapFailInputParameterIsNull, new Object[0]);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new MVASQLException(MessageCode.General_unwrapFail, iface.getName(), this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public MVADualResultSet createDualResultSet(String libref, String tableName, String[] password, String options) throws SQLException {
        if (libref == null || libref.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_nullLibrefError, new Object[0]);
        }
        MVADualResultSet dual = new MVADualResultSet(this, libref, tableName, password, options);
        this._currentResultSet = dual;
        return dual;
    }

    public ResultSet getRioTable(String libref, String tableName) throws SQLException {
        this._currentResultSet = (MVAResultSet)this.getTable(libref, tableName);
        return this._currentResultSet;
    }

    public ResultSet getRioTable(String libref, String tableName, String tableType, String[] password, String options) throws SQLException {
        this._currentResultSet = (MVAResultSet)this.getTable(libref, tableName, tableType, password, options);
        return this._currentResultSet;
    }

    public ResultSet getDualRioTable(String libref, String tableName, String[] password, String options) throws SQLException {
        this._currentResultSet = this.createDualResultSet(libref, tableName, password, options);
        return this._currentResultSet;
    }

    public void deleteRioTable(String libref, String tableName) throws SQLException {
        try {
            this.deleteTable(libref, tableName);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    public void deleteRioTable(String libref, String tableName, String tableType, String alterPassword) throws SQLException {
        try {
            this.deleteTable(libref, tableName, tableType, alterPassword);
        }
        catch (RIOException rioe) {
            throw rioe.toSQLException();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this._closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this._closeOnCompletion;
    }
}

