/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Engine;
import com.sas.iom.orb.brg.InboundPacket;
import com.sas.iom.orb.brg.Marshaller;
import com.sas.iom.orb.brg.Marshaller0100;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.iom.orb.brg.OutboundPacket;
import com.sas.iom.orb.brg.RB;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.SealedString;
import com.sas.text.Message;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public final class Engine0100
extends Engine {
    private static final byte PE_ROW_MAJOR = 0;
    private static final byte PE_NO_CAP = 0;
    private static final byte PE_APPL_JDK1_1 = 6;
    private static final byte PE_PLAT_JAVA = 9;
    private static final byte PE_REDIRECT_ME = 1;
    private static final byte PE_BEEN_REDIRECTED = 2;
    private static final byte[] requirementsVector = new byte[]{24, 0, 16, 16, 32, 32, 0, 48, 0, 0, 2, -128, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0};
    private static final String CLSID_SASOMI_2_0 = "0217e202-b560-11db-ad91-001083ff6836";

    protected Engine0100() {
    }

    @Override
    protected Marshaller createMarshaller() {
        return new Marshaller0100();
    }

    @Override
    protected void initEncoding(Conversation conversation) {
        this.setEncoding(conversation, "ISO8859_1");
    }

    @Override
    protected boolean flowInitClient(Conversation conversation) {
        super.flowInitClient(conversation);
        String xcodePref = (String)conversation.getOption("transcodingpreference");
        if (xcodePref == null || "client".equals(xcodePref)) {
            conversation.setTranscodingPreference((byte)0);
        } else {
            conversation.setTranscodingPreference((byte)1);
        }
        conversation.setSASDateTime(true);
        return false;
    }

    @Override
    protected boolean flowSendReqs(Conversation conversation) {
        int len = requirementsVector.length + 9;
        Crypto crypto = null;
        String algStr = null;
        ByteBuffer algBuf = null;
        byte algLen = 0;
        byte encryptionLevel = conversation.getEncryptionLevel();
        if (encryptionLevel != 0) {
            crypto = this.getCrypto(conversation);
            if (crypto != null) {
                algStr = crypto.getName();
                algBuf = this.getMarshaller().stringToBuffer(conversation, algStr);
                algLen = (byte)algBuf.remaining();
                len += algLen + 1;
            } else {
                encryptionLevel = conversation.getEncryptionLevel();
                if (encryptionLevel != 0) {
                    ++len;
                }
            }
        }
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer reqs = bufferManager.allocate(len);
        reqs.put((byte)105);
        reqs.put(requirementsVector);
        reqs.put((byte)0);
        reqs.put((byte)0);
        byte transcodingPreference = conversation.getTranscodingPreference();
        reqs.put(transcodingPreference);
        reqs.put((byte)6);
        reqs.put((byte)9);
        reqs.put((byte)0);
        byte redirectMe = conversation.isRedirected() ? (byte)2 : 1;
        reqs.put(redirectMe);
        reqs.put(encryptionLevel);
        if (encryptionLevel != 0) {
            reqs.put(algLen);
            if (algBuf != null) {
                reqs.put(algBuf);
            }
        }
        reqs.flip();
        byte status = this.sendReqs(conversation, reqs);
        boolean done = this.handleStatus(conversation, status);
        return done;
    }

    @Override
    protected boolean flowSendUserPass(Conversation conversation) {
        String userName = conversation.getUserName();
        SealedString sealedPassword = conversation.getSealedPassword();
        ORBImpl orb = conversation.getORB();
        AnyImpl _userName = (AnyImpl)orb.create_any();
        _userName.insertIOM(18, userName);
        AnyImpl _password = (AnyImpl)orb.create_any();
        _password.insertIOM(18, sealedPassword);
        AnyImpl[] parmArray = new AnyImpl[]{_userName, _password};
        OutboundPacket packet = new OutboundPacket();
        packet.setParameterArray(parmArray);
        packet.setType(0);
        packet.setMethodId(1);
        this.sendPacket(conversation, packet);
        InboundPacket reply = this.readPacket(conversation);
        Marshaller marshaller = this.getMarshaller();
        marshaller.unmarshalRC(conversation, reply);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        if (conversation.getEncryptionLevel() == 1) {
            this.closeCipher(conversation);
        }
        int conversationID = reply.getClientId();
        conversation.setConversationID(conversationID);
        String encoding = null;
        encoding = marshaller.unmarshalWZXOctet1dArrayNTToString(conversation, mapBuf, dataBuf);
        if (this.isLoggable(conversation, fineRecord)) {
            Engine0100.log(conversation, fineRecord, "received encoding: " + encoding, null);
        }
        if (encoding.equals("Cp1047") || !Charset.isSupported(encoding)) {
            byte xcodePref = conversation.getTranscodingPreference();
            if (xcodePref == 1) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.005.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                INITIALIZE initialize = new INITIALIZE(message);
                UnsupportedEncodingException uee = new UnsupportedEncodingException(encoding);
                initialize.initCause((Throwable)uee);
                throw initialize;
            }
            conversation.setTranscodingPreference((byte)1);
            conversation.setFlowState(100);
        } else {
            this.setEncoding(conversation, encoding);
            conversation.setFlowState(70);
        }
        return false;
    }

    @Override
    protected boolean flowSendXcode(Conversation conversation) {
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(12);
        this.sendPacket(conversation, request);
        InboundPacket reply = this.readPacket(conversation);
        this.getMarshaller().unmarshalRC(conversation, reply);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        String encoding = this.getMarshaller().unmarshalWZXOctet1dArrayNTToString(conversation, mapBuf, dataBuf);
        if (this.isLoggable(conversation, fineRecord)) {
            Engine0100.log(conversation, fineRecord, "received encoding: " + encoding, null);
        }
        if (!Charset.isSupported(encoding)) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine0100.001.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            INITIALIZE initialize = new INITIALIZE(message);
            UnsupportedEncodingException uee = new UnsupportedEncodingException(encoding);
            initialize.initCause((Throwable)uee);
            throw initialize;
        }
        conversation.setEncoding(encoding);
        conversation.setFlowState(70);
        return false;
    }

    @Override
    protected boolean flowSendAuth(Conversation conversation) {
        Locale locale = conversation.getLocale();
        String messageIndex = "Engine0100.002.ex.txt";
        String message = RB.getStringResource(messageIndex, locale);
        throw new NO_PERMISSION(message, 5, CompletionStatus.COMPLETED_NO);
    }

    @Override
    protected boolean flowReadUserPass(Conversation conversation) {
        InboundPacket request = this.readPacket(conversation);
        byte encrLevel = conversation.getEncryptionLevel();
        if (encrLevel == 1) {
            this.closeCipher(conversation);
        }
        int replyID = request.getReplyId();
        int conversationID = Engine0100.assignConversationID();
        ByteBuffer mapBuf = request.getMapBuf();
        ByteBuffer dataBuf = request.getDataBuf();
        Marshaller marshaller = this.getMarshaller();
        String userName = marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
        conversation.setUserName(userName);
        char[] passwordChars = marshaller.unmarshalStringNTToCharArray(conversation, mapBuf, dataBuf);
        conversation.setPasswordChars(passwordChars);
        Arrays.fill(passwordChars, '\u0000');
        conversation.setConversationID(conversationID);
        OutboundPacket reply = new OutboundPacket();
        reply.setType(0);
        reply.setMethodId(1);
        reply.setReplyId(replyID);
        reply.setRC(OutboundPacket.zero);
        AnyImpl[] parmArr = new AnyImpl[2];
        String encodingName = conversation.isColumnMajor() ? "65001" : conversation.getEncoding();
        byte[] encodingArr = marshaller.stringToBytes(conversation, encodingName);
        ORBImpl orb = conversation.getORB();
        parmArr[0] = (AnyImpl)orb.create_any();
        parmArr[0].insertIOM(4, encodingArr);
        parmArr[1] = (AnyImpl)orb.create_any();
        parmArr[1].insert_string("");
        reply.setParameterArray(parmArr);
        this.sendPacket(conversation, reply);
        conversation.setFlowState(70);
        return false;
    }

    @Override
    protected ObjectImpl newObject(Conversation conversation) {
        try {
            ObjectImpl result = super.newObject(conversation);
            return result;
        }
        catch (SystemException se) {
            String classID = conversation.getClassID();
            if (CLSID_SASOMI_2_0.equals(classID)) {
                String host = conversation.getHost();
                int port = conversation.getPort();
                String serverEntryPoint = host + ":" + port;
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine0100.003.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex, locale);
                String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
                BAD_PARAM bad_param = new BAD_PARAM(message);
                bad_param.initCause((Throwable)se);
                throw bad_param;
            }
            throw se;
        }
    }
}

