/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.InputStreamImpl;
import com.sas.iom.orb.ORBBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

@SASScope
public final class OutputStreamImpl
extends OutputStream {
    private ORBBase orb;
    private List stream;

    protected OutputStreamImpl(ORBBase orb) {
        this.orb = orb;
    }

    public synchronized InputStream create_input_stream() {
        int size = this.stream != null ? this.stream.size() : 0;
        ArrayList copy = new ArrayList(size);
        if (size > 0) {
            copy.addAll(this.stream);
        }
        InputStreamImpl iStream = new InputStreamImpl(this.orb, copy);
        return iStream;
    }

    public synchronized void write_boolean(boolean value) {
        Boolean b = value ? AnyImpl.Btrue : AnyImpl.Bfalse;
        this.checkStream();
        this.stream.add(b);
    }

    public synchronized void write_char(char value) {
        Character c = new Character(value);
        this.checkStream();
        this.stream.add(c);
    }

    public void write_wchar(char value) {
        this.write_char(value);
    }

    public void write_octet(byte value) {
        this.write_longlong(value);
    }

    public void write_short(short value) {
        this.write_longlong(value);
    }

    public void write_ushort(short value) {
        this.write_longlong(value);
    }

    public void write_long(int value) {
        this.write_longlong(value);
    }

    public void write_ulong(int value) {
        this.write_longlong(value);
    }

    public synchronized void write_longlong(long value) {
        Long l = new Long(value);
        this.checkStream();
        this.stream.add(l);
    }

    public void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public void write_float(float value) {
        this.write_double(value);
    }

    public synchronized void write_double(double value) {
        Double d = new Double(value);
        this.checkStream();
        this.stream.add(d);
    }

    public void write_string(String value) {
        this.writeObject(value);
    }

    public void write_wstring(String value) {
        this.writeObject(value);
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        boolean[] ba = new boolean[length];
        this.writeArray(value, offset, length, ba);
    }

    public void write_char_array(char[] value, int offset, int length) {
        char[] ca = new char[length];
        this.writeArray(value, offset, length, ca);
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        this.write_char_array(value, offset, length);
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        byte[] ba = new byte[length];
        this.writeArray(value, offset, length, ba);
    }

    public void write_short_array(short[] value, int offset, int length) {
        short[] sa = new short[length];
        this.writeArray(value, offset, length, sa);
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public void write_long_array(int[] value, int offset, int length) {
        int[] ia = new int[length];
        this.writeArray(value, offset, length, ia);
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        long[] la = new long[length];
        this.writeArray(value, offset, length, la);
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public void write_float_array(float[] value, int offset, int length) {
        float[] fa = new float[length];
        this.writeArray(value, offset, length, fa);
    }

    public void write_double_array(double[] value, int offset, int length) {
        double[] da = new double[length];
        this.writeArray(value, offset, length, da);
    }

    public void write_Object(Object value) {
        this.writeObject(value);
    }

    public void write_TypeCode(TypeCode value) {
        this.writeObject(value);
    }

    public void write_any(Any value) {
        this.writeObject(value);
    }

    protected void setStream(List stream) {
        this.stream = stream;
    }

    protected List getStream() {
        return this.stream;
    }

    private void checkStream() {
        if (this.stream == null) {
            this.stream = new LinkedList();
        }
    }

    private synchronized void writeObject(java.lang.Object o) {
        this.checkStream();
        this.stream.add(o);
    }

    private void writeArray(java.lang.Object orig, int off, int len, java.lang.Object copy) {
        System.arraycopy(orig, off, copy, 0, len);
        this.writeObject(copy);
    }
}

