/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceSessionHelper {
    private Logger logger = LogManager.getLogger(ServiceSessionHelper.class);

    public void deleteFile(String filepath, Command command) throws BackupException {
        this.logger.info("creating ANT project for deleting history file on primary backup server node");
        String antProjectFile = this.createANTProject(filepath);
        this.logger.debug(antProjectFile);
        if (!"".equals(antProjectFile)) {
            try {
                this.logger.info("Running ANT project for deleting history file on primary backup server node");
                BackupServerUtil.runANTProject(antProjectFile, command);
                this.logger.info("Deleted history file on primary backup server node");
            }
            catch (Exception exception) {
                this.logger.error("Exception while deleting history file on primary backup server node");
                throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
            }
        }
    }

    private String createANTProject(String filePath) {
        StringBuilder projectFile = new StringBuilder();
        if (filePath != null && !filePath.isEmpty()) {
            String projectFilePrePart = "<project name=\"deletehistory\" default=\"deletefile\"><target name=\"deletefile\">";
            String projectFilePostPart = "</target></project>";
            String deleteCommandPrePart = "<delete dir=\"";
            String deleteCommandPostPart = "\" verbose=\"true\" failonerror=\"false\"/>";
            String startEncode = "<?xml version=\"1.0\"?>";
            projectFile.append(startEncode);
            projectFile.append(projectFilePrePart);
            projectFile.append(deleteCommandPrePart);
            projectFile.append(filePath);
            projectFile.append(deleteCommandPostPart);
            projectFile.append(projectFilePostPart);
        }
        return projectFile.toString();
    }
}

